/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.projectmanagement.ffdc.exceptions;

import java.util.Objects;
import org.odpi.openmetadata.accessservices.projectmanagement.ffdc.exceptions.ProjectManagementCheckedExceptionBase;

public class UnrecognizedGUIDException
extends ProjectManagementCheckedExceptionBase {
    private String expectedTypeName;
    private String guid;

    public UnrecognizedGUIDException(int httpCode, String className, String actionDescription, String errorMessage, String systemAction, String userAction, String expectedTypeName, String guid) {
        super(httpCode, className, actionDescription, errorMessage, systemAction, userAction);
        this.expectedTypeName = expectedTypeName;
        this.guid = guid;
    }

    public UnrecognizedGUIDException(int httpCode, String className, String actionDescription, String errorMessage, String systemAction, String userAction, Throwable caughtError, String expectedTypeName, String guid) {
        super(httpCode, className, actionDescription, errorMessage, systemAction, userAction, caughtError);
        this.expectedTypeName = expectedTypeName;
        this.guid = guid;
    }

    public String getExpectedTypeName() {
        return this.expectedTypeName;
    }

    public String getGUID() {
        return this.guid;
    }

    @Override
    public String toString() {
        return "UnrecognizedGUIDException{expectedTypeName='" + this.expectedTypeName + '\'' + ", guid='" + this.guid + '\'' + ", reportedHTTPCode=" + this.getReportedHTTPCode() + ", reportingClassName='" + this.getReportingClassName() + '\'' + ", reportingActionDescription='" + this.getReportingActionDescription() + '\'' + ", errorMessage='" + this.getErrorMessage() + '\'' + ", reportedSystemAction='" + this.getReportedSystemAction() + '\'' + ", reportedUserAction='" + this.getReportedUserAction() + '\'' + ", reportedCaughtException=" + this.getReportedCaughtException() + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof UnrecognizedGUIDException)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        UnrecognizedGUIDException that = (UnrecognizedGUIDException)objectToCompare;
        return Objects.equals(this.getExpectedTypeName(), that.getExpectedTypeName()) && Objects.equals(this.guid, that.guid);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getExpectedTypeName(), this.guid);
    }
}

