/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.projectmanagement.ffdc;

import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageSet;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogRecordSeverity;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLogRecordSeverity;

public enum ProjectManagementAuditCode implements AuditLogMessageSet
{
    SERVICE_INITIALIZING("OMAS-PROJECT-MANAGEMENT-0001", OMRSAuditLogRecordSeverity.STARTUP, "The Project Management Open Metadata Access Service (OMAS) is initializing a new server instance", "The local server has started up a new instance of the Project Management OMAS.", "No action is needed if this service is required.  This is part of the configured operation of the server."),
    SERVICE_INITIALIZED("OMAS-PROJECT-MANAGEMENT-0003", OMRSAuditLogRecordSeverity.STARTUP, "The Project Management Open Metadata Access Service (OMAS) has initialized a new instance for server {0}", "The access service has completed initialization of a new instance.", "Verify that there were no errors reported as the service started."),
    SERVICE_SHUTDOWN("OMAS-PROJECT-MANAGEMENT-0004", OMRSAuditLogRecordSeverity.SHUTDOWN, "The Project Management Open Metadata Access Service (OMAS) is shutting down its instance for server {0}", "The local administrator has requested shut down of an Project Management OMAS instance.", "Verify that all resources have been released."),
    SERVICE_INSTANCE_FAILURE("OMAS-PROJECT-MANAGEMENT-0005", OMRSAuditLogRecordSeverity.EXCEPTION, "The Project Management Open Metadata Access Service (OMAS) is unable to initialize a new instance; error message is {0}", "The access service detected an error during the start up of a specific server instance.  Its services are not available for the server.", "Review the error message and any other reported failures to determine the cause of the problem.  Once this is resolved, restart the server.");

    private static final long serialVersionUID = 1L;
    private final AuditLogMessageDefinition messageDefinition;

    private ProjectManagementAuditCode(String messageId, OMRSAuditLogRecordSeverity severity, String message, String systemAction, String userAction) {
        this.messageDefinition = new AuditLogMessageDefinition(messageId, (AuditLogRecordSeverity)severity, message, systemAction, userAction);
    }

    public AuditLogMessageDefinition getMessageDefinition() {
        return this.messageDefinition;
    }

    public AuditLogMessageDefinition getMessageDefinition(String ... params) {
        this.messageDefinition.setMessageParameters(params);
        return this.messageDefinition;
    }
}

