/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.projectmanagement.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Date;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.projectmanagement.properties.ReferenceableProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ProjectProperties
extends ReferenceableProperties {
    private String identifier = null;
    private String name = null;
    private String description = null;
    private String projectPhase = null;
    private String projectHealth = null;
    private String projectStatus = null;
    private int priority = 0;
    private Date startDate = null;
    private Date plannedEndDate = null;

    public ProjectProperties() {
    }

    public ProjectProperties(ProjectProperties template) {
        super(template);
        if (template != null) {
            this.identifier = template.getIdentifier();
            this.name = template.getName();
            this.description = template.getDescription();
            this.projectPhase = template.getProjectPhase();
            this.projectHealth = template.getProjectHealth();
            this.projectStatus = template.getProjectStatus();
            this.priority = template.getPriority();
            this.startDate = template.getStartDate();
            this.plannedEndDate = template.getPlannedEndDate();
        }
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getProjectPhase() {
        return this.projectPhase;
    }

    public void setProjectPhase(String projectPhase) {
        this.projectPhase = projectPhase;
    }

    public String getProjectHealth() {
        return this.projectHealth;
    }

    public void setProjectHealth(String projectHealth) {
        this.projectHealth = projectHealth;
    }

    public String getProjectStatus() {
        return this.projectStatus;
    }

    public void setProjectStatus(String projectStatus) {
        this.projectStatus = projectStatus;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public Date getStartDate() {
        if (this.startDate == null) {
            return null;
        }
        return new Date(this.startDate.getTime());
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getPlannedEndDate() {
        if (this.plannedEndDate == null) {
            return null;
        }
        return new Date(this.plannedEndDate.getTime());
    }

    public void setPlannedEndDate(Date plannedEndDate) {
        this.plannedEndDate = plannedEndDate;
    }

    @Override
    public String toString() {
        return "ProjectProperties{identifier='" + this.identifier + "', name='" + this.name + "', description='" + this.description + "', phase='" + this.projectPhase + "', health='" + this.projectHealth + "', status='" + this.projectStatus + "', startDate=" + this.startDate + ", priority=" + this.priority + ", plannedEndDate=" + this.plannedEndDate + ", qualifiedName='" + this.getQualifiedName() + "', additionalProperties=" + this.getAdditionalProperties() + ", effectiveFrom=" + this.getEffectiveFrom() + ", effectiveTo=" + this.getEffectiveTo() + ", vendorProperties=" + this.getVendorProperties() + ", typeName='" + this.getTypeName() + "', extendedProperties=" + this.getExtendedProperties() + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        ProjectProperties that = (ProjectProperties)objectToCompare;
        return this.priority == that.priority && Objects.equals(this.identifier, that.identifier) && Objects.equals(this.name, that.name) && Objects.equals(this.description, that.description) && Objects.equals(this.projectPhase, that.projectPhase) && Objects.equals(this.projectHealth, that.projectHealth) && Objects.equals(this.projectStatus, that.projectStatus) && Objects.equals(this.startDate, that.startDate) && Objects.equals(this.plannedEndDate, that.plannedEndDate);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.identifier, this.name, this.description, this.projectPhase, this.projectHealth, this.projectStatus, this.priority, this.startDate, this.plannedEndDate);
    }
}

