/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.projectmanagement.client;

import java.util.List;
import org.odpi.openmetadata.accessservices.projectmanagement.api.ProjectsInterface;
import org.odpi.openmetadata.accessservices.projectmanagement.client.ProjectManagementBaseClient;
import org.odpi.openmetadata.accessservices.projectmanagement.client.rest.ProjectManagementRESTClient;
import org.odpi.openmetadata.accessservices.projectmanagement.metadataelements.ActorProfileElement;
import org.odpi.openmetadata.accessservices.projectmanagement.metadataelements.PersonRoleElement;
import org.odpi.openmetadata.accessservices.projectmanagement.metadataelements.ProjectElement;
import org.odpi.openmetadata.accessservices.projectmanagement.properties.ProjectProperties;
import org.odpi.openmetadata.accessservices.projectmanagement.properties.ProjectTeamProperties;
import org.odpi.openmetadata.accessservices.projectmanagement.properties.ReferenceableProperties;
import org.odpi.openmetadata.accessservices.projectmanagement.properties.RelationshipProperties;
import org.odpi.openmetadata.accessservices.projectmanagement.properties.TemplateProperties;
import org.odpi.openmetadata.accessservices.projectmanagement.rest.ActorProfileListResponse;
import org.odpi.openmetadata.accessservices.projectmanagement.rest.PersonRoleListResponse;
import org.odpi.openmetadata.accessservices.projectmanagement.rest.ProjectListResponse;
import org.odpi.openmetadata.accessservices.projectmanagement.rest.ProjectResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class ProjectManagement
extends ProjectManagementBaseClient
implements ProjectsInterface {
    private static final String projectURLTemplatePrefix = "/servers/{0}/open-metadata/access-services/project-profile/users/{1}/projects";

    public ProjectManagement(String serverName, String serverPlatformURLRoot, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, auditLog);
    }

    public ProjectManagement(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot);
    }

    public ProjectManagement(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password);
    }

    public ProjectManagement(String serverName, String serverPlatformURLRoot, String userId, String password, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password, auditLog);
    }

    public ProjectManagement(String serverName, String serverPlatformURLRoot, ProjectManagementRESTClient restClient, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, restClient, maxPageSize);
    }

    public String createProject(String userId, String externalSourceGUID, String externalSourceName, ProjectProperties projectProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createProject";
        String propertiesParameterName = "projectProperties";
        String urlTemplate = this.serverPlatformURLRoot + projectURLTemplatePrefix;
        return super.createReferenceable(userId, externalSourceGUID, externalSourceName, (ReferenceableProperties)projectProperties, "projectProperties", urlTemplate, "createProject");
    }

    public String createProjectFromTemplate(String userId, String externalSourceGUID, String externalSourceName, String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createProjectFromTemplate";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/project-profile/users/{1}/projects/from-template/{2}";
        return super.createReferenceableFromTemplate(userId, externalSourceGUID, externalSourceName, templateGUID, templateProperties, urlTemplate, "createProjectFromTemplate");
    }

    public void updateProject(String userId, String externalSourceGUID, String externalSourceName, String projectGUID, boolean isMergeUpdate, ProjectProperties projectProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateProject";
        String elementGUIDParameterName = "projectGUID";
        String propertiesParameterName = "projectProperties";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/project-profile/users/{1}/projects/{2}?isMergeUpdate={3}";
        super.updateReferenceable(userId, externalSourceGUID, externalSourceName, projectGUID, "projectGUID", isMergeUpdate, (ReferenceableProperties)projectProperties, "projectProperties", urlTemplate, "updateProject");
    }

    public void setupProjectManagementRole(String userId, String externalSourceGUID, String externalSourceName, String projectGUID, String personRoleGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupProjectRole";
        String projectGUIDParameterName = "projectGUID";
        String personRoleGUIDParameterName = "personRoleGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/project-profile/users/{1}/projects/{2}/project-management-roles/{3}";
        super.setupRelationship(userId, externalSourceGUID, externalSourceName, projectGUID, "projectGUID", null, personRoleGUID, "personRoleGUID", urlTemplate, "setupProjectRole");
    }

    public void clearProjectManagementRole(String userId, String externalSourceGUID, String externalSourceName, String projectGUID, String personRoleGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearProjectRole";
        String projectGUIDParameterName = "projectGUID";
        String personRoleGUIDParameterName = "personRoleGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/project-profile/users/{1}/projects/{2}/project-management-roles/{3}/delete";
        super.clearRelationship(userId, externalSourceGUID, externalSourceName, projectGUID, "projectGUID", personRoleGUID, "personRoleGUID", urlTemplate, "clearProjectRole");
    }

    public void setupProjectTeam(String userId, String externalSourceGUID, String externalSourceName, String projectGUID, ProjectTeamProperties properties, String actorProfileGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupProjectRole";
        String projectGUIDParameterName = "projectGUID";
        String personRoleGUIDParameterName = "personRoleGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/project-profile/users/{1}/projects/{2}/project-teams/{3}";
        super.setupRelationship(userId, externalSourceGUID, externalSourceName, projectGUID, "projectGUID", (RelationshipProperties)properties, actorProfileGUID, "personRoleGUID", urlTemplate, "setupProjectRole");
    }

    public void clearProjectTeam(String userId, String externalSourceGUID, String externalSourceName, String projectGUID, String actorProfileGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearProjectRole";
        String projectGUIDParameterName = "projectGUID";
        String personRoleGUIDParameterName = "personRoleGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/project-profile/users/{1}/projects/{2}/project-teams/{3}/delete";
        super.clearRelationship(userId, externalSourceGUID, externalSourceName, projectGUID, "projectGUID", actorProfileGUID, "personRoleGUID", urlTemplate, "clearProjectRole");
    }

    public void removeProject(String userId, String externalSourceGUID, String externalSourceName, String projectGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeProject";
        String elementGUIDParameterName = "projectGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/project-profile/users/{1}/projects/{2}/delete";
        super.removeReferenceable(userId, externalSourceGUID, externalSourceName, projectGUID, "projectGUID", urlTemplate, "removeProject");
    }

    public List<ProjectElement> findProjects(String userId, String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findProject";
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findProject");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findProject");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findProject");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/project-profile/users/{1}/projects/by-search-string?startFrom={2}&pageSize={3}";
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        ProjectListResponse restResult = this.restClient.callProjectListPostRESTCall("findProject", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElements();
    }

    public List<ProjectElement> getProjectsByName(String userId, String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getProjectByName";
        String nameParameterName = "name";
        this.invalidParameterHandler.validateUserId(userId, "getProjectByName");
        this.invalidParameterHandler.validateName(name, "name", "getProjectByName");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getProjectByName");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/project-profile/users/{1}/projects/by-name?startFrom={2}&pageSize={3}";
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(name);
        requestBody.setNamePropertyName("name");
        ProjectListResponse restResult = this.restClient.callProjectListPostRESTCall("getProjectByName", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElements();
    }

    public List<ProjectElement> getProjects(String userId, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getProjects";
        this.invalidParameterHandler.validateUserId(userId, "getProjects");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getProjects");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/project-profile/users/{1}/projects?startFrom={2}&pageSize={3}";
        ProjectListResponse restResult = this.restClient.callProjectListGetRESTCall("getProjects", urlTemplate, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElements();
    }

    public List<PersonRoleElement> getProjectManagementRoles(String userId, String projectGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getProjectManagementRoles";
        String guidPropertyName = "projectGUID";
        this.invalidParameterHandler.validateUserId(userId, "getProjectManagementRoles");
        this.invalidParameterHandler.validateGUID(projectGUID, "projectGUID", "getProjectManagementRoles");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/project-profile/users/{1}/projects/project-managers/by-project/{2}?startFrom={3}&pageSize={4}";
        PersonRoleListResponse restResult = this.restClient.callPersonRoleListGetRESTCall("getProjectManagementRoles", urlTemplate, this.serverName, userId, projectGUID, Integer.toString(startFrom), Integer.toString(pageSize));
        return restResult.getElements();
    }

    public List<ActorProfileElement> getProjectActors(String userId, String projectGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getProjectActors";
        String guidPropertyName = "projectGUID";
        this.invalidParameterHandler.validateUserId(userId, "getProjectActors");
        this.invalidParameterHandler.validateGUID(projectGUID, "projectGUID", "getProjectActors");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/project-profile/users/{1}/projects/project-actors/by-project/{2}?startFrom={3}&pageSize={4}";
        ActorProfileListResponse restResult = this.restClient.callActorProfileListGetRESTCall("getProjectActors", urlTemplate, this.serverName, userId, projectGUID, Integer.toString(startFrom), Integer.toString(pageSize));
        return restResult.getElements();
    }

    public ProjectElement getProjectByGUID(String userId, String projectGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getProjectByGUID";
        String guidParameterName = "projectGUID";
        this.invalidParameterHandler.validateUserId(userId, "getProjectByGUID");
        this.invalidParameterHandler.validateGUID(projectGUID, "projectGUID", "getProjectByGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/project-profile/users/{1}/projects/{2}";
        ProjectResponse restResult = this.restClient.callProjectGetRESTCall("getProjectByGUID", urlTemplate, this.serverName, userId, projectGUID);
        return restResult.getElement();
    }
}

