/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.projectmanagement.client;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.projectmanagement.api.ProjectsInterface;
import org.odpi.openmetadata.accessservices.projectmanagement.client.ProjectManagementBaseClient;
import org.odpi.openmetadata.accessservices.projectmanagement.client.rest.ProjectManagementRESTClient;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.commonservices.ffdc.rest.ActorProfilesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.PersonRolesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.ProjectResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.ProjectsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.governanceaction.converters.ProjectConverter;
import org.odpi.openmetadata.frameworks.governanceaction.converters.TeamMemberConverter;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.search.ElementProperties;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ElementStatus;
import org.odpi.openmetadata.frameworks.openmetadata.enums.SequencingOrder;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ActorProfileElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementControlHeader;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.PersonRoleElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ProjectElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ProjectTeamMember;
import org.odpi.openmetadata.frameworks.openmetadata.properties.ReferenceableProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.RelationshipProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.projects.ProjectProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.projects.ProjectTeamProperties;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;

public class ProjectManagement
extends ProjectManagementBaseClient
implements ProjectsInterface {
    private static final String projectURLTemplatePrefix = "/servers/{0}/open-metadata/access-services/project-management/users/{1}/projects";
    private final ProjectConverter<ProjectElement> projectConverter;
    private final Class<ProjectElement> projectBeanClass = ProjectElement.class;
    private final TeamMemberConverter<ProjectTeamMember> teamMemberConverter;
    private final Class<ProjectTeamMember> projectMemberBeanClass = ProjectTeamMember.class;

    public ProjectManagement(String serverName, String serverPlatformURLRoot, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, maxPageSize, auditLog);
        this.projectConverter = new ProjectConverter(this.propertyHelper, AccessServiceDescription.PROJECT_MANAGEMENT_OMAS.getAccessServiceName(), serverName);
        this.teamMemberConverter = new TeamMemberConverter(this.propertyHelper, AccessServiceDescription.PROJECT_MANAGEMENT_OMAS.getAccessServiceName(), serverName);
    }

    public ProjectManagement(String serverName, String serverPlatformURLRoot, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, maxPageSize);
        this.projectConverter = new ProjectConverter(this.propertyHelper, AccessServiceDescription.PROJECT_MANAGEMENT_OMAS.getAccessServiceName(), serverName);
        this.teamMemberConverter = new TeamMemberConverter(this.propertyHelper, AccessServiceDescription.PROJECT_MANAGEMENT_OMAS.getAccessServiceName(), serverName);
    }

    public ProjectManagement(String serverName, String serverPlatformURLRoot, String userId, String password, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password, maxPageSize);
        this.projectConverter = new ProjectConverter(this.propertyHelper, AccessServiceDescription.PROJECT_MANAGEMENT_OMAS.getAccessServiceName(), serverName);
        this.teamMemberConverter = new TeamMemberConverter(this.propertyHelper, AccessServiceDescription.PROJECT_MANAGEMENT_OMAS.getAccessServiceName(), serverName);
    }

    public ProjectManagement(String serverName, String serverPlatformURLRoot, String userId, String password, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password, maxPageSize, auditLog);
        this.projectConverter = new ProjectConverter(this.propertyHelper, AccessServiceDescription.PROJECT_MANAGEMENT_OMAS.getAccessServiceName(), serverName);
        this.teamMemberConverter = new TeamMemberConverter(this.propertyHelper, AccessServiceDescription.PROJECT_MANAGEMENT_OMAS.getAccessServiceName(), serverName);
    }

    public ProjectManagement(String serverName, String serverPlatformURLRoot, ProjectManagementRESTClient restClient, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, restClient, maxPageSize);
        this.projectConverter = new ProjectConverter(this.propertyHelper, AccessServiceDescription.PROJECT_MANAGEMENT_OMAS.getAccessServiceName(), serverName);
        this.teamMemberConverter = new TeamMemberConverter(this.propertyHelper, AccessServiceDescription.PROJECT_MANAGEMENT_OMAS.getAccessServiceName(), serverName);
    }

    public String createProject(String userId, String externalSourceGUID, String externalSourceName, ProjectProperties projectProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createProject";
        String propertiesParameterName = "projectProperties";
        String urlTemplate = this.serverPlatformURLRoot + projectURLTemplatePrefix;
        return super.createReferenceable(userId, externalSourceGUID, externalSourceName, (ReferenceableProperties)projectProperties, "projectProperties", urlTemplate, "createProject");
    }

    public String createProject(String userId, String anchorGUID, boolean isOwnAnchor, String optionalClassification, ProjectProperties properties, String parentGUID, String parentRelationshipTypeName, ElementProperties parentRelationshipProperties, boolean parentAtEnd1) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "createProject";
        String projectPropertiesName = "properties";
        String qualifiedNameParameterName = "properties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createProject");
        this.invalidParameterHandler.validateObject((Object)properties, "properties", "createProject");
        this.invalidParameterHandler.validateName(properties.getQualifiedName(), "properties.qualifiedName", "createProject");
        String projectTypeName = OpenMetadataType.PROJECT.typeName;
        if (properties.getTypeName() != null) {
            projectTypeName = properties.getTypeName();
        }
        HashMap<String, Object> initialClassifications = null;
        if (optionalClassification != null) {
            initialClassifications = new HashMap<String, Object>();
            initialClassifications.put(optionalClassification, null);
        }
        return this.openMetadataStoreClient.createMetadataElementInStore(userId, null, null, projectTypeName, ElementStatus.ACTIVE, initialClassifications, anchorGUID, isOwnAnchor, properties.getEffectiveFrom(), properties.getEffectiveTo(), this.getElementProperties(properties), parentGUID, parentRelationshipTypeName, parentRelationshipProperties, parentAtEnd1);
    }

    private ElementProperties getElementProperties(ProjectProperties projectProperties) {
        if (projectProperties != null) {
            ElementProperties elementProperties = this.propertyHelper.addStringProperty(null, OpenMetadataProperty.QUALIFIED_NAME.name, projectProperties.getQualifiedName());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.NAME.name, projectProperties.getName());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.DESCRIPTION.name, projectProperties.getDescription());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.IDENTIFIER.name, projectProperties.getIdentifier());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.PROJECT_PHASE.name, projectProperties.getProjectStatus());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.PROJECT_HEALTH.name, projectProperties.getProjectStatus());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.PROJECT_STATUS.name, projectProperties.getProjectStatus());
            elementProperties = this.propertyHelper.addDateProperty(elementProperties, OpenMetadataProperty.START_DATE.name, projectProperties.getStartDate());
            elementProperties = this.propertyHelper.addDateProperty(elementProperties, OpenMetadataProperty.PLANNED_END_DATE.name, projectProperties.getPlannedEndDate());
            elementProperties = this.propertyHelper.addStringMapProperty(elementProperties, OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, projectProperties.getAdditionalProperties());
            elementProperties = this.propertyHelper.addPropertyMap(elementProperties, projectProperties.getExtendedProperties());
            return elementProperties;
        }
        return null;
    }

    public String createProjectFromTemplate(String userId, String anchorGUID, boolean isOwnAnchor, Date effectiveFrom, Date effectiveTo, String templateGUID, ElementProperties replacementProperties, Map<String, String> placeholderProperties, String parentGUID, String parentRelationshipTypeName, ElementProperties parentRelationshipProperties, boolean parentAtEnd1) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataStoreClient.createMetadataElementFromTemplate(userId, OpenMetadataType.PROJECT.typeName, anchorGUID, isOwnAnchor, effectiveFrom, effectiveTo, templateGUID, replacementProperties, placeholderProperties, parentGUID, parentRelationshipTypeName, parentRelationshipProperties, parentAtEnd1);
    }

    public void updateProject(String userId, String externalSourceGUID, String externalSourceName, String projectGUID, boolean isMergeUpdate, ProjectProperties projectProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateProject";
        String elementGUIDParameterName = "projectGUID";
        String propertiesParameterName = "projectProperties";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/project-management/users/{1}/projects/{2}?isMergeUpdate={3}";
        super.updateReferenceable(userId, externalSourceGUID, externalSourceName, projectGUID, "projectGUID", isMergeUpdate, (ReferenceableProperties)projectProperties, "projectProperties", urlTemplate, "updateProject");
    }

    public void setupProjectManagementRole(String userId, String externalSourceGUID, String externalSourceName, String projectGUID, String personRoleGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupProjectRole";
        String projectGUIDParameterName = "projectGUID";
        String personRoleGUIDParameterName = "personRoleGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/project-management/users/{1}/projects/{2}/project-management-roles/{3}";
        super.setupRelationship(userId, externalSourceGUID, externalSourceName, projectGUID, "projectGUID", null, personRoleGUID, "personRoleGUID", urlTemplate, "setupProjectRole");
    }

    public void clearProjectManagementRole(String userId, String externalSourceGUID, String externalSourceName, String projectGUID, String personRoleGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearProjectRole";
        String projectGUIDParameterName = "projectGUID";
        String personRoleGUIDParameterName = "personRoleGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/project-management/users/{1}/projects/{2}/project-management-roles/{3}/delete";
        super.clearRelationship(userId, externalSourceGUID, externalSourceName, projectGUID, "projectGUID", personRoleGUID, "personRoleGUID", urlTemplate, "clearProjectRole");
    }

    public void setupProjectTeam(String userId, String externalSourceGUID, String externalSourceName, String projectGUID, ProjectTeamProperties properties, String actorProfileGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupProjectTeam";
        String projectGUIDParameterName = "projectGUID";
        String personRoleGUIDParameterName = "actorProfileGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/project-management/users/{1}/projects/{2}/project-teams/{3}";
        super.setupRelationship(userId, externalSourceGUID, externalSourceName, projectGUID, "projectGUID", (RelationshipProperties)properties, actorProfileGUID, "actorProfileGUID", urlTemplate, "setupProjectTeam");
    }

    public void clearProjectTeam(String userId, String externalSourceGUID, String externalSourceName, String projectGUID, String actorGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearProjectTeam";
        String projectGUIDParameterName = "projectGUID";
        String personRoleGUIDParameterName = "actorGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/project-management/users/{1}/projects/{2}/project-teams/{3}/delete";
        super.clearRelationship(userId, externalSourceGUID, externalSourceName, projectGUID, "projectGUID", actorGUID, "actorGUID", urlTemplate, "clearProjectTeam");
    }

    public void removeProject(String userId, String externalSourceGUID, String externalSourceName, String projectGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeProject";
        String elementGUIDParameterName = "projectGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/project-management/users/{1}/projects/{2}/delete";
        super.removeReferenceable(userId, externalSourceGUID, externalSourceName, projectGUID, "projectGUID", urlTemplate, "removeProject");
    }

    public List<ProjectElement> getLinkedProjects(String userId, String parentGUID, String projectStatus, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getLinkedProjects";
        String parentGUIDParameterName = "parentGUID";
        this.invalidParameterHandler.validateUserId(userId, "getLinkedProjects");
        this.invalidParameterHandler.validateGUID(parentGUID, "parentGUID", "getLinkedProjects");
        this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getLinkedProjects");
        List linkedProjects = this.openMetadataStoreClient.getRelatedMetadataElements(userId, parentGUID, 1, null, false, false, new Date(), startFrom, pageSize);
        if (linkedProjects != null) {
            ArrayList<ProjectElement> filteredProjects = new ArrayList<ProjectElement>();
            for (RelatedMetadataElement relatedMetadataElement : linkedProjects) {
                if (!this.propertyHelper.isTypeOf((ElementControlHeader)relatedMetadataElement.getElement(), OpenMetadataType.PROJECT.typeName)) continue;
                ProjectElement projectElement = (ProjectElement)this.projectConverter.getNewBean(this.projectBeanClass, relatedMetadataElement, "getLinkedProjects");
                if (projectStatus != null && !projectStatus.isBlank() && !projectStatus.equals(projectElement.getProperties().getProjectStatus())) continue;
                filteredProjects.add(projectElement);
            }
            if (!filteredProjects.isEmpty()) {
                return filteredProjects;
            }
        }
        return null;
    }

    public List<ProjectElement> getClassifiedProjects(String userId, String classificationName, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getClassifiedProjects";
        String parameterName = "classificationName";
        this.invalidParameterHandler.validateUserId(userId, "getClassifiedProjects");
        this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getClassifiedProjects");
        this.invalidParameterHandler.validateName(classificationName, "classificationName", "getClassifiedProjects");
        List openMetadataElements = this.openMetadataStoreClient.getMetadataElementsByClassification(userId, OpenMetadataType.PROJECT.typeName, null, classificationName, null, null, OpenMetadataProperty.QUALIFIED_NAME.name, SequencingOrder.PROPERTY_ASCENDING, false, false, new Date(), startFrom, pageSize);
        return this.convertProjects(openMetadataElements);
    }

    public List<ProjectTeamMember> getProjectMembers(String userId, String projectGUID, String teamRole, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getProjectMembers";
        String parentGUIDParameterName = "projectGUID";
        this.invalidParameterHandler.validateUserId(userId, "getProjectMembers");
        this.invalidParameterHandler.validateGUID(projectGUID, "projectGUID", "getProjectMembers");
        this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getProjectMembers");
        List linkedActors = this.openMetadataStoreClient.getRelatedMetadataElements(userId, projectGUID, 1, null, false, false, new Date(), startFrom, pageSize);
        if (linkedActors != null) {
            ArrayList<ProjectTeamMember> teamMembers = new ArrayList<ProjectTeamMember>();
            for (RelatedMetadataElement relatedMetadataElement : linkedActors) {
                ProjectTeamMember projectTeamMember;
                if (this.propertyHelper.isTypeOf((ElementControlHeader)relatedMetadataElement, OpenMetadataType.PROJECT_MANAGEMENT_RELATIONSHIP.typeName)) {
                    if (teamRole != null && !teamRole.isBlank() && !OpenMetadataType.PROJECT_MANAGEMENT_RELATIONSHIP.typeName.equals(teamRole)) continue;
                    projectTeamMember = (ProjectTeamMember)this.teamMemberConverter.getNewBean(this.projectMemberBeanClass, relatedMetadataElement, "getProjectMembers");
                    ProjectTeamProperties projectTeamProperties = new ProjectTeamProperties();
                    projectTeamProperties.setTeamRole(OpenMetadataType.PROJECT_MANAGEMENT_RELATIONSHIP.typeName);
                    projectTeamMember.setProjectTeamProperties(projectTeamProperties);
                    teamMembers.add(projectTeamMember);
                    continue;
                }
                if (!this.propertyHelper.isTypeOf((ElementControlHeader)relatedMetadataElement, OpenMetadataType.PROJECT_TEAM_RELATIONSHIP.typeName)) continue;
                projectTeamMember = (ProjectTeamMember)this.teamMemberConverter.getNewBean(this.projectMemberBeanClass, relatedMetadataElement, "getProjectMembers");
                if (teamRole != null && (projectTeamMember.getProjectTeamProperties() == null || !teamRole.equals(projectTeamMember.getProjectTeamProperties().getTeamRole()))) continue;
                teamMembers.add(projectTeamMember);
            }
            if (!teamMembers.isEmpty()) {
                return teamMembers;
            }
        }
        return null;
    }

    private List<ProjectElement> convertProjects(List<OpenMetadataElement> openMetadataElements) throws PropertyServerException {
        String methodName = "convertProjects";
        if (openMetadataElements != null) {
            ArrayList<ProjectElement> projectElements = new ArrayList<ProjectElement>();
            for (OpenMetadataElement openMetadataElement : openMetadataElements) {
                if (openMetadataElement == null) continue;
                projectElements.add((ProjectElement)this.projectConverter.getNewBean(this.projectBeanClass, openMetadataElement, "convertProjects"));
            }
            return projectElements;
        }
        return null;
    }

    public List<ProjectElement> findProjects(String userId, String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findProject";
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findProject");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findProject");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findProject");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/project-management/users/{1}/projects/by-search-string?startFrom={2}&pageSize={3}";
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        ProjectsResponse restResult = this.restClient.callProjectsPostRESTCall("findProject", urlTemplate, requestBody, new Object[]{this.serverName, userId, startFrom, validatedPageSize});
        return restResult.getElements();
    }

    public List<ProjectElement> getProjectsByName(String userId, String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getProjectByName";
        String nameParameterName = "name";
        this.invalidParameterHandler.validateUserId(userId, "getProjectByName");
        this.invalidParameterHandler.validateName(name, "name", "getProjectByName");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getProjectByName");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/project-management/users/{1}/projects/by-name?startFrom={2}&pageSize={3}";
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(name);
        requestBody.setNamePropertyName("name");
        ProjectsResponse restResult = this.restClient.callProjectsPostRESTCall("getProjectByName", urlTemplate, requestBody, new Object[]{this.serverName, userId, startFrom, validatedPageSize});
        return restResult.getElements();
    }

    public List<ProjectElement> getProjects(String userId, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getProjects";
        this.invalidParameterHandler.validateUserId(userId, "getProjects");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getProjects");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/project-management/users/{1}/projects?startFrom={2}&pageSize={3}";
        ProjectsResponse restResult = this.restClient.callProjectsGetRESTCall("getProjects", urlTemplate, new Object[]{this.serverName, userId, startFrom, validatedPageSize});
        return restResult.getElements();
    }

    public List<PersonRoleElement> getProjectManagementRoles(String userId, String projectGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getProjectManagementRoles";
        String guidPropertyName = "projectGUID";
        this.invalidParameterHandler.validateUserId(userId, "getProjectManagementRoles");
        this.invalidParameterHandler.validateGUID(projectGUID, "projectGUID", "getProjectManagementRoles");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/project-management/users/{1}/projects/project-managers/by-project/{2}?startFrom={3}&pageSize={4}";
        PersonRolesResponse restResult = this.restClient.callPersonRolesGetRESTCall("getProjectManagementRoles", urlTemplate, new Object[]{this.serverName, userId, projectGUID, Integer.toString(startFrom), Integer.toString(pageSize)});
        return restResult.getElements();
    }

    public List<ActorProfileElement> getProjectActors(String userId, String projectGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getProjectActors";
        String guidPropertyName = "projectGUID";
        this.invalidParameterHandler.validateUserId(userId, "getProjectActors");
        this.invalidParameterHandler.validateGUID(projectGUID, "projectGUID", "getProjectActors");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/project-management/users/{1}/projects/project-actors/by-project/{2}?startFrom={3}&pageSize={4}";
        ActorProfilesResponse restResult = this.restClient.callActorProfilesGetRESTCall("getProjectActors", urlTemplate, new Object[]{this.serverName, userId, projectGUID, Integer.toString(startFrom), Integer.toString(pageSize)});
        return restResult.getElements();
    }

    public ProjectElement getProjectByGUID(String userId, String projectGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getProjectByGUID";
        String guidParameterName = "projectGUID";
        this.invalidParameterHandler.validateUserId(userId, "getProjectByGUID");
        this.invalidParameterHandler.validateGUID(projectGUID, "projectGUID", "getProjectByGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/project-management/users/{1}/projects/{2}";
        ProjectResponse restResult = this.restClient.callProjectGetRESTCall("getProjectByGUID", urlTemplate, new Object[]{this.serverName, userId, projectGUID});
        return restResult.getElement();
    }
}

