/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.projectmanagement.converters;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.odpi.openmetadata.accessservices.projectmanagement.converters.ProjectManagementOMASConverter;
import org.odpi.openmetadata.accessservices.projectmanagement.metadataelements.ActorProfileElement;
import org.odpi.openmetadata.accessservices.projectmanagement.properties.ActorProfileProperties;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class ActorProfileConverter<B>
extends ProjectManagementOMASConverter<B> {
    public ActorProfileConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    public B getNewComplexBean(Class<B> beanClass, EntityDetail primaryEntity, List<EntityDetail> supplementaryEntities, List<Relationship> relationships, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof ActorProfileElement) {
                ActorProfileElement bean = (ActorProfileElement)returnBean;
                ActorProfileProperties profileProperties = new ActorProfileProperties();
                if (primaryEntity != null) {
                    bean.setElementHeader(this.getMetadataElementHeader(beanClass, primaryEntity, methodName));
                    InstanceProperties instanceProperties = new InstanceProperties(primaryEntity.getProperties());
                    profileProperties.setQualifiedName(this.removeQualifiedName(instanceProperties));
                    profileProperties.setKnownName(this.removeName(instanceProperties));
                    profileProperties.setDescription(this.removeDescription(instanceProperties));
                    profileProperties.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
                    profileProperties.setEffectiveFrom(instanceProperties.getEffectiveFromTime());
                    profileProperties.setEffectiveTo(instanceProperties.getEffectiveToTime());
                    profileProperties.setTypeName(bean.getElementHeader().getType().getTypeName());
                    profileProperties.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
                    bean.setProfileProperties(profileProperties);
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
                }
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }
}

