/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.projectmanagement.converters;

import org.odpi.openmetadata.accessservices.projectmanagement.metadataelements.RelatedElement;
import org.odpi.openmetadata.accessservices.projectmanagement.properties.RelationshipProperties;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementStub;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ContactMethodType;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class ProjectManagementOMASConverter<B>
extends OpenMetadataAPIGenericConverter<B> {
    long karmaPointPlateau = 0L;

    public ProjectManagementOMASConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    public ProjectManagementOMASConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName, int karmaPointPlateau) {
        this(repositoryHelper, serviceName, serverName);
        this.karmaPointPlateau = karmaPointPlateau;
    }

    public RelatedElement getRelatedElement(Class<B> beanClass, EntityDetail entity, Relationship relationship, String methodName) throws PropertyServerException {
        RelatedElement relatedElement = new RelatedElement();
        relatedElement.setRelationshipHeader(this.getMetadataElementHeader(beanClass, (InstanceHeader)relationship, null, methodName));
        if (relationship != null) {
            InstanceProperties instanceProperties = new InstanceProperties(relationship.getProperties());
            RelationshipProperties relationshipProperties = new RelationshipProperties();
            relationshipProperties.setEffectiveFrom(instanceProperties.getEffectiveFromTime());
            relationshipProperties.setEffectiveTo(instanceProperties.getEffectiveToTime());
            relationshipProperties.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
            relatedElement.setRelationshipProperties(relationshipProperties);
        } else {
            this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.RELATIONSHIP_DEF, methodName);
        }
        if (entity != null) {
            ElementStub elementStub = this.getElementStub(beanClass, entity, methodName);
            relatedElement.setRelatedElement(elementStub);
        } else {
            this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
        }
        return relatedElement;
    }

    ContactMethodType getContactMethodTypeFromProperties(InstanceProperties properties) {
        String methodName = "getContactMethodTypeFromProperties";
        ContactMethodType contactMethodType = ContactMethodType.OTHER;
        if (properties != null) {
            int ordinal = this.repositoryHelper.removeEnumPropertyOrdinal(this.serviceName, OpenMetadataProperty.CONTACT_METHOD_TYPE.name, properties, "getContactMethodTypeFromProperties");
            switch (ordinal) {
                case 0: {
                    contactMethodType = ContactMethodType.EMAIL;
                    break;
                }
                case 1: {
                    contactMethodType = ContactMethodType.PHONE;
                    break;
                }
                case 2: {
                    contactMethodType = ContactMethodType.CHAT;
                    break;
                }
                case 3: {
                    contactMethodType = ContactMethodType.PROFILE;
                    break;
                }
                case 4: {
                    contactMethodType = ContactMethodType.ACCOUNT;
                    break;
                }
                case 99: {
                    contactMethodType = ContactMethodType.OTHER;
                }
            }
        }
        return contactMethodType;
    }
}

