/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.projectmanagement.server;

import java.util.List;
import org.odpi.openmetadata.accessservices.projectmanagement.ffdc.ProjectManagementErrorCode;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.commonservices.generichandlers.ActorProfileConverter;
import org.odpi.openmetadata.commonservices.generichandlers.ActorProfileHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.PersonRoleConverter;
import org.odpi.openmetadata.commonservices.generichandlers.PersonRoleHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ProjectConverter;
import org.odpi.openmetadata.commonservices.generichandlers.ProjectHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.commonservices.generichandlers.RelatedElementConverter;
import org.odpi.openmetadata.commonservices.multitenant.OMASServiceInstance;
import org.odpi.openmetadata.commonservices.multitenant.ffdc.exceptions.NewInstanceException;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ActorProfileElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.PersonRoleElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ProjectElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.RelatedElement;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;

public class ProjectManagementServicesInstance
extends OMASServiceInstance {
    private static final AccessServiceDescription myDescription = AccessServiceDescription.PROJECT_MANAGEMENT_OMAS;
    private final ReferenceableHandler<RelatedElement> relatedElementHandler;
    private final ActorProfileHandler<ActorProfileElement> actorProfileHandler;
    private final PersonRoleHandler<PersonRoleElement> personRoleHandler;
    private final ProjectHandler<ProjectElement> projectHandler;

    public ProjectManagementServicesInstance(OMRSRepositoryConnector repositoryConnector, List<String> supportedZones, AuditLog auditLog, String localServerUserId, int maxPageSize) throws NewInstanceException {
        super(myDescription.getAccessServiceFullName(), repositoryConnector, supportedZones, null, null, auditLog, localServerUserId, maxPageSize);
        String methodName = "new ServiceInstance";
        if (this.repositoryHandler == null) {
            throw new NewInstanceException(ProjectManagementErrorCode.OMRS_NOT_INITIALIZED.getMessageDefinition(new String[]{"new ServiceInstance"}), ((Object)((Object)this)).getClass().getName(), "new ServiceInstance");
        }
        this.relatedElementHandler = new ReferenceableHandler((OpenMetadataAPIGenericConverter)new RelatedElementConverter(this.repositoryHelper, this.serviceName, this.serverName), RelatedElement.class, this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, localServerUserId, this.securityVerifier, supportedZones, this.defaultZones, this.publishZones, auditLog);
        this.actorProfileHandler = new ActorProfileHandler((OpenMetadataAPIGenericConverter)new ActorProfileConverter(this.repositoryHelper, this.serviceName, this.serverName), ActorProfileElement.class, this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, localServerUserId, this.securityVerifier, supportedZones, this.defaultZones, this.publishZones, auditLog);
        this.personRoleHandler = new PersonRoleHandler((OpenMetadataAPIGenericConverter)new PersonRoleConverter(this.repositoryHelper, this.serviceName, this.serverName), PersonRoleElement.class, this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, localServerUserId, this.securityVerifier, supportedZones, this.defaultZones, this.publishZones, auditLog);
        this.projectHandler = new ProjectHandler((OpenMetadataAPIGenericConverter)new ProjectConverter(this.repositoryHelper, this.serviceName, this.serverName), ProjectElement.class, this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, localServerUserId, this.securityVerifier, supportedZones, this.defaultZones, this.publishZones, auditLog);
    }

    public ReferenceableHandler<RelatedElement> getRelatedElementHandler() throws PropertyServerException {
        String methodName = "getRelatedElementHandler";
        this.validateActiveRepository("getRelatedElementHandler");
        return this.relatedElementHandler;
    }

    public ActorProfileHandler<ActorProfileElement> getActorProfileHandler() throws PropertyServerException {
        String methodName = "getActorProfileHandler";
        this.validateActiveRepository("getActorProfileHandler");
        return this.actorProfileHandler;
    }

    public PersonRoleHandler<PersonRoleElement> getPersonRoleHandler() throws PropertyServerException {
        String methodName = "getPersonRoleHandler";
        this.validateActiveRepository("getPersonRoleHandler");
        return this.personRoleHandler;
    }

    public ProjectHandler<ProjectElement> getProjectHandler() throws PropertyServerException {
        String methodName = "getCommunityHandler";
        this.validateActiveRepository("getCommunityHandler");
        return this.projectHandler;
    }
}

