/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.projectmanagement.server;

import java.util.Date;
import org.odpi.openmetadata.accessservices.projectmanagement.server.ProjectManagementInstanceHandler;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.ActorProfilesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.ExternalSourceRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.PersonRolesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.ReferenceableRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.RegisteredOMAGServiceResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.RelatedElementsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.RelationshipRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.generichandlers.ActorProfileHandler;
import org.odpi.openmetadata.commonservices.generichandlers.PersonRoleHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ProjectHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ActorProfileElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ActorRoleElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ProjectElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.RelatedElementStub;
import org.odpi.openmetadata.frameworks.openmetadata.properties.ReferenceableProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.RelationshipProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.actors.AssignmentScopeProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.projects.ProjectProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.projects.ProjectTeamProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.projects.StakeholderProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.resources.ResourceListProperties;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.slf4j.LoggerFactory;

public class ProjectManagementRESTServices {
    private static final ProjectManagementInstanceHandler instanceHandler = new ProjectManagementInstanceHandler();
    private final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(ProjectManagementRESTServices.class), instanceHandler.getServiceName());

    public RegisteredOMAGServiceResponse getServiceDescription(String serverName, String userId) {
        String methodName = "getServiceDescription";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getServiceDescription");
        RegisteredOMAGServiceResponse response = new RegisteredOMAGServiceResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getServiceDescription");
            response.setService(instanceHandler.getRegisteredOMAGService(userId, serverName, AccessServiceDescription.PROJECT_MANAGEMENT_OMAS.getAccessServiceCode(), "getServiceDescription"));
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getServiceDescription", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createProject(String serverName, String userId, ReferenceableRequestBody requestBody) {
        String methodName = "createProject";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createProject");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createProject");
            ProjectHandler<ProjectElement> handler = instanceHandler.getProjectHandler(userId, serverName, "createProject");
            if (requestBody != null) {
                ReferenceableProperties referenceableProperties = requestBody.getProperties();
                if (referenceableProperties instanceof ProjectProperties) {
                    ProjectProperties properties = (ProjectProperties)referenceableProperties;
                    String projectGUID = handler.createProject(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), properties.getQualifiedName(), properties.getIdentifier(), properties.getName(), properties.getDescription(), properties.getStartDate(), properties.getPlannedEndDate(), properties.getProjectPhase(), properties.getProjectHealth(), properties.getProjectStatus(), properties.getPriority(), properties.getAdditionalProperties(), properties.getTypeName(), properties.getExtendedProperties(), false, false, null, properties.getEffectiveFrom(), properties.getEffectiveTo(), new Date(), "createProject");
                    if (projectGUID != null) {
                        handler.setVendorProperties(userId, projectGUID, properties.getVendorProperties(), false, false, new Date(), "createProject");
                    }
                    response.setGUID(projectGUID);
                } else {
                    this.restExceptionHandler.handleInvalidPropertiesObject(ProjectProperties.class.getName(), "createProject");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createProject", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "createProject", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateProject(String serverName, String userId, String projectGUID, boolean isMergeUpdate, ReferenceableRequestBody requestBody) {
        String methodName = "updateProject";
        String projectGUIDParameterName = "projectGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateProject");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateProject");
            ProjectHandler<ProjectElement> handler = instanceHandler.getProjectHandler(userId, serverName, "updateProject");
            if (requestBody != null) {
                ReferenceableProperties referenceableProperties = requestBody.getProperties();
                if (referenceableProperties instanceof ProjectProperties) {
                    ProjectProperties properties = (ProjectProperties)referenceableProperties;
                    handler.updateProject(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), projectGUID, "projectGUID", properties.getQualifiedName(), properties.getIdentifier(), properties.getName(), properties.getDescription(), properties.getStartDate(), properties.getPlannedEndDate(), properties.getProjectPhase(), properties.getProjectHealth(), properties.getProjectStatus(), properties.getPriority(), properties.getAdditionalProperties(), properties.getTypeName(), properties.getExtendedProperties(), properties.getEffectiveFrom(), properties.getEffectiveTo(), isMergeUpdate, false, false, new Date(), "updateProject");
                    if (!isMergeUpdate || properties.getVendorProperties() != null) {
                        handler.setVendorProperties(userId, projectGUID, properties.getVendorProperties(), false, false, new Date(), "updateProject");
                    }
                } else {
                    this.restExceptionHandler.handleInvalidPropertiesObject(ProjectProperties.class.getName(), "updateProject");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateProject", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "updateProject", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupProjectTeam(String serverName, String userId, String projectGUID, String projectRoleGUID, RelationshipRequestBody requestBody) {
        String methodName = "setupProjectTeam";
        String projectGUIDParameterName = "projectGUID";
        String projectRoleGUIDParameterName = "projectRoleGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupProjectTeam");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupProjectTeam");
            ProjectHandler<ProjectElement> handler = instanceHandler.getProjectHandler(userId, serverName, "setupProjectTeam");
            if (requestBody != null) {
                RelationshipProperties relationshipProperties = requestBody.getProperties();
                if (relationshipProperties instanceof ProjectTeamProperties) {
                    ProjectTeamProperties properties = (ProjectTeamProperties)relationshipProperties;
                    handler.addActorToProject(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), projectGUID, "projectGUID", projectRoleGUID, "projectRoleGUID", properties.getTeamRole(), properties.getEffectiveFrom(), properties.getEffectiveTo(), false, false, new Date(), "setupProjectTeam");
                } else if (requestBody.getProperties() == null) {
                    handler.addActorToProject(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), projectGUID, "projectGUID", projectRoleGUID, "projectRoleGUID", null, null, null, false, false, new Date(), "setupProjectTeam");
                } else {
                    this.restExceptionHandler.handleInvalidPropertiesObject(ProjectTeamProperties.class.getName(), "setupProjectTeam");
                }
            } else {
                handler.addActorToProject(userId, null, null, projectGUID, "projectGUID", projectRoleGUID, "projectRoleGUID", null, null, null, false, false, new Date(), "setupProjectTeam");
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "setupProjectTeam", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearProjectTeam(String serverName, String userId, String projectGUID, String actorProfileGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "clearProjectTeam";
        String projectGUIDParameterName = "projectGUID";
        String actorProfileGUIDParameterName = "actorProfileGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearProjectTeam");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearProjectTeam");
            ProjectHandler<ProjectElement> handler = instanceHandler.getProjectHandler(userId, serverName, "clearProjectTeam");
            if (requestBody != null) {
                handler.removeActorFromProject(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), projectGUID, "projectGUID", actorProfileGUID, "actorProfileGUID", false, false, new Date(), "clearProjectTeam");
            } else {
                handler.removeActorFromProject(userId, null, null, projectGUID, "projectGUID", actorProfileGUID, "actorProfileGUID", false, false, new Date(), "clearProjectTeam");
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "clearProjectTeam", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupProjectManagementRole(String serverName, String userId, String projectGUID, String projectRoleGUID, RelationshipRequestBody requestBody) {
        String methodName = "setupProjectManagementRole";
        String projectGUIDParameterName = "projectGUID";
        String projectRoleGUIDParameterName = "projectRoleGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupProjectManagementRole");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupProjectManagementRole");
            ProjectHandler<ProjectElement> handler = instanceHandler.getProjectHandler(userId, serverName, "setupProjectManagementRole");
            if (requestBody != null) {
                if (requestBody.getProperties() != null) {
                    ProjectTeamProperties properties = (ProjectTeamProperties)requestBody.getProperties();
                    handler.addProjectManager(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), projectGUID, "projectGUID", projectRoleGUID, "projectRoleGUID", properties.getEffectiveFrom(), properties.getEffectiveTo(), false, false, new Date(), "setupProjectManagementRole");
                } else {
                    handler.addProjectManager(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), projectGUID, "projectGUID", projectRoleGUID, "projectRoleGUID", null, null, false, false, new Date(), "setupProjectManagementRole");
                }
            } else {
                handler.addProjectManager(userId, null, null, projectGUID, "projectGUID", projectRoleGUID, "projectRoleGUID", null, null, false, false, new Date(), "setupProjectManagementRole");
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "setupProjectManagementRole", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearProjectManagementRole(String serverName, String userId, String projectGUID, String projectRoleGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "clearProjectManagementRole";
        String projectGUIDParameterName = "projectGUID";
        String projectRoleGUIDParameterName = "projectRoleGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearProjectManagementRole");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearProjectManagementRole");
            ProjectHandler<ProjectElement> handler = instanceHandler.getProjectHandler(userId, serverName, "clearProjectManagementRole");
            if (requestBody != null) {
                handler.removeProjectManager(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), projectGUID, "projectGUID", projectRoleGUID, "projectRoleGUID", false, false, new Date(), "clearProjectManagementRole");
            } else {
                handler.removeProjectManager(userId, null, null, projectGUID, "projectGUID", projectRoleGUID, "projectRoleGUID", false, false, new Date(), "clearProjectManagementRole");
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "clearProjectManagementRole", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeProject(String serverName, String userId, String projectGUID, boolean cascadedDelete, ExternalSourceRequestBody requestBody) {
        String methodName = "removeProject";
        String projectGUIDParameterName = "projectGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeProject");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeProject");
            ProjectHandler<ProjectElement> handler = instanceHandler.getProjectHandler(userId, serverName, "removeProject");
            if (requestBody != null) {
                handler.removeProject(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), projectGUID, "projectGUID", cascadedDelete, false, false, new Date(), "removeProject");
            } else {
                handler.removeProject(userId, null, null, projectGUID, "projectGUID", cascadedDelete, false, false, new Date(), "removeProject");
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "removeProject", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public PersonRolesResponse getProjectManagementRoles(String serverName, String userId, String projectGUID, int startFrom, int pageSize) {
        String methodName = "getProjectManagementRoles";
        String guidParameterName = "projectGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getProjectManagementRoles");
        PersonRolesResponse response = new PersonRolesResponse();
        AuditLog auditLog = null;
        try {
            PersonRoleHandler<ActorRoleElement> handler = instanceHandler.getPersonRoleHandler(userId, serverName, "getProjectManagementRoles");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getProjectManagementRoles");
            response.setElements(handler.getProjectManagerRoles(userId, projectGUID, "projectGUID", startFrom, pageSize, false, false, new Date(), "getProjectManagementRoles"));
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getProjectManagementRoles", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ActorProfilesResponse getProjectActors(String serverName, String userId, String projectGUID, int startFrom, int pageSize) {
        String methodName = "getProjectActors";
        String guidParameterName = "projectGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getProjectActors");
        ActorProfilesResponse response = new ActorProfilesResponse();
        AuditLog auditLog = null;
        try {
            ActorProfileHandler<ActorProfileElement> handler = instanceHandler.getActorProfileHandler(userId, serverName, "getProjectActors");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getProjectActors");
            response.setElements(handler.getActorsForProject(userId, projectGUID, "projectGUID", startFrom, pageSize, false, false, new Date(), "getProjectActors"));
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getProjectActors", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupMoreInformation(String serverName, String userId, String elementGUID, String detailGUID, RelationshipRequestBody requestBody) {
        String methodName = "setupMoreInformation";
        String elementGUIDParameterName = "elementGUID";
        String detailGUIDParameterName = "detailGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupMoreInformation");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupMoreInformation");
            ReferenceableHandler<RelatedElementStub> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "setupMoreInformation");
            if (requestBody != null) {
                if (requestBody.getProperties() != null) {
                    handler.addMoreInformation(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), elementGUID, "elementGUID", detailGUID, "detailGUID", requestBody.getProperties().getEffectiveFrom(), requestBody.getProperties().getEffectiveTo(), false, false, new Date(), "setupMoreInformation");
                } else {
                    handler.addMoreInformation(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), elementGUID, "elementGUID", detailGUID, "detailGUID", null, null, false, false, new Date(), "setupMoreInformation");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "setupMoreInformation", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "setupMoreInformation", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearMoreInformation(String serverName, String userId, String elementGUID, String detailGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "clearMoreInformation";
        String elementGUIDParameterName = "elementGUID";
        String detailGUIDParameterName = "detailGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearMoreInformation");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearMoreInformation");
            ReferenceableHandler<RelatedElementStub> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "clearMoreInformation");
            if (requestBody != null) {
                handler.removeMoreInformation(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), elementGUID, "elementGUID", detailGUID, "detailGUID", false, false, new Date(), "clearMoreInformation");
            } else {
                handler.removeMoreInformation(userId, null, null, elementGUID, "elementGUID", detailGUID, "detailGUID", false, false, new Date(), "clearMoreInformation");
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "clearMoreInformation", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelatedElementsResponse getMoreInformation(String serverName, String userId, String elementGUID, int startFrom, int pageSize) {
        String methodName = "getMoreInformation";
        String guidPropertyName = "elementGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getMoreInformation");
        RelatedElementsResponse response = new RelatedElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getMoreInformation");
            ReferenceableHandler<RelatedElementStub> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "getMoreInformation");
            response.setElements(handler.getMoreInformation(userId, elementGUID, "elementGUID", OpenMetadataType.REFERENCEABLE.typeName, OpenMetadataType.REFERENCEABLE.typeName, startFrom, pageSize, false, false, new Date(), "getMoreInformation"));
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getMoreInformation", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelatedElementsResponse getDescriptiveElements(String serverName, String userId, String detailGUID, int startFrom, int pageSize) {
        String methodName = "getDescriptiveElements";
        String guidPropertyName = "detailGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getDescriptiveElements");
        RelatedElementsResponse response = new RelatedElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDescriptiveElements");
            ReferenceableHandler<RelatedElementStub> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "getDescriptiveElements");
            response.setElements(handler.getDescriptiveElements(userId, detailGUID, "detailGUID", OpenMetadataType.REFERENCEABLE.typeName, OpenMetadataType.REFERENCEABLE.typeName, startFrom, pageSize, false, false, new Date(), "getDescriptiveElements"));
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getDescriptiveElements", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupStakeholder(String serverName, String userId, String elementGUID, String stakeholderGUID, RelationshipRequestBody requestBody) {
        String methodName = "setupStakeholder";
        String elementGUIDParameterName = "elementGUID";
        String stakeholderGUIDParameterName = "stakeholderGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupStakeholder");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupStakeholder");
            ReferenceableHandler<RelatedElementStub> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "setupStakeholder");
            if (requestBody != null) {
                RelationshipProperties relationshipProperties = requestBody.getProperties();
                if (relationshipProperties instanceof StakeholderProperties) {
                    StakeholderProperties properties = (StakeholderProperties)relationshipProperties;
                    handler.addStakeholder(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), elementGUID, "elementGUID", stakeholderGUID, "stakeholderGUID", properties.getStakeholderRole(), properties.getEffectiveFrom(), properties.getEffectiveTo(), false, false, new Date(), "setupStakeholder");
                } else if (requestBody.getProperties() == null) {
                    handler.addStakeholder(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), elementGUID, "elementGUID", stakeholderGUID, "stakeholderGUID", null, null, null, false, false, new Date(), "setupStakeholder");
                } else {
                    this.restExceptionHandler.handleInvalidPropertiesObject(StakeholderProperties.class.getName(), "setupStakeholder");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "setupStakeholder", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "setupStakeholder", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearStakeholder(String serverName, String userId, String elementGUID, String stakeholderGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "clearStakeholder";
        String elementGUIDParameterName = "elementGUID";
        String stakeholderGUIDParameterName = "stakeholderGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearStakeholder");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearStakeholder");
            ReferenceableHandler<RelatedElementStub> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "clearStakeholder");
            if (requestBody != null) {
                handler.removeStakeholder(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), elementGUID, "elementGUID", stakeholderGUID, "stakeholderGUID", false, false, new Date(), "clearStakeholder");
            } else {
                handler.removeStakeholder(userId, null, null, elementGUID, "elementGUID", stakeholderGUID, "stakeholderGUID", false, false, new Date(), "clearStakeholder");
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "clearStakeholder", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelatedElementsResponse getStakeholders(String serverName, String userId, String elementGUID, int startFrom, int pageSize) {
        String methodName = "getStakeholders";
        String guidPropertyName = "elementGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getStakeholders");
        RelatedElementsResponse response = new RelatedElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getStakeholders");
            ReferenceableHandler<RelatedElementStub> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "getStakeholders");
            response.setElements(handler.getStakeholders(userId, elementGUID, "elementGUID", OpenMetadataType.REFERENCEABLE.typeName, OpenMetadataType.REFERENCEABLE.typeName, startFrom, pageSize, false, false, new Date(), "getStakeholders"));
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getStakeholders", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelatedElementsResponse getStakeholderCommissionedElements(String serverName, String userId, String stakeholderGUID, int startFrom, int pageSize) {
        String methodName = "getStakeholderCommissionedElements";
        String guidPropertyName = "stakeholderGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getStakeholderCommissionedElements");
        RelatedElementsResponse response = new RelatedElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getStakeholderCommissionedElements");
            ReferenceableHandler<RelatedElementStub> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "getStakeholderCommissionedElements");
            response.setElements(handler.getCommissionedByStakeholder(userId, stakeholderGUID, "stakeholderGUID", OpenMetadataType.REFERENCEABLE.typeName, OpenMetadataType.REFERENCEABLE.typeName, startFrom, pageSize, false, false, new Date(), "getStakeholderCommissionedElements"));
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getStakeholderCommissionedElements", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupAssignmentScope(String serverName, String userId, String elementGUID, String scopeGUID, RelationshipRequestBody requestBody) {
        String methodName = "setupAssignmentScope";
        String elementGUIDParameterName = "elementGUID";
        String scopeGUIDParameterName = "scopeGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupAssignmentScope");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupAssignmentScope");
            ReferenceableHandler<RelatedElementStub> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "setupAssignmentScope");
            if (requestBody != null) {
                RelationshipProperties relationshipProperties = requestBody.getProperties();
                if (relationshipProperties instanceof AssignmentScopeProperties) {
                    AssignmentScopeProperties properties = (AssignmentScopeProperties)relationshipProperties;
                    handler.addAssignmentScope(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), elementGUID, "elementGUID", scopeGUID, "scopeGUID", properties.getAssignmentType(), properties.getDescription(), properties.getEffectiveFrom(), properties.getEffectiveTo(), false, false, new Date(), "setupAssignmentScope");
                } else if (requestBody.getProperties() == null) {
                    handler.addAssignmentScope(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), elementGUID, "elementGUID", scopeGUID, "scopeGUID", null, null, null, null, false, false, new Date(), "setupAssignmentScope");
                } else {
                    this.restExceptionHandler.handleInvalidPropertiesObject(AssignmentScopeProperties.class.getName(), "setupAssignmentScope");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "setupAssignmentScope", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "setupAssignmentScope", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearAssignmentScope(String serverName, String userId, String elementGUID, String scopeGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "clearAssignmentScope";
        String elementGUIDParameterName = "elementGUID";
        String scopeGUIDParameterName = "scopeGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearAssignmentScope");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearAssignmentScope");
            ReferenceableHandler<RelatedElementStub> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "clearAssignmentScope");
            if (requestBody != null) {
                handler.removeAssignmentScope(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), elementGUID, "elementGUID", scopeGUID, "scopeGUID", false, false, new Date(), "clearAssignmentScope");
            } else {
                handler.removeAssignmentScope(userId, null, null, elementGUID, "elementGUID", scopeGUID, "scopeGUID", false, false, new Date(), "clearAssignmentScope");
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "clearAssignmentScope", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelatedElementsResponse getAssignedScopes(String serverName, String userId, String elementGUID, int startFrom, int pageSize) {
        String methodName = "getAssignedScopes";
        String guidPropertyName = "elementGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAssignedScopes");
        RelatedElementsResponse response = new RelatedElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAssignedScopes");
            ReferenceableHandler<RelatedElementStub> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "getAssignedScopes");
            response.setElements(handler.getAssignmentScope(userId, elementGUID, "elementGUID", OpenMetadataType.REFERENCEABLE.typeName, OpenMetadataType.REFERENCEABLE.typeName, startFrom, pageSize, false, false, new Date(), "getAssignedScopes"));
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getAssignedScopes", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelatedElementsResponse getAssignedActors(String serverName, String userId, String scopeGUID, int startFrom, int pageSize) {
        String methodName = "getAssignedActors";
        String guidPropertyName = "scopeGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAssignedActors");
        RelatedElementsResponse response = new RelatedElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAssignedActors");
            ReferenceableHandler<RelatedElementStub> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "getAssignedActors");
            response.setElements(handler.getAssignedActors(userId, scopeGUID, "scopeGUID", OpenMetadataType.REFERENCEABLE.typeName, OpenMetadataType.REFERENCEABLE.typeName, startFrom, pageSize, false, false, new Date(), "getAssignedActors"));
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getAssignedActors", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupResource(String serverName, String userId, String elementGUID, String resourceGUID, RelationshipRequestBody requestBody) {
        String methodName = "setupResource";
        String elementGUIDParameterName = "elementGUID";
        String resourceGUIDParameterName = "resourceGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupResource");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupResource");
            ReferenceableHandler<RelatedElementStub> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "setupResource");
            if (requestBody != null) {
                RelationshipProperties relationshipProperties = requestBody.getProperties();
                if (relationshipProperties instanceof ResourceListProperties) {
                    ResourceListProperties properties = (ResourceListProperties)relationshipProperties;
                    handler.saveResourceListMember(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), elementGUID, "elementGUID", resourceGUID, "resourceGUID", properties.getResourceUse(), properties.getResourceUseDescription(), properties.getResourceUseProperties(), properties.getWatchResource(), properties.getEffectiveFrom(), properties.getEffectiveTo(), false, false, new Date(), "setupResource");
                } else if (requestBody.getProperties() == null) {
                    handler.saveResourceListMember(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), elementGUID, "elementGUID", resourceGUID, "resourceGUID", null, null, null, false, null, null, false, false, new Date(), "setupResource");
                } else {
                    this.restExceptionHandler.handleInvalidPropertiesObject(ResourceListProperties.class.getName(), "setupResource");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "setupResource", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "setupResource", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearResource(String serverName, String userId, String elementGUID, String resourceGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "clearResource";
        String elementGUIDParameterName = "elementGUID";
        String resourceGUIDParameterName = "resourceGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearResource");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearResource");
            ReferenceableHandler<RelatedElementStub> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "clearResource");
            if (requestBody != null) {
                handler.removeResourceListMember(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), elementGUID, "elementGUID", resourceGUID, "resourceGUID", false, false, new Date(), "clearResource");
            } else {
                handler.removeResourceListMember(userId, null, null, elementGUID, "elementGUID", resourceGUID, "resourceGUID", false, false, new Date(), "clearResource");
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "clearResource", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelatedElementsResponse getResourceList(String serverName, String userId, String elementGUID, int startFrom, int pageSize) {
        String methodName = "getResourceList";
        String guidPropertyName = "elementGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getResourceList");
        RelatedElementsResponse response = new RelatedElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getResourceList");
            ReferenceableHandler<RelatedElementStub> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "getResourceList");
            response.setElements(handler.getResourceList(userId, elementGUID, "elementGUID", OpenMetadataType.REFERENCEABLE.typeName, startFrom, pageSize, false, false, new Date(), "getResourceList"));
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getResourceList", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelatedElementsResponse getSupportedByResource(String serverName, String userId, String resourceGUID, int startFrom, int pageSize) {
        String methodName = "getSupportedByResource";
        String guidPropertyName = "resourceGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getSupportedByResource");
        RelatedElementsResponse response = new RelatedElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getSupportedByResource");
            ReferenceableHandler<RelatedElementStub> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "getSupportedByResource");
            response.setElements(handler.getSupportedByResource(userId, resourceGUID, "resourceGUID", OpenMetadataType.REFERENCEABLE.typeName, startFrom, pageSize, false, false, new Date(), "getSupportedByResource"));
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getSupportedByResource", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

