/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.projectmanagement.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.accessservices.projectmanagement.rest.ActorProfileListResponse;
import org.odpi.openmetadata.accessservices.projectmanagement.rest.ExternalSourceRequestBody;
import org.odpi.openmetadata.accessservices.projectmanagement.rest.PersonRoleListResponse;
import org.odpi.openmetadata.accessservices.projectmanagement.rest.ProjectListResponse;
import org.odpi.openmetadata.accessservices.projectmanagement.rest.ProjectResponse;
import org.odpi.openmetadata.accessservices.projectmanagement.rest.ReferenceableRequestBody;
import org.odpi.openmetadata.accessservices.projectmanagement.rest.RelatedElementListResponse;
import org.odpi.openmetadata.accessservices.projectmanagement.rest.RelationshipRequestBody;
import org.odpi.openmetadata.accessservices.projectmanagement.rest.TemplateRequestBody;
import org.odpi.openmetadata.accessservices.projectmanagement.server.ProjectManagementRESTServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/project-management/users/{userId}"})
@Tag(name="Project Management OMAS", description="The Project Management OMAS provides APIs and events for tools and applications that support project leaders - particularly those who are leading governance projects.\n", externalDocs=@ExternalDocumentation(description="Project Management Open Metadata Access Service (OMAS)", url="https://egeria-project.org/services/omas/project-management/overview/"))
public class ProjectManagementResource {
    private ProjectManagementRESTServices restAPI = new ProjectManagementRESTServices();

    @PostMapping(path={"/projects"})
    public GUIDResponse createProject(@PathVariable String serverName, @PathVariable String userId, @RequestBody ReferenceableRequestBody requestBody) {
        return this.restAPI.createProject(serverName, userId, requestBody);
    }

    @PostMapping(path={"/projects/from-template/{templateGUID}"})
    public GUIDResponse createProjectFromTemplate(@PathVariable String serverName, @PathVariable String userId, @PathVariable String templateGUID, @RequestBody TemplateRequestBody requestBody) {
        return this.restAPI.createProjectFromTemplate(serverName, userId, templateGUID, requestBody);
    }

    @PostMapping(path={"/projects/{projectGUID}"})
    public VoidResponse updateProject(@PathVariable String serverName, @PathVariable String userId, @PathVariable String projectGUID, @RequestParam boolean isMergeUpdate, @RequestBody ReferenceableRequestBody requestBody) {
        return this.restAPI.updateProject(serverName, userId, projectGUID, isMergeUpdate, requestBody);
    }

    @PostMapping(path={"/projects/{projectGUID}/project-management-roles/{projectRoleGUID}"})
    public VoidResponse setupProjectManagementRole(@PathVariable String serverName, @PathVariable String userId, @PathVariable String projectGUID, @PathVariable String projectRoleGUID, @RequestBody RelationshipRequestBody requestBody) {
        return this.restAPI.setupProjectManagementRole(serverName, userId, projectGUID, projectRoleGUID, requestBody);
    }

    @PostMapping(path={"/projects/{projectGUID}/project-management-roles/{projectRoleGUID}/delete"})
    public VoidResponse clearProjectManagementRole(@PathVariable String serverName, @PathVariable String userId, @PathVariable String projectGUID, @PathVariable String projectRoleGUID, @RequestBody ExternalSourceRequestBody requestBody) {
        return this.restAPI.clearProjectManagementRole(serverName, userId, projectGUID, projectRoleGUID, requestBody);
    }

    @PostMapping(path={"/projects/{projectGUID}/project-teams/{actorProfileGUID}"})
    public VoidResponse setupProjectTeam(@PathVariable String serverName, @PathVariable String userId, @PathVariable String projectGUID, @PathVariable String actorProfileGUID, @RequestBody RelationshipRequestBody requestBody) {
        return this.restAPI.setupProjectTeam(serverName, userId, projectGUID, actorProfileGUID, requestBody);
    }

    @PostMapping(path={"/projects/{projectGUID}/project-teams/{actorProfileGUID}/delete"})
    public VoidResponse clearProjectTeam(@PathVariable String serverName, @PathVariable String userId, @PathVariable String projectGUID, @PathVariable String actorProfileGUID, @RequestBody ExternalSourceRequestBody requestBody) {
        return this.restAPI.clearProjectTeam(serverName, userId, projectGUID, actorProfileGUID, requestBody);
    }

    @PostMapping(path={"/projects/{projectGUID}/delete"})
    public VoidResponse removeProject(@PathVariable String serverName, @PathVariable String userId, @PathVariable String projectGUID, @RequestBody ExternalSourceRequestBody requestBody) {
        return this.restAPI.removeProject(serverName, userId, projectGUID, requestBody);
    }

    @PostMapping(path={"/projects/by-search-string"})
    public ProjectListResponse findProjects(@PathVariable String serverName, @PathVariable String userId, @RequestBody SearchStringRequestBody requestBody, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.findProjects(serverName, userId, requestBody, startFrom, pageSize);
    }

    @PostMapping(path={"/projects/by-name"})
    public ProjectListResponse getProjectsByName(@PathVariable String serverName, @PathVariable String userId, @RequestBody NameRequestBody requestBody, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getProjectsByName(serverName, userId, requestBody, startFrom, pageSize);
    }

    @GetMapping(path={"/project-managers/by-project/{projectGUID}"})
    public PersonRoleListResponse getProjectManagementRoles(@PathVariable String serverName, @PathVariable String userId, @PathVariable String projectGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getProjectManagementRoles(serverName, userId, projectGUID, startFrom, pageSize);
    }

    @GetMapping(path={"/project-actors/by-project/{projectGUID}"})
    public ActorProfileListResponse getProjectActors(@PathVariable String serverName, @PathVariable String userId, @PathVariable String projectGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getProjectActors(serverName, userId, projectGUID, startFrom, pageSize);
    }

    @GetMapping(path={"/projects"})
    public ProjectListResponse getProjectsByName(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getProjects(serverName, userId, startFrom, pageSize);
    }

    @GetMapping(path={"/projects/{guid}"})
    public ProjectResponse getProjectByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getProjectByGUID(serverName, userId, guid);
    }

    @PostMapping(path={"/related-elements/{elementGUID}/more-information/{detailGUID}"})
    public VoidResponse setupMoreInformation(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @PathVariable String detailGUID, @RequestBody RelationshipRequestBody requestBody) {
        return this.restAPI.setupMoreInformation(serverName, userId, elementGUID, detailGUID, requestBody);
    }

    @PostMapping(path={"/related-elements/{elementGUID}/more-information/{detailGUID}/delete"})
    public VoidResponse clearMoreInformation(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @PathVariable String detailGUID, @RequestBody ExternalSourceRequestBody requestBody) {
        return this.restAPI.clearMoreInformation(serverName, userId, elementGUID, detailGUID, requestBody);
    }

    @GetMapping(path={"/related-elements/more-information/by-descriptive-element/{elementGUID}"})
    public RelatedElementListResponse getMoreInformation(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getMoreInformation(serverName, userId, elementGUID, startFrom, pageSize);
    }

    @GetMapping(path={"/related-elements/more-information/by-detail-element/{detailGUID}"})
    public RelatedElementListResponse getDescriptiveElements(@PathVariable String serverName, @PathVariable String userId, @PathVariable String detailGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getDescriptiveElements(serverName, userId, detailGUID, startFrom, pageSize);
    }

    @PostMapping(path={"/related-elements/{elementGUID}/stakeholders/{stakeholderGUID}"})
    public VoidResponse setupStakeholder(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @PathVariable String stakeholderGUID, @RequestBody RelationshipRequestBody requestBody) {
        return this.restAPI.setupStakeholder(serverName, userId, elementGUID, stakeholderGUID, requestBody);
    }

    @PostMapping(path={"/related-elements/{elementGUID}/stakeholders/{stakeholderGUID}/delete"})
    public VoidResponse clearStakeholder(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @PathVariable String stakeholderGUID, @RequestBody ExternalSourceRequestBody requestBody) {
        return this.restAPI.clearStakeholder(serverName, userId, elementGUID, stakeholderGUID, requestBody);
    }

    @GetMapping(path={"/related-elements/stakeholders/by-commissioned-element/{elementGUID}"})
    public RelatedElementListResponse getStakeholders(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getStakeholders(serverName, userId, elementGUID, startFrom, pageSize);
    }

    @GetMapping(path={"/related-elements/stakeholders/by-stakeholder/{stakeholderGUID}"})
    public RelatedElementListResponse getStakeholderCommissionedElements(@PathVariable String serverName, @PathVariable String userId, @PathVariable String stakeholderGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getStakeholderCommissionedElements(serverName, userId, stakeholderGUID, startFrom, pageSize);
    }

    @PostMapping(path={"/related-elements/{elementGUID}/assignment-scopes/{scopeGUID}"})
    public VoidResponse setupAssignmentScope(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @PathVariable String scopeGUID, @RequestBody RelationshipRequestBody requestBody) {
        return this.restAPI.setupAssignmentScope(serverName, userId, elementGUID, scopeGUID, requestBody);
    }

    @PostMapping(path={"/related-elements/{elementGUID}/assignment-scopes/{scopeGUID}/delete"})
    public VoidResponse clearAssignmentScope(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @PathVariable String scopeGUID, @RequestBody ExternalSourceRequestBody requestBody) {
        return this.restAPI.clearAssignmentScope(serverName, userId, elementGUID, scopeGUID, requestBody);
    }

    @GetMapping(path={"/related-elements/assignment-scopes/by-assigned-actor/{elementGUID}"})
    public RelatedElementListResponse getAssignedScopes(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getAssignedScopes(serverName, userId, elementGUID, startFrom, pageSize);
    }

    @GetMapping(path={"/related-elements/assignment-scopes/by-assigned-scope/{scopeGUID}"})
    public RelatedElementListResponse getAssignedActors(@PathVariable String serverName, @PathVariable String userId, @PathVariable String scopeGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getAssignedActors(serverName, userId, scopeGUID, startFrom, pageSize);
    }

    @PostMapping(path={"/related-elements/{elementGUID}/resource-list/{resourceGUID}"})
    public VoidResponse setupResource(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @PathVariable String resourceGUID, @RequestBody RelationshipRequestBody requestBody) {
        return this.restAPI.setupResource(serverName, userId, elementGUID, resourceGUID, requestBody);
    }

    @PostMapping(path={"/related-elements/{elementGUID}/resource-list/{resourceGUID}/delete"})
    public VoidResponse clearResource(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @PathVariable String resourceGUID, @RequestBody ExternalSourceRequestBody requestBody) {
        return this.restAPI.clearResource(serverName, userId, elementGUID, resourceGUID, requestBody);
    }

    @GetMapping(path={"/related-elements/resource-list/by-assignee/{elementGUID}"})
    public RelatedElementListResponse getResourceList(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getResourceList(serverName, userId, elementGUID, startFrom, pageSize);
    }

    @GetMapping(path={"/related-elements/resource-list/by-resource/{resourceGUID}"})
    public RelatedElementListResponse getSupportedByResource(@PathVariable String serverName, @PathVariable String userId, @PathVariable String resourceGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getSupportedByResource(serverName, userId, resourceGUID, startFrom, pageSize);
    }
}

