/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.projectmanager.server;

import org.odpi.openmetadata.accessservices.projectmanagement.client.ConnectedAssetClient;
import org.odpi.openmetadata.accessservices.projectmanagement.client.OpenMetadataStoreClient;
import org.odpi.openmetadata.accessservices.projectmanagement.client.ProjectManagement;
import org.odpi.openmetadata.adminservices.configuration.registration.ViewServiceDescription;
import org.odpi.openmetadata.commonservices.multitenant.OMVSServiceInstance;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;

public class ProjectManagerInstance
extends OMVSServiceInstance {
    private static final ViewServiceDescription myDescription = ViewServiceDescription.PROJECT_MANAGER;
    private final ProjectManagement projectManagement;
    private final ConnectedAssetClient connectedAssetClient;
    private final OpenMetadataStoreClient openMetadataStoreClient;

    public ProjectManagerInstance(String serverName, AuditLog auditLog, String localServerUserId, int maxPageSize, String remoteServerName, String remoteServerURL) throws InvalidParameterException {
        super(serverName, myDescription.getViewServiceName(), auditLog, localServerUserId, maxPageSize, remoteServerName, remoteServerURL);
        this.projectManagement = new ProjectManagement(remoteServerName, remoteServerURL, maxPageSize);
        this.connectedAssetClient = new ConnectedAssetClient(remoteServerName, remoteServerURL, maxPageSize);
        this.openMetadataStoreClient = new OpenMetadataStoreClient(remoteServerName, remoteServerURL, maxPageSize);
    }

    public ProjectManagement getProjectManagement() {
        return this.projectManagement;
    }

    public ConnectedAssetClient getConnectedAssetClient() {
        return this.connectedAssetClient;
    }

    public OpenMetadataStoreClient getOpenMetadataStoreClient() {
        return this.openMetadataStoreClient;
    }
}

