/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.projectmanager.server;

import org.odpi.openmetadata.accessservices.projectmanagement.client.ProjectManagement;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.ExternalSourceRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.FilterRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NewProjectRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.ProjectGraphResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.ProjectMembersResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.ProjectResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.ProjectsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.RelatedElementsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.RelationshipRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.TemplateRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.properties.RelationshipProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.projects.ProjectProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.projects.ProjectTeamProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.resources.ResourceListProperties;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.tokencontroller.TokenController;
import org.odpi.openmetadata.viewservices.projectmanager.server.ProjectManagerInstanceHandler;
import org.slf4j.LoggerFactory;

public class ProjectManagerRESTServices
extends TokenController {
    private static final ProjectManagerInstanceHandler instanceHandler = new ProjectManagerInstanceHandler();
    private static final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(ProjectManagerRESTServices.class), instanceHandler.getServiceName());

    public ProjectsResponse getLinkedProjects(String serverName, String parentGUID, int startFrom, int pageSize, FilterRequestBody requestBody) {
        String methodName = "getLinkedProjects";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getLinkedProjects");
        ProjectsResponse response = new ProjectsResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getLinkedProjects");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getLinkedProjects");
            ProjectManagement handler = instanceHandler.getProjectManagement(userId, serverName, "getLinkedProjects");
            if (requestBody != null) {
                response.setElements(handler.getLinkedProjects(userId, parentGUID, requestBody.getFilter(), startFrom, pageSize));
            } else {
                response.setElements(handler.getLinkedProjects(userId, parentGUID, null, startFrom, pageSize));
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getLinkedProjects", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ProjectMembersResponse getProjectTeam(String serverName, String projectGUID, int startFrom, int pageSize, FilterRequestBody requestBody) {
        String methodName = "getProjectTeam";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getProjectTeam");
        ProjectMembersResponse response = new ProjectMembersResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getProjectTeam");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getProjectTeam");
            ProjectManagement handler = instanceHandler.getProjectManagement(userId, serverName, "getProjectTeam");
            if (requestBody != null) {
                response.setElements(handler.getProjectMembers(userId, projectGUID, requestBody.getFilter(), startFrom, pageSize));
            } else {
                response.setElements(handler.getProjectMembers(userId, projectGUID, null, startFrom, pageSize));
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getProjectTeam", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ProjectsResponse getClassifiedProjects(String serverName, int startFrom, int pageSize, FilterRequestBody requestBody) {
        String methodName = "getClassifiedProjects";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getClassifiedProjects");
        ProjectsResponse response = new ProjectsResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getClassifiedProjects");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getClassifiedProjects");
            ProjectManagement handler = instanceHandler.getProjectManagement(userId, serverName, "getClassifiedProjects");
            if (requestBody != null) {
                response.setElements(handler.getClassifiedProjects(userId, requestBody.getFilter(), startFrom, pageSize));
            } else {
                response.setElements(handler.getClassifiedProjects(userId, null, startFrom, pageSize));
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getClassifiedProjects", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ProjectsResponse findProjects(String serverName, boolean startsWith, boolean endsWith, boolean ignoreCase, int startFrom, int pageSize, FilterRequestBody requestBody) {
        String methodName = "findProjects";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "findProjects");
        ProjectsResponse response = new ProjectsResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "findProjects");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findProjects");
            ProjectManagement handler = instanceHandler.getProjectManagement(userId, serverName, "findProjects");
            if (requestBody != null) {
                response.setElements(handler.findProjects(userId, instanceHandler.getSearchString(requestBody.getFilter(), startsWith, endsWith, ignoreCase), startFrom, pageSize));
            } else {
                response.setElements(handler.findProjects(userId, "", startFrom, pageSize));
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "findProjects", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ProjectsResponse getProjectsByName(String serverName, int startFrom, int pageSize, FilterRequestBody requestBody) {
        String methodName = "getProjectsByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getProjectsByName");
        ProjectsResponse response = new ProjectsResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getProjectsByName");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getProjectsByName");
            ProjectManagement handler = instanceHandler.getProjectManagement(userId, serverName, "getProjectsByName");
            if (requestBody != null) {
                response.setElements(handler.getProjectsByName(userId, requestBody.getFilter(), startFrom, pageSize));
            } else {
                response.setElements(handler.getProjectsByName(userId, null, startFrom, pageSize));
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getProjectsByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ProjectResponse getProject(String serverName, String projectGUID) {
        String methodName = "getProject";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getProject");
        ProjectResponse response = new ProjectResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getProject");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getProject");
            ProjectManagement handler = instanceHandler.getProjectManagement(userId, serverName, "getProject");
            response.setElement(handler.getProjectByGUID(userId, projectGUID));
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getProject", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ProjectGraphResponse getProjectGraph(String serverName, String projectGUID) {
        String methodName = "getProjectGraph";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getProjectGraph");
        ProjectGraphResponse response = new ProjectGraphResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getProjectGraph");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getProjectGraph");
            ProjectManagement handler = instanceHandler.getProjectManagement(userId, serverName, "getProjectGraph");
            response.setElement(handler.getProjectGraph(userId, projectGUID));
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getProjectGraph", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createProject(String serverName, String optionalClassificationName, NewProjectRequestBody requestBody) {
        String methodName = "createProject";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "createProject");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "createProject");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createProject");
            if (requestBody != null) {
                ProjectManagement handler = instanceHandler.getProjectManagement(userId, serverName, "createProject");
                response.setGUID(handler.createProject(userId, requestBody.getAnchorGUID(), requestBody.getIsOwnAnchor(), requestBody.getAnchorScopeGUID(), optionalClassificationName, requestBody.getProjectProperties(), requestBody.getParentGUID(), requestBody.getParentRelationshipTypeName(), requestBody.getParentRelationshipProperties(), requestBody.getParentAtEnd1()));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "createProject", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "createProject", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createTaskForProject(String serverName, String projectGUID, ProjectProperties requestBody) {
        String methodName = "createTaskForProject";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "createTaskForProject");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "createTaskForProject");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createTaskForProject");
            if (requestBody != null) {
                ProjectManagement handler = instanceHandler.getProjectManagement(userId, serverName, "createTaskForProject");
                response.setGUID(handler.createProject(userId, projectGUID, false, null, OpenMetadataType.TASK_CLASSIFICATION.typeName, requestBody, projectGUID, OpenMetadataType.PROJECT_HIERARCHY_RELATIONSHIP.typeName, null, true));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "createTaskForProject", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "createTaskForProject", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createProjectFromTemplate(String serverName, TemplateRequestBody requestBody) {
        String methodName = "createProjectFromTemplate";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "createProjectFromTemplate");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "createProjectFromTemplate");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createProjectFromTemplate");
            if (requestBody != null) {
                ProjectManagement handler = instanceHandler.getProjectManagement(userId, serverName, "createProjectFromTemplate");
                response.setGUID(handler.createProjectFromTemplate(userId, requestBody.getAnchorGUID(), requestBody.getIsOwnAnchor(), requestBody.getAnchorScopeGUID(), null, null, requestBody.getTemplateGUID(), requestBody.getReplacementProperties(), requestBody.getPlaceholderPropertyValues(), requestBody.getParentGUID(), requestBody.getParentRelationshipTypeName(), requestBody.getParentRelationshipProperties(), requestBody.getParentAtEnd1()));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "createProjectFromTemplate", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "createProjectFromTemplate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateProject(String serverName, String projectGUID, boolean replaceAllProperties, ProjectProperties requestBody) {
        String methodName = "updateProject";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "updateProject");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "updateProject");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateProject");
            if (requestBody != null) {
                ProjectManagement handler = instanceHandler.getProjectManagement(userId, serverName, "updateProject");
                handler.updateProject(userId, null, null, projectGUID, !replaceAllProperties, requestBody);
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "updateProject", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "updateProject", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse deleteProject(String serverName, String projectGUID, boolean cascadedDelete, NullRequestBody requestBody) {
        String methodName = "deleteProject";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "deleteProject");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "deleteProject");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteProject");
            ProjectManagement handler = instanceHandler.getProjectManagement(userId, serverName, "deleteProject");
            handler.removeProject(userId, null, null, projectGUID, cascadedDelete);
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "deleteProject", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addToProjectTeam(String serverName, String projectGUID, String actorGUID, ProjectTeamProperties requestBody) {
        String methodName = "addToProjectTeam";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "addToProjectTeam");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "addToProjectTeam");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addToProjectTeam");
            if (requestBody != null) {
                ProjectManagement handler = instanceHandler.getProjectManagement(userId, serverName, "addToProjectTeam");
                handler.setupProjectTeam(userId, null, null, projectGUID, requestBody, actorGUID);
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "addToProjectTeam", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "addToProjectTeam", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeFromProjectTeam(String serverName, String projectGUID, String actorGUID, NullRequestBody requestBody) {
        String methodName = "removeFromProjectTeam";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "removeFromProjectTeam");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "removeFromProjectTeam");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeFromProjectTeam");
            ProjectManagement handler = instanceHandler.getProjectManagement(userId, serverName, "removeFromProjectTeam");
            handler.clearProjectTeam(userId, null, null, projectGUID, actorGUID);
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "removeFromProjectTeam", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupProjectManagementRole(String serverName, String projectGUID, String projectRoleGUID, NullRequestBody requestBody) {
        String methodName = "setupProjectManagementRole";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "setupProjectManagementRole");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "setupProjectManagementRole");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupProjectManagementRole");
            ProjectManagement handler = instanceHandler.getProjectManagement(userId, serverName, "setupProjectManagementRole");
            handler.setupProjectManagementRole(userId, null, null, projectGUID, projectRoleGUID);
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "setupProjectManagementRole", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearProjectManagementRole(String serverName, String projectGUID, String projectRoleGUID, NullRequestBody requestBody) {
        String methodName = "clearProjectManagementRole";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "clearProjectManagementRole");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "clearProjectManagementRole");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearProjectManagementRole");
            ProjectManagement handler = instanceHandler.getProjectManagement(userId, serverName, "clearProjectManagementRole");
            handler.clearProjectManagementRole(userId, null, null, projectGUID, projectRoleGUID);
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "clearProjectManagementRole", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupResource(String serverName, String elementGUID, String resourceGUID, RelationshipRequestBody requestBody) {
        String methodName = "setupResource";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "setupResource");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "setupResource");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupResource");
            ProjectManagement handler = instanceHandler.getProjectManagement(userId, serverName, "setupResource");
            if (requestBody != null) {
                RelationshipProperties relationshipProperties = requestBody.getProperties();
                if (relationshipProperties instanceof ResourceListProperties) {
                    ResourceListProperties resourceListProperties = (ResourceListProperties)relationshipProperties;
                    handler.setupResource(userId, null, null, elementGUID, resourceListProperties, resourceGUID);
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(ResourceListProperties.class.getName(), "setupResource");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "setupResource", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "setupResource", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearResource(String serverName, String elementGUID, String resourceGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "clearResource";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "clearResource");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "clearResource");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearResource");
            ProjectManagement handler = instanceHandler.getProjectManagement(userId, serverName, "clearResource");
            if (requestBody != null) {
                handler.clearResource(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), elementGUID, resourceGUID);
            } else {
                handler.clearResource(userId, null, null, elementGUID, resourceGUID);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "clearResource", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelatedElementsResponse getResourceList(String serverName, String elementGUID, int startFrom, int pageSize) {
        String methodName = "getResourceList";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getResourceList");
        RelatedElementsResponse response = new RelatedElementsResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getResourceList");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getResourceList");
            ProjectManagement handler = instanceHandler.getProjectManagement(userId, serverName, "getResourceList");
            response.setElements(handler.getResourceList(userId, elementGUID, startFrom, pageSize));
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getResourceList", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelatedElementsResponse getSupportedByResource(String serverName, String resourceGUID, int startFrom, int pageSize) {
        String methodName = "getSupportedByResource";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getSupportedByResource");
        RelatedElementsResponse response = new RelatedElementsResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getSupportedByResource");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getSupportedByResource");
            ProjectManagement handler = instanceHandler.getProjectManagement(userId, serverName, "getSupportedByResource");
            response.setElements(handler.getSupportedByResource(userId, resourceGUID, startFrom, pageSize));
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getSupportedByResource", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

