/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.projectmanager.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.commonservices.ffdc.rest.ExternalSourceRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.FilterRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NewProjectRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.ProjectMembersResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.ProjectResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.ProjectsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.RelatedElementsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.RelationshipRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.TemplateRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.openmetadata.properties.projects.ProjectProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.projects.ProjectTeamProperties;
import org.odpi.openmetadata.viewservices.projectmanager.server.ProjectManagerRESTServices;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/api/open-metadata/project-manager"})
@Tag(name="API: Project Manager OMVS", description="Maintain and explore the contents of nested projects. These projects can be used to represent digital products, or projects of resources for a particular project or team. They can be used to organize assets and other resources into logical groups.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omvs/project-manager/overview/"))
public class ProjectManagerResource {
    private final ProjectManagerRESTServices restAPI = new ProjectManagerRESTServices();

    @PostMapping(path={"/metadata-elements/{parentGUID}/projects"})
    @Operation(summary="getLinkedProjects", description="Returns the list of projects that are linked off of the supplied element. Any relationship will do.  The request body is optional, but if supplied acts as a filter on project status.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/project"))
    public ProjectsResponse getLinkedProjects(@PathVariable String serverName, @PathVariable String parentGUID, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestBody(required=false) FilterRequestBody requestBody) {
        return this.restAPI.getLinkedProjects(serverName, parentGUID, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/projects/by-classifications"})
    @Operation(summary="getClassifiedProjects", description="Returns the list of projects with a particular classification.  The name of the classification is supplied in the request body.  Examples of these classifications include StudyProject, PersonalProject, Campaign or Task.  There is also GlossaryProject and GovernanceProject.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/project"))
    public ProjectsResponse getClassifiedProjects(@PathVariable String serverName, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestBody FilterRequestBody requestBody) {
        return this.restAPI.getClassifiedProjects(serverName, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/projects/{projectGUID}/team"})
    @Operation(summary="getProjectTeam", description="Returns the list of actors that are linked off of the project.  This includes the project managers. The optional request body allows a teamRole to be specified as a filter.  To filter out the project managers, specify ProjectManagement as the team role.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/project"))
    public ProjectMembersResponse getProjectTeam(@PathVariable String serverName, @PathVariable String projectGUID, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestBody(required=false) FilterRequestBody requestBody) {
        return this.restAPI.getProjectTeam(serverName, projectGUID, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/projects/by-search-string"})
    @Operation(summary="findProjects", description="Returns the list of projects matching the search string.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/project"))
    public ProjectsResponse findProjects(@PathVariable String serverName, @RequestParam(required=false, defaultValue="false") boolean startsWith, @RequestParam(required=false, defaultValue="false") boolean endsWith, @RequestParam(required=false, defaultValue="false") boolean ignoreCase, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestBody(required=false) FilterRequestBody requestBody) {
        return this.restAPI.findProjects(serverName, startsWith, endsWith, ignoreCase, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/projects/by-name"})
    @Operation(summary="getProjectsByName", description="Returns the list of projects with a particular name.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/project"))
    public ProjectsResponse getProjectsByName(@PathVariable String serverName, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestBody(required=false) FilterRequestBody requestBody) {
        return this.restAPI.getProjectsByName(serverName, startFrom, pageSize, requestBody);
    }

    @GetMapping(path={"/projects/{projectGUID}"})
    @Operation(summary="getProjectByGUID", description="Return the properties of a specific project.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/project"))
    public ProjectResponse getProject(@PathVariable String serverName, @PathVariable String projectGUID) {
        return this.restAPI.getProject(serverName, projectGUID);
    }

    @PostMapping(path={"/projects"})
    @Operation(summary="createProject", description="Create a new generic project with an optional classification.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/project"))
    public GUIDResponse createProject(@PathVariable String serverName, @RequestParam(required=false) String classificationName, @RequestBody NewProjectRequestBody requestBody) {
        return this.restAPI.createProject(serverName, classificationName, requestBody);
    }

    @PostMapping(path={"/projects/{projectGUID}/task"})
    @Operation(summary="createTaskForProject", description="Create a new task linked to the supplied project.  Used to identify a discrete piece of work within the project.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/project"))
    public GUIDResponse createTaskProject(@PathVariable String serverName, @PathVariable String projectGUID, @RequestBody ProjectProperties requestBody) {
        return this.restAPI.createTaskForProject(serverName, projectGUID, requestBody);
    }

    @PostMapping(path={"/projects/from-template"})
    @Operation(summary="createProjectFromTemplate", description="Create a new metadata element to represent a project using an existing metadata element as a template. The template defines additional classifications and relationships that should be added to the new project.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/project"))
    public GUIDResponse createProjectFromTemplate(@PathVariable String serverName, @RequestBody TemplateRequestBody requestBody) {
        return this.restAPI.createProjectFromTemplate(serverName, requestBody);
    }

    @PostMapping(path={"/projects/{projectGUID}/update"})
    @Operation(summary="updateProject", description="Update the properties of a project.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/project"))
    public VoidResponse updateProject(@PathVariable String serverName, @PathVariable String projectGUID, @RequestParam boolean replaceAllProperties, @RequestBody ProjectProperties requestBody) {
        return this.restAPI.updateProject(serverName, projectGUID, replaceAllProperties, requestBody);
    }

    @PostMapping(path={"/projects/{projectGUID}/delete"})
    @Operation(summary="deleteProject", description="Delete a project.  It is detected from all parent elements.  If members are anchored to the project then they are also deleted.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/project"))
    public VoidResponse deleteProject(@PathVariable String serverName, @PathVariable String projectGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.deleteProject(serverName, projectGUID, requestBody);
    }

    @PostMapping(path={"/projects/{projectGUID}/members/{actorGUID}/attach"})
    @Operation(summary="addToProjectTeam", description="Add an actor to a project.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/project"))
    public VoidResponse addToProjectTeam(@PathVariable String serverName, @PathVariable String projectGUID, @PathVariable String actorGUID, @RequestBody(required=false) ProjectTeamProperties requestBody) {
        return this.restAPI.addToProjectTeam(serverName, projectGUID, actorGUID, requestBody);
    }

    @PostMapping(path={"/projects/{projectGUID}/members/{actorGUID}/detach"})
    @Operation(summary="removeFromProjectTeam", description="Remove an actor from a project.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/project"))
    public VoidResponse removeFromProjectTeam(@PathVariable String serverName, @PathVariable String projectGUID, @PathVariable String actorGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.removeFromProjectTeam(serverName, projectGUID, actorGUID, requestBody);
    }

    @PostMapping(path={"/projects/{projectGUID}/project-management-roles/{projectRoleGUID}/attach"})
    @Operation(summary="setupProjectManagementRole", description="Create a ProjectManagement relationship between a project and a person role to show that anyone appointed to the role is a member of the project.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/project"))
    public VoidResponse setupProjectManagementRole(@PathVariable String serverName, @PathVariable String projectGUID, @PathVariable String projectRoleGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.setupProjectManagementRole(serverName, projectGUID, projectRoleGUID, requestBody);
    }

    @PostMapping(path={"/projects/{projectGUID}/project-management-roles/{projectRoleGUID}/detach"})
    @Operation(summary="clearProjectManagementRole", description="Remove a ProjectManagement relationship between a project and a person role.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/project"))
    public VoidResponse clearProjectManagementRole(@PathVariable String serverName, @PathVariable String projectGUID, @PathVariable String projectRoleGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.clearProjectManagementRole(serverName, projectGUID, projectRoleGUID, requestBody);
    }

    @PostMapping(path={"/related-elements/{elementGUID}/resource-list/{resourceGUID}"})
    @Operation(summary="setupResource", description="Create a 'ResourceList' relationship between a consuming element (such as a project) and an element that represents a resource.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/resource"))
    public VoidResponse setupResource(@PathVariable String serverName, @PathVariable String elementGUID, @PathVariable String resourceGUID, @RequestBody(required=false) RelationshipRequestBody requestBody) {
        return this.restAPI.setupResource(serverName, elementGUID, resourceGUID, requestBody);
    }

    @PostMapping(path={"/related-elements/{elementGUID}/resource-list/{resourceGUID}/delete"})
    @Operation(summary="clearResource", description="Remove a 'ResourceList' relationship between a consuming element and an element that represents a resource.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/resource"))
    public VoidResponse clearResource(@PathVariable String serverName, @PathVariable String elementGUID, @PathVariable String resourceGUID, @RequestBody(required=false) ExternalSourceRequestBody requestBody) {
        return this.restAPI.clearResource(serverName, elementGUID, resourceGUID, requestBody);
    }

    @GetMapping(path={"/related-elements/resource-list/by-assignee/{elementGUID}"})
    @Operation(summary="getResourceList", description="Retrieve the list of resources assigned to an element (such as a project) via the 'ResourceList' relationship.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/resource"))
    public RelatedElementsResponse getResourceList(@PathVariable String serverName, @PathVariable String elementGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getResourceList(serverName, elementGUID, startFrom, pageSize);
    }

    @GetMapping(path={"/related-elements/resource-list/by-resource/{resourceGUID}"})
    @Operation(summary="getSupportedByResource", description="Retrieve the list of elements (such as projects, technology types, ...) assigned to a resource via the ResourceList' relationship.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/resource"))
    public RelatedElementsResponse getSupportedByResource(@PathVariable String serverName, @PathVariable String resourceGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getSupportedByResource(serverName, resourceGUID, startFrom, pageSize);
    }
}

