/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.openconnectors.governancedaemonconnectors.securitysync.rangerconnector.admin;

import org.odpi.openmetadata.adminservices.configuration.properties.SecuritySyncConfig;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBroker;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.securitysync.rangerconnector.auditlog.RangerConnectorAuditCode;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.securitysync.rangerconnector.listener.GovernanceEventListener;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.securitysync.rangerconnector.processor.GovernanceEventProcessor;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLogRecordSeverity;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicListener;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSConfigErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerConnector {
    private static final Logger log = LoggerFactory.getLogger(RangerConnector.class);
    private OMRSAuditLog auditLog;
    OpenMetadataTopicConnector inTopic;

    public void initialize(SecuritySyncConfig securitySyncConfig, OMRSAuditLog auditLog) {
        String actionDescription = "initialize";
        this.auditLog = auditLog;
        this.logAudit(RangerConnectorAuditCode.SERVICE_INITIALIZING, "initialize");
        GovernanceEventProcessor governanceEventProcessor = new GovernanceEventProcessor(securitySyncConfig, auditLog);
        this.inTopic = this.getTopicConnector(securitySyncConfig.getSecuritySyncInTopic(), auditLog);
        GovernanceEventListener governanceEventListener = new GovernanceEventListener(governanceEventProcessor);
        this.inTopic.registerListener((OpenMetadataTopicListener)governanceEventListener);
        this.startTopic(this.inTopic);
        governanceEventProcessor.processExistingGovernedAssetsFromRepository();
        this.logAudit(RangerConnectorAuditCode.SERVICE_INITIALIZED, "initialize");
    }

    private OpenMetadataTopicConnector getTopicConnector(Connection topicConnection, OMRSAuditLog auditLog) {
        try {
            ConnectorBroker connectorBroker = new ConnectorBroker();
            OpenMetadataTopicConnector topicConnector = (OpenMetadataTopicConnector)connectorBroker.getConnector(topicConnection);
            topicConnector.setAuditLog(auditLog);
            return topicConnector;
        }
        catch (Exception error) {
            String methodName = "getTopicConnector";
            log.debug("Unable to create topic connector: " + error.toString());
            OMRSErrorCode errorCode = OMRSErrorCode.NULL_TOPIC_CONNECTOR;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"getTopicConnector"});
            throw new OMRSConfigErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), (Throwable)error);
        }
    }

    private void startTopic(OpenMetadataTopicConnector topic) {
        try {
            topic.start();
        }
        catch (ConnectorCheckedException e) {
            log.error(e.getErrorMessage());
        }
    }

    public void shutdown() {
        try {
            this.inTopic.disconnect();
        }
        catch (ConnectorCheckedException e) {
            log.error("Error disconnecting in topic connector");
        }
        String actionDescription = "shutdown";
        this.logAudit(RangerConnectorAuditCode.SERVICE_SHUTDOWN, "shutdown");
    }

    private void logAudit(RangerConnectorAuditCode auditCode, String actionDescription) {
        this.auditLog.logRecord(actionDescription, auditCode.getLogMessageId(), OMRSAuditLogRecordSeverity.INFO, auditCode.getFormattedLogMessage("Ranger Connector"), null, auditCode.getSystemAction(), auditCode.getUserAction());
    }
}

