/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.openconnectors.governancedaemonconnectors.securitysync.rangerconnector.listener;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.odpi.openmetadata.accessservices.governanceengine.api.events.GovernanceEngineEvent;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.securitysync.rangerconnector.processor.GovernanceEventProcessor;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GovernanceEventListener
implements OpenMetadataTopicListener {
    private static final Logger log = LoggerFactory.getLogger(GovernanceEventListener.class);
    private GovernanceEventProcessor governanceEventProcessor;
    private static ObjectMapper objectMapper = new ObjectMapper();

    public GovernanceEventListener(GovernanceEventProcessor governanceEventProcessor) {
        this.governanceEventProcessor = governanceEventProcessor;
    }

    public void processEvent(String receivedEvent) {
        log.info("[Ranger Connector Sync] Event Received");
        try {
            GovernanceEngineEvent event = (GovernanceEngineEvent)objectMapper.readValue(receivedEvent, GovernanceEngineEvent.class);
            switch (event.getEventType()) {
                case NEW_CLASSIFIED_ASSET: {
                    this.governanceEventProcessor.processClassifiedGovernedAssetEvent(event.getGovernedAsset());
                    break;
                }
                case RE_CLASSIFIED_ASSET: {
                    this.governanceEventProcessor.processReClassifiedGovernedAssetEvent(event.getGovernedAsset());
                    break;
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
    }
}

