/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.openconnectors.governancedaemonconnectors.securitysync.rangerconnector.processor;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.odpi.openmetadata.accessservices.governanceengine.api.objects.Context;
import org.odpi.openmetadata.accessservices.governanceengine.api.objects.GovernanceClassification;
import org.odpi.openmetadata.accessservices.governanceengine.api.objects.GovernedAsset;
import org.odpi.openmetadata.accessservices.governanceengine.api.objects.GovernedAssetListAPIResponse;
import org.odpi.openmetadata.adminservices.configuration.properties.SecuritySyncConfig;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.securitysync.rangerconnector.auditlog.RangerConnectorAuditCode;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.securitysync.rangerconnector.model.RangerPolicyResource;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.securitysync.rangerconnector.model.RangerResource;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.securitysync.rangerconnector.model.RangerServiceResource;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.securitysync.rangerconnector.model.RangerTag;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.securitysync.rangerconnector.model.ResourceTagMapper;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLogRecordSeverity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestTemplate;

public class GovernanceEventProcessor {
    private static final Logger log = LoggerFactory.getLogger(GovernanceEventProcessor.class);
    private OMRSAuditLog auditLog;
    private SecuritySyncConfig securitySyncConfig;

    public GovernanceEventProcessor(SecuritySyncConfig securitySyncConfig, OMRSAuditLog auditLog) {
        this.auditLog = auditLog;
        this.securitySyncConfig = securitySyncConfig;
    }

    public void processExistingGovernedAssetsFromRepository() {
        this.logProcessing("processExistingGovernedAssetsFromRepository", RangerConnectorAuditCode.CLASSIFIED_GOVERNED_ASSET_INITIAL_LOAD);
        List governedAssets = this.getGovernedAssets().getGovernedAssetList();
        HashMap<RangerTag, Set<RangerServiceResource>> tagResourcesMap = new HashMap<RangerTag, Set<RangerServiceResource>>();
        HashMap<String, RangerTag> rangerTagMap = new HashMap<String, RangerTag>();
        HashMap<Long, RangerTag> tags = new HashMap<Long, RangerTag>();
        Long resourceIndex = 0L;
        Long tagIndex = 0L;
        for (GovernedAsset governedAsset : governedAssets) {
            List<Long> rangerTagId;
            if (governedAsset.getAssignedGovernanceClassifications().isEmpty()) continue;
            Long l = tagIndex;
            tagIndex = tagIndex + 1L;
            Iterator iterator = tagIndex;
            RangerTag rangerTag = this.getRangerTag(governedAsset, rangerTagMap, tags, l);
            iterator = resourceIndex;
            Long l2 = resourceIndex = Long.valueOf(resourceIndex + 1L);
            List<RangerServiceResource> rangerServiceResources = this.getRangerServiceResources((Long)((Object)iterator), governedAsset);
            if (tagResourcesMap.containsKey(rangerTag)) {
                for (Map.Entry entry : tagResourcesMap.entrySet()) {
                    if (!((RangerTag)entry.getKey()).equals(rangerTag)) continue;
                    ((Set)entry.getValue()).addAll(rangerServiceResources);
                    break;
                }
            } else {
                tagResourcesMap.put(rangerTag, rangerServiceResources.stream().collect(Collectors.toSet()));
            }
            if (!(rangerTagId = this.getRangerTagId(rangerTag, tags)).isEmpty()) continue;
            return;
        }
        HashMap<Long, List<Long>> resourceToTagIds = new HashMap<Long, List<Long>>();
        List<RangerServiceResource> resources = this.mapRangerServicesResources(tagResourcesMap);
        for (RangerServiceResource resource : resources) {
            for (Map.Entry entry : tagResourcesMap.entrySet()) {
                if (!((Set)entry.getValue()).contains(resource)) continue;
                RangerTag rangerTagForResource = (RangerTag)entry.getKey();
                for (Map.Entry rangerTagId : tags.entrySet()) {
                    if (!((RangerTag)rangerTagId.getValue()).equals(rangerTagForResource)) continue;
                    resourceToTagIds.put(resource.getId(), Collections.singletonList(rangerTagId.getKey()));
                }
            }
        }
        RangerResource rangerResource = this.buildRangerResource(resources, tags, resourceToTagIds);
        this.mapResourcesToTagsInRangerServer(rangerResource);
    }

    public void processClassifiedGovernedAssetEvent(GovernedAsset governedAsset) {
        this.logProcessing("processClassifiedGovernedAssetEvent", RangerConnectorAuditCode.CLASSIFIED_GOVERNED_ASSET_EVENT_RECEIVED);
        RangerResource rangerResource = this.processGovernedAsset(governedAsset);
        this.mapResourcesToTagsInRangerServer(rangerResource);
    }

    public void processReClassifiedGovernedAssetEvent(GovernedAsset governedAsset) {
        this.logProcessing("processReClassifiedGovernedAssetEvent", RangerConnectorAuditCode.RE_CLASSIFIED_GOVERNED_ASSET_EVENT_RECEIVED);
        if (governedAsset == null) {
            return;
        }
        RangerServiceResource resource = this.getResourceFromRanger(governedAsset.getGuid());
        if (resource == null) {
            return;
        }
        ResourceTagMapper resourceTagMapper = this.getExistingTagIdAssociatedWithTheResource(resource.getId());
        List<RangerTag> allTags = this.getAllTags();
        if (resourceTagMapper != null) {
            this.deleteMappingBetweenTagAndResource(resourceTagMapper);
        }
        if (governedAsset.getAssignedGovernanceClassifications() == null || governedAsset.getAssignedGovernanceClassifications().isEmpty()) {
            return;
        }
        GovernanceClassification classification = (GovernanceClassification)governedAsset.getAssignedGovernanceClassifications().get(0);
        if (!classification.getAttributes().containsKey("level")) {
            return;
        }
        String newTagGuid = (String)classification.getAttributes().get("level");
        RangerTag existingTag = this.existingTag(allTags, newTagGuid);
        if (existingTag == null) {
            RangerTag rangerTag = this.buildTag(classification);
            this.createNewTag(rangerTag);
        }
        this.createMappingBetweenTagAndResource(newTagGuid, resource.getGuid());
    }

    private RangerTag getRangerTag(GovernedAsset governedAsset, Map<String, RangerTag> rangerTagMap, Map<Long, RangerTag> tags, Long tagIndex) {
        GovernanceClassification classification = (GovernanceClassification)governedAsset.getAssignedGovernanceClassifications().get(0);
        String tagName = (String)classification.getAttributes().get("level");
        if (rangerTagMap.containsKey(tagName)) {
            return rangerTagMap.get(tagName);
        }
        RangerTag tag = this.buildTag(classification);
        rangerTagMap.put(tagName, tag);
        tags.put(tagIndex, tag);
        return tag;
    }

    private RangerResource processGovernedAsset(GovernedAsset governedAsset) {
        Map<Long, RangerTag> tags = this.buildTags(governedAsset.getAssignedGovernanceClassifications());
        List<RangerServiceResource> rangerServiceResources = this.getRangerServiceResources(0L, governedAsset);
        Map<Long, List<Long>> resourceToTagIds = this.mapResources(tags, rangerServiceResources);
        return this.buildRangerResource(rangerServiceResources, tags, resourceToTagIds);
    }

    private Map<Long, List<Long>> mapResources(Map<Long, RangerTag> tags, List<RangerServiceResource> rangerServiceResources) {
        HashMap<Long, List<Long>> resourceToTagIds = new HashMap<Long, List<Long>>();
        ArrayList<Long> tagList = new ArrayList<Long>(tags.keySet());
        for (RangerServiceResource rangerServiceResource : rangerServiceResources) {
            resourceToTagIds.putAll(this.mapResourcesToTags(rangerServiceResource.getId(), tagList));
        }
        return resourceToTagIds;
    }

    private List<RangerServiceResource> getRangerServiceResources(Long resourceId, GovernedAsset governedAsset) {
        ArrayList<RangerServiceResource> rangerServiceResources = new ArrayList<RangerServiceResource>(governedAsset.getContexts().size());
        for (Context context : governedAsset.getContexts()) {
            Map<String, RangerPolicyResource> resourceMap = this.getRangerPolicyResourceMap(context);
            Long l = resourceId;
            Long l2 = resourceId = Long.valueOf(resourceId + 1L);
            RangerServiceResource serviceResource = this.getRangerServiceResource(resourceMap, governedAsset.getGuid(), l);
            rangerServiceResources.add(serviceResource);
        }
        return rangerServiceResources;
    }

    private void createNewTag(RangerTag rangerTag) {
        Gson gson = new Gson();
        String body = gson.toJson((Object)rangerTag);
        RestTemplate restTemplate = new RestTemplate();
        HttpEntity entity = new HttpEntity((Object)body, (MultiValueMap)this.getHttpHeaders());
        try {
            String createTagURL = this.getRangerURL("{0}/service/tags/");
            restTemplate.exchange(createTagURL, HttpMethod.POST, entity, String.class, new Object[0]);
        }
        catch (HttpStatusCodeException exception) {
            log.error(exception.getMessage());
        }
    }

    private void logProcessing(String action, RangerConnectorAuditCode auditCode) {
        this.auditLog.logRecord(action, auditCode.getLogMessageId(), OMRSAuditLogRecordSeverity.INFO, auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
    }

    private Map<Long, RangerTag> buildTags(List<GovernanceClassification> classifications) {
        HashMap<Long, RangerTag> tags = new HashMap<Long, RangerTag>(classifications.size());
        long index = 0L;
        for (GovernanceClassification classification : classifications) {
            RangerTag rangerTag = this.buildTag(classification);
            tags.put(index++, rangerTag);
        }
        return tags;
    }

    private RangerTag buildTag(GovernanceClassification classification) {
        RangerTag tag = new RangerTag();
        tag.setCreatedBy("Egeria - Ranger Connector");
        tag.setType("Confidentiality");
        if (classification.getAttributes().containsKey("level")) {
            tag.setGuid((String)classification.getAttributes().get("level"));
        }
        return tag;
    }

    private Map<String, RangerPolicyResource> getRangerPolicyResourceMap(Context context) {
        HashMap<String, RangerPolicyResource> resourceElements = new HashMap<String, RangerPolicyResource>(3);
        RangerPolicyResource schemaValues = this.getListOfPossibleValuesOfElements("gaian");
        resourceElements.put("schema", schemaValues);
        RangerPolicyResource tableValue = this.getListOfPossibleValuesOfElements(context.getTable());
        resourceElements.put("table", tableValue);
        if (context.getColumn() != null) {
            RangerPolicyResource columnValue = this.getListOfPossibleValuesOfElements(context.getColumn());
            resourceElements.put("column", columnValue);
        }
        return resourceElements;
    }

    private RangerPolicyResource getListOfPossibleValuesOfElements(String value) {
        RangerPolicyResource resourceValue = new RangerPolicyResource();
        resourceValue.setValues(Collections.singletonList(value));
        return resourceValue;
    }

    private Map<Long, List<Long>> mapResourcesToTags(Long rangerServiceResourceId, List<Long> tagList) {
        HashMap<Long, List<Long>> resourceToTagIds = new HashMap<Long, List<Long>>();
        resourceToTagIds.put(rangerServiceResourceId, tagList);
        return resourceToTagIds;
    }

    private RangerResource buildRangerResource(List<RangerServiceResource> rangerServiceResource, Map<Long, RangerTag> tags, Map<Long, List<Long>> resourceToTagIds) {
        RangerResource rangerResource = new RangerResource();
        rangerResource.setTags(tags);
        rangerResource.setServiceResources(rangerServiceResource);
        rangerResource.setResourceToTagIds(resourceToTagIds);
        rangerResource.setOp("add_or_update");
        rangerResource.setServiceName(this.securitySyncConfig.getTagServiceName());
        rangerResource.setTagVersion(1L);
        return rangerResource;
    }

    private RangerServiceResource getRangerServiceResource(Map<String, RangerPolicyResource> resourceElements, String guid, Long resourceId) {
        RangerServiceResource serviceResource = new RangerServiceResource();
        serviceResource.setId(resourceId);
        serviceResource.setGuid(guid);
        serviceResource.setServiceName("gaian");
        serviceResource.setCreatedBy("Egeria - Ranger Connector");
        serviceResource.setResourceElements(resourceElements);
        return serviceResource;
    }

    private void mapResourcesToTagsInRangerServer(RangerResource resource) {
        String body = this.getBody(resource);
        RestTemplate restTemplate = new RestTemplate();
        HttpEntity entity = new HttpEntity((Object)body, (MultiValueMap)this.getHttpHeaders());
        try {
            String url = this.getRangerURL("{0}/service/tags/importservicetags");
            restTemplate.exchange(url, HttpMethod.PUT, entity, String.class, new Object[0]);
        }
        catch (HttpStatusCodeException exception) {
            log.error(exception.getMessage());
        }
    }

    private Object mapToObject(ResponseEntity<String> result, Class className) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        try {
            return mapper.readValue((String)result.getBody(), className);
        }
        catch (IOException e) {
            log.error("403", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    private RangerServiceResource getResourceFromRanger(String resourceGuid) {
        String rangerBaseURL = this.securitySyncConfig.getSecurityServerURL();
        String resourceURL = MessageFormat.format("{0}/service/tags/resource/guid/{1}", rangerBaseURL, resourceGuid);
        RestTemplate restTemplate = new RestTemplate();
        HttpEntity entity = new HttpEntity((MultiValueMap)this.getHttpHeaders());
        try {
            ResponseEntity result = restTemplate.exchange(resourceURL, HttpMethod.GET, entity, String.class, new Object[0]);
            return (RangerServiceResource)this.mapToObject((ResponseEntity<String>)result, RangerServiceResource.class);
        }
        catch (HttpStatusCodeException exception) {
            log.error(exception.getMessage());
            return null;
        }
    }

    private ResourceTagMapper getExistingTagIdAssociatedWithTheResource(Long id) {
        List<ResourceTagMapper> mapper = this.getMappedResources();
        if (mapper == null) {
            return null;
        }
        Optional<ResourceTagMapper> mappedResource = mapper.stream().filter(resourceTagMapper -> resourceTagMapper.getResourceId().equals(id)).findFirst();
        return mappedResource.orElse(null);
    }

    private RangerTag existingTag(List<RangerTag> rangerTags, String tagGuid) {
        Optional<RangerTag> any = rangerTags.stream().filter(tag -> tag.getGuid().equals(tagGuid)).findAny();
        return any.orElse(null);
    }

    private void deleteMappingBetweenTagAndResource(ResourceTagMapper resourceTagMapper) {
        String rangerBaseURL = this.securitySyncConfig.getSecurityServerURL();
        String deleteAssociationURL = MessageFormat.format("{0}/service/tags/tagresourcemap/{1}", rangerBaseURL, resourceTagMapper.getGuid());
        RestTemplate restTemplate = new RestTemplate();
        HttpHeaders headers = this.getHttpHeaders();
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        try {
            restTemplate.delete(deleteAssociationURL, new Object[]{HttpMethod.DELETE, entity});
        }
        catch (HttpStatusCodeException exception) {
            log.error(exception.getMessage());
        }
    }

    private ResourceTagMapper createMappingBetweenTagAndResource(String tagGuid, String resourceGuid) {
        String rangerBaseURL = this.securitySyncConfig.getSecurityServerURL();
        String createAssociation = MessageFormat.format("{0}/service/tags/tagresourcemaps?tag-guid={1}&resource-guid={2}", rangerBaseURL, tagGuid, resourceGuid);
        RestTemplate restTemplate = new RestTemplate();
        HttpEntity entity = new HttpEntity((MultiValueMap)this.getHttpHeaders());
        try {
            ResponseEntity result = restTemplate.exchange(createAssociation, HttpMethod.POST, entity, String.class, new Object[0]);
            return (ResourceTagMapper)this.mapToObject((ResponseEntity<String>)result, ResourceTagMapper.class);
        }
        catch (HttpStatusCodeException exception) {
            log.error(exception.getMessage());
            return null;
        }
    }

    private String getBody(RangerResource resource) {
        Gson gson = new Gson();
        return gson.toJson((Object)resource);
    }

    private String getRangerURL(String s) {
        String rangerBaseURL = this.securitySyncConfig.getSecurityServerURL();
        return MessageFormat.format(s, rangerBaseURL);
    }

    private HttpHeaders getHttpHeaders() {
        HttpHeaders headers = this.getBasicHTTPHeaders();
        headers.set("Authorization", this.securitySyncConfig.getSecurityServerAuthorization());
        return headers;
    }

    private HttpHeaders getBasicHTTPHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
        return headers;
    }

    private List<RangerTag> getAllTags() {
        String allMappedResources = this.getRangerURL("{0}/service/tags/tags");
        RestTemplate restTemplate = new RestTemplate();
        HttpEntity entity = new HttpEntity((MultiValueMap)this.getHttpHeaders());
        try {
            ResponseEntity response = restTemplate.exchange(allMappedResources, HttpMethod.GET, entity, (ParameterizedTypeReference)new ParameterizedTypeReference<List<RangerTag>>(){}, new Object[0]);
            return (List)response.getBody();
        }
        catch (HttpStatusCodeException exception) {
            log.error(exception.getMessage());
            return Collections.emptyList();
        }
    }

    private List<ResourceTagMapper> getMappedResources() {
        String allMappedResources = this.getRangerURL("{0}/service/tags/tagresourcemaps");
        RestTemplate restTemplate = new RestTemplate();
        HttpEntity entity = new HttpEntity((MultiValueMap)this.getHttpHeaders());
        try {
            ResponseEntity response = restTemplate.exchange(allMappedResources, HttpMethod.GET, entity, (ParameterizedTypeReference)new ParameterizedTypeReference<List<ResourceTagMapper>>(){}, new Object[0]);
            return (List)response.getBody();
        }
        catch (HttpStatusCodeException exception) {
            log.error(exception.getMessage());
            return Collections.emptyList();
        }
    }

    private GovernedAssetListAPIResponse getGovernedAssets() {
        String governanceEngineURL = this.getGovernanceEngineURL("{0}/assets?classification={0}");
        RestTemplate restTemplate = new RestTemplate();
        HttpEntity entity = new HttpEntity((MultiValueMap)this.getBasicHTTPHeaders());
        try {
            ResponseEntity result = restTemplate.exchange(governanceEngineURL, HttpMethod.GET, entity, String.class, new Object[0]);
            return (GovernedAssetListAPIResponse)this.mapToObject((ResponseEntity<String>)result, GovernedAssetListAPIResponse.class);
        }
        catch (HttpStatusCodeException exception) {
            log.error(exception.getMessage());
            return null;
        }
    }

    private String getGovernanceEngineURL(String endpoint) {
        String geBaseURL = this.securitySyncConfig.getGovernanceEngineServerURL();
        return MessageFormat.format(endpoint, geBaseURL, "Confidentiality");
    }

    private List<RangerServiceResource> mapRangerServicesResources(Map<RangerTag, Set<RangerServiceResource>> tagResourcesMap) {
        ArrayList<RangerServiceResource> resources = new ArrayList<RangerServiceResource>();
        for (RangerTag key : tagResourcesMap.keySet()) {
            resources.addAll((Collection<RangerServiceResource>)tagResourcesMap.get(key));
        }
        return resources;
    }

    private List<Long> getRangerTagId(RangerTag rangerTag, Map<Long, RangerTag> tags) {
        if (!tags.containsValue(rangerTag)) {
            return Collections.emptyList();
        }
        for (Map.Entry<Long, RangerTag> longRangerTagEntry : tags.entrySet()) {
            if (!longRangerTagEntry.getValue().equals(rangerTag)) continue;
            return Collections.singletonList(longRangerTagEntry.getKey());
        }
        return Collections.emptyList();
    }
}

