/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.openconnectors.governancedaemonconnectors.securitysync.rangerconnector;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.odpi.openmetadata.accessservices.governanceengine.api.objects.Context;
import org.odpi.openmetadata.accessservices.governanceengine.api.objects.GovernanceClassification;
import org.odpi.openmetadata.accessservices.governanceengine.api.objects.GovernedAsset;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBase;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.securitysync.rangerconnector.SecurityServiceConnector;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.securitysync.rangerconnector.model.RangerBaseObject;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.securitysync.rangerconnector.model.RangerPolicyResource;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.securitysync.rangerconnector.model.RangerSecurityServicePolicies;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.securitysync.rangerconnector.model.RangerServiceResource;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.securitysync.rangerconnector.model.RangerTag;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.securitysync.rangerconnector.model.RangerTagDef;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.securitysync.rangerconnector.model.ResourceTagMapper;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.securitysync.rangerconnector.util.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestTemplate;

public class RangerSecurityServiceConnector
extends ConnectorBase
implements SecurityServiceConnector {
    private static final Logger log = LoggerFactory.getLogger(RangerSecurityServiceConnector.class);
    private Connection connection;

    public RangerSecurityServiceConnector(Connection securityServerConnection) {
        this.connection = securityServerConnection;
    }

    @Override
    public void importTaggedResources(List<GovernedAsset> governedAssets) {
        HashSet<RangerTag> tags = new HashSet<RangerTag>();
        ArrayList<RangerServiceResource> resources = new ArrayList<RangerServiceResource>();
        Map<String, Set<String>> tagToResource = this.buildResourceToTagsAssociationMap(governedAssets, tags, resources);
        this.createRangerTagDef();
        List<ResourceTagMapper> exitingAssociationResourceTags = this.getExistingAssociationResourceTags();
        if (exitingAssociationResourceTags.isEmpty()) {
            resources.forEach(this::createRangerServiceResource);
            tags.forEach(this::createRangerTag);
            tagToResource.forEach((key, value) -> value.forEach(x -> this.createAssociationResourceToSecurityTag((String)key, (String)x)));
            return;
        }
        List<RangerServiceResource> existingResources = this.getExistingResources();
        Map<Long, RangerServiceResource> existingResourcesMap = this.mapResourceIds(existingResources);
        Set<RangerTag> rangerExistingTags = this.getExistingTags();
        Map<Long, RangerTag> existingTagsMap = this.mapTagIds(rangerExistingTags);
        Map<String, Set<String>> existingAssoc = this.mapResourceTagsById(exitingAssociationResourceTags, existingResourcesMap, existingTagsMap);
        if (tagToResource.isEmpty()) {
            existingAssoc.forEach((key, value) -> value.forEach(x -> this.deleteAssociationResourceToSecurityTagBasedOnIds((String)key, (String)x)));
            return;
        }
        this.syncTags(tags, rangerExistingTags);
        this.syncResources(resources, existingResources);
        this.syncAssociations(tagToResource, existingAssoc);
    }

    @Override
    public RangerSecurityServicePolicies getSecurityServicePolicies(String serviceName, Long lastKnownVersion) {
        if (serviceName == null) {
            return null;
        }
        String servicePoliciesURL = MessageFormat.format("{0}/service/plugins/policies/download/{1}?lastKnownVersion={2}", this.connection.getEndpoint().getAddress(), serviceName, lastKnownVersion);
        RestTemplate restTemplate = new RestTemplate();
        HttpEntity entity = new HttpEntity((MultiValueMap)this.getHttpHeaders());
        try {
            ResponseEntity result = restTemplate.exchange(servicePoliciesURL, HttpMethod.GET, entity, RangerSecurityServicePolicies.class, new Object[0]);
            if (result.getStatusCode().value() == HttpStatus.OK.value()) {
                return (RangerSecurityServicePolicies)result.getBody();
            }
            if (result.getStatusCode().value() == HttpStatus.NOT_MODIFIED.value()) {
                log.debug("Policies list not modified since last known version {}", (Object)lastKnownVersion);
                return null;
            }
            return (RangerSecurityServicePolicies)result.getBody();
        }
        catch (HttpStatusCodeException exception) {
            log.debug("Unable to fetch the security service policies for service = {} with last known version {}", (Object)serviceName, (Object)lastKnownVersion);
            return null;
        }
    }

    @Override
    public RangerServiceResource createResource(GovernedAsset governedAsset) {
        RangerServiceResource serviceResource = this.buildRangerResource(governedAsset);
        return this.createRangerServiceResource(serviceResource);
    }

    private RangerServiceResource createRangerServiceResource(RangerServiceResource resource) {
        String createAssociation = this.getRangerURL("{0}/service/tags/resources/", new Object[0]);
        String body = this.getBody(resource);
        RestTemplate restTemplate = new RestTemplate();
        HttpEntity entity = new HttpEntity((Object)body, (MultiValueMap)this.getHttpHeaders());
        try {
            ResponseEntity result = restTemplate.exchange(createAssociation, HttpMethod.POST, entity, RangerServiceResource.class, new Object[0]);
            return (RangerServiceResource)result.getBody();
        }
        catch (HttpStatusCodeException exception) {
            log.debug("Unable to create the resource {}", (Object)resource);
            return null;
        }
    }

    @Override
    public RangerServiceResource getResourceByGUID(String resourceGuid) {
        String resourceURL = this.getRangerURL("{0}/service/tags/resource/guid/{1}", resourceGuid);
        RestTemplate restTemplate = new RestTemplate();
        HttpEntity entity = new HttpEntity((MultiValueMap)this.getHttpHeaders());
        try {
            ResponseEntity result = restTemplate.exchange(resourceURL, HttpMethod.GET, entity, RangerServiceResource.class, new Object[0]);
            return (RangerServiceResource)result.getBody();
        }
        catch (HttpStatusCodeException exception) {
            log.debug("Unable to fetch the resource with guid = {}", (Object)resourceGuid);
            return null;
        }
    }

    @Override
    public void deleteResource(String resourceGuid) {
        String resourceURL = this.getRangerURL("{0}/service/tags/resource/guid/{1}", resourceGuid);
        RestTemplate restTemplate = new RestTemplate();
        HttpEntity entity = new HttpEntity((MultiValueMap)this.getHttpHeaders());
        try {
            restTemplate.delete(resourceURL, new Object[]{HttpMethod.DELETE, entity});
            log.info("The resource with guid = {} has been deleted", (Object)resourceGuid);
        }
        catch (HttpStatusCodeException exception) {
            log.debug("Unable to delete the resource with guid = {}", (Object)resourceGuid);
        }
    }

    @Override
    public List<RangerTag> createSecurityTags(GovernanceClassification classification) {
        if (classification.getSecurityLabels() == null || classification.getSecurityLabels().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<RangerTag> rangerTags = new ArrayList<RangerTag>(classification.getSecurityLabels().size());
        for (String securityTag : classification.getSecurityLabels()) {
            RangerTag rangerTag = this.buildRangerTag(securityTag, classification.getSecurityProperties());
            rangerTags.add(this.createRangerTag(rangerTag));
        }
        return rangerTags;
    }

    @Override
    public List<ResourceTagMapper> getTagsAssociatedWithTheResource(Long id) {
        List<ResourceTagMapper> mapper = this.getExistingAssociationResourceTags();
        if (mapper == null) {
            return Collections.emptyList();
        }
        return mapper.stream().filter(resourceTagMapper -> resourceTagMapper.getResourceId().equals(id)).collect(Collectors.toList());
    }

    @Override
    public ResourceTagMapper createAssociationResourceToSecurityTag(String resourceGUID, String tagGUID) {
        String rangerBaseURL = this.connection.getEndpoint().getAddress();
        String createAssociation = MessageFormat.format("{0}/service/tags/tagresourcemaps?tag-guid={1}&resource-guid={2}", rangerBaseURL, tagGUID, resourceGUID);
        RestTemplate restTemplate = new RestTemplate();
        HttpEntity entity = new HttpEntity((MultiValueMap)this.getHttpHeaders());
        try {
            ResponseEntity result = restTemplate.exchange(createAssociation, HttpMethod.POST, entity, ResourceTagMapper.class, new Object[0]);
            return (ResourceTagMapper)result.getBody();
        }
        catch (HttpStatusCodeException exception) {
            log.debug("Unable to create the association between tag {} and resource {}", (Object)tagGUID, (Object)resourceGUID);
            return null;
        }
    }

    @Override
    public void deleteAssociationResourceToSecurityTag(ResourceTagMapper resourceTagMapper) {
        String rangerBaseURL = this.connection.getEndpoint().getAddress();
        String deleteAssociationURL = MessageFormat.format("{0}/service/tags/tagresourcemap/{1}", rangerBaseURL, resourceTagMapper.getId());
        Boolean isDeleted = this.doDelete(deleteAssociationURL);
        if (isDeleted.booleanValue()) {
            log.info("The association with id {} between tag {} and resource {} has been removed", new Object[]{resourceTagMapper.getId(), resourceTagMapper.getTagId(), resourceTagMapper.getResourceId()});
        } else {
            log.info("Unable to delete the association with id = {} between tag {} and resource {}", new Object[]{resourceTagMapper.getId(), resourceTagMapper.getTagId(), resourceTagMapper.getResourceId()});
        }
    }

    private void deleteAssociationResourceToSecurityTagBasedOnIds(String resourceGUID, String tagGUID) {
        String rangerBaseURL = this.connection.getEndpoint().getAddress();
        String deleteURLByGUIDs = MessageFormat.format("{0}/service/tags/tagresourcemaps?tag-guid={1}&resource-guid={2}", rangerBaseURL, tagGUID, resourceGUID);
        Boolean isDeleted = this.doDelete(deleteURLByGUIDs);
        if (isDeleted.booleanValue()) {
            log.debug("The association between tag {} and resoure {} has been deleted", (Object)tagGUID, (Object)resourceGUID);
        } else {
            log.debug("Unable to delete the association between tag {} and resource {}", (Object)tagGUID, (Object)resourceGUID);
        }
    }

    private RangerTagDef createRangerTagDef() {
        RangerTagDef rangerTagDef = this.buildRangerTagDef();
        String body = this.getBody(rangerTagDef);
        String createRangerTagDefURL = this.getRangerURL("{0}/service/tags/tagdefs", new Object[0]);
        RestTemplate restTemplate = new RestTemplate();
        HttpEntity entity = new HttpEntity((Object)body, (MultiValueMap)this.getHttpHeaders());
        try {
            ResponseEntity result = restTemplate.exchange(createRangerTagDefURL, HttpMethod.POST, entity, RangerTagDef.class, new Object[0]);
            return (RangerTagDef)result.getBody();
        }
        catch (HttpStatusCodeException exception) {
            log.debug("Unable to create a security tag");
            return null;
        }
    }

    private RangerTag createRangerTag(RangerTag rangerTag) {
        String createTagURL = this.getRangerURL("{0}/service/tags/tags", new Object[0]);
        String body = this.getBody(rangerTag);
        RestTemplate restTemplate = new RestTemplate();
        HttpEntity entity = new HttpEntity((Object)body, (MultiValueMap)this.getHttpHeaders());
        try {
            restTemplate.exchange(createTagURL, HttpMethod.POST, entity, RangerTag.class, new Object[0]);
            return rangerTag;
        }
        catch (HttpStatusCodeException exception) {
            log.debug("Unable to create a security tag {}", (Object)rangerTag);
            return rangerTag;
        }
    }

    private RangerTagDef buildRangerTagDef() {
        RangerTagDef rangerTagDef = new RangerTagDef();
        rangerTagDef.setId(1L);
        rangerTagDef.setCreatedBy("Egeria - Ranger Connector");
        rangerTagDef.setName("SecurityTags");
        return rangerTagDef;
    }

    private RangerServiceResource buildRangerResource(GovernedAsset governedAsset) {
        RangerServiceResource serviceResource = new RangerServiceResource();
        serviceResource.setGuid(governedAsset.getGuid());
        serviceResource.setServiceName("gaian");
        serviceResource.setCreatedBy("Egeria - Ranger Connector");
        Map<String, RangerPolicyResource> resourceElements = this.getRangerPolicyResourceMap(governedAsset.getContext());
        serviceResource.setResourceElements(resourceElements);
        return serviceResource;
    }

    private RangerTag buildRangerTag(String tagGUID, Map<String, String> tagAttributes) {
        RangerTag tag = new RangerTag();
        tag.setCreatedBy("Egeria - Ranger Connector");
        tag.setType("SecurityTags");
        tag.setOwner(Constants.OPEN_METADATA_OWNER);
        tag.setGuid(tagGUID);
        if (tagAttributes == null) {
            tagAttributes = new HashMap<String, String>();
        }
        tagAttributes.put("name", tagGUID);
        tag.setAttributes(tagAttributes);
        return tag;
    }

    private List<ResourceTagMapper> getExistingAssociationResourceTags() {
        String allMappedResources = this.getRangerURL("{0}/service/tags/tagresourcemaps", new Object[0]);
        RestTemplate restTemplate = new RestTemplate();
        HttpEntity entity = new HttpEntity((MultiValueMap)this.getHttpHeaders());
        try {
            ResponseEntity response = restTemplate.exchange(allMappedResources, HttpMethod.GET, entity, (ParameterizedTypeReference)new ParameterizedTypeReference<List<ResourceTagMapper>>(){}, new Object[0]);
            return (List)response.getBody();
        }
        catch (HttpStatusCodeException exception) {
            log.debug("Unable to fetch the mapped resources");
            return Collections.emptyList();
        }
    }

    private Map<String, RangerPolicyResource> getRangerPolicyResourceMap(Context context) {
        HashMap<String, RangerPolicyResource> resourceElements = new HashMap<String, RangerPolicyResource>(3);
        RangerPolicyResource schemaValues = this.getListOfPossibleValuesOfElements("gaian");
        resourceElements.put("schema", schemaValues);
        if (context == null) {
            return resourceElements;
        }
        RangerPolicyResource tableValue = this.getListOfPossibleValuesOfElements(context.getTable());
        resourceElements.put("table", tableValue);
        if (context.getColumn() != null) {
            RangerPolicyResource columnValue = this.getListOfPossibleValuesOfElements(context.getColumn());
            resourceElements.put("column", columnValue);
        }
        return resourceElements;
    }

    private RangerPolicyResource getListOfPossibleValuesOfElements(String value) {
        RangerPolicyResource resourceValue = new RangerPolicyResource();
        resourceValue.setValues(Collections.singletonList(value));
        return resourceValue;
    }

    public List<RangerServiceResource> getExistingResources() {
        String createAssociation = this.getRangerURL("{0}/service/tags/resources/", new Object[0]);
        RestTemplate restTemplate = new RestTemplate();
        HttpEntity entity = new HttpEntity((MultiValueMap)this.getHttpHeaders());
        try {
            ResponseEntity response = restTemplate.exchange(createAssociation, HttpMethod.GET, entity, (ParameterizedTypeReference)new ParameterizedTypeReference<List<RangerServiceResource>>(){}, new Object[0]);
            if (response.getBody() != null) {
                return (List)response.getBody();
            }
        }
        catch (HttpStatusCodeException exception) {
            log.debug("Unable to fetch the resources");
        }
        return Collections.emptyList();
    }

    private Set<RangerTag> getExistingTags() {
        String createTagURL = this.getRangerURL("{0}/service/tags/tags", new Object[0]);
        RestTemplate restTemplate = new RestTemplate();
        HttpEntity entity = new HttpEntity((MultiValueMap)this.getHttpHeaders());
        try {
            ResponseEntity response = restTemplate.exchange(createTagURL, HttpMethod.GET, entity, (ParameterizedTypeReference)new ParameterizedTypeReference<List<RangerTag>>(){}, new Object[0]);
            if (response.getBody() != null) {
                return new HashSet<RangerTag>((Collection)response.getBody());
            }
        }
        catch (HttpStatusCodeException exception) {
            log.debug("Unable to get the security tags");
        }
        return Collections.emptySet();
    }

    private Map<String, Set<String>> buildResourceToTagsAssociationMap(List<GovernedAsset> governedAssets, Set<RangerTag> tags, List<RangerServiceResource> resources) {
        HashMap<String, Set<String>> tagToResource = new HashMap<String, Set<String>>();
        for (GovernedAsset governedAsset : governedAssets) {
            if (governedAsset.getAssignedGovernanceClassification() == null || governedAsset.getAssignedGovernanceClassification().getSecurityLabels() == null || governedAsset.getAssignedGovernanceClassification().getSecurityLabels().isEmpty()) continue;
            RangerServiceResource resource = this.buildRangerResource(governedAsset);
            resources.add(resource);
            GovernanceClassification governanceClassification = governedAsset.getAssignedGovernanceClassification();
            for (String securityLabel : governanceClassification.getSecurityLabels()) {
                RangerTag rangerTag = this.buildRangerTag(securityLabel, governanceClassification.getSecurityProperties());
                tags.add(rangerTag);
                this.addTag(tagToResource, resource, rangerTag);
            }
        }
        return tagToResource;
    }

    private void addTag(Map<String, Set<String>> tagToResource, RangerServiceResource resource, RangerTag rangerTag) {
        if (tagToResource.containsKey(resource.getGuid())) {
            tagToResource.get(resource.getGuid()).add(rangerTag.getGuid());
        } else {
            HashSet<String> securityTags = new HashSet<String>();
            securityTags.add(rangerTag.getGuid());
            tagToResource.put(resource.getGuid(), securityTags);
        }
    }

    private void syncResources(List<RangerServiceResource> resources, List<RangerServiceResource> existingResources) {
        Collection newResources = CollectionUtils.subtract(resources, existingResources);
        newResources.forEach(this::createRangerServiceResource);
    }

    private void syncTags(Set<RangerTag> tags, Set<RangerTag> rangerExistingTags) {
        Collection newTags = CollectionUtils.subtract(tags, rangerExistingTags);
        newTags.forEach(this::createRangerTag);
    }

    private void syncAssociations(Map<String, Set<String>> tagToResource, Map<String, Set<String>> existingMapping) {
        HashMap<String, List> newMappings = new HashMap<String, List>();
        HashMap<String, List> outdatedMapping = new HashMap<String, List>();
        for (Map.Entry<String, Set<String>> tags2 : tagToResource.entrySet()) {
            Collection outdatedTags;
            Set<String> existingTags = existingMapping.get(tags2.getKey());
            if (existingTags == null) {
                newMappings.put(tags2.getKey(), new ArrayList(tags2.getValue()));
                continue;
            }
            Collection newlyAdded = CollectionUtils.subtract((Iterable)tags2.getValue(), existingTags);
            if (!newlyAdded.isEmpty()) {
                newMappings.put(tags2.getKey(), (List)newlyAdded);
            }
            if ((outdatedTags = CollectionUtils.subtract(existingTags, (Iterable)tags2.getValue())).isEmpty()) continue;
            outdatedMapping.put(tags2.getKey(), (List)outdatedTags);
        }
        newMappings.forEach((resourceId, tags) -> tags.forEach(tagId -> this.createAssociationResourceToSecurityTag((String)resourceId, (String)tagId)));
        outdatedMapping.forEach((resourceId, tags) -> tags.forEach(tag -> this.deleteAssociationResourceToSecurityTagBasedOnIds((String)resourceId, (String)tag)));
    }

    private Map<Long, RangerTag> mapTagIds(Set<RangerTag> tags) {
        return tags.stream().collect(Collectors.toMap(RangerBaseObject::getId, Function.identity()));
    }

    private Map<Long, RangerServiceResource> mapResourceIds(List<RangerServiceResource> resources) {
        return resources.stream().collect(Collectors.toMap(RangerBaseObject::getId, Function.identity()));
    }

    private Map<String, Set<String>> mapResourceTagsById(List<ResourceTagMapper> exitingAssociationResourceTags, Map<Long, RangerServiceResource> existingResourcesMap, Map<Long, RangerTag> existingTagsMap) {
        HashMap<String, Set<String>> existingAssoc = new HashMap<String, Set<String>>();
        for (ResourceTagMapper mapper : exitingAssociationResourceTags) {
            RangerServiceResource resource = existingResourcesMap.get(mapper.getResourceId());
            RangerTag rangerTag = existingTagsMap.get(mapper.getTagId());
            this.addTag(existingAssoc, resource, rangerTag);
        }
        return existingAssoc;
    }

    private String getRangerURL(String s, Object ... params) {
        String rangerBaseURL = this.connection.getEndpoint().getAddress();
        return MessageFormat.format(s, rangerBaseURL, params);
    }

    private String getBody(Object resource) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            return objectMapper.writeValueAsString(resource);
        }
        catch (JsonProcessingException e) {
            log.error("error write json ");
            return null;
        }
    }

    private HttpHeaders getHttpHeaders() {
        HttpHeaders headers = this.getBasicHTTPHeaders();
        if (this.connection != null && this.connection.getConfigurationProperties() != null && this.connection.getConfigurationProperties().containsKey("securityServerAuthorization")) {
            headers.set("Authorization", (String)this.connection.getConfigurationProperties().get("securityServerAuthorization"));
        }
        return headers;
    }

    private HttpHeaders getBasicHTTPHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
        return headers;
    }

    private Boolean doDelete(String deleteAssociationURL) {
        RestTemplate restTemplate = new RestTemplate();
        HttpHeaders headers = this.getHttpHeaders();
        headers.add("X-HTTP-Method-Override", "DELETE");
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        try {
            restTemplate.exchange(deleteAssociationURL, HttpMethod.DELETE, entity, Void.class, new Object[0]);
        }
        catch (HttpStatusCodeException exception) {
            log.debug("Unable to doDelete the association between tag and resource");
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RangerSecurityServiceConnector that = (RangerSecurityServiceConnector)o;
        return Objects.equals(this.connection, that.connection);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.connection);
    }
}

