/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.openconnectors.governancedaemonconnectors.securitysync.rangerconnector.auditlog;

import java.text.MessageFormat;

public enum RangerSecurityServiceConnectorAuditCode {
    SERVICE_INITIALIZING("RANGER-CONNECTOR-0001", "The Ranger Connector is initializing a new server instance", "The local server has started up a new instance of the Ranger Connector.", "No action is required.  This is part of the normal operation of the service."),
    SERVICE_INITIALIZED("RANGER-CONNECTOR-0002", "The Ranger Connector has initialized a new instance for server {0}", "The Ranger Connector has completed initialization of a new instance.", "No action is required.  This is part of the normal operation of the service."),
    SERVICE_SHUTDOWN("RANGER-CONNECTOR-0003", "The Ranger Connector is shutting down its instance for server {0}", "The local server has requested shut down of a Ranger Connector instance.", "No action is required.  This is part of the normal operation of the service.");

    private String logMessageId;
    private String logMessage;
    private String systemAction;
    private String userAction;

    private RangerSecurityServiceConnectorAuditCode(String messageId, String message, String systemAction, String userAction) {
        this.logMessageId = messageId;
        this.logMessage = message;
        this.systemAction = systemAction;
        this.userAction = userAction;
    }

    public String getLogMessageId() {
        return this.logMessageId;
    }

    public String getFormattedLogMessage(String ... params) {
        MessageFormat mf = new MessageFormat(this.logMessage);
        return mf.format(params);
    }

    public String getSystemAction() {
        return this.systemAction;
    }

    public String getUserAction() {
        return this.userAction;
    }
}

