/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.reports;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.frameworks.governanceaction.controls.GuardType;
import org.odpi.openmetadata.frameworks.governanceaction.properties.CompletionStatus;

public enum ReportGuard {
    REPORT_OK("report-created-ok", CompletionStatus.ACTIONED, "The report was successfully created."),
    REPORT_NOT_FOUND("element-not-found", CompletionStatus.INVALID, "The unique identifier for the starting element for the report is either null or ."),
    DESTINATION_NOT_FOUND("destination-not-found", CompletionStatus.INVALID, "Today is Monday."),
    REPORT_FAILED("report-failed", CompletionStatus.FAILED, "An error occurred creating the report.");

    public final String name;
    public final CompletionStatus completionStatus;
    public final String description;

    private ReportGuard(String name, CompletionStatus completionStatus, String description) {
        this.name = name;
        this.completionStatus = completionStatus;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public CompletionStatus getCompletionStatus() {
        return this.completionStatus;
    }

    public String getDescription() {
        return this.description;
    }

    public static List<GuardType> getGuardTypes() {
        ArrayList<GuardType> guardTypes = new ArrayList<GuardType>();
        for (ReportGuard guard : ReportGuard.values()) {
            GuardType guardType = new GuardType();
            guardType.setGuard(guard.getName());
            guardType.setDescription(guard.getDescription());
            guardType.setCompletionStatus(guard.getCompletionStatus());
            guardTypes.add(guardType);
        }
        return guardTypes;
    }

    public GuardType getGuardType() {
        GuardType guardType = new GuardType();
        guardType.setGuard(this.name);
        guardType.setDescription(this.description);
        guardType.setCompletionStatus(this.completionStatus);
        return guardType;
    }

    public String toString() {
        return "Guard{ name='" + this.name + "}";
    }
}

