/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.reports.surveyreport;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adapters.connectors.reports.ReportRequestParameter;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.governanceaction.GeneralGovernanceActionService;
import org.odpi.openmetadata.frameworks.governanceaction.OpenMetadataStore;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ActionTargetElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.search.ArrayTypePropertyValue;
import org.odpi.openmetadata.frameworks.governanceaction.search.ElementProperties;
import org.odpi.openmetadata.frameworks.governanceaction.search.MapTypePropertyValue;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyHelper;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyValue;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementControlHeader;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.reports.EgeriaReport;

public class SurveyReportService
extends GeneralGovernanceActionService {
    private final Date reportDate = new Date();
    private final PropertyHelper propertyHelper = new PropertyHelper();

    public void start() throws ConnectorCheckedException {
        String methodName = "start";
        super.start();
        try {
            String reportDirectory = "surveys/survey-reports";
            if (this.governanceContext.getRequestParameters() != null && this.governanceContext.getRequestParameters().get(ReportRequestParameter.REPORT_DIRECTORY.getName()) != null) {
                reportDirectory = (String)this.governanceContext.getRequestParameters().get(ReportRequestParameter.REPORT_DIRECTORY.getName());
            }
            for (ActionTargetElement actionTargetRelationship : this.governanceContext.getActionTargetElements()) {
                if (actionTargetRelationship == null || actionTargetRelationship.getTargetElement() == null || !this.propertyHelper.isTypeOf((ElementControlHeader)actionTargetRelationship.getTargetElement(), OpenMetadataType.SURVEY_REPORT.typeName)) continue;
                this.createReport(reportDirectory, actionTargetRelationship.getTargetElement());
            }
        }
        catch (Exception error) {
            super.handleUnexpectedException("start", (Throwable)error);
        }
    }

    public String getAnnotationTitle(OpenMetadataElement annotationElement) {
        Map annotationProperties;
        String annotationTitle = annotationElement.getType().getTypeName() + ": GUID " + annotationElement.getElementGUID();
        if (annotationElement.getElementProperties() != null && (annotationProperties = annotationElement.getElementProperties().getPropertiesAsStrings()).get(OpenMetadataProperty.ANNOTATION_TYPE.name) != null) {
            annotationTitle = annotationElement.getType().getTypeName() + ": " + (String)annotationProperties.get(OpenMetadataProperty.ANNOTATION_TYPE.name);
        }
        return annotationTitle;
    }

    public String getAnnotationURL(OpenMetadataElement annotationElement) {
        Map annotationProperties;
        String annotationURL = "#" + annotationElement.getType().getTypeName() + "-GUID-" + annotationElement.getElementGUID();
        if (annotationElement.getElementProperties() != null && (annotationProperties = annotationElement.getElementProperties().getPropertiesAsStrings()).get(OpenMetadataProperty.ANNOTATION_TYPE.name) != null) {
            String annotationType = (String)annotationProperties.get(OpenMetadataProperty.ANNOTATION_TYPE.name);
            annotationURL = "#" + annotationElement.getType().getTypeName() + "-" + annotationType.replace(' ', '-');
        }
        return annotationURL;
    }

    private void printReport(int reportIndentLevel, OpenMetadataStore openMetadataStoreClient, OpenMetadataElement surveyReportElement, EgeriaReport outputReport) throws IOException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        Map surveyReportProperties;
        int annotationIndentLevel = reportIndentLevel + 1;
        outputReport.printReportSubheading(reportIndentLevel, "Survey report: " + surveyReportElement.getVersions().getCreateTime());
        if (surveyReportElement.getElementProperties() != null && (surveyReportProperties = surveyReportElement.getElementProperties().getPropertiesAsStrings()) != null) {
            for (String propertyName : surveyReportProperties.keySet()) {
                outputReport.printReportLine(reportIndentLevel, propertyName, (String)surveyReportProperties.get(propertyName));
            }
        }
        outputReport.printReportLine(reportIndentLevel, "\n**Annotations**");
        int startFrom = 0;
        int maxPageSize = 100;
        List annotationElements = openMetadataStoreClient.getRelatedMetadataElements(surveyReportElement.getElementGUID(), 1, OpenMetadataType.REPORTED_ANNOTATION_RELATIONSHIP.typeName, startFrom, maxPageSize);
        if (annotationElements != null) {
            while (annotationElements != null) {
                for (RelatedMetadataElement reportedAnnotationLink : annotationElements) {
                    if (reportedAnnotationLink == null || reportedAnnotationLink.getElement() == null) continue;
                    OpenMetadataElement reportedAnnotationElement = reportedAnnotationLink.getElement();
                    outputReport.printReportLine(reportIndentLevel, "* [" + this.getAnnotationTitle(reportedAnnotationElement) + "](" + this.getAnnotationURL(reportedAnnotationElement) + ")");
                }
                annotationElements = openMetadataStoreClient.getRelatedMetadataElements(surveyReportElement.getElementGUID(), 1, OpenMetadataType.REPORTED_ANNOTATION_RELATIONSHIP.typeName, startFrom += maxPageSize, maxPageSize);
            }
        } else {
            outputReport.printReportLine(annotationIndentLevel, "\nNone.");
        }
        startFrom = 0;
        annotationElements = openMetadataStoreClient.getRelatedMetadataElements(surveyReportElement.getElementGUID(), 1, OpenMetadataType.REPORTED_ANNOTATION_RELATIONSHIP.typeName, startFrom, maxPageSize);
        while (annotationElements != null) {
            for (RelatedMetadataElement reportedAnnotationElement : annotationElements) {
                if (reportedAnnotationElement == null || reportedAnnotationElement.getElement() == null) continue;
                this.printAnnotation(annotationIndentLevel, openMetadataStoreClient, reportedAnnotationElement, outputReport);
            }
            annotationElements = openMetadataStoreClient.getRelatedMetadataElements(surveyReportElement.getElementGUID(), 1, OpenMetadataType.REPORTED_ANNOTATION_RELATIONSHIP.typeName, startFrom += maxPageSize, maxPageSize);
        }
    }

    private void printMapProperty(int indentLevel, String propertyName, ElementProperties elementProperties, EgeriaReport outputReport) throws IOException {
        int annotationPropertyIndentLevel = indentLevel + 1;
        if (elementProperties != null && elementProperties.getPropertyValue(propertyName) != null) {
            MapTypePropertyValue mapTypePropertyValue;
            ArrayList<String> tableHeadings = new ArrayList<String>(Arrays.asList("Name", "Value"));
            outputReport.printReportLine(indentLevel, "* **" + propertyName + "**:");
            PropertyValue propertyValue = elementProperties.getPropertyValue(propertyName);
            if (propertyValue instanceof MapTypePropertyValue && (mapTypePropertyValue = (MapTypePropertyValue)propertyValue).getMapValues() != null) {
                Map mapValueProperties = mapTypePropertyValue.getMapValues().getPropertiesAsStrings();
                for (String mapPropertyName : mapValueProperties.keySet()) {
                    outputReport.printElementInTable(annotationPropertyIndentLevel, tableHeadings, new ArrayList<String>(Arrays.asList(mapPropertyName, (String)mapValueProperties.get(mapPropertyName))));
                    tableHeadings = null;
                }
            }
        }
    }

    private void printArrayProperty(int indentLevel, String propertyName, ElementProperties elementProperties, EgeriaReport outputReport) throws IOException {
        int annotationPropertyIndentLevel = indentLevel + 1;
        if (elementProperties != null && elementProperties.getPropertyValue(propertyName) != null) {
            ArrayTypePropertyValue arrayTypePropertyValue;
            ArrayList<String> tableHeadings = new ArrayList<String>(List.of("Values"));
            outputReport.printReportLine(indentLevel, "* **" + propertyName + "**:");
            PropertyValue propertyValue = elementProperties.getPropertyValue(propertyName);
            if (propertyValue instanceof ArrayTypePropertyValue && (arrayTypePropertyValue = (ArrayTypePropertyValue)propertyValue).getArrayValues() != null) {
                Map propertiesAsStrings = arrayTypePropertyValue.getArrayValues().getPropertiesAsStrings();
                for (String mapPropertyName : propertiesAsStrings.keySet()) {
                    outputReport.printElementInTable(annotationPropertyIndentLevel, tableHeadings, new ArrayList<String>(Collections.singletonList((String)propertiesAsStrings.get(mapPropertyName))));
                    tableHeadings = null;
                }
            }
        }
    }

    private void printAnnotation(int annotationIndentLevel, OpenMetadataStore openMetadataStoreClient, RelatedMetadataElement reportedAnnotationElement, EgeriaReport outputReport) throws IOException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        int annotationPropertyIndentLevel = annotationIndentLevel + 1;
        int startFrom = 0;
        int maxPageSize = 100;
        ArrayList<String> tableHeadings = new ArrayList<String>(Arrays.asList("Property Name", "Property Value"));
        OpenMetadataElement annotationElement = reportedAnnotationElement.getElement();
        outputReport.printReportSubheading(annotationIndentLevel, this.getAnnotationTitle(annotationElement));
        outputReport.printReportLine(annotationIndentLevel, "Creation Time", annotationElement.getVersions().getCreateTime().toString());
        if (annotationElement.getElementProperties() != null) {
            ArrayList<String> processedProperties = new ArrayList<String>();
            Map annotationProperties = annotationElement.getElementProperties().getPropertiesAsStrings();
            outputReport.printReportLine(annotationIndentLevel, OpenMetadataProperty.ANNOTATION_TYPE.name, (String)annotationProperties.get(OpenMetadataProperty.ANNOTATION_TYPE.name));
            processedProperties.add(OpenMetadataProperty.ANNOTATION_TYPE.name);
            outputReport.printReportLine(annotationIndentLevel, OpenMetadataProperty.SUMMARY.name, (String)annotationProperties.get(OpenMetadataProperty.SUMMARY.name));
            processedProperties.add(OpenMetadataProperty.SUMMARY.name);
            outputReport.printReportLine(annotationIndentLevel, OpenMetadataProperty.ANNOTATION_STATUS.name, (String)annotationProperties.get(OpenMetadataProperty.ANNOTATION_STATUS.name));
            processedProperties.add(OpenMetadataProperty.ANNOTATION_STATUS.name);
            outputReport.printReportLine(annotationIndentLevel, OpenMetadataProperty.CONFIDENCE_LEVEL.name, (String)annotationProperties.get(OpenMetadataProperty.CONFIDENCE_LEVEL.name));
            processedProperties.add(OpenMetadataProperty.CONFIDENCE_LEVEL.name);
            outputReport.printReportLine(annotationIndentLevel, OpenMetadataProperty.EXPRESSION.name, (String)annotationProperties.get(OpenMetadataProperty.EXPRESSION.name));
            processedProperties.add(OpenMetadataProperty.EXPRESSION.name);
            outputReport.printReportLine(annotationIndentLevel, OpenMetadataProperty.EXPLANATION.name, (String)annotationProperties.get(OpenMetadataProperty.EXPLANATION.name));
            processedProperties.add(OpenMetadataProperty.EXPLANATION.name);
            outputReport.printReportLine(annotationIndentLevel, OpenMetadataProperty.ANALYSIS_STEP.name, (String)annotationProperties.get(OpenMetadataProperty.ANALYSIS_STEP.name));
            processedProperties.add(OpenMetadataProperty.ANALYSIS_STEP.name);
            outputReport.printReportLine(annotationIndentLevel, OpenMetadataProperty.JSON_PROPERTIES.name, (String)annotationProperties.get(OpenMetadataProperty.JSON_PROPERTIES.name));
            processedProperties.add(OpenMetadataProperty.JSON_PROPERTIES.name);
            this.printMapProperty(annotationIndentLevel, OpenMetadataProperty.VALUE_COUNT.name, annotationElement.getElementProperties(), outputReport);
            processedProperties.add(OpenMetadataProperty.VALUE_COUNT.name);
            this.printArrayProperty(annotationIndentLevel, OpenMetadataProperty.VALUE_LIST.name, annotationElement.getElementProperties(), outputReport);
            processedProperties.add(OpenMetadataProperty.VALUE_COUNT.name);
            this.printMapProperty(annotationIndentLevel, OpenMetadataProperty.PROFILE_PROPERTIES.name, annotationElement.getElementProperties(), outputReport);
            processedProperties.add(OpenMetadataProperty.PROFILE_PROPERTIES.name);
            this.printMapProperty(annotationIndentLevel, OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, annotationElement.getElementProperties(), outputReport);
            processedProperties.add(OpenMetadataProperty.ADDITIONAL_PROPERTIES.name);
            outputReport.printReportLine(annotationIndentLevel, "* **Other Properties**:");
            for (String propertyName : annotationProperties.keySet()) {
                if (processedProperties.contains(propertyName)) continue;
                outputReport.printElementInTable(annotationPropertyIndentLevel, tableHeadings, new ArrayList<String>(Arrays.asList(propertyName, (String)annotationProperties.get(propertyName))));
                tableHeadings = null;
            }
        }
        List associatedElements = openMetadataStoreClient.getRelatedMetadataElements(reportedAnnotationElement.getElement().getElementGUID(), 2, OpenMetadataType.ASSOCIATED_ANNOTATION_RELATIONSHIP.typeName, startFrom, maxPageSize);
        while (associatedElements != null) {
            int associatedElementIndentLevel = annotationIndentLevel + 1;
            for (RelatedMetadataElement associatedElement : associatedElements) {
                if (associatedElement == null) continue;
                outputReport.printReportLine(associatedElementIndentLevel, "Associated " + associatedElement.getElement().getType().getTypeName() + " Element: " + associatedElement.getElement().getElementGUID());
                if (associatedElement.getElement().getElementProperties() == null) continue;
                Map associatedElementProperties = associatedElement.getElement().getElementProperties().getPropertiesAsStrings();
                for (String propertyName : associatedElementProperties.keySet()) {
                    outputReport.printReportLine(associatedElementIndentLevel + 1, propertyName, (String)associatedElementProperties.get(propertyName));
                }
            }
            associatedElements = openMetadataStoreClient.getRelatedMetadataElements(reportedAnnotationElement.getElement().getElementGUID(), 2, OpenMetadataType.ASSOCIATED_ANNOTATION_RELATIONSHIP.typeName, startFrom += maxPageSize, maxPageSize);
        }
    }

    private void createReport(String surveyReportDirectory, OpenMetadataElement surveyReport) {
        int indentLevel = 0;
        try {
            OpenMetadataStore openMetadataStoreClient = this.governanceContext.getOpenMetadataStore();
            if (surveyReport != null) {
                String reportFileName = "survey-report-" + this.reportDate + ".md";
                EgeriaReport outputReport = new EgeriaReport(surveyReportDirectory + "/" + reportFileName, false);
                outputReport.printReportTitle(indentLevel, "Asset survey report");
                outputReport.printReportLine(indentLevel, "Date: " + this.reportDate);
                int reportIndentLevel = indentLevel + 1;
                this.printReport(reportIndentLevel, openMetadataStoreClient, surveyReport, outputReport);
                outputReport.closeReport();
            }
        }
        catch (Exception error) {
            System.out.println("There was an " + error.getClass().getName() + " exception when calling the platform.  Error message is: " + error.getMessage());
            System.exit(-1);
        }
    }
}

