/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.reports.surveyreport;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adapters.connectors.reports.ReportRequestParameter;
import org.odpi.openmetadata.adapters.connectors.reports.ffdc.ReportsAuditCode;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.governanceaction.GeneralGovernanceActionService;
import org.odpi.openmetadata.frameworks.governanceaction.OpenMetadataStore;
import org.odpi.openmetadata.frameworks.governanceaction.controls.Guard;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ActionTargetElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElementList;
import org.odpi.openmetadata.frameworks.governanceaction.search.ArrayTypePropertyValue;
import org.odpi.openmetadata.frameworks.governanceaction.search.ElementProperties;
import org.odpi.openmetadata.frameworks.governanceaction.search.MapTypePropertyValue;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyHelper;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyValue;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementControlHeader;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.reports.EgeriaReport;

public class SurveyReportService
extends GeneralGovernanceActionService {
    private final Date reportDate = new Date();
    private final PropertyHelper propertyHelper = new PropertyHelper();

    public void start() throws ConnectorCheckedException {
        String methodName = "start";
        super.start();
        try {
            String reportDirectory = "surveys/survey-reports";
            if (this.governanceContext.getRequestParameters() != null && this.governanceContext.getRequestParameters().get(ReportRequestParameter.REPORT_DIRECTORY.getName()) != null) {
                reportDirectory = (String)this.governanceContext.getRequestParameters().get(ReportRequestParameter.REPORT_DIRECTORY.getName());
            }
            for (ActionTargetElement actionTargetRelationship : this.governanceContext.getActionTargetElements()) {
                if (actionTargetRelationship == null || actionTargetRelationship.getTargetElement() == null || !this.propertyHelper.isTypeOf((ElementControlHeader)actionTargetRelationship.getTargetElement(), OpenMetadataType.SURVEY_REPORT.typeName)) continue;
                this.createReport(reportDirectory, actionTargetRelationship.getTargetElement());
            }
        }
        catch (Exception error) {
            super.handleUnexpectedException("start", (Throwable)error);
        }
    }

    public String getAnnotationTitle(OpenMetadataElement annotationElement) {
        Map annotationProperties;
        Object annotationTitle = annotationElement.getType().getTypeName() + ": GUID " + annotationElement.getElementGUID();
        if (annotationElement.getElementProperties() != null && (annotationProperties = annotationElement.getElementProperties().getPropertiesAsStrings()).get(OpenMetadataProperty.ANNOTATION_TYPE.name) != null) {
            annotationTitle = (String)annotationProperties.get(OpenMetadataProperty.ANNOTATION_TYPE.name);
        }
        return annotationTitle;
    }

    public String getAnnotationURL(OpenMetadataElement annotationElement) {
        Map annotationProperties;
        String annotationURL = "#" + annotationElement.getType().getTypeName() + "-GUID-" + annotationElement.getElementGUID();
        if (annotationElement.getElementProperties() != null && (annotationProperties = annotationElement.getElementProperties().getPropertiesAsStrings()).get(OpenMetadataProperty.ANNOTATION_TYPE.name) != null) {
            String annotationType = (String)annotationProperties.get(OpenMetadataProperty.ANNOTATION_TYPE.name);
            annotationURL = "#" + annotationType.replace(' ', '-');
        }
        return annotationURL;
    }

    private void printReport(int reportIndentLevel, OpenMetadataStore openMetadataStoreClient, OpenMetadataElement surveyReportElement, EgeriaReport outputReport) throws IOException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "printReport";
        int annotationIndentLevel = reportIndentLevel + 1;
        outputReport.printReportLine(reportIndentLevel, "* Report Start Time: " + surveyReportElement.getVersions().getCreateTime());
        outputReport.printReportLine(reportIndentLevel, "* Report Completion Time: " + this.propertyHelper.getDateProperty(this.governanceServiceName, OpenMetadataProperty.COMPLETION_DATE.name, surveyReportElement.getElementProperties(), "printReport"));
        outputReport.printReportLine(reportIndentLevel, "* Final Analysis Step: " + this.propertyHelper.getStringProperty(this.governanceServiceName, OpenMetadataProperty.ANALYSIS_STEP.name, surveyReportElement.getElementProperties(), "printReport"));
        outputReport.printReportLine(reportIndentLevel, "\n" + this.propertyHelper.getStringProperty(this.governanceServiceName, OpenMetadataProperty.DESCRIPTION.name, surveyReportElement.getElementProperties(), "printReport"));
        outputReport.printReportSubheading(reportIndentLevel, "Annotations");
        int startFrom = 0;
        int maxPageSize = 100;
        RelatedMetadataElementList annotationElements = openMetadataStoreClient.getRelatedMetadataElements(surveyReportElement.getElementGUID(), 1, OpenMetadataType.REPORTED_ANNOTATION_RELATIONSHIP.typeName, startFrom, maxPageSize);
        if (annotationElements != null && annotationElements.getElementList() != null) {
            while (annotationElements != null && annotationElements.getElementList() != null) {
                for (RelatedMetadataElement reportedAnnotationLink : annotationElements.getElementList()) {
                    if (reportedAnnotationLink == null || reportedAnnotationLink.getElement() == null) continue;
                    OpenMetadataElement reportedAnnotationElement = reportedAnnotationLink.getElement();
                    outputReport.printReportLine(reportIndentLevel, "* [" + this.getAnnotationTitle(reportedAnnotationElement) + "](" + this.getAnnotationURL(reportedAnnotationElement) + ")");
                }
                annotationElements = openMetadataStoreClient.getRelatedMetadataElements(surveyReportElement.getElementGUID(), 1, OpenMetadataType.REPORTED_ANNOTATION_RELATIONSHIP.typeName, startFrom += maxPageSize, maxPageSize);
            }
        } else {
            outputReport.printReportLine(annotationIndentLevel, "\nNone.");
        }
        startFrom = 0;
        annotationElements = openMetadataStoreClient.getRelatedMetadataElements(surveyReportElement.getElementGUID(), 1, OpenMetadataType.REPORTED_ANNOTATION_RELATIONSHIP.typeName, startFrom, maxPageSize);
        while (annotationElements != null && annotationElements.getElementList() != null) {
            for (RelatedMetadataElement reportedAnnotationElement : annotationElements.getElementList()) {
                if (reportedAnnotationElement == null || reportedAnnotationElement.getElement() == null) continue;
                this.printAnnotation(annotationIndentLevel, openMetadataStoreClient, reportedAnnotationElement, outputReport);
            }
            annotationElements = openMetadataStoreClient.getRelatedMetadataElements(surveyReportElement.getElementGUID(), 1, OpenMetadataType.REPORTED_ANNOTATION_RELATIONSHIP.typeName, startFrom += maxPageSize, maxPageSize);
        }
    }

    private void printMapProperty(int indentLevel, String propertyName, ElementProperties elementProperties, EgeriaReport outputReport) throws IOException {
        int annotationPropertyIndentLevel = indentLevel + 1;
        if (elementProperties != null && elementProperties.getPropertyValue(propertyName) != null) {
            MapTypePropertyValue mapTypePropertyValue;
            ArrayList<String> tableHeadings = new ArrayList<String>(Arrays.asList("Name", "Value"));
            outputReport.printReportLine(indentLevel, "\n**" + propertyName + "**:\n");
            PropertyValue propertyValue = elementProperties.getPropertyValue(propertyName);
            if (propertyValue instanceof MapTypePropertyValue && (mapTypePropertyValue = (MapTypePropertyValue)propertyValue).getMapValues() != null) {
                Map mapValueProperties = mapTypePropertyValue.getMapValues().getPropertiesAsStrings();
                for (String mapPropertyName : mapValueProperties.keySet()) {
                    outputReport.printElementInTable(annotationPropertyIndentLevel, tableHeadings, new ArrayList<String>(Arrays.asList(mapPropertyName, (String)mapValueProperties.get(mapPropertyName))));
                    tableHeadings = null;
                }
            }
        }
    }

    private void printArrayProperty(int indentLevel, String propertyName, ElementProperties elementProperties, EgeriaReport outputReport) throws IOException {
        int annotationPropertyIndentLevel = indentLevel + 1;
        if (elementProperties != null && elementProperties.getPropertyValue(propertyName) != null) {
            ArrayTypePropertyValue arrayTypePropertyValue;
            ArrayList<String> tableHeadings = new ArrayList<String>(List.of("Values"));
            outputReport.printReportLine(indentLevel, "* **" + propertyName + "**:");
            PropertyValue propertyValue = elementProperties.getPropertyValue(propertyName);
            if (propertyValue instanceof ArrayTypePropertyValue && (arrayTypePropertyValue = (ArrayTypePropertyValue)propertyValue).getArrayValues() != null) {
                Map propertiesAsStrings = arrayTypePropertyValue.getArrayValues().getPropertiesAsStrings();
                for (String mapPropertyName : propertiesAsStrings.keySet()) {
                    outputReport.printElementInTable(annotationPropertyIndentLevel, tableHeadings, new ArrayList<String>(Collections.singletonList((String)propertiesAsStrings.get(mapPropertyName))));
                    tableHeadings = null;
                }
            }
        }
    }

    private void printAnnotation(int annotationIndentLevel, OpenMetadataStore openMetadataStoreClient, RelatedMetadataElement reportedAnnotationElement, EgeriaReport outputReport) throws IOException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        int annotationPropertyIndentLevel = annotationIndentLevel + 1;
        int startFrom = 0;
        int maxPageSize = 100;
        ArrayList<String> tableHeadings = new ArrayList<String>(Arrays.asList("Property Name", "Property Value"));
        OpenMetadataElement annotationElement = reportedAnnotationElement.getElement();
        outputReport.printReportSubheading(annotationIndentLevel, this.getAnnotationTitle(annotationElement));
        outputReport.printReportLine(annotationIndentLevel, "Creation Time", annotationElement.getVersions().getCreateTime().toString());
        if (annotationElement.getElementProperties() != null) {
            Map annotationProperties = annotationElement.getElementProperties().getPropertiesAsStrings();
            outputReport.printReportLine(annotationIndentLevel, OpenMetadataProperty.SUMMARY.name, (String)annotationProperties.get(OpenMetadataProperty.SUMMARY.name));
            if (annotationProperties.get(OpenMetadataProperty.ANNOTATION_STATUS.name) != null) {
                outputReport.printReportLine(annotationIndentLevel, OpenMetadataProperty.ANNOTATION_STATUS.name, (String)annotationProperties.get(OpenMetadataProperty.ANNOTATION_STATUS.name));
            }
            if (annotationProperties.get(OpenMetadataProperty.CONFIDENCE_LEVEL.name) != null) {
                outputReport.printReportLine(annotationIndentLevel, OpenMetadataProperty.CONFIDENCE_LEVEL.name, (String)annotationProperties.get(OpenMetadataProperty.CONFIDENCE_LEVEL.name));
            }
            if (annotationProperties.get(OpenMetadataProperty.EXPRESSION.name) != null) {
                outputReport.printReportLine(annotationIndentLevel, OpenMetadataProperty.EXPRESSION.name, (String)annotationProperties.get(OpenMetadataProperty.EXPRESSION.name));
            }
            outputReport.printReportLine(annotationIndentLevel, OpenMetadataProperty.EXPLANATION.name, (String)annotationProperties.get(OpenMetadataProperty.EXPLANATION.name));
            outputReport.printReportLine(annotationIndentLevel, OpenMetadataProperty.ANALYSIS_STEP.name, (String)annotationProperties.get(OpenMetadataProperty.ANALYSIS_STEP.name));
            this.printMapProperty(annotationIndentLevel, OpenMetadataProperty.VALUE_COUNT.name, annotationElement.getElementProperties(), outputReport);
            this.printArrayProperty(annotationIndentLevel, OpenMetadataProperty.VALUE_LIST.name, annotationElement.getElementProperties(), outputReport);
            this.printMapProperty(annotationIndentLevel, OpenMetadataProperty.PROFILE_PROPERTIES.name, annotationElement.getElementProperties(), outputReport);
            this.printMapProperty(annotationIndentLevel, OpenMetadataProperty.RESOURCE_PROPERTIES.name, annotationElement.getElementProperties(), outputReport);
            this.printMapProperty(annotationIndentLevel, OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, annotationElement.getElementProperties(), outputReport);
        }
        RelatedMetadataElementList associatedElements = openMetadataStoreClient.getRelatedMetadataElements(reportedAnnotationElement.getElement().getElementGUID(), 2, OpenMetadataType.ASSOCIATED_ANNOTATION_RELATIONSHIP.typeName, startFrom, maxPageSize);
        while (associatedElements != null && associatedElements.getElementList() != null) {
            int associatedElementIndentLevel = annotationIndentLevel + 1;
            for (RelatedMetadataElement associatedElement : associatedElements.getElementList()) {
                if (associatedElement == null) continue;
                outputReport.printReportLine(associatedElementIndentLevel, "Associated " + associatedElement.getElement().getType().getTypeName() + " Element: " + associatedElement.getElement().getElementGUID());
                if (associatedElement.getElement().getElementProperties() == null) continue;
                Map associatedElementProperties = associatedElement.getElement().getElementProperties().getPropertiesAsStrings();
                for (String propertyName : associatedElementProperties.keySet()) {
                    outputReport.printReportLine(associatedElementIndentLevel + 1, propertyName, (String)associatedElementProperties.get(propertyName));
                }
            }
            associatedElements = openMetadataStoreClient.getRelatedMetadataElements(reportedAnnotationElement.getElement().getElementGUID(), 2, OpenMetadataType.ASSOCIATED_ANNOTATION_RELATIONSHIP.typeName, startFrom += maxPageSize, maxPageSize);
        }
    }

    private void createReport(String surveyReportDirectory, OpenMetadataElement surveyReport) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "createReport";
        int indentLevel = 0;
        try {
            OpenMetadataStore openMetadataStoreClient = this.governanceContext.getOpenMetadataStore();
            if (surveyReport != null) {
                String reportDisplayName = this.propertyHelper.getStringProperty(this.governanceServiceName, OpenMetadataProperty.DISPLAY_NAME.name, surveyReport.getElementProperties(), "createReport");
                if (reportDisplayName == null) {
                    reportDisplayName = "Asset survey report";
                }
                String reportFileName = reportDisplayName + "-" + this.reportDate + ".md";
                EgeriaReport outputReport = new EgeriaReport(surveyReportDirectory + "/" + reportFileName, false);
                outputReport.printReportTitle(indentLevel, reportDisplayName);
                outputReport.printReportLine(indentLevel, "* Report Print Time: " + this.reportDate);
                int reportIndentLevel = indentLevel + 1;
                this.printReport(reportIndentLevel, openMetadataStoreClient, surveyReport, outputReport);
                outputReport.closeReport();
                this.governanceContext.recordCompletionStatus(Guard.SERVICE_COMPLETED.getCompletionStatus(), List.of(Guard.SERVICE_COMPLETED.getName()), null, null, ReportsAuditCode.REPORT_CREATED.getMessageDefinition(this.governanceServiceName, reportFileName));
            }
        }
        catch (Exception error) {
            this.governanceContext.recordCompletionStatus(Guard.SERVICE_FAILED.getCompletionStatus(), List.of(Guard.SERVICE_FAILED.getName()), null, null, ReportsAuditCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.governanceServiceName, error.getClass().getName(), "createReport", error.getMessage()));
        }
    }
}

