/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.engineservices.repositorygovernance.connector;

import java.util.List;
import org.odpi.openmetadata.engineservices.repositorygovernance.connector.RepositoryGovernanceContext;
import org.odpi.openmetadata.engineservices.repositorygovernance.connector.RepositoryGovernanceService;
import org.odpi.openmetadata.engineservices.repositorygovernance.ffdc.RepositoryGovernanceErrorCode;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.AuditLoggingComponent;
import org.odpi.openmetadata.frameworks.auditlog.ComponentDescription;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBase;
import org.odpi.openmetadata.frameworks.connectors.VirtualConnectorExtension;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;

public abstract class RepositoryGovernanceServiceConnector
extends ConnectorBase
implements RepositoryGovernanceService,
AuditLoggingComponent,
VirtualConnectorExtension {
    protected String repositoryGovernanceServiceName = "<Unknown>";
    protected RepositoryGovernanceContext repositoryGovernanceContext = null;
    protected AuditLog auditLog = null;
    protected List<Connector> embeddedConnectors = null;

    public void setAuditLog(AuditLog auditLog) {
        this.auditLog = auditLog;
    }

    public ComponentDescription getConnectorComponentDescription() {
        if (this.auditLog != null && this.auditLog.getReport() != null) {
            return this.auditLog.getReport().getReportingComponent();
        }
        return null;
    }

    public void initializeEmbeddedConnectors(List<Connector> embeddedConnectors) {
        this.embeddedConnectors = embeddedConnectors;
    }

    public synchronized void setRepositoryGovernanceContext(RepositoryGovernanceContext repositoryGovernanceContext) {
        this.repositoryGovernanceContext = repositoryGovernanceContext;
    }

    public void setRepositoryGovernanceServiceName(String archiveServiceName) {
        this.repositoryGovernanceServiceName = archiveServiceName;
    }

    public synchronized RepositoryGovernanceContext getRepositoryGovernanceContext() {
        return this.repositoryGovernanceContext;
    }

    public synchronized void start() throws ConnectorCheckedException {
        super.start();
        this.validateContext(this.repositoryGovernanceContext);
    }

    protected void handleUnexpectedException(String methodName, Exception error) throws ConnectorCheckedException {
        throw new ConnectorCheckedException(RepositoryGovernanceErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.repositoryGovernanceServiceName, error.getClass().getName(), methodName, error.getMessage()), this.getClass().getName(), methodName);
    }

    protected void validateContext(RepositoryGovernanceContext governanceContext) throws ConnectorCheckedException {
        String methodName = "start";
        if (governanceContext == null) {
            throw new ConnectorCheckedException(RepositoryGovernanceErrorCode.NULL_REPOSITORY_GOVERNANCE_CONTEXT.getMessageDefinition(this.repositoryGovernanceServiceName), this.getClass().getName(), "start");
        }
    }

    public synchronized void disconnect() throws ConnectorCheckedException {
        super.disconnect();
        if (this.embeddedConnectors != null) {
            for (Connector embeddedConnector : this.embeddedConnectors) {
                if (embeddedConnector == null) continue;
                try {
                    embeddedConnector.disconnect();
                }
                catch (Exception exception) {}
            }
        }
    }
}

