/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.engineservices.repositorygovernance.client;

import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.properties.ConnectorReport;
import org.odpi.openmetadata.commonservices.ffdc.rest.ConnectorReportResponse;
import org.odpi.openmetadata.engineservices.repositorygovernance.api.RepositoryGovernanceAPI;
import org.odpi.openmetadata.engineservices.repositorygovernance.client.rest.RepositoryGovernanceRESTClient;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class RepositoryGovernanceClient
implements RepositoryGovernanceAPI {
    private String serverName;
    private String serverPlatformRootURL;
    private String repositoryGovernanceEngineName;
    private RepositoryGovernanceRESTClient restClient;
    private InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    private RESTExceptionHandler exceptionHandler = new RESTExceptionHandler();

    public RepositoryGovernanceClient(String serverPlatformRootURL, String serverName, String repositoryGovernanceEngineName) throws InvalidParameterException {
        this.serverPlatformRootURL = serverPlatformRootURL;
        this.serverName = serverName;
        this.repositoryGovernanceEngineName = repositoryGovernanceEngineName;
        this.restClient = new RepositoryGovernanceRESTClient(serverName, serverPlatformRootURL);
    }

    public RepositoryGovernanceClient(String serverPlatformRootURL, String serverName, String repositoryGovernanceEngineName, String userId, String password) throws InvalidParameterException {
        this.serverPlatformRootURL = serverPlatformRootURL;
        this.serverName = serverName;
        this.repositoryGovernanceEngineName = repositoryGovernanceEngineName;
        this.restClient = new RepositoryGovernanceRESTClient(serverName, serverPlatformRootURL, userId, password);
    }

    public ConnectorReport validateConnector(String userId, String connectorProviderClassName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "validateConnector";
        String nameParameter = "connectorProviderClassName";
        String urlTemplate = "/servers/{0}/open-metadata/engine-services/repository-governance/users/{1}/validate-connector";
        this.invalidParameterHandler.validateUserId(userId, "validateConnector");
        this.invalidParameterHandler.validateName(connectorProviderClassName, "connectorProviderClassName", "validateConnector");
        ConnectorReportResponse restResult = this.restClient.callOCFConnectorReportGetRESTCall("validateConnector", this.serverPlatformRootURL + "/servers/{0}/open-metadata/engine-services/repository-governance/users/{1}/validate-connector", new Object[]{this.serverName, userId, connectorProviderClassName});
        return restResult.getConnectorReport();
    }
}

