/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.engineservices.repositorygovernance.handlers;

import java.util.Date;
import org.odpi.openmetadata.accessservices.governanceengine.client.GovernanceEngineClient;
import org.odpi.openmetadata.accessservices.governanceengine.properties.GovernanceEngineProperties;
import org.odpi.openmetadata.engineservices.repositorygovernance.connector.RepositoryGovernanceContext;
import org.odpi.openmetadata.engineservices.repositorygovernance.connector.RepositoryGovernanceService;
import org.odpi.openmetadata.engineservices.repositorygovernance.ffdc.RepositoryGovernanceAuditCode;
import org.odpi.openmetadata.engineservices.repositorygovernance.ffdc.RepositoryGovernanceErrorCode;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.governanceaction.properties.CompletionStatus;
import org.odpi.openmetadata.governanceservers.enginehostservices.admin.GovernanceServiceHandler;

public class RepositoryGovernanceServiceHandler
extends GovernanceServiceHandler {
    private RepositoryGovernanceService repositoryGovernanceService;
    private RepositoryGovernanceContext repositoryGovernanceContext;

    RepositoryGovernanceServiceHandler(GovernanceEngineProperties repositoryGovernanceEngineProperties, String repositoryGovernanceEngineGUID, String engineHostUserId, String governanceActionGUID, GovernanceEngineClient governanceActionClient, String requestType, String repositoryGovernanceServiceGUID, String repositoryGovernanceServiceName, Connector repositoryGovernanceServiceConnector, RepositoryGovernanceContext repositoryGovernanceContext, AuditLog auditLog) throws InvalidParameterException {
        super(repositoryGovernanceEngineProperties, repositoryGovernanceEngineGUID, engineHostUserId, governanceActionGUID, governanceActionClient, requestType, repositoryGovernanceServiceGUID, repositoryGovernanceServiceName, repositoryGovernanceServiceConnector, auditLog);
        this.requestType = requestType;
        this.repositoryGovernanceContext = repositoryGovernanceContext;
        this.auditLog = auditLog;
        try {
            this.repositoryGovernanceService = (RepositoryGovernanceService)repositoryGovernanceServiceConnector;
        }
        catch (Exception error) {
            String repositoryGovernanceServiceConnectorParameterName = "repositoryGovernanceServiceConnector";
            String actionDescription = "Cast connector to RepositoryGovernanceService";
            auditLog.logException("Cast connector to RepositoryGovernanceService", RepositoryGovernanceAuditCode.INVALID_REPOSITORY_GOVERNANCE_SERVICE.getMessageDefinition(new String[]{repositoryGovernanceServiceName, requestType, error.getClass().getName(), error.getMessage()}), (Throwable)error);
            throw new InvalidParameterException(RepositoryGovernanceErrorCode.INVALID_REPOSITORY_GOVERNANCE_SERVICE.getMessageDefinition(new String[]{repositoryGovernanceServiceName, requestType, error.getClass().getName(), error.getMessage()}), ((Object)((Object)this)).getClass().getName(), "Cast connector to RepositoryGovernanceService", (Throwable)error, "repositoryGovernanceServiceConnector");
        }
    }

    public void run() {
        String actionDescription = "Maintain an repository governance service";
        try {
            this.auditLog.logMessage("Maintain an repository governance service", RepositoryGovernanceAuditCode.REPOSITORY_GOVERNANCE_SERVICE_STARTING.getMessageDefinition(new String[]{this.governanceServiceName, this.requestType, this.governanceEngineProperties.getQualifiedName(), this.governanceEngineGUID}));
            this.repositoryGovernanceService.setRepositoryGovernanceContext(this.repositoryGovernanceContext);
            this.repositoryGovernanceService.setRepositoryGovernanceServiceName(this.governanceServiceName);
            Date startTime = new Date();
            this.repositoryGovernanceService.start();
            Date endTime = new Date();
            CompletionStatus completionStatus = this.repositoryGovernanceContext.getCompletionStatus();
            if (completionStatus == null) {
                this.auditLog.logMessage("Maintain an repository governance service", RepositoryGovernanceAuditCode.REPOSITORY_GOVERNANCE_SERVICE_RETURNED.getMessageDefinition(new String[]{this.governanceServiceName, this.requestType, Long.toString(endTime.getTime() - startTime.getTime())}));
            } else {
                this.auditLog.logMessage("Maintain an repository governance service", RepositoryGovernanceAuditCode.REPOSITORY_GOVERNANCE_SERVICE_COMPLETE.getMessageDefinition(new String[]{this.governanceServiceName, this.requestType, completionStatus.getName(), Long.toString(endTime.getTime() - startTime.getTime())}));
                super.disconnect();
                this.repositoryGovernanceService.setRepositoryGovernanceContext(null);
            }
        }
        catch (Exception error) {
            this.auditLog.logException("Maintain an repository governance service", RepositoryGovernanceAuditCode.REPOSITORY_GOVERNANCE_SERVICE_FAILED.getMessageDefinition(new String[]{this.governanceServiceName, error.getClass().getName(), this.requestType, this.governanceEngineProperties.getQualifiedName(), this.governanceEngineGUID, error.getMessage()}), error.toString(), (Throwable)error);
            try {
                CompletionStatus completionStatus = this.repositoryGovernanceContext.getCompletionStatus();
                if (completionStatus == null) {
                    this.repositoryGovernanceContext.recordCompletionStatus(CompletionStatus.FAILED, null, null, null);
                    super.disconnect();
                }
            }
            catch (Exception statusError) {
                this.auditLog.logException("Maintain an repository governance service", RepositoryGovernanceAuditCode.EXC_ON_ERROR_STATUS_UPDATE.getMessageDefinition(new String[]{this.governanceEngineProperties.getDisplayName(), this.governanceServiceName, statusError.getClass().getName(), statusError.getMessage()}), statusError.toString(), (Throwable)statusError);
            }
        }
    }
}

