/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.engineservices.repositorygovernance.admin;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.governanceengine.client.GovernanceEngineClient;
import org.odpi.openmetadata.accessservices.governanceengine.client.GovernanceEngineConfigurationClient;
import org.odpi.openmetadata.adminservices.configuration.properties.EngineConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.EngineServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.EngineServiceDescription;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.engineservices.repositorygovernance.ffdc.RepositoryGovernanceAuditCode;
import org.odpi.openmetadata.engineservices.repositorygovernance.ffdc.RepositoryGovernanceErrorCode;
import org.odpi.openmetadata.engineservices.repositorygovernance.handlers.RepositoryGovernanceEngineHandler;
import org.odpi.openmetadata.engineservices.repositorygovernance.server.RepositoryGovernanceInstance;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.governanceservers.enginehostservices.admin.EngineServiceAdmin;
import org.odpi.openmetadata.governanceservers.enginehostservices.admin.GovernanceEngineHandler;
import org.odpi.openmetadata.repositoryservices.clients.EnterpriseRepositoryServicesClient;

public class RepositoryGovernanceAdmin
extends EngineServiceAdmin {
    private RepositoryGovernanceInstance archiveManagerInstance = null;

    public Map<String, GovernanceEngineHandler> initialize(String localServerId, String localServerName, AuditLog auditLog, String localServerUserId, String localServerPassword, int maxPageSize, GovernanceEngineConfigurationClient configurationClient, GovernanceEngineClient governanceActionClient, EngineServiceConfig engineServiceConfig) throws OMAGConfigurationErrorException {
        String actionDescription = "initialize engine service";
        String methodName = "initialize";
        this.auditLog = auditLog;
        this.localServerName = localServerName;
        auditLog.logMessage("initialize engine service", RepositoryGovernanceAuditCode.ENGINE_SERVICE_INITIALIZING.getMessageDefinition(new String[]{localServerName}));
        try {
            this.validateConfigDocument(engineServiceConfig);
            String partnerServiceRootURL = this.getPartnerServiceRootURL(engineServiceConfig);
            String partnerServiceServerName = this.getPartnerServiceServerName(engineServiceConfig);
            List archiveEngines = this.getEngines(engineServiceConfig);
            EnterpriseRepositoryServicesClient restClient = localServerName != null && localServerPassword != null ? new EnterpriseRepositoryServicesClient(partnerServiceServerName, partnerServiceRootURL, localServerUserId, localServerPassword, maxPageSize, localServerId) : new EnterpriseRepositoryServicesClient(partnerServiceServerName, partnerServiceRootURL, maxPageSize, localServerId);
            Map<String, RepositoryGovernanceEngineHandler> archiveEngineHandlers = this.getRepositoryGovernanceEngineHandlers(archiveEngines, partnerServiceServerName, localServerUserId, configurationClient, governanceActionClient, restClient, maxPageSize);
            if (archiveEngineHandlers == null) {
                auditLog.logMessage("initialize engine service", RepositoryGovernanceAuditCode.NO_REPOSITORY_GOVERNANCE_ENGINES_STARTED.getMessageDefinition(new String[]{localServerName}));
                throw new OMAGConfigurationErrorException(RepositoryGovernanceErrorCode.NO_REPOSITORY_GOVERNANCE_ENGINES_STARTED.getMessageDefinition(new String[]{localServerName}), ((Object)((Object)this)).getClass().getName(), "initialize");
            }
            this.archiveManagerInstance = new RepositoryGovernanceInstance(localServerName, EngineServiceDescription.REPOSITORY_GOVERNANCE_OMES.getEngineServiceName(), auditLog, localServerUserId, maxPageSize, engineServiceConfig.getOMAGServerPlatformRootURL(), engineServiceConfig.getOMAGServerName(), archiveEngineHandlers);
            HashMap<String, GovernanceEngineHandler> governanceEngineHandlers = new HashMap<String, GovernanceEngineHandler>();
            for (String engineName : archiveEngineHandlers.keySet()) {
                if (engineName == null) continue;
                governanceEngineHandlers.put(engineName, archiveEngineHandlers.get(engineName));
            }
            return governanceEngineHandlers;
        }
        catch (Exception error) {
            auditLog.logException("initialize engine service", RepositoryGovernanceAuditCode.SERVICE_INSTANCE_FAILURE.getMessageDefinition(new String[]{localServerName, error.getMessage()}), error.toString(), (Throwable)error);
            throw new OMAGConfigurationErrorException(RepositoryGovernanceErrorCode.SERVICE_INSTANCE_FAILURE.getMessageDefinition(new String[]{localServerName, error.getMessage()}), ((Object)((Object)this)).getClass().getName(), "initialize", (Throwable)error);
        }
    }

    private Map<String, RepositoryGovernanceEngineHandler> getRepositoryGovernanceEngineHandlers(List<EngineConfig> archiveEngines, String accessServiceServerName, String localServerUserId, GovernanceEngineConfigurationClient configurationClient, GovernanceEngineClient governanceActionClient, EnterpriseRepositoryServicesClient archiveEngineClient, int maxPageSize) throws OMAGConfigurationErrorException {
        HashMap<String, RepositoryGovernanceEngineHandler> archiveEngineHandlers = new HashMap<String, RepositoryGovernanceEngineHandler>();
        for (EngineConfig archiveEngine : archiveEngines) {
            if (archiveEngine == null) continue;
            RepositoryGovernanceEngineHandler handler = new RepositoryGovernanceEngineHandler(archiveEngine, accessServiceServerName, localServerUserId, configurationClient, governanceActionClient, archiveEngineClient, this.auditLog, maxPageSize);
            archiveEngineHandlers.put(archiveEngine.getEngineQualifiedName(), handler);
        }
        if (archiveEngineHandlers.isEmpty()) {
            return null;
        }
        return archiveEngineHandlers;
    }

    public void shutdown() {
        String actionDescription = "shutdown";
        this.auditLog.logMessage("shutdown", RepositoryGovernanceAuditCode.SERVER_SHUTTING_DOWN.getMessageDefinition(new String[]{this.localServerName}));
        this.archiveManagerInstance.shutdown();
        this.auditLog.logMessage("shutdown", RepositoryGovernanceAuditCode.SERVER_SHUTDOWN.getMessageDefinition(new String[]{this.localServerName}));
    }
}

