/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.engineservices.repositorygovernance.server;

import java.util.Map;
import org.odpi.openmetadata.commonservices.multitenant.OMESServiceInstance;
import org.odpi.openmetadata.engineservices.repositorygovernance.ffdc.RepositoryGovernanceErrorCode;
import org.odpi.openmetadata.engineservices.repositorygovernance.handlers.RepositoryGovernanceEngineHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;

public class RepositoryGovernanceInstance
extends OMESServiceInstance {
    private Map<String, RepositoryGovernanceEngineHandler> repositoryGovernanceEngineInstances;

    public RepositoryGovernanceInstance(String serverName, String serviceName, AuditLog auditLog, String localServerUserId, int maxPageSize, String accessServiceRootURL, String accessServiceServerName, Map<String, RepositoryGovernanceEngineHandler> repositoryGovernanceEngineInstances) {
        super(serverName, serviceName, auditLog, localServerUserId, maxPageSize, accessServiceRootURL, accessServiceServerName);
        this.repositoryGovernanceEngineInstances = repositoryGovernanceEngineInstances;
    }

    synchronized RepositoryGovernanceEngineHandler getRepositoryGovernanceEngine(String repositoryGovernanceEngineName) throws InvalidParameterException {
        String methodName = "getRepositoryGovernanceEngine";
        String guidParameterName = "archiveEngineName";
        RepositoryGovernanceEngineHandler instance = this.repositoryGovernanceEngineInstances.get(repositoryGovernanceEngineName);
        if (instance == null) {
            throw new InvalidParameterException(RepositoryGovernanceErrorCode.UNKNOWN_REPOSITORY_GOVERNANCE_ENGINE.getMessageDefinition(new String[]{this.serverName, repositoryGovernanceEngineName}), ((Object)((Object)this)).getClass().getName(), "getRepositoryGovernanceEngine", "archiveEngineName");
        }
        return instance;
    }
}

