/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.engineservices.repositorygovernance.handlers;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.governanceengine.client.GovernanceEngineClient;
import org.odpi.openmetadata.accessservices.governanceengine.client.GovernanceEngineConfigurationClient;
import org.odpi.openmetadata.adminservices.configuration.properties.EngineConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.EngineServiceDescription;
import org.odpi.openmetadata.engineservices.repositorygovernance.handlers.RepositoryGovernanceServiceContext;
import org.odpi.openmetadata.engineservices.repositorygovernance.handlers.RepositoryGovernanceServiceHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ActionTargetElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RequestSourceElement;
import org.odpi.openmetadata.governanceservers.enginehostservices.admin.GovernanceEngineHandler;
import org.odpi.openmetadata.governanceservers.enginehostservices.admin.GovernanceServiceCache;
import org.odpi.openmetadata.governanceservers.enginehostservices.admin.GovernanceServiceHandler;
import org.odpi.openmetadata.repositoryservices.clients.EnterpriseRepositoryServicesClient;

public class RepositoryGovernanceEngineHandler
extends GovernanceEngineHandler {
    private final EnterpriseRepositoryServicesClient repositoryGovernanceEngineClient;
    private static final String supportGovernanceEngineType = "RepositoryGovernanceEngine";

    public RepositoryGovernanceEngineHandler(EngineConfig engineConfig, String serverName, String serverUserId, GovernanceEngineConfigurationClient configurationClient, GovernanceEngineClient serverClient, EnterpriseRepositoryServicesClient repositoryGovernanceEngineClient, AuditLog auditLog, int maxPageSize) {
        super(engineConfig, serverName, serverUserId, EngineServiceDescription.REPOSITORY_GOVERNANCE_OMES.getEngineServiceFullName(), configurationClient, serverClient, auditLog, maxPageSize);
        this.repositoryGovernanceEngineClient = repositoryGovernanceEngineClient;
    }

    public GovernanceServiceHandler runGovernanceService(String governanceActionGUID, String governanceRequestType, Date startDate, Map<String, String> requestParameters, List<RequestSourceElement> requestSourceElements, List<ActionTargetElement> actionTargetElements) throws InvalidParameterException, PropertyServerException {
        String methodName = "runGovernanceService";
        super.validateGovernanceEngineInitialized(supportGovernanceEngineType, "runGovernanceService");
        GovernanceServiceCache governanceServiceCache = super.getServiceCache(governanceRequestType);
        if (governanceServiceCache != null && actionTargetElements != null && !actionTargetElements.isEmpty()) {
            RepositoryGovernanceServiceHandler repositoryGovernanceServiceHandler = this.getRepositoryGovernanceServiceHandler(governanceServiceCache.getGovernanceServiceName(), governanceServiceCache.getServiceRequestType(), governanceServiceCache.getRequestParameters(requestParameters), requestSourceElements, actionTargetElements, governanceActionGUID, governanceServiceCache);
            Thread thread = new Thread((Runnable)((Object)repositoryGovernanceServiceHandler), governanceServiceCache.getGovernanceServiceName() + new Date());
            thread.start();
            return repositoryGovernanceServiceHandler;
        }
        return null;
    }

    private RepositoryGovernanceServiceHandler getRepositoryGovernanceServiceHandler(String repositoryGovernanceServiceName, String repositoryGovernanceRequestType, Map<String, String> requestParameters, List<RequestSourceElement> requestSourceElements, List<ActionTargetElement> actionTargetElements, String governanceActionGUID, GovernanceServiceCache governanceServiceCache) throws InvalidParameterException, PropertyServerException {
        RepositoryGovernanceServiceContext repositoryGovernanceContext = new RepositoryGovernanceServiceContext(this.engineUserId, repositoryGovernanceServiceName, repositoryGovernanceRequestType, requestParameters, requestSourceElements, actionTargetElements, this.repositoryGovernanceEngineClient);
        RepositoryGovernanceServiceHandler repositoryGovernanceServiceHandler = new RepositoryGovernanceServiceHandler(this.governanceEngineProperties, this.governanceEngineGUID, this.serverUserId, governanceActionGUID, this.serverClient, repositoryGovernanceRequestType, governanceServiceCache.getGovernanceServiceGUID(), governanceServiceCache.getGovernanceServiceName(), governanceServiceCache.getNextGovernanceService(), repositoryGovernanceContext, this.auditLog);
        repositoryGovernanceContext.setRepositoryGovernanceServiceHandler(repositoryGovernanceServiceHandler);
        return repositoryGovernanceServiceHandler;
    }
}

