/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.engineservices.repositorygovernance.handlers;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.engineservices.repositorygovernance.connector.RepositoryGovernanceContext;
import org.odpi.openmetadata.engineservices.repositorygovernance.ffdc.RepositoryGovernanceErrorCode;
import org.odpi.openmetadata.engineservices.repositorygovernance.handlers.RepositoryGovernanceServiceHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectionCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ActionTargetElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.CompletionStatus;
import org.odpi.openmetadata.frameworks.governanceaction.properties.NewActionTarget;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RequestSourceElement;
import org.odpi.openmetadata.repositoryservices.clients.EnterpriseRepositoryServicesClient;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicRepositoryEventListener;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.HistorySequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchClassifications;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefGallery;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefProperties;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.ClassificationErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityProxyOnlyException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PagingErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;

public class RepositoryGovernanceServiceContext
extends RepositoryGovernanceContext {
    private volatile CompletionStatus completionStatus = null;
    private RepositoryGovernanceServiceHandler repositoryGovernanceServiceHandler = null;
    private String repositoryGovernanceServiceName;
    private EnterpriseRepositoryServicesClient repositoryServicesClient;

    public RepositoryGovernanceServiceContext(String userId, String repositoryGovernanceServiceName, String requestType, Map<String, String> requestParameters, List<RequestSourceElement> requestSourceElements, List<ActionTargetElement> actionTargetElements, EnterpriseRepositoryServicesClient repositoryServicesClient) {
        super(userId, requestType, requestParameters, requestSourceElements, actionTargetElements);
        this.repositoryGovernanceServiceName = repositoryGovernanceServiceName;
        this.repositoryServicesClient = repositoryServicesClient;
    }

    public void setRepositoryGovernanceServiceHandler(RepositoryGovernanceServiceHandler archiveServiceHandler) {
        this.repositoryGovernanceServiceHandler = archiveServiceHandler;
    }

    public void registerListener(OMRSTopicRepositoryEventListener listener) throws InvalidParameterException, UserNotAuthorizedException, RepositoryErrorException, ConnectionCheckedException, ConnectorCheckedException {
        this.repositoryServicesClient.registerListener(this.userId, listener);
    }

    public void disconnectFromEnterpriseTopic() throws ConnectorCheckedException {
        this.repositoryServicesClient.disconnectFromEnterpriseTopic();
    }

    public String getMetadataCollectionId() throws RepositoryErrorException {
        return this.repositoryServicesClient.getMetadataCollectionId(this.userId);
    }

    public TypeDefGallery getAllTypes() throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        return this.repositoryServicesClient.getAllTypes(this.userId);
    }

    public TypeDefGallery findTypesByName(String name) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        return this.repositoryServicesClient.findTypesByName(this.userId, name);
    }

    public List<TypeDef> findTypeDefsByCategory(TypeDefCategory category) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        return this.repositoryServicesClient.findTypeDefsByCategory(this.userId, category);
    }

    public List<AttributeTypeDef> findAttributeTypeDefsByCategory(AttributeTypeDefCategory category) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        return this.repositoryServicesClient.findAttributeTypeDefsByCategory(this.userId, category);
    }

    public List<TypeDef> findTypeDefsByProperty(TypeDefProperties matchCriteria) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        return this.repositoryServicesClient.findTypeDefsByProperty(this.userId, matchCriteria);
    }

    public List<TypeDef> findTypesByExternalID(String standard, String organization, String identifier) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        return this.repositoryServicesClient.findTypesByExternalID(this.userId, standard, organization, identifier);
    }

    public List<TypeDef> searchForTypeDefs(String searchCriteria) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        return this.repositoryServicesClient.searchForTypeDefs(this.userId, searchCriteria);
    }

    public TypeDef getTypeDefByGUID(String guid) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, UserNotAuthorizedException {
        return this.repositoryServicesClient.getTypeDefByGUID(this.userId, guid);
    }

    public AttributeTypeDef getAttributeTypeDefByGUID(String guid) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, UserNotAuthorizedException {
        return this.repositoryServicesClient.getAttributeTypeDefByGUID(this.userId, guid);
    }

    public TypeDef getTypeDefByName(String name) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, UserNotAuthorizedException {
        return this.repositoryServicesClient.getTypeDefByName(this.userId, name);
    }

    public AttributeTypeDef getAttributeTypeDefByName(String name) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, UserNotAuthorizedException {
        return this.repositoryServicesClient.getAttributeTypeDefByName(this.userId, name);
    }

    public EntityDetail isEntityKnown(String guid) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        return this.repositoryServicesClient.isEntityKnown(this.userId, guid);
    }

    public EntitySummary getEntitySummary(String guid) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, UserNotAuthorizedException {
        return this.repositoryServicesClient.getEntitySummary(this.userId, guid);
    }

    public EntityDetail getEntityDetail(String guid) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, EntityProxyOnlyException, UserNotAuthorizedException {
        return this.repositoryServicesClient.getEntityDetail(this.userId, guid);
    }

    public EntityDetail getEntityDetail(String guid, Date asOfTime) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, EntityProxyOnlyException, FunctionNotSupportedException, UserNotAuthorizedException {
        return this.repositoryServicesClient.getEntityDetail(this.userId, guid, asOfTime);
    }

    public List<EntityDetail> getEntityDetailHistory(String guid, Date fromTime, Date toTime, int startFromElement, int pageSize, HistorySequencingOrder sequencingOrder) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, EntityProxyOnlyException, FunctionNotSupportedException, UserNotAuthorizedException {
        return this.repositoryServicesClient.getEntityDetailHistory(this.userId, guid, fromTime, toTime, startFromElement, pageSize, sequencingOrder);
    }

    public List<Relationship> getRelationshipsForEntity(String entityGUID, String relationshipTypeGUID, int fromRelationshipElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, EntityNotKnownException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        return this.repositoryServicesClient.getRelationshipsForEntity(this.userId, entityGUID, relationshipTypeGUID, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
    }

    public List<EntityDetail> findEntities(String entityTypeGUID, List<String> entitySubtypeGUIDs, SearchProperties matchProperties, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, SearchClassifications matchClassifications, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        return this.repositoryServicesClient.findEntities(this.userId, entityTypeGUID, entitySubtypeGUIDs, matchProperties, fromEntityElement, limitResultsByStatus, matchClassifications, asOfTime, sequencingProperty, sequencingOrder, pageSize);
    }

    public List<EntityDetail> findEntitiesByProperty(String entityTypeGUID, InstanceProperties matchProperties, MatchCriteria matchCriteria, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, List<String> limitResultsByClassification, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        return this.repositoryServicesClient.findEntitiesByProperty(this.userId, entityTypeGUID, matchProperties, matchCriteria, fromEntityElement, limitResultsByStatus, limitResultsByClassification, asOfTime, sequencingProperty, sequencingOrder, pageSize);
    }

    public List<EntityDetail> findEntitiesByClassification(String entityTypeGUID, String classificationName, InstanceProperties matchClassificationProperties, MatchCriteria matchCriteria, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, ClassificationErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        return this.repositoryServicesClient.findEntitiesByClassification(this.userId, entityTypeGUID, classificationName, matchClassificationProperties, matchCriteria, fromEntityElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
    }

    public List<EntityDetail> findEntitiesByPropertyValue(String entityTypeGUID, String searchCriteria, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, List<String> limitResultsByClassification, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        return this.repositoryServicesClient.findEntitiesByPropertyValue(this.userId, entityTypeGUID, searchCriteria, fromEntityElement, limitResultsByStatus, limitResultsByClassification, asOfTime, sequencingProperty, sequencingOrder, pageSize);
    }

    public Relationship isRelationshipKnown(String guid) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        return this.repositoryServicesClient.isRelationshipKnown(this.userId, guid);
    }

    public Relationship getRelationship(String guid) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, UserNotAuthorizedException {
        return this.repositoryServicesClient.getRelationship(this.userId, guid);
    }

    public Relationship getRelationship(String guid, Date asOfTime) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        return this.repositoryServicesClient.getRelationship(this.userId, guid, asOfTime);
    }

    public List<Relationship> getRelationshipHistory(String guid, Date fromTime, Date toTime, int startFromElement, int pageSize, HistorySequencingOrder sequencingOrder) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        return this.repositoryServicesClient.getRelationshipHistory(this.userId, guid, fromTime, toTime, startFromElement, pageSize, sequencingOrder);
    }

    public List<Relationship> findRelationships(String relationshipTypeGUID, List<String> relationshipSubtypeGUIDs, SearchProperties matchProperties, int fromRelationshipElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        return this.repositoryServicesClient.findRelationships(this.userId, relationshipTypeGUID, relationshipSubtypeGUIDs, matchProperties, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
    }

    public List<Relationship> findRelationshipsByProperty(String relationshipTypeGUID, InstanceProperties matchProperties, MatchCriteria matchCriteria, int fromRelationshipElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        return this.repositoryServicesClient.findRelationshipsByProperty(this.userId, relationshipTypeGUID, matchProperties, matchCriteria, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
    }

    public List<Relationship> findRelationshipsByPropertyValue(String relationshipTypeGUID, String searchCriteria, int fromRelationshipElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        return this.repositoryServicesClient.findRelationshipsByPropertyValue(this.userId, relationshipTypeGUID, searchCriteria, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
    }

    public synchronized void recordCompletionStatus(CompletionStatus status, List<String> outputGuards, Map<String, String> newRequestParameters, List<NewActionTarget> newActionTargets, String completionMessage) throws PropertyServerException {
        String methodName = "recordCompletionStatus";
        this.completionStatus = status;
        HashMap<String, String> combinedRequestParameters = new HashMap<String, String>();
        if (this.requestParameters != null) {
            combinedRequestParameters.putAll(this.requestParameters);
        }
        if (newRequestParameters != null) {
            combinedRequestParameters.putAll(newRequestParameters);
        }
        try {
            this.repositoryServicesClient.disconnectFromEnterpriseTopic();
            this.repositoryGovernanceServiceHandler.recordCompletionStatus(status, outputGuards, combinedRequestParameters, newActionTargets, completionMessage);
        }
        catch (Exception error) {
            throw new PropertyServerException(RepositoryGovernanceErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(new String[]{this.repositoryGovernanceServiceName, error.getClass().getName(), "recordCompletionStatus", error.getMessage()}), ((Object)((Object)this)).getClass().getName(), "recordCompletionStatus", (Throwable)error);
        }
    }

    public synchronized CompletionStatus getCompletionStatus() {
        return this.completionStatus;
    }

    public String toString() {
        return "RepositoryGovernanceServiceContext{completionStatus=" + this.completionStatus + ", repositoryServicesClient=" + this.repositoryServicesClient + ", repositoryGovernanceServiceHandler=" + this.repositoryGovernanceServiceHandler + ", userId='" + this.userId + "', requestType='" + this.requestType + "', requestParameters=" + this.requestParameters + ", requestType='" + this.getRequestType() + "', requestParameters=" + this.getRequestParameters() + ", requestSourceElements=" + this.getRequestSourceElements() + ", actionTargetElements=" + this.getActionTargetElements() + "}";
    }
}

