/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.engineservices.repositorygovernance.server;

import org.odpi.openmetadata.adminservices.configuration.registration.EngineServiceDescription;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.properties.ConnectorReport;
import org.odpi.openmetadata.commonservices.ffdc.rest.ConnectorReportResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.engineservices.repositorygovernance.connector.RepositoryGovernanceServiceConnector;
import org.odpi.openmetadata.engineservices.repositorygovernance.server.RepositoryGovernanceInstanceHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.slf4j.LoggerFactory;

public class RepositoryGovernanceRESTServices {
    private static final RepositoryGovernanceInstanceHandler instanceHandler = new RepositoryGovernanceInstanceHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(RepositoryGovernanceRESTServices.class), instanceHandler.getServiceName());
    private final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public ConnectorReportResponse validateConnector(String serverName, String userId, String connectorProviderClassName) {
        String methodName = "validateConnector";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "validateConnector");
        ConnectorReportResponse response = new ConnectorReportResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "validateConnector");
            ConnectorReport connectorReport = instanceHandler.validateConnector(connectorProviderClassName, RepositoryGovernanceServiceConnector.class, EngineServiceDescription.REPOSITORY_GOVERNANCE_OMES.getEngineServiceFullName());
            if (connectorReport != null) {
                response.setConnectorReport(connectorReport);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "validateConnector", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

