/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.engineservices.repositorygovernance.admin;

import org.odpi.openmetadata.accessservices.governanceserver.client.GovernanceConfigurationClient;
import org.odpi.openmetadata.adminservices.configuration.properties.EngineServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.EngineServiceDescription;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.engineservices.repositorygovernance.ffdc.RepositoryGovernanceAuditCode;
import org.odpi.openmetadata.engineservices.repositorygovernance.ffdc.RepositoryGovernanceErrorCode;
import org.odpi.openmetadata.engineservices.repositorygovernance.server.RepositoryGovernanceInstance;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.governanceservers.enginehostservices.admin.EngineServiceAdmin;
import org.odpi.openmetadata.governanceservers.enginehostservices.enginemap.GovernanceEngineMap;

public class RepositoryGovernanceAdmin
extends EngineServiceAdmin {
    private RepositoryGovernanceInstance archiveManagerInstance = null;

    public void initialize(String localServerId, String localServerName, AuditLog auditLog, String localServerUserId, String localServerPassword, int maxPageSize, GovernanceConfigurationClient configurationClient, EngineServiceConfig engineServiceConfig, GovernanceEngineMap governanceEngineMap) throws OMAGConfigurationErrorException {
        String actionDescription = "initialize engine service";
        String methodName = "initialize";
        this.auditLog = auditLog;
        this.localServerName = localServerName;
        try {
            this.validateConfigDocument(engineServiceConfig);
            String partnerServiceRootURL = this.getPartnerServiceRootURL(engineServiceConfig);
            String partnerServiceServerName = this.getPartnerServiceServerName(engineServiceConfig);
            auditLog.logMessage("initialize engine service", RepositoryGovernanceAuditCode.ENGINE_SERVICE_INITIALIZING.getMessageDefinition(new String[]{localServerName, partnerServiceServerName, partnerServiceRootURL}));
            governanceEngineMap.setGovernanceEngineProperties(engineServiceConfig.getEngines(), partnerServiceServerName, partnerServiceRootURL);
            this.archiveManagerInstance = new RepositoryGovernanceInstance(localServerName, EngineServiceDescription.REPOSITORY_GOVERNANCE_OMES.getEngineServiceName(), auditLog, localServerUserId, maxPageSize, engineServiceConfig.getOMAGServerPlatformRootURL(), engineServiceConfig.getOMAGServerName());
        }
        catch (Exception error) {
            auditLog.logException("initialize engine service", RepositoryGovernanceAuditCode.SERVICE_INSTANCE_FAILURE.getMessageDefinition(new String[]{localServerName, error.getMessage()}), error.toString(), (Throwable)error);
            throw new OMAGConfigurationErrorException(RepositoryGovernanceErrorCode.SERVICE_INSTANCE_FAILURE.getMessageDefinition(new String[]{localServerName, error.getMessage()}), ((Object)((Object)this)).getClass().getName(), "initialize", (Throwable)error);
        }
    }

    public void shutdown() {
        String actionDescription = "shutdown";
        this.auditLog.logMessage("shutdown", RepositoryGovernanceAuditCode.SERVER_SHUTTING_DOWN.getMessageDefinition(new String[]{this.localServerName}));
        this.archiveManagerInstance.shutdown();
        this.auditLog.logMessage("shutdown", RepositoryGovernanceAuditCode.SERVER_SHUTDOWN.getMessageDefinition(new String[]{this.localServerName}));
    }
}

