/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.engineservices.repositorygovernance.handlers;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.governanceserver.client.GovernanceConfigurationClient;
import org.odpi.openmetadata.accessservices.governanceserver.client.GovernanceContextClient;
import org.odpi.openmetadata.adminservices.configuration.properties.EngineConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.EngineServiceDescription;
import org.odpi.openmetadata.engineservices.repositorygovernance.handlers.RepositoryGovernanceServiceContext;
import org.odpi.openmetadata.engineservices.repositorygovernance.handlers.RepositoryGovernanceServiceHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ActionTargetElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RequestSourceElement;
import org.odpi.openmetadata.governanceservers.enginehostservices.admin.GovernanceEngineHandler;
import org.odpi.openmetadata.governanceservers.enginehostservices.admin.GovernanceServiceCache;
import org.odpi.openmetadata.repositoryservices.clients.EnterpriseRepositoryServicesClient;

public class RepositoryGovernanceEngineHandler
extends GovernanceEngineHandler {
    private final EnterpriseRepositoryServicesClient repositoryGovernanceEngineClient;
    private static final String supportGovernanceEngineType = "RepositoryGovernanceEngine";

    public RepositoryGovernanceEngineHandler(EngineConfig engineConfig, String serverName, String serverUserId, GovernanceConfigurationClient configurationClient, GovernanceContextClient engineActionClient, EnterpriseRepositoryServicesClient repositoryGovernanceEngineClient, AuditLog auditLog, int maxPageSize) {
        super(engineConfig, serverName, serverUserId, EngineServiceDescription.REPOSITORY_GOVERNANCE_OMES.getEngineServiceFullName(), configurationClient, engineActionClient, auditLog, maxPageSize);
        this.repositoryGovernanceEngineClient = repositoryGovernanceEngineClient;
    }

    public void runGovernanceService(String engineActionGUID, String governanceRequestType, String requesterUserId, Date requestedStartDate, Map<String, String> requestParameters, List<RequestSourceElement> requestSourceElements, List<ActionTargetElement> actionTargetElements) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "runGovernanceService";
        super.validateGovernanceEngineInitialized(supportGovernanceEngineType, "runGovernanceService");
        GovernanceServiceCache governanceServiceCache = super.getServiceCache(governanceRequestType);
        if (governanceServiceCache != null && actionTargetElements != null && !actionTargetElements.isEmpty()) {
            RepositoryGovernanceServiceHandler repositoryGovernanceServiceHandler = this.getRepositoryGovernanceServiceHandler(governanceServiceCache.getGovernanceServiceName(), governanceServiceCache.getServiceRequestType(), governanceServiceCache.getRequestParameters(requestParameters), requesterUserId, requestSourceElements, actionTargetElements, engineActionGUID, requestedStartDate, governanceServiceCache);
            this.startServiceExecutionThread(engineActionGUID, repositoryGovernanceServiceHandler, governanceServiceCache.getGovernanceServiceName() + new Date());
        }
    }

    private RepositoryGovernanceServiceHandler getRepositoryGovernanceServiceHandler(String repositoryGovernanceServiceName, String repositoryGovernanceRequestType, Map<String, String> requestParameters, String requesterUserId, List<RequestSourceElement> requestSourceElements, List<ActionTargetElement> actionTargetElements, String engineActionGUID, Date requestedStartDate, GovernanceServiceCache governanceServiceCache) throws InvalidParameterException, PropertyServerException {
        RepositoryGovernanceServiceContext repositoryGovernanceContext = new RepositoryGovernanceServiceContext(this.engineUserId, repositoryGovernanceServiceName, repositoryGovernanceRequestType, requestParameters, requesterUserId, requestSourceElements, actionTargetElements, this.repositoryGovernanceEngineClient);
        RepositoryGovernanceServiceHandler repositoryGovernanceServiceHandler = new RepositoryGovernanceServiceHandler(this.governanceEngineProperties, this.governanceEngineGUID, this.serverUserId, engineActionGUID, this.engineActionClient, repositoryGovernanceRequestType, governanceServiceCache.getGovernanceServiceGUID(), governanceServiceCache.getGovernanceServiceName(), governanceServiceCache.getNextGovernanceService(), repositoryGovernanceContext, requestedStartDate, this.auditLog);
        repositoryGovernanceContext.setRepositoryGovernanceServiceHandler(repositoryGovernanceServiceHandler);
        return repositoryGovernanceServiceHandler;
    }
}

