/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.repositoryhandler;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandlerErrorCode;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class RepositoryErrorHandler {
    private String serviceName;
    private String serverName;
    private OMRSRepositoryHelper repositoryHelper;

    public RepositoryErrorHandler(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        this.repositoryHelper = repositoryHelper;
        this.serviceName = serviceName;
        this.serverName = serverName;
    }

    public void validateRepositoryConnector(OMRSRepositoryConnector repositoryConnector, String methodName) throws PropertyServerException {
        if (repositoryConnector == null) {
            RepositoryHandlerErrorCode errorCode = RepositoryHandlerErrorCode.OMRS_NOT_INITIALIZED;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(methodName);
            throw new PropertyServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        if (!repositoryConnector.isActive()) {
            RepositoryHandlerErrorCode errorCode = RepositoryHandlerErrorCode.OMRS_NOT_AVAILABLE;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(methodName);
            throw new PropertyServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        try {
            repositoryConnector.getMetadataCollection();
        }
        catch (Throwable error) {
            RepositoryHandlerErrorCode errorCode = RepositoryHandlerErrorCode.NO_METADATA_COLLECTION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(methodName);
            throw new PropertyServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    void validateProperties(String instanceGUID, String validatingPropertyName, String validatingProperty, InstanceProperties retrievedProperties, String methodName) throws InvalidParameterException {
        Map instancePropertyValueMap;
        InstancePropertyValue retrievedPropertyValue;
        if (validatingProperty != null && retrievedProperties != null && !validatingProperty.equals((retrievedPropertyValue = (InstancePropertyValue)(instancePropertyValueMap = retrievedProperties.getInstanceProperties()).get(validatingPropertyName)).valueAsString())) {
            RepositoryHandlerErrorCode errorCode = RepositoryHandlerErrorCode.INVALID_PROPERTY;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(validatingPropertyName, validatingProperty, methodName, retrievedPropertyValue.valueAsString(), instanceGUID);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), validatingPropertyName);
        }
    }

    void validateInstanceType(String userId, InstanceHeader instanceHeader, String guidParameterName, String expectedTypeName, String methodName) throws InvalidParameterException {
        InstanceType type;
        if (instanceHeader != null && (type = instanceHeader.getType()) != null && !this.repositoryHelper.isTypeOf(methodName, type.getTypeDefName(), expectedTypeName)) {
            this.handleWrongTypeForGUIDException(instanceHeader.getGUID(), methodName, type.getTypeDefName(), expectedTypeName);
        }
    }

    boolean isInstanceATypeOf(InstanceHeader instanceHeader, String entityTypeName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        InstanceType type;
        if (instanceHeader != null && (type = instanceHeader.getType()) != null) {
            return this.repositoryHelper.isTypeOf(methodName, type.getTypeDefName(), entityTypeName);
        }
        return false;
    }

    void handleWrongTypeForGUIDException(String guid, String methodName, String actualType, String expectedType) throws InvalidParameterException {
        String defaultGUIDParameterName = "guid";
        RepositoryHandlerErrorCode errorCode = RepositoryHandlerErrorCode.INSTANCE_WRONG_TYPE_FOR_GUID;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(methodName, guid, actualType, expectedType);
        throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), "guid");
    }

    void handleUnauthorizedUser(String userId, String methodName) throws UserNotAuthorizedException {
        RepositoryHandlerErrorCode errorCode = RepositoryHandlerErrorCode.USER_NOT_AUTHORIZED;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(userId, methodName, this.serviceName, this.serverName);
        throw new UserNotAuthorizedException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), userId);
    }

    public void handleUnsupportedProperty(Throwable error, String methodName, String propertyName) throws InvalidParameterException {
        RepositoryHandlerErrorCode errorCode = RepositoryHandlerErrorCode.INVALID_PROPERTY;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(propertyName, methodName, this.serviceName, this.serverName, error.getMessage());
        throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), error, propertyName);
    }

    public void handleRepositoryError(Throwable error, String methodName) throws PropertyServerException {
        RepositoryHandlerErrorCode errorCode = RepositoryHandlerErrorCode.PROPERTY_SERVER_ERROR;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(error.getMessage(), methodName, this.serviceName, this.serverName);
        throw new PropertyServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    public void handleUnknownEntity(Throwable error, String entityGUID, String entityTypeName, String methodName, String guidParameterName) throws InvalidParameterException {
        RepositoryHandlerErrorCode errorCode = RepositoryHandlerErrorCode.UNKNOWN_ENTITY;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(entityTypeName, entityGUID, methodName, this.serviceName, this.serverName, error.getMessage());
        throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), error, guidParameterName);
    }

    public void handleEntityProxy(Throwable error, String entityGUID, String entityTypeName, String methodName, String guidParameterName) throws InvalidParameterException {
        RepositoryHandlerErrorCode errorCode = RepositoryHandlerErrorCode.PROXY_ENTITY_FOUND;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(entityTypeName, entityGUID, this.serverName, error.getMessage());
        throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), error, guidParameterName);
    }

    public void handleAmbiguousRelationships(String entityGUID, String entityTypeName, String relationshipTypeName, List<Relationship> returnedRelationships, String methodName) throws PropertyServerException {
        ArrayList<String> relationshipGUIDs = new ArrayList<String>();
        if (returnedRelationships != null) {
            for (Relationship relationship : returnedRelationships) {
                if (relationship == null) continue;
                relationshipGUIDs.add(relationship.getGUID());
            }
        }
        RepositoryHandlerErrorCode errorCode = RepositoryHandlerErrorCode.MULTIPLE_RELATIONSHIPS_FOUND;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(relationshipTypeName, entityTypeName, entityGUID, ((Object)relationshipGUIDs).toString(), methodName, this.serverName);
        throw new PropertyServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    public void handleAmbiguousEntityName(String name, String nameParameterName, String entityTypeName, List<EntityDetail> returnedEntities, String methodName) throws PropertyServerException {
        ArrayList<String> entityGUIDs = new ArrayList<String>();
        if (returnedEntities != null) {
            for (EntityDetail entity : returnedEntities) {
                if (entity == null) continue;
                entityGUIDs.add(entity.getGUID());
            }
        }
        RepositoryHandlerErrorCode errorCode = RepositoryHandlerErrorCode.MULTIPLE_ENTITIES_FOUND;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(entityTypeName, name, ((Object)entityGUIDs).toString(), methodName, nameParameterName, this.serverName);
        throw new PropertyServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    public void handleNoRelationship(String entityGUID, String entityTypeName, String relationshipTypeName, String methodName) throws PropertyServerException {
        RepositoryHandlerErrorCode errorCode = RepositoryHandlerErrorCode.NO_RELATIONSHIPS_FOUND;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(relationshipTypeName, entityTypeName, entityGUID, methodName, this.serverName);
        throw new PropertyServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    public void handleNoEntity(String entityTypeGUID, String entityTypeName, InstanceProperties properties, String methodName) throws PropertyServerException {
        RepositoryHandlerErrorCode errorCode = RepositoryHandlerErrorCode.NULL_ENTITY_RETURNED;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(methodName, this.serverName, entityTypeName, entityTypeGUID, properties.toString());
        throw new PropertyServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    public void handleNoEntityForClassification(String entityGUID, String classificationTypeGUID, String classificationTypeName, InstanceProperties properties, String methodName) throws PropertyServerException {
        RepositoryHandlerErrorCode errorCode = RepositoryHandlerErrorCode.NULL_ENTITY_RETURNED_FOR_CLASSIFICATION;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(methodName, this.serverName, entityGUID, classificationTypeName, classificationTypeGUID, properties.toString());
        throw new PropertyServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }
}

