/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.repositoryhandler;

import java.text.MessageFormat;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum RepositoryHandlerErrorCode {
    INVALID_PROPERTY(400, "REPOSITORY-HANDLER-400-001 ", "An unsupported property named {0} was passed to the repository services by the {1} request for open metadata access service {2} on server {3}; error message was: {4}", "The system is unable to process the request.", "Correct the types and property names of the properties passed on the request."),
    USER_NOT_AUTHORIZED(400, "REPOSITORY-HANDLER-400-002 ", "User {0} is not authorized to issue the {1} request for open metadata access service {3} on server {4}", "The system is unable to process the request.", "Verify the access rights of the user."),
    PROPERTY_SERVER_ERROR(400, "REPOSITORY-HANDLER-400-003 ", "An unexpected error was returned by the property server during {1} request for open metadata access service {2} on server {3}; message was {0}", "The system is unable to process the request.", "Verify the sanity of the server.  This is probably a logic error.  If you can not work out what happened, ask the ODPi Egeria community for help."),
    INVALID_PROPERTY_VALUE(400, "REPOSITORY-HANDLER-400-004 ", "The property named {0} with value of {1} supplied on method {2} does not match the stored value of {3} for entity {4}", "The system is unable to process the request.", "Correct the values of the properties passed on the request and retry."),
    INSTANCE_WRONG_TYPE_FOR_GUID(404, "REPOSITORY-HANDLER-404-005 ", "The {0} method has retrieved a object for unique identifier (guid) {1} which is of type {2} rather than type {3}", "The service is not able to return the requested object.", "Check that the unique identifier is correct and the property server(s) supporting the service is/are running."),
    OMRS_NOT_INITIALIZED(404, "REPOSITORY-HANDLER-404-001 ", "The open metadata repository services are not initialized for the {0} operation", "The system is unable to connect to the open metadata property server.", "Check that the server where the Discovery Engine OMAS is running initialized correctly.  Correct any errors discovered and retry the request when the open metadata services are available."),
    OMRS_NOT_AVAILABLE(404, "REPOSITORY-HANDLER-404-002 ", "The open metadata repository services are not available for the {0} operation", "The system is unable to connect to the open metadata property server.", "Check that the server where the Discovery Engine OMAS is running initialized correctly.  Correct any errors discovered and retry the request when the open metadata services are available."),
    NO_METADATA_COLLECTION(404, "REPOSITORY-HANDLER-404-003 ", "The repository connector {0} is not returning a metadata collection object", "The system is unable to access any metadata.", "Check that the open metadata server URL is correct and the server is running.  Report the error to the system administrator."),
    PROXY_ENTITY_FOUND(404, "REPOSITORY-HANDLER-404-004 ", "Only an entity proxy for requested {0} object with unique identifier (guid) {1} is found in the open metadata server {2}, error message was: {3}", "The system is unable to populate the requested connection object.", "Check that the connection name and the OMAS Server URL are correct.  Retry the request when the connection is available in the OMAS Service"),
    MULTIPLE_RELATIONSHIPS_FOUND(404, "REPOSITORY-HANDLER-404-005 ", "Multiple {0} relationships are connected to the {1} entity with unique identifier {2}: the relationship identifiers are {3}; the calling method is {4} and the server is {5}", "The system is unable to process a request because multiple relationships have been discovered and it is unsure which relationship to follow.", "Investigate why multiple relationships exist.  Then retry the request once the issue is resolve."),
    UNKNOWN_ENTITY(404, "REPOSITORY-HANDLER-404-006 ", "The {0} with unique identifier {1} is not found for method {2} of access service {3} in open metadata server {4}, error message was: {5}", "The system is unable to update information associated with the asset because none of the connected open metadata repositories recognize the asset's unique identifier.", "The unique identifier of the asset is supplied by the caller.  Verify that the caller's logic is correct, and that there are no errors being reported by the open metadata repository. Once all errors have been resolved, retry the request."),
    NO_RELATIONSHIPS_FOUND(404, "REPOSITORY-HANDLER-404-007 ", "No {0} relationships are connected to the {1} entity with unique identifier {2}: the calling method is {3} and the server is {4}", "The system is unable to process a request because no relationships have been discovered and it is unable to retrieve all of the information it needs.", "Check that the unique identifier is correct and the property server(s) supporting the assets is/are running."),
    NULL_ENTITY_RETURNED(404, "REPOSITORY-HANDLER-404-008 ", "A null entity was returned to method {0} of server {1} during a request to create a new entity of type {2} (guid {3}) and properties of: {4}", "The system is unable to process a request .", "This may be a logic error or a configuration error.  Look for errors in the server's audit log and console to understand and correct the source of the error."),
    MULTIPLE_ENTITIES_FOUND(404, "REPOSITORY-HANDLER-404-009 ", "Multiple {0} entities where found with a name of {1}: the identifiers of the returned entities are {2}; the calling method is {3}, the name parameter is {4} and the server is {5}", "The system is unable to process a request because multiple relationships have been discovered and it is unsure which relationship to follow.", "Investigate why multiple relationships exist.  Then retry the request once the issue is resolve."),
    NULL_ENTITY_RETURNED_FOR_CLASSIFICATION(404, "REPOSITORY-HANDLER-404-008 ", "A null entity was returned to method {0} of server {1} during a request to add a classification of type {4} (guid {3}) to entity {2} with properties of: {5}", "The system is unable to process a request .", "This may be a logic error or a configuration error.  Look for errors in the server's audit log and console to understand and correct the source of the error.");

    private int httpErrorCode;
    private String errorMessageId;
    private String errorMessage;
    private String systemAction;
    private String userAction;
    private static final Logger log;

    private RepositoryHandlerErrorCode(int newHTTPErrorCode, String newErrorMessageId, String newErrorMessage, String newSystemAction, String newUserAction) {
        this.httpErrorCode = newHTTPErrorCode;
        this.errorMessageId = newErrorMessageId;
        this.errorMessage = newErrorMessage;
        this.systemAction = newSystemAction;
        this.userAction = newUserAction;
    }

    public int getHTTPErrorCode() {
        return this.httpErrorCode;
    }

    public String getErrorMessageId() {
        return this.errorMessageId;
    }

    public String getUnformattedErrorMessage() {
        return this.errorMessage;
    }

    public String getFormattedErrorMessage(String ... params) {
        log.debug(String.format("<== DiscoveryEngineErrorCode.getMessage(%s)", Arrays.toString(params)));
        MessageFormat mf = new MessageFormat(this.errorMessage);
        String result = mf.format(params);
        log.debug(String.format("==> DiscoveryEngineErrorCode.getMessage(%s): %s", Arrays.toString(params), result));
        return result;
    }

    public String getSystemAction() {
        return this.systemAction;
    }

    public String getUserAction() {
        return this.userAction;
    }

    public String toString() {
        return "RepositoryHandlerErrorCode{httpErrorCode=" + this.httpErrorCode + ", errorMessageId='" + this.errorMessageId + '\'' + ", errorMessage='" + this.errorMessage + '\'' + ", systemAction='" + this.systemAction + '\'' + ", userAction='" + this.userAction + '\'' + '}';
    }

    static {
        log = LoggerFactory.getLogger(RepositoryHandlerErrorCode.class);
    }
}

