/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.repositoryhandler;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryErrorHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandlerAuditCode;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityProxyOnlyException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryHandler {
    private RepositoryErrorHandler errorHandler;
    private OMRSMetadataCollection metadataCollection;
    private int maxPageSize;
    private OMRSAuditLog auditLog;
    private static final Logger log = LoggerFactory.getLogger(RepositoryHandler.class);

    public RepositoryHandler(OMRSAuditLog auditLog, RepositoryErrorHandler errorHandler, OMRSMetadataCollection metadataCollection, int maxPageSize) {
        this.auditLog = auditLog;
        this.errorHandler = errorHandler;
        this.metadataCollection = metadataCollection;
        this.maxPageSize = maxPageSize;
    }

    public EntitySummary validateEntityGUID(String userId, String guid, String entityTypeName, String methodName, String guidParameterName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        try {
            return this.metadataCollection.getEntitySummary(userId, guid);
        }
        catch (EntityNotKnownException error) {
            this.errorHandler.handleUnknownEntity(error, guid, entityTypeName, methodName, guidParameterName);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Throwable error) {
            this.errorHandler.handleRepositoryError(error, methodName);
        }
        return null;
    }

    public EntitySummary isEntityKnown(String userId, String guid, String entityTypeName, String methodName, String guidParameterName) throws UserNotAuthorizedException, PropertyServerException {
        try {
            EntitySummary entity = this.metadataCollection.getEntitySummary(userId, guid);
            this.errorHandler.validateInstanceType(userId, (InstanceHeader)entity, guidParameterName, entityTypeName, methodName);
            return entity;
        }
        catch (EntityNotKnownException error) {
            return null;
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Throwable error) {
            this.errorHandler.handleRepositoryError(error, methodName);
        }
        return null;
    }

    public String createEntity(String userId, String entityTypeGUID, String entityTypeName, InstanceProperties properties, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        return this.createEntity(userId, entityTypeGUID, entityTypeName, properties, null, InstanceStatus.ACTIVE, methodName);
    }

    public String createEntity(String userId, String entityTypeGUID, String entityTypeName, InstanceProperties properties, List<Classification> initialClassifications, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        return this.createEntity(userId, entityTypeGUID, entityTypeName, properties, initialClassifications, InstanceStatus.ACTIVE, methodName);
    }

    public String createEntity(String userId, String entityTypeGUID, String entityTypeName, InstanceProperties properties, InstanceStatus instanceStatus, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        return this.createEntity(userId, entityTypeGUID, entityTypeName, properties, null, instanceStatus, methodName);
    }

    public String createEntity(String userId, String entityTypeGUID, String entityTypeName, InstanceProperties properties, List<Classification> initialClassifications, InstanceStatus instanceStatus, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        try {
            EntityDetail newEntity = this.metadataCollection.addEntity(userId, entityTypeGUID, properties, initialClassifications, instanceStatus);
            if (newEntity != null) {
                return newEntity.getGUID();
            }
            this.errorHandler.handleNoEntity(entityTypeGUID, entityTypeName, properties, methodName);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Throwable error) {
            this.errorHandler.handleRepositoryError(error, methodName);
        }
        return null;
    }

    public String createExternalEntity(String userId, String entityTypeGUID, String entityTypeName, String externalSourceGUID, String externalSourceName, InstanceProperties properties, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        return this.createExternalEntity(userId, entityTypeGUID, entityTypeName, externalSourceGUID, externalSourceName, properties, null, InstanceStatus.ACTIVE, methodName);
    }

    public String createExternalEntity(String userId, String entityTypeGUID, String entityTypeName, String externalSourceGUID, String externalSourceName, InstanceProperties properties, List<Classification> initialClassifications, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        return this.createExternalEntity(userId, entityTypeGUID, entityTypeName, externalSourceGUID, externalSourceName, properties, initialClassifications, InstanceStatus.ACTIVE, methodName);
    }

    public String createExternalEntity(String userId, String entityTypeGUID, String entityTypeName, String externalSourceGUID, String externalSourceName, InstanceProperties properties, InstanceStatus instanceStatus, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        return this.createExternalEntity(userId, entityTypeGUID, entityTypeName, externalSourceGUID, externalSourceName, properties, null, instanceStatus, methodName);
    }

    public String createExternalEntity(String userId, String entityTypeGUID, String entityTypeName, String externalSourceGUID, String externalSourceName, InstanceProperties properties, List<Classification> initialClassifications, InstanceStatus instanceStatus, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        try {
            EntityDetail newEntity = this.metadataCollection.addExternalEntity(userId, entityTypeGUID, externalSourceGUID, externalSourceName, properties, initialClassifications, instanceStatus);
            if (newEntity != null) {
                return newEntity.getGUID();
            }
            this.errorHandler.handleNoEntity(entityTypeGUID, entityTypeName, properties, methodName);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Throwable error) {
            this.errorHandler.handleRepositoryError(error, methodName);
        }
        return null;
    }

    public String addUniqueAttachedEntityToAnchor(String userId, String anchorEntityGUID, String anchorEntityTypeName, String anchorRelationshipTypeGUID, String anchorRelationshipTypeName, InstanceProperties anchorRelationshipProperties, String attachedEntityTypeGUID, String attachedEntityTypeName, InstanceProperties attachedEntityProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "anchorEntityGUID";
        this.validateEntityGUID(userId, anchorEntityGUID, anchorEntityTypeName, methodName, "anchorEntityGUID");
        String attachedEntityGUID = this.createEntity(userId, attachedEntityTypeGUID, attachedEntityTypeName, attachedEntityProperties, methodName);
        if (attachedEntityGUID != null) {
            this.createRelationship(userId, anchorRelationshipTypeGUID, anchorEntityGUID, attachedEntityGUID, anchorRelationshipProperties, methodName);
        }
        return attachedEntityGUID;
    }

    public void updateEntity(String userId, String entityGUID, String entityTypeGUID, String entityTypeName, InstanceProperties properties, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        try {
            EntityDetail newEntity = this.metadataCollection.updateEntityProperties(userId, entityGUID, properties);
            if (newEntity == null) {
                this.errorHandler.handleNoEntity(entityTypeGUID, entityTypeName, properties, methodName);
            }
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Throwable error) {
            this.errorHandler.handleRepositoryError(error, methodName);
        }
    }

    public void updateEntityStatus(String userId, String entityGUID, String entityTypeGUID, String entityTypeName, InstanceStatus instanceStatus, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        try {
            EntityDetail newEntity = this.metadataCollection.updateEntityStatus(userId, entityGUID, instanceStatus);
            if (newEntity == null) {
                this.errorHandler.handleNoEntity(entityTypeGUID, entityTypeName, null, methodName);
            }
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Throwable error) {
            this.errorHandler.handleRepositoryError(error, methodName);
        }
    }

    public void classifyEntity(String userId, String entityGUID, String classificationTypeGUID, String classificationTypeName, InstanceProperties properties, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        try {
            EntityDetail newEntity = this.metadataCollection.classifyEntity(userId, entityGUID, classificationTypeName, properties);
            if (newEntity == null) {
                this.errorHandler.handleNoEntityForClassification(entityGUID, classificationTypeGUID, classificationTypeName, properties, methodName);
            }
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Throwable error) {
            this.errorHandler.handleRepositoryError(error, methodName);
        }
    }

    public void reclassifyEntity(String userId, String entityGUID, String classificationTypeGUID, String classificationTypeName, InstanceProperties properties, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        try {
            EntityDetail newEntity = this.metadataCollection.updateEntityClassification(userId, entityGUID, classificationTypeName, properties);
            if (newEntity == null) {
                this.errorHandler.handleNoEntityForClassification(entityGUID, classificationTypeGUID, classificationTypeName, properties, methodName);
            }
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Throwable error) {
            this.errorHandler.handleRepositoryError(error, methodName);
        }
    }

    public void declassifyEntity(String userId, String entityGUID, String classificationTypeGUID, String classificationTypeName, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        try {
            EntityDetail newEntity = this.metadataCollection.declassifyEntity(userId, entityGUID, classificationTypeName);
            if (newEntity == null) {
                this.errorHandler.handleNoEntityForClassification(entityGUID, classificationTypeGUID, classificationTypeName, null, methodName);
            }
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Throwable error) {
            this.errorHandler.handleRepositoryError(error, methodName);
        }
    }

    public void removeEntity(String userId, String obsoleteEntityGUID, String entityTypeGUID, String entityTypeName, String validatingPropertyName, String validatingProperty, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "obsoleteEntityGUID";
        try {
            EntityDetail obsoleteEntity = this.getEntityByGUID(userId, obsoleteEntityGUID, "obsoleteEntityGUID", entityTypeName, methodName);
            if (obsoleteEntity != null) {
                this.errorHandler.validateProperties(obsoleteEntityGUID, validatingPropertyName, validatingProperty, obsoleteEntity.getProperties(), methodName);
                this.removeIsolatedEntity(userId, obsoleteEntityGUID, entityTypeGUID, entityTypeName, methodName);
            }
        }
        catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException error) {
            throw error;
        }
        catch (Throwable error) {
            this.errorHandler.handleRepositoryError(error, methodName);
        }
    }

    public void removeEntityOnLastUse(String userId, String obsoleteEntityGUID, String guidParameterName, String entityTypeGUID, String entityTypeName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        try {
            List relationships = this.metadataCollection.getRelationshipsForEntity(userId, obsoleteEntityGUID, null, 0, null, null, null, null, 5);
            if (relationships == null || relationships.isEmpty()) {
                this.removeIsolatedEntity(userId, obsoleteEntityGUID, entityTypeGUID, entityTypeName, methodName);
            }
        }
        catch (EntityNotKnownException error) {
            this.errorHandler.handleUnknownEntity(error, obsoleteEntityGUID, entityTypeName, methodName, guidParameterName);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (FunctionNotSupportedException error) {
            this.purgeEntity(userId, entityTypeGUID, entityTypeName, obsoleteEntityGUID, methodName);
        }
        catch (Throwable error) {
            this.errorHandler.handleRepositoryError(error, methodName);
        }
    }

    public void removeIsolatedEntity(String userId, String obsoleteEntityGUID, String entityTypeGUID, String entityTypeName, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        try {
            this.metadataCollection.deleteEntity(userId, entityTypeGUID, entityTypeName, obsoleteEntityGUID);
        }
        catch (FunctionNotSupportedException error) {
            this.purgeEntity(userId, obsoleteEntityGUID, entityTypeGUID, entityTypeName, methodName);
        }
        catch (Throwable error) {
            this.errorHandler.handleRepositoryError(error, methodName);
        }
    }

    private void purgeEntity(String userId, String obsoleteEntityGUID, String entityTypeGUID, String entityTypeName, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        try {
            this.metadataCollection.purgeEntity(userId, entityTypeGUID, entityTypeName, obsoleteEntityGUID);
            RepositoryHandlerAuditCode auditCode = RepositoryHandlerAuditCode.ENTITY_PURGED;
            this.auditLog.logRecord(methodName, auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(obsoleteEntityGUID, entityTypeName, entityTypeGUID, methodName, this.metadataCollection.getMetadataCollectionId(userId)), null, auditCode.getSystemAction(), auditCode.getUserAction());
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Throwable error) {
            this.errorHandler.handleRepositoryError(error, methodName);
        }
    }

    public void removeUniqueEntityTypeFromAnchor(String userId, String anchorEntityGUID, String anchorEntityTypeName, String anchorRelationshipTypeGUID, String anchorRelationshipTypeName, String attachedEntityTypeGUID, String attachedEntityTypeName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        Relationship relationship = this.getUniqueRelationshipByType(userId, anchorEntityGUID, anchorEntityTypeName, anchorRelationshipTypeGUID, anchorRelationshipTypeName, methodName);
        EntityDetail entity = this.getEntityForRelationshipType(userId, anchorEntityGUID, anchorEntityTypeName, anchorRelationshipTypeGUID, anchorRelationshipTypeName, methodName);
        if (relationship != null) {
            this.removeRelationship(userId, anchorRelationshipTypeGUID, anchorRelationshipTypeName, relationship.getGUID(), methodName);
        }
        if (entity != null) {
            String attachedEntityGUID = entity.getGUID();
            try {
                this.metadataCollection.deleteEntity(userId, attachedEntityTypeGUID, attachedEntityTypeName, attachedEntityGUID);
            }
            catch (EntityNotKnownException error) {
                String guidParameterName = "attachedEntityGUID";
                this.errorHandler.handleUnknownEntity(error, anchorEntityGUID, attachedEntityTypeName, methodName, "attachedEntityGUID");
            }
            catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
                this.errorHandler.handleUnauthorizedUser(userId, methodName);
            }
            catch (FunctionNotSupportedException error) {
                this.purgeEntity(userId, attachedEntityTypeGUID, attachedEntityTypeGUID, attachedEntityGUID, methodName);
            }
            catch (Throwable error) {
                this.errorHandler.handleRepositoryError(error, methodName);
            }
        }
    }

    public List<EntityDetail> getEntitiesForType(String userId, String entityTypeGUID, String entityTypeName, int startingFrom, int pageSize, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        try {
            List results = this.metadataCollection.findEntitiesByProperty(userId, entityTypeGUID, null, null, startingFrom, null, null, null, null, null, pageSize);
            if (results == null) {
                return null;
            }
            if (results.isEmpty()) {
                return null;
            }
            for (EntityDetail entity : results) {
                if (entity == null) continue;
                this.errorHandler.validateInstanceType(userId, (InstanceHeader)entity, "<null>", entityTypeName, methodName);
            }
            return results;
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Throwable error) {
            this.errorHandler.handleRepositoryError(error, methodName);
        }
        return null;
    }

    public List<EntityDetail> getEntitiesForRelationshipType(String userId, String anchorEntityGUID, String anchorEntityTypeName, String relationshipTypeGUID, String relationshipTypeName, int startingFrom, int pageSize, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        ArrayList<EntityDetail> results = new ArrayList<EntityDetail>();
        try {
            List relationships = this.metadataCollection.getRelationshipsForEntity(userId, anchorEntityGUID, relationshipTypeGUID, startingFrom, null, null, null, null, pageSize);
            if (relationships != null) {
                for (Relationship relationship : relationships) {
                    EntityProxy requiredEnd = relationship.getEntityOneProxy();
                    if (anchorEntityGUID.equals(requiredEnd.getGUID())) {
                        requiredEnd = relationship.getEntityTwoProxy();
                    }
                    results.add(this.metadataCollection.getEntityDetail(userId, requiredEnd.getGUID()));
                }
            } else if (log.isDebugEnabled()) {
                log.debug("No relationships of type " + relationshipTypeName + " found for " + anchorEntityTypeName + " entity " + anchorEntityGUID);
            }
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Throwable error) {
            this.errorHandler.handleRepositoryError(error, methodName);
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    public List<EntityDetail> getEntitiesForRelationshipEnd(String userId, String anchorEntityGUID, String anchorEntityTypeName, boolean anchorAtEnd1, String relationshipTypeGUID, String relationshipTypeName, int startingFrom, int pageSize, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        ArrayList<EntityDetail> results = new ArrayList<EntityDetail>();
        try {
            List relationships = this.metadataCollection.getRelationshipsForEntity(userId, anchorEntityGUID, relationshipTypeGUID, startingFrom, null, null, null, null, pageSize);
            if (relationships != null) {
                for (Relationship relationship : relationships) {
                    EntityProxy anchorEndProxy = relationship.getEntityOneProxy();
                    EntityProxy requiredEndProxy = relationship.getEntityTwoProxy();
                    if (!anchorAtEnd1) {
                        anchorEndProxy = relationship.getEntityTwoProxy();
                        requiredEndProxy = relationship.getEntityOneProxy();
                    }
                    if (!anchorEntityGUID.equals(anchorEndProxy.getGUID())) continue;
                    results.add(this.metadataCollection.getEntityDetail(userId, requiredEndProxy.getGUID()));
                }
            } else if (log.isDebugEnabled()) {
                log.debug("No relationships of type " + relationshipTypeName + " found for " + anchorEntityTypeName + " entity " + anchorEntityGUID);
            }
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Throwable error) {
            this.errorHandler.handleRepositoryError(error, methodName);
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    public EntityDetail getAttachedEntityFromUser(String userId, String anchorEntityGUID, String anchorEntityTypeName, String relationshipTypeGUID, String relationshipTypeName, String attachedEntityTypeGUID, String attachedEntityTypeName, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        try {
            boolean moreResultsAvailable = true;
            int startNextQueryFrom = 0;
            while (moreResultsAvailable) {
                List<EntityDetail> retrievedEntities = this.getEntitiesForRelationshipType(userId, anchorEntityGUID, anchorEntityTypeName, relationshipTypeGUID, relationshipTypeName, startNextQueryFrom, this.maxPageSize, methodName);
                if (retrievedEntities != null) {
                    moreResultsAvailable = retrievedEntities.size() == this.maxPageSize;
                    startNextQueryFrom += this.maxPageSize;
                    for (EntityDetail entity : retrievedEntities) {
                        if (entity == null || !userId.equals(entity.getCreatedBy()) && !userId.equals(entity.getUpdatedBy()) && (entity.getMaintainedBy() == null || !entity.getMaintainedBy().contains(userId))) continue;
                        return entity;
                    }
                    continue;
                }
                moreResultsAvailable = false;
                if (!log.isDebugEnabled()) continue;
                log.debug("No entities of type " + attachedEntityTypeName + " found for " + anchorEntityTypeName + " entity " + anchorEntityGUID);
            }
        }
        catch (Throwable error) {
            this.errorHandler.handleRepositoryError(error, methodName);
        }
        return null;
    }

    public List<EntityDetail> getAttachedEntitiesFromUser(String userId, String anchorEntityGUID, String anchorEntityTypeName, String relationshipTypeGUID, String relationshipTypeName, String attachedEntityTypeGUID, String attachedEntityTypeName, int startingFrom, int pageSize, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        ArrayList<EntityDetail> results = new ArrayList<EntityDetail>();
        try {
            boolean moreResultsAvailable = true;
            int startNextQueryFrom = startingFrom;
            while (moreResultsAvailable && results.size() < pageSize) {
                List<EntityDetail> retrievedEntities = this.getEntitiesForRelationshipType(userId, anchorEntityGUID, anchorEntityTypeName, relationshipTypeGUID, relationshipTypeName, startNextQueryFrom, pageSize, methodName);
                if (retrievedEntities != null) {
                    moreResultsAvailable = retrievedEntities.size() == pageSize;
                    startNextQueryFrom += pageSize;
                    for (EntityDetail entity : retrievedEntities) {
                        if (entity == null || !userId.equals(entity.getCreatedBy()) && !userId.equals(entity.getUpdatedBy()) && (entity.getMaintainedBy() == null || !entity.getMaintainedBy().contains(userId))) continue;
                        results.add(entity);
                    }
                    continue;
                }
                moreResultsAvailable = false;
                if (!log.isDebugEnabled()) continue;
                log.debug("No entities of type " + attachedEntityTypeName + " found for " + anchorEntityTypeName + " entity " + anchorEntityGUID);
            }
        }
        catch (Throwable error) {
            this.errorHandler.handleRepositoryError(error, methodName);
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    public List<EntityProxy> getRelatedEntityProxies(String userId, String anchorEntityGUID, String anchorEntityTypeName, String relationshipTypeGUID, String relationshipTypeName, int startingFrom, int pageSize, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        List<Relationship> relationships = this.getRelationshipsByType(userId, anchorEntityGUID, anchorEntityTypeName, relationshipTypeGUID, relationshipTypeName, startingFrom, pageSize, methodName);
        if (relationships != null) {
            ArrayList<EntityProxy> entityProxies = new ArrayList<EntityProxy>();
            for (Relationship relationship : relationships) {
                EntityProxy relatedEntityProxy;
                if (relationship == null || (relatedEntityProxy = this.getOtherEnd(anchorEntityGUID, relationship)) == null) continue;
                entityProxies.add(relatedEntityProxy);
            }
            if (entityProxies.isEmpty()) {
                return null;
            }
            return entityProxies;
        }
        return null;
    }

    public EntityProxy getOtherEnd(String anchorEntityGUID, Relationship relationship) {
        if (relationship != null) {
            EntityProxy entityProxy = relationship.getEntityOneProxy();
            if (entityProxy != null && anchorEntityGUID.equals(entityProxy.getGUID())) {
                entityProxy = relationship.getEntityTwoProxy();
            }
            return entityProxy;
        }
        return null;
    }

    public EntityDetail getEntityForRelationship(String userId, EntityProxy requiredEnd, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        try {
            return this.metadataCollection.getEntityDetail(userId, requiredEnd.getGUID());
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Throwable error) {
            this.errorHandler.handleRepositoryError(error, methodName);
        }
        return null;
    }

    public EntityDetail getEntityForRelationshipType(String userId, String anchorEntityGUID, String anchorEntityTypeName, String relationshipTypeGUID, String relationshipTypeName, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        try {
            List relationships = this.metadataCollection.getRelationshipsForEntity(userId, anchorEntityGUID, relationshipTypeGUID, 0, null, null, null, null, 100);
            if (relationships != null) {
                if (relationships.size() == 1) {
                    Relationship relationship = (Relationship)relationships.get(0);
                    EntityProxy requiredEnd = relationship.getEntityOneProxy();
                    if (anchorEntityGUID.equals(requiredEnd.getGUID())) {
                        requiredEnd = relationship.getEntityTwoProxy();
                    }
                    return this.metadataCollection.getEntityDetail(userId, requiredEnd.getGUID());
                }
                if (relationships.size() > 1) {
                    this.errorHandler.handleAmbiguousRelationships(anchorEntityGUID, anchorEntityTypeName, relationshipTypeName, relationships, methodName);
                }
            }
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Throwable error) {
            this.errorHandler.handleRepositoryError(error, methodName);
        }
        return null;
    }

    public EntityDetail getEntityByGUID(String userId, String guid, String guidParameterName, String entityTypeName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        try {
            EntityDetail entity = this.metadataCollection.getEntityDetail(userId, guid);
            this.errorHandler.validateInstanceType(userId, (InstanceHeader)entity, guidParameterName, entityTypeName, methodName);
            return entity;
        }
        catch (EntityNotKnownException error) {
            this.errorHandler.handleUnknownEntity(error, guid, entityTypeName, methodName, guidParameterName);
        }
        catch (EntityProxyOnlyException error) {
            this.errorHandler.handleEntityProxy(error, guid, entityTypeName, methodName, guidParameterName);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Throwable error) {
            this.errorHandler.handleRepositoryError(error, methodName);
        }
        return null;
    }

    public boolean isEntityATypeOf(String userId, String guid, String guidParameterName, String entityTypeName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        try {
            EntityDetail entity = this.metadataCollection.getEntityDetail(userId, guid);
            return this.errorHandler.isInstanceATypeOf((InstanceHeader)entity, entityTypeName, methodName);
        }
        catch (EntityNotKnownException error) {
            this.errorHandler.handleUnknownEntity(error, guid, entityTypeName, methodName, guidParameterName);
        }
        catch (EntityProxyOnlyException error) {
            this.errorHandler.handleEntityProxy(error, guid, entityTypeName, methodName, guidParameterName);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Throwable error) {
            this.errorHandler.handleRepositoryError(error, methodName);
        }
        return false;
    }

    public List<EntityDetail> getEntityByName(String userId, InstanceProperties nameProperties, String entityTypeGUID, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        try {
            return this.metadataCollection.findEntitiesByProperty(userId, entityTypeGUID, nameProperties, MatchCriteria.ANY, 0, null, null, null, null, null, 2);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Throwable error) {
            this.errorHandler.handleRepositoryError(error, methodName);
        }
        return null;
    }

    public List<EntityDetail> getEntitiesByName(String userId, InstanceProperties nameProperties, String entityTypeGUID, int startingFrom, int pageSize, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        try {
            return this.metadataCollection.findEntitiesByProperty(userId, entityTypeGUID, nameProperties, MatchCriteria.ANY, startingFrom, null, null, null, null, null, pageSize);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Throwable error) {
            this.errorHandler.handleRepositoryError(error, methodName);
        }
        return null;
    }

    public List<EntityDetail> getEntitiesByAllProperties(String userId, InstanceProperties properties, String entityTypeGUID, int startingFrom, int pageSize, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        try {
            return this.metadataCollection.findEntitiesByProperty(userId, entityTypeGUID, properties, MatchCriteria.ALL, startingFrom, null, null, null, null, null, pageSize);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Throwable error) {
            this.errorHandler.handleRepositoryError(error, methodName);
        }
        return null;
    }

    public EntityDetail getUniqueEntityByName(String userId, String nameValue, String nameParameterName, InstanceProperties nameProperties, String entityTypeGUID, String entityTypeName, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        try {
            List returnedEntities = this.metadataCollection.findEntitiesByProperty(userId, entityTypeGUID, nameProperties, MatchCriteria.ANY, 0, null, null, null, null, null, 2);
            if (returnedEntities == null || returnedEntities.isEmpty()) {
                return null;
            }
            if (returnedEntities.size() == 1) {
                return (EntityDetail)returnedEntities.get(0);
            }
            this.errorHandler.handleAmbiguousEntityName(nameValue, nameParameterName, entityTypeName, returnedEntities, methodName);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Throwable error) {
            this.errorHandler.handleRepositoryError(error, methodName);
        }
        return null;
    }

    public List<EntityDetail> getEntitiesByType(String userId, String entityTypeGUID, int startingFrom, int pageSize, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        try {
            return this.metadataCollection.findEntitiesByProperty(userId, entityTypeGUID, null, null, startingFrom, null, null, null, null, null, pageSize);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Throwable error) {
            this.errorHandler.handleRepositoryError(error, methodName);
        }
        return null;
    }

    public List<Relationship> getRelationshipsByType(String userId, String anchorEntityGUID, String anchorEntityTypeName, String relationshipTypeGUID, String relationshipTypeName, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        return this.getRelationshipsByType(userId, anchorEntityGUID, anchorEntityTypeName, relationshipTypeGUID, relationshipTypeName, 0, this.maxPageSize, methodName);
    }

    public List<Relationship> getRelationshipsByType(String userId, String anchorEntityGUID, String anchorEntityTypeName, String relationshipTypeGUID, String relationshipTypeName, int startingFrom, int pageSize, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        try {
            List relationships = this.metadataCollection.getRelationshipsForEntity(userId, anchorEntityGUID, relationshipTypeGUID, startingFrom, null, null, null, null, pageSize);
            if (relationships == null || relationships.isEmpty()) {
                if (log.isDebugEnabled()) {
                    log.debug("No relationships of type " + relationshipTypeName + " found for " + anchorEntityTypeName + " entity " + anchorEntityGUID);
                }
                return null;
            }
            return relationships;
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Throwable error) {
            this.errorHandler.handleRepositoryError(error, methodName);
        }
        return null;
    }

    public List<Relationship> getRequiredRelationshipsByType(String userId, String anchorEntityGUID, String anchorEntityTypeName, String relationshipTypeGUID, String relationshipTypeName, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        try {
            List relationships = this.metadataCollection.getRelationshipsForEntity(userId, anchorEntityGUID, relationshipTypeGUID, 0, null, null, null, null, 100);
            if (relationships == null || relationships.isEmpty()) {
                this.errorHandler.handleNoRelationship(anchorEntityGUID, anchorEntityTypeName, relationshipTypeName, methodName);
            }
            return relationships;
        }
        catch (PropertyServerException error) {
            throw error;
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Throwable error) {
            this.errorHandler.handleRepositoryError(error, methodName);
        }
        return null;
    }

    public int countAttachedRelationshipsByType(String userId, String anchorEntityGUID, String anchorEntityTypeName, String relationshipTypeGUID, String relationshipTypeName, String methodName) throws PropertyServerException, UserNotAuthorizedException {
        List<Relationship> relationships = this.getRelationshipsByType(userId, anchorEntityGUID, anchorEntityTypeName, relationshipTypeGUID, relationshipTypeName, methodName);
        int count = 0;
        if (relationships != null) {
            for (Relationship relationship : relationships) {
                if (relationship == null) continue;
                ++count;
            }
        }
        return count;
    }

    public Relationship getRelationshipBetweenEntities(String userId, String entity1GUID, String entity1TypeName, String entity2GUID, String relationshipTypeGUID, String relationshipTypeName, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        List<Relationship> entity1Relationships = this.getRelationshipsByType(userId, entity1GUID, entity1TypeName, relationshipTypeGUID, relationshipTypeName, methodName);
        if (entity1Relationships != null) {
            for (Relationship relationship : entity1Relationships) {
                EntityProxy entity2Proxy;
                if (relationship == null || (entity2Proxy = relationship.getEntityTwoProxy()) == null || !entity2GUID.equals(entity2Proxy.getGUID())) continue;
                return relationship;
            }
        }
        return null;
    }

    public List<Relationship> getPagedRelationshipsByType(String userId, String anchorEntityGUID, String anchorEntityTypeName, String relationshipTypeGUID, String relationshipTypeName, int startingFrom, int maximumResults, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        try {
            List relationships = this.metadataCollection.getRelationshipsForEntity(userId, anchorEntityGUID, relationshipTypeGUID, startingFrom, null, null, null, null, maximumResults);
            if (relationships == null || relationships.isEmpty()) {
                this.errorHandler.handleNoRelationship(anchorEntityGUID, anchorEntityTypeName, relationshipTypeName, methodName);
            }
            return relationships;
        }
        catch (PropertyServerException error) {
            throw error;
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Throwable error) {
            this.errorHandler.handleRepositoryError(error, methodName);
        }
        return null;
    }

    public Relationship getUniqueRelationshipByType(String userId, String anchorEntityGUID, String anchorEntityTypeName, String relationshipTypeGUID, String relationshipTypeName, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        try {
            List<Relationship> relationships = this.getRelationshipsByType(userId, anchorEntityGUID, anchorEntityTypeName, relationshipTypeGUID, relationshipTypeName, methodName);
            if (relationships != null) {
                if (relationships.size() == 1) {
                    return relationships.get(0);
                }
                if (relationships.size() > 1) {
                    this.errorHandler.handleAmbiguousRelationships(anchorEntityGUID, anchorEntityTypeName, relationshipTypeName, relationships, methodName);
                }
            }
        }
        catch (PropertyServerException | UserNotAuthorizedException error) {
            throw error;
        }
        catch (Throwable error) {
            this.errorHandler.handleRepositoryError(error, methodName);
        }
        return null;
    }

    public void createRelationship(String userId, String relationshipTypeGUID, String end1GUID, String end2GUID, InstanceProperties relationshipProperties, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        try {
            this.metadataCollection.addRelationship(userId, relationshipTypeGUID, relationshipProperties, end1GUID, end2GUID, InstanceStatus.ACTIVE);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Throwable error) {
            this.errorHandler.handleRepositoryError(error, methodName);
        }
    }

    public void ensureRelationship(String userId, String end1TypeName, String end1GUID, String end2GUID, String relationshipTypeGUID, String relationshipTypeName, InstanceProperties relationshipProperties, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        Relationship relationship = this.getRelationshipBetweenEntities(userId, end1GUID, end1TypeName, end2GUID, relationshipTypeGUID, relationshipTypeName, methodName);
        if (relationship == null) {
            this.createRelationship(userId, relationshipTypeGUID, end1GUID, end2GUID, relationshipProperties, methodName);
        } else if (relationshipProperties != null || relationship.getProperties() != null) {
            this.updateRelationshipProperties(userId, relationship.getGUID(), relationshipProperties, methodName);
        }
    }

    public void createExternalRelationship(String userId, String relationshipTypeGUID, String externalSourceGUID, String externalSourceName, String end1GUID, String end2GUID, InstanceProperties relationshipProperties, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        try {
            this.metadataCollection.addExternalRelationship(userId, relationshipTypeGUID, externalSourceGUID, externalSourceName, relationshipProperties, end1GUID, end2GUID, InstanceStatus.ACTIVE);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Throwable error) {
            this.errorHandler.handleRepositoryError(error, methodName);
        }
    }

    public void removeRelationship(String userId, String relationshipTypeGUID, String relationshipTypeName, String relationshipGUID, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        try {
            this.metadataCollection.deleteRelationship(userId, relationshipTypeGUID, relationshipTypeName, relationshipGUID);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (FunctionNotSupportedException error) {
            this.purgeRelationship(userId, relationshipTypeGUID, relationshipTypeName, relationshipGUID, methodName);
        }
        catch (Throwable error) {
            this.errorHandler.handleRepositoryError(error, methodName);
        }
    }

    public void purgeRelationship(String userId, String relationshipTypeGUID, String relationshipTypeName, String relationshipGUID, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        try {
            this.metadataCollection.purgeRelationship(userId, relationshipTypeGUID, relationshipTypeName, relationshipGUID);
            RepositoryHandlerAuditCode auditCode = RepositoryHandlerAuditCode.RELATIONSHIP_PURGED;
            this.auditLog.logRecord(methodName, auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(relationshipGUID, relationshipTypeName, relationshipTypeGUID, methodName, this.metadataCollection.getMetadataCollectionId(userId)), null, auditCode.getSystemAction(), auditCode.getUserAction());
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Throwable error) {
            this.errorHandler.handleRepositoryError(error, methodName);
        }
    }

    public void removeAllRelationshipsOfType(String userId, String anchorEntityGUID, String anchorEntityTypeName, String relationshipTypeGUID, String relationshipTypeName, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        try {
            boolean moreToReceive = true;
            while (moreToReceive) {
                List<Relationship> relationships = this.getRelationshipsByType(userId, anchorEntityGUID, anchorEntityTypeName, relationshipTypeGUID, relationshipTypeName, 0, this.maxPageSize, methodName);
                if (relationships != null && !relationships.isEmpty()) {
                    for (Relationship relationship : relationships) {
                        if (relationship == null) continue;
                        this.removeRelationship(userId, relationshipTypeGUID, relationshipTypeName, relationship.getGUID(), methodName);
                    }
                    continue;
                }
                moreToReceive = false;
            }
        }
        catch (PropertyServerException | UserNotAuthorizedException error) {
            throw error;
        }
        catch (Throwable error) {
            this.errorHandler.handleRepositoryError(error, methodName);
        }
    }

    public void removeRelationshipBetweenEntities(String userId, String relationshipTypeGUID, String relationshipTypeName, String entity1GUID, String entity1TypeName, String entity2GUID, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        Relationship relationship = this.getRelationshipBetweenEntities(userId, entity1GUID, entity1TypeName, entity2GUID, relationshipTypeGUID, relationshipTypeName, methodName);
        if (relationship != null) {
            this.removeRelationship(userId, relationshipTypeGUID, relationshipTypeName, relationship.getGUID(), methodName);
        }
    }

    public void updateRelationshipProperties(String userId, String relationshipGUID, InstanceProperties relationshipProperties, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        try {
            this.metadataCollection.updateRelationshipProperties(userId, relationshipGUID, relationshipProperties);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Throwable error) {
            this.errorHandler.handleRepositoryError(error, methodName);
        }
    }

    public void updateUniqueRelationshipByType(String userId, String end1GUID, String end1TypeName, String end2GUID, String end2TypeName, String relationshipTypeGUID, String relationshipTypeName, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        Relationship existingRelationshipForEntity1 = this.getUniqueRelationshipByType(userId, end1GUID, end1TypeName, relationshipTypeGUID, relationshipTypeName, methodName);
        existingRelationshipForEntity1 = this.removeIncompatibleRelationship(userId, existingRelationshipForEntity1, end1GUID, end2GUID, relationshipTypeGUID, relationshipTypeName, methodName);
        Relationship existingRelationshipForEntity2 = this.getUniqueRelationshipByType(userId, end2GUID, end2TypeName, relationshipTypeGUID, relationshipTypeName, methodName);
        existingRelationshipForEntity2 = this.removeIncompatibleRelationship(userId, existingRelationshipForEntity2, end1GUID, end2GUID, relationshipTypeGUID, relationshipTypeName, methodName);
        if (existingRelationshipForEntity1 == null && existingRelationshipForEntity2 == null) {
            this.createRelationship(userId, relationshipTypeGUID, end1GUID, end2GUID, null, methodName);
        }
    }

    public void removeUniqueRelationshipByType(String userId, String entityGUID, String entityTypeName, String relationshipTypeGUID, String relationshipTypeName, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        Relationship obsoleteRelationship = this.getUniqueRelationshipByType(userId, entityGUID, entityTypeName, relationshipTypeGUID, relationshipTypeName, methodName);
        if (obsoleteRelationship != null) {
            this.removeRelationship(userId, relationshipTypeGUID, relationshipTypeName, obsoleteRelationship.getGUID(), methodName);
        }
    }

    private Relationship removeIncompatibleRelationship(String userId, Relationship relationship, String end1GUID, String end2GUID, String relationshipTypeGUID, String relationshipTypeName, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        if (relationship == null) {
            return null;
        }
        EntityProxy end1Proxy = relationship.getEntityOneProxy();
        EntityProxy end2Proxy = relationship.getEntityTwoProxy();
        if (end1GUID.equals(end1Proxy.getGUID()) && end2GUID.equals(end2Proxy.getGUID())) {
            return relationship;
        }
        this.removeRelationship(userId, relationshipTypeGUID, relationshipTypeName, relationship.getGUID(), methodName);
        return null;
    }

    public OMRSMetadataCollection getMetadataCollection() {
        return this.metadataCollection;
    }
}

