/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.repositoryhandler;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandlerErrorCode;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class RepositoryErrorHandler {
    private String serviceName;
    private String serverName;
    private OMRSRepositoryHelper repositoryHelper;

    public RepositoryErrorHandler(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        this.repositoryHelper = repositoryHelper;
        this.serviceName = serviceName;
        this.serverName = serverName;
    }

    public void validateRepositoryConnector(OMRSRepositoryConnector repositoryConnector, String methodName) throws PropertyServerException {
        if (repositoryConnector == null) {
            throw new PropertyServerException(RepositoryHandlerErrorCode.OMRS_NOT_INITIALIZED.getMessageDefinition(methodName), this.getClass().getName(), methodName);
        }
        if (!repositoryConnector.isActive()) {
            throw new PropertyServerException(RepositoryHandlerErrorCode.OMRS_NOT_AVAILABLE.getMessageDefinition(methodName), this.getClass().getName(), methodName);
        }
        try {
            repositoryConnector.getMetadataCollection();
        }
        catch (Throwable error) {
            throw new PropertyServerException(RepositoryHandlerErrorCode.NO_METADATA_COLLECTION.getMessageDefinition(methodName), this.getClass().getName(), methodName);
        }
    }

    void validateProperties(String instanceGUID, String validatingPropertyName, String validatingProperty, InstanceProperties retrievedProperties, String methodName) throws InvalidParameterException {
        Map instancePropertyValueMap;
        InstancePropertyValue retrievedPropertyValue;
        if (validatingProperty != null && retrievedProperties != null && !validatingProperty.equals((retrievedPropertyValue = (InstancePropertyValue)(instancePropertyValueMap = retrievedProperties.getInstanceProperties()).get(validatingPropertyName)).valueAsString())) {
            throw new InvalidParameterException(RepositoryHandlerErrorCode.INVALID_PROPERTY_VALUE.getMessageDefinition(validatingPropertyName, validatingProperty, methodName, retrievedPropertyValue.valueAsString(), instanceGUID), this.getClass().getName(), methodName, validatingPropertyName);
        }
    }

    void validateInstanceType(String userId, InstanceHeader instanceHeader, String guidParameterName, String expectedTypeName, String methodName) throws InvalidParameterException {
        InstanceType type;
        if (instanceHeader != null && (type = instanceHeader.getType()) != null && !this.repositoryHelper.isTypeOf(methodName, type.getTypeDefName(), expectedTypeName)) {
            this.handleWrongTypeForGUIDException(instanceHeader.getGUID(), methodName, type.getTypeDefName(), expectedTypeName);
        }
    }

    boolean isInstanceATypeOf(InstanceHeader instanceHeader, String entityTypeName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        InstanceType type;
        if (instanceHeader != null && (type = instanceHeader.getType()) != null) {
            return this.repositoryHelper.isTypeOf(methodName, type.getTypeDefName(), entityTypeName);
        }
        return false;
    }

    void handleWrongTypeForGUIDException(String guid, String methodName, String actualType, String expectedType) throws InvalidParameterException {
        String defaultGUIDParameterName = "guid";
        throw new InvalidParameterException(RepositoryHandlerErrorCode.INSTANCE_WRONG_TYPE_FOR_GUID.getMessageDefinition(methodName, guid, actualType, expectedType), this.getClass().getName(), methodName, "guid");
    }

    public void handleDuplicateCreateRequest(String typeName, String qualifiedName, String existingEntityGUID, String methodName) throws InvalidParameterException {
        String parameterName = "qualifiedName";
        throw new InvalidParameterException(RepositoryHandlerErrorCode.DUPLICATE_CREATE_REQUEST.getMessageDefinition(typeName, "qualifiedName", qualifiedName, existingEntityGUID), this.getClass().getName(), methodName, "qualifiedName");
    }

    public void handleUnauthorizedUser(String userId, String methodName) throws UserNotAuthorizedException {
        throw new UserNotAuthorizedException(RepositoryHandlerErrorCode.USER_NOT_AUTHORIZED.getMessageDefinition(userId, methodName, this.serviceName, this.serverName), this.getClass().getName(), methodName, userId);
    }

    public void handleUnsupportedProperty(Throwable error, String methodName, String propertyName) throws InvalidParameterException {
        throw new InvalidParameterException(RepositoryHandlerErrorCode.INVALID_PROPERTY.getMessageDefinition(propertyName, methodName, this.serviceName, this.serverName, error.getMessage()), this.getClass().getName(), methodName, error, propertyName);
    }

    public void handleRepositoryError(Throwable error, String methodName) throws PropertyServerException {
        throw new PropertyServerException(RepositoryHandlerErrorCode.PROPERTY_SERVER_ERROR.getMessageDefinition(error.getMessage(), methodName, this.serviceName, this.serverName), this.getClass().getName(), methodName);
    }

    public void handleUnknownEntity(Throwable error, String entityGUID, String entityTypeName, String methodName, String guidParameterName) throws InvalidParameterException {
        throw new InvalidParameterException(RepositoryHandlerErrorCode.UNKNOWN_ENTITY.getMessageDefinition(entityTypeName, entityGUID, methodName, this.serviceName, this.serverName, error.getMessage()), this.getClass().getName(), methodName, error, guidParameterName);
    }

    public void handleEntityProxy(Throwable error, String entityGUID, String entityTypeName, String methodName, String guidParameterName) throws InvalidParameterException {
        throw new InvalidParameterException(RepositoryHandlerErrorCode.PROXY_ENTITY_FOUND.getMessageDefinition(entityTypeName, entityGUID, this.serverName, error.getMessage()), this.getClass().getName(), methodName, error, guidParameterName);
    }

    public void handleAmbiguousRelationships(String entityGUID, String entityTypeName, String relationshipTypeName, List<Relationship> returnedRelationships, String methodName) throws PropertyServerException {
        ArrayList<String> relationshipGUIDs = new ArrayList<String>();
        if (returnedRelationships != null) {
            for (Relationship relationship : returnedRelationships) {
                if (relationship == null) continue;
                relationshipGUIDs.add(relationship.getGUID());
            }
        }
        throw new PropertyServerException(RepositoryHandlerErrorCode.MULTIPLE_RELATIONSHIPS_FOUND.getMessageDefinition(relationshipTypeName, entityTypeName, entityGUID, ((Object)relationshipGUIDs).toString(), methodName, this.serverName), this.getClass().getName(), methodName);
    }

    public void handleAmbiguousEntityName(String name, String nameParameterName, String entityTypeName, List<EntityDetail> returnedEntities, String methodName) throws PropertyServerException {
        ArrayList<String> entityGUIDs = new ArrayList<String>();
        if (returnedEntities != null) {
            for (EntityDetail entity : returnedEntities) {
                if (entity == null) continue;
                entityGUIDs.add(entity.getGUID());
            }
        }
        throw new PropertyServerException(RepositoryHandlerErrorCode.MULTIPLE_ENTITIES_FOUND.getMessageDefinition(entityTypeName, name, ((Object)entityGUIDs).toString(), methodName, nameParameterName, this.serverName), this.getClass().getName(), methodName);
    }

    public void handleNoRelationship(String entityGUID, String entityTypeName, String relationshipTypeName, String methodName) throws PropertyServerException {
        throw new PropertyServerException(RepositoryHandlerErrorCode.NO_RELATIONSHIPS_FOUND.getMessageDefinition(relationshipTypeName, entityTypeName, entityGUID, methodName, this.serverName), this.getClass().getName(), methodName);
    }

    public void handleNoEntity(String entityTypeGUID, String entityTypeName, InstanceProperties properties, String methodName) throws PropertyServerException {
        throw new PropertyServerException(RepositoryHandlerErrorCode.NULL_ENTITY_RETURNED.getMessageDefinition(methodName, this.serverName, entityTypeName, entityTypeGUID, properties.toString()), this.getClass().getName(), methodName);
    }

    public void handleNoEntityForClassification(String entityGUID, String classificationTypeGUID, String classificationTypeName, InstanceProperties properties, String methodName) throws PropertyServerException {
        String propertiesAsString = properties != null ? properties.toString() : "";
        throw new PropertyServerException(RepositoryHandlerErrorCode.NULL_ENTITY_RETURNED_FOR_CLASSIFICATION.getMessageDefinition(methodName, this.serverName, entityGUID, classificationTypeName, classificationTypeGUID, propertiesAsString), this.getClass().getName(), methodName);
    }
}

