/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.repositoryhandler;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchProperties;

public class RepositoryFindRelationshipsIterator {
    private RepositoryHandler repositoryHandler;
    private String userId;
    private String relationshipTypeGUID;
    private int startingFrom;
    private int requesterPageSize;
    private String methodName;
    private List<Relationship> relationshipsCache = null;
    private List<String> relationshipSubtypeGUIDs;
    private SearchProperties searchProperties;
    private List<InstanceStatus> limitResultsByStatus;
    private Date asOfTime;
    private String sequencingProperty;
    private SequencingOrder sequencingOrder;

    public RepositoryFindRelationshipsIterator(RepositoryHandler repositoryHandler, String userId, String relationshipTypeGUID, List<String> relationshipSubtypeGUIDs, SearchProperties searchProperties, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int startingFrom, int requesterPageSize, String methodName) {
        this.repositoryHandler = repositoryHandler;
        this.userId = userId;
        this.relationshipTypeGUID = relationshipTypeGUID;
        this.relationshipSubtypeGUIDs = relationshipSubtypeGUIDs;
        this.searchProperties = searchProperties;
        this.limitResultsByStatus = limitResultsByStatus;
        this.asOfTime = asOfTime;
        this.sequencingProperty = sequencingProperty;
        this.sequencingOrder = sequencingOrder;
        this.startingFrom = startingFrom;
        this.requesterPageSize = requesterPageSize;
        this.methodName = methodName;
    }

    public boolean moreToReceive() throws UserNotAuthorizedException, PropertyServerException {
        if (this.relationshipsCache == null || this.relationshipsCache.isEmpty()) {
            this.relationshipsCache = this.repositoryHandler.findRelationships(this.userId, this.relationshipTypeGUID, this.relationshipSubtypeGUIDs, this.searchProperties, this.limitResultsByStatus, this.asOfTime, this.sequencingProperty, this.sequencingOrder, this.startingFrom, this.requesterPageSize, this.methodName);
            if (this.relationshipsCache != null) {
                this.startingFrom += this.relationshipsCache.size();
            }
        }
        return this.relationshipsCache != null;
    }

    public Relationship getNext() throws UserNotAuthorizedException, PropertyServerException {
        if (this.moreToReceive()) {
            return this.relationshipsCache.remove(0);
        }
        return null;
    }
}

