/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.repositoryhandler;

import java.util.List;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;

public class RepositoryEntitiesIterator {
    private RepositoryHandler repositoryHandler;
    private String userId;
    private String entityTypeGUID;
    private String entityTypeName;
    private int startingFrom;
    private int pageSize;
    private String methodName;
    private List<EntityDetail> entitiesCache = null;

    public RepositoryEntitiesIterator(RepositoryHandler repositoryHandler, String userId, String entityTypeGUID, String entityTypeName, int startingFrom, int pageSize, String methodName) {
        this.repositoryHandler = repositoryHandler;
        this.userId = userId;
        this.entityTypeGUID = entityTypeGUID;
        this.entityTypeName = entityTypeName;
        this.startingFrom = startingFrom;
        this.pageSize = pageSize;
        this.methodName = methodName;
    }

    public boolean moreToReceive() throws UserNotAuthorizedException, PropertyServerException {
        if (this.entitiesCache == null || this.entitiesCache.isEmpty()) {
            this.entitiesCache = this.repositoryHandler.getEntitiesForType(this.userId, this.entityTypeGUID, this.entityTypeName, this.startingFrom, this.pageSize, this.methodName);
            if (this.entitiesCache != null) {
                this.startingFrom += this.entitiesCache.size();
            }
        }
        return this.entitiesCache != null;
    }

    public EntityDetail getNext() throws UserNotAuthorizedException, PropertyServerException {
        if (this.moreToReceive()) {
            return this.entitiesCache.remove(0);
        }
        return null;
    }
}

