/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.repositoryhandler;

import java.util.List;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;

public class RepositoryRelatedEntitiesIterator {
    private RepositoryHandler repositoryHandler;
    private String userId;
    private String anchorEntityGUID;
    private String anchorEntityTypeName;
    private String relationshipTypeGUID;
    private String relationshipTypeName;
    private int startingFrom;
    private int pageSize;
    private String methodName;
    private List<EntityDetail> entitiesCache = null;

    public RepositoryRelatedEntitiesIterator(RepositoryHandler repositoryHandler, String userId, String anchorEntityGUID, String anchorEntityTypeName, String relationshipTypeGUID, String relationshipTypeName, int startingFrom, int pageSize, String methodName) {
        this.repositoryHandler = repositoryHandler;
        this.userId = userId;
        this.anchorEntityGUID = anchorEntityGUID;
        this.anchorEntityTypeName = anchorEntityTypeName;
        this.relationshipTypeGUID = relationshipTypeGUID;
        this.relationshipTypeName = relationshipTypeName;
        this.startingFrom = startingFrom;
        this.pageSize = pageSize;
        this.methodName = methodName;
    }

    public boolean moreToReceive() throws UserNotAuthorizedException, PropertyServerException {
        if (this.entitiesCache == null || this.entitiesCache.isEmpty()) {
            this.entitiesCache = this.repositoryHandler.getEntitiesForRelationshipType(this.userId, this.anchorEntityGUID, this.anchorEntityTypeName, this.relationshipTypeGUID, this.relationshipTypeName, this.startingFrom, this.pageSize, this.methodName);
            if (this.entitiesCache != null) {
                this.startingFrom += this.entitiesCache.size();
            }
        }
        return this.entitiesCache != null;
    }

    public EntityDetail getNext() throws UserNotAuthorizedException, PropertyServerException {
        if (this.moreToReceive()) {
            return this.entitiesCache.remove(0);
        }
        return null;
    }
}

