/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.repositoryhandler;

import java.util.List;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;

public class RepositoryRelationshipsIterator {
    private RepositoryHandler repositoryHandler;
    private String userId;
    private String anchorEntityGUID;
    private String anchorEntityTypeName;
    private String relationshipTypeGUID;
    private String relationshipTypeName;
    private int startingFrom;
    private int pageSize;
    private String methodName;
    private List<Relationship> relationshipsCache = null;

    public RepositoryRelationshipsIterator(RepositoryHandler repositoryHandler, String userId, String anchorEntityGUID, String anchorEntityTypeName, String relationshipTypeGUID, String relationshipTypeName, int startingFrom, int pageSize, String methodName) {
        this.repositoryHandler = repositoryHandler;
        this.userId = userId;
        this.anchorEntityGUID = anchorEntityGUID;
        this.anchorEntityTypeName = anchorEntityTypeName;
        this.relationshipTypeGUID = relationshipTypeGUID;
        this.relationshipTypeName = relationshipTypeName;
        this.startingFrom = startingFrom;
        this.pageSize = pageSize;
        this.methodName = methodName;
    }

    public boolean moreToReceive() throws UserNotAuthorizedException, PropertyServerException {
        if (this.relationshipsCache == null || this.relationshipsCache.isEmpty()) {
            this.relationshipsCache = this.repositoryHandler.getRelationshipsByType(this.userId, this.anchorEntityGUID, this.anchorEntityTypeName, this.relationshipTypeGUID, this.relationshipTypeName, this.startingFrom, this.pageSize, this.methodName);
            if (this.relationshipsCache != null) {
                this.startingFrom += this.relationshipsCache.size();
            }
        }
        return this.relationshipsCache != null;
    }

    public Relationship getNext() throws UserNotAuthorizedException, PropertyServerException {
        if (this.moreToReceive()) {
            return this.relationshipsCache.remove(0);
        }
        return null;
    }
}

