/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.repositoryhandler;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryIteratorForEntities;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchClassifications;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchProperties;

public class RepositoryFindEntitiesIterator
extends RepositoryIteratorForEntities {
    private List<String> entitySubtypeGUIDs;
    private SearchProperties searchProperties;
    private List<InstanceStatus> limitResultsByStatus;
    private SearchClassifications searchClassifications;
    private Date asOfTime;
    private String sequencingProperty;
    private SequencingOrder sequencingOrder;

    public RepositoryFindEntitiesIterator(RepositoryHandler repositoryHandler, String userId, String entityTypeGUID, List<String> entitySubtypeGUIDs, SearchProperties searchProperties, List<InstanceStatus> limitResultsByStatus, SearchClassifications searchClassifications, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int startingFrom, int requesterPageSize, String methodName) {
        super(repositoryHandler, userId, entityTypeGUID, null, startingFrom, requesterPageSize, methodName);
        this.entitySubtypeGUIDs = entitySubtypeGUIDs;
        this.searchProperties = searchProperties;
        this.limitResultsByStatus = limitResultsByStatus;
        this.searchClassifications = searchClassifications;
        this.asOfTime = asOfTime;
        this.sequencingProperty = sequencingProperty;
        this.sequencingOrder = sequencingOrder;
    }

    @Override
    public boolean moreToReceive() throws UserNotAuthorizedException, PropertyServerException {
        if (this.entitiesCache == null || this.entitiesCache.isEmpty()) {
            this.entitiesCache = this.repositoryHandler.findEntities(this.userId, this.entityTypeGUID, this.entitySubtypeGUIDs, this.searchProperties, this.limitResultsByStatus, this.searchClassifications, this.asOfTime, this.sequencingProperty, this.sequencingOrder, this.startingFrom, this.pageSize, this.methodName);
            if (this.entitiesCache != null) {
                this.startingFrom += this.entitiesCache.size();
            }
        }
        return this.entitiesCache != null;
    }
}

