/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.repositoryhandler;

import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryIteratorForEntities;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;

public class RepositorySelectedEntitiesIterator
extends RepositoryIteratorForEntities {
    private InstanceProperties properties;
    private MatchCriteria matchCriteria;
    private String searchCriteria;

    public RepositorySelectedEntitiesIterator(RepositoryHandler repositoryHandler, String userId, String entityTypeGUID, InstanceProperties properties, MatchCriteria matchCriteria, String sequencingPropertyName, int startingFrom, int pageSize, String methodName) {
        super(repositoryHandler, userId, entityTypeGUID, null, sequencingPropertyName, startingFrom, pageSize, methodName);
        this.properties = properties;
        this.matchCriteria = matchCriteria;
        this.searchCriteria = null;
    }

    public RepositorySelectedEntitiesIterator(RepositoryHandler repositoryHandler, String userId, String entityTypeGUID, String searchCriteria, String sequencingPropertyName, int startingFrom, int pageSize, String methodName) {
        super(repositoryHandler, userId, entityTypeGUID, null, sequencingPropertyName, startingFrom, pageSize, methodName);
        this.searchCriteria = searchCriteria;
        this.properties = null;
        this.matchCriteria = null;
    }

    @Override
    public boolean moreToReceive() throws UserNotAuthorizedException, PropertyServerException {
        if (this.entitiesCache == null || this.entitiesCache.isEmpty()) {
            this.entitiesCache = this.searchCriteria != null ? this.repositoryHandler.getEntitiesByValue(this.userId, this.searchCriteria, this.entityTypeGUID, this.sequencingPropertyName, this.startingFrom, this.pageSize, this.methodName) : (this.matchCriteria == MatchCriteria.ANY ? this.repositoryHandler.getEntitiesByName(this.userId, this.properties, this.entityTypeGUID, this.sequencingPropertyName, this.startingFrom, this.pageSize, this.methodName) : (this.matchCriteria == MatchCriteria.ALL ? this.repositoryHandler.getEntitiesByAllProperties(this.userId, this.properties, this.entityTypeGUID, this.sequencingPropertyName, this.startingFrom, this.pageSize, this.methodName) : this.repositoryHandler.getEntitiesWithoutPropertyValues(this.userId, this.properties, this.entityTypeGUID, this.sequencingPropertyName, this.startingFrom, this.pageSize, this.methodName)));
            if (this.entitiesCache != null) {
                this.startingFrom += this.entitiesCache.size();
            }
        }
        return this.entitiesCache != null;
    }
}

