/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.repositoryhandler;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryErrorHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandlerAuditCode;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryRelatedEntitiesIterator;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryRelationshipsIterator;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ClassificationOrigin;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceAuditHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceGraph;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchClassifications;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchProperties;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityProxyOnlyException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotKnownException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryHandler {
    private RepositoryErrorHandler errorHandler;
    private OMRSMetadataCollection metadataCollection;
    private int maxPageSize;
    private AuditLog auditLog;
    private static final Logger log = LoggerFactory.getLogger(RepositoryHandler.class);

    public RepositoryHandler(AuditLog auditLog, RepositoryErrorHandler errorHandler, OMRSMetadataCollection metadataCollection, int maxPageSize) {
        this.auditLog = auditLog;
        this.errorHandler = errorHandler;
        this.metadataCollection = metadataCollection;
        this.maxPageSize = maxPageSize;
    }

    public EntitySummary validateEntityGUID(String userId, String guid, String entityTypeName, String methodName, String guidParameterName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "validateEntityGUID";
        try {
            return this.metadataCollection.getEntitySummary(userId, guid);
        }
        catch (EntityNotKnownException error) {
            this.errorHandler.handleUnknownEntity(error, guid, entityTypeName, methodName, guidParameterName);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Exception error) {
            this.errorHandler.handleRepositoryError(error, methodName, "validateEntityGUID");
        }
        return null;
    }

    public EntitySummary isEntityKnown(String userId, String guid, String entityTypeName, String methodName, String guidParameterName) throws UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "isEntityKnown";
        try {
            EntitySummary entity = this.metadataCollection.getEntitySummary(userId, guid);
            this.errorHandler.validateInstanceType((InstanceHeader)entity, entityTypeName, methodName, "isEntityKnown");
            return entity;
        }
        catch (EntityNotKnownException error) {
            return null;
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Exception error) {
            this.errorHandler.handleRepositoryError(error, methodName, "isEntityKnown");
        }
        return null;
    }

    public String createEntity(String userId, String entityTypeGUID, String entityTypeName, String externalSourceGUID, String externalSourceName, InstanceProperties properties, List<Classification> initialClassifications, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        return this.createEntity(userId, entityTypeGUID, entityTypeName, externalSourceGUID, externalSourceName, properties, initialClassifications, InstanceStatus.ACTIVE, methodName);
    }

    public String createEntity(String userId, String entityTypeGUID, String entityTypeName, String externalSourceGUID, String externalSourceName, InstanceProperties properties, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        return this.createEntity(userId, entityTypeGUID, entityTypeName, externalSourceGUID, externalSourceName, properties, null, InstanceStatus.ACTIVE, methodName);
    }

    public String createEntity(String userId, String entityTypeGUID, String entityTypeName, String externalSourceGUID, String externalSourceName, InstanceProperties properties, InstanceStatus instanceStatus, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        return this.createEntity(userId, entityTypeGUID, entityTypeName, externalSourceGUID, externalSourceName, properties, null, instanceStatus, methodName);
    }

    public String createEntity(String userId, String entityTypeGUID, String entityTypeName, String externalSourceGUID, String externalSourceName, InstanceProperties properties, List<Classification> initialClassifications, InstanceStatus instanceStatus, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "createEntity";
        try {
            EntityDetail newEntity = externalSourceGUID == null ? this.metadataCollection.addEntity(userId, entityTypeGUID, properties, initialClassifications, instanceStatus) : this.metadataCollection.addExternalEntity(userId, entityTypeGUID, externalSourceGUID, externalSourceName, properties, initialClassifications, instanceStatus);
            if (newEntity != null) {
                return newEntity.getGUID();
            }
            this.errorHandler.handleNoEntity(entityTypeGUID, entityTypeName, properties, methodName);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Exception error) {
            this.errorHandler.handleRepositoryError(error, methodName, "createEntity");
        }
        return null;
    }

    public String addUniqueAttachedEntityToElement(String userId, String externalSourceGUID, String externalSourceName, String startingEntityGUID, String startingEntityTypeName, String startingRelationshipTypeGUID, String startingRelationshipTypeName, InstanceProperties startingRelationshipProperties, String attachedEntityTypeGUID, String attachedEntityTypeName, InstanceProperties attachedEntityProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "elementEntityGUID";
        this.validateEntityGUID(userId, startingEntityGUID, startingEntityTypeName, methodName, "elementEntityGUID");
        String attachedEntityGUID = this.createEntity(userId, attachedEntityTypeGUID, attachedEntityTypeName, externalSourceGUID, externalSourceName, attachedEntityProperties, methodName);
        if (attachedEntityGUID != null) {
            this.createRelationship(userId, startingRelationshipTypeGUID, externalSourceGUID, externalSourceName, startingEntityGUID, attachedEntityGUID, startingRelationshipProperties, methodName);
        }
        return attachedEntityGUID;
    }

    public EntityDetail updateEntityProperties(String userId, String externalSourceGUID, String externalSourceName, String entityGUID, String entityTypeGUID, String entityTypeName, InstanceProperties updateProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "entityGUID";
        EntityDetail originalEntity = this.getEntityByGUID(userId, entityGUID, "entityGUID", entityTypeName, methodName);
        return this.updateEntityProperties(userId, externalSourceGUID, externalSourceName, entityGUID, originalEntity, entityTypeGUID, entityTypeName, updateProperties, methodName);
    }

    public EntityDetail updateEntityProperties(String userId, String externalSourceGUID, String externalSourceName, String entityGUID, EntityDetail originalEntity, String entityTypeGUID, String entityTypeName, InstanceProperties newProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "updateEntityProperties";
        if (originalEntity != null) {
            this.errorHandler.validateProvenance(userId, (InstanceAuditHeader)originalEntity, entityGUID, externalSourceGUID, externalSourceName, methodName);
            if (newProperties == null && originalEntity.getProperties() == null) {
                return originalEntity;
            }
            if (newProperties != null && newProperties.equals((Object)originalEntity.getProperties())) {
                return originalEntity;
            }
            try {
                EntityDetail newEntity = this.metadataCollection.updateEntityProperties(userId, entityGUID, newProperties);
                if (newEntity == null) {
                    this.errorHandler.handleNoEntity(entityTypeGUID, entityTypeName, newProperties, methodName);
                }
                return newEntity;
            }
            catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
                this.errorHandler.handleUnauthorizedUser(userId, methodName);
            }
            catch (Exception error) {
                this.errorHandler.handleRepositoryError(error, methodName, "updateEntityProperties");
            }
        }
        return null;
    }

    public void updateSelectedEntityClassifications(String userId, String externalSourceGUID, String externalSourceName, String entityGUID, String entityTypeGUID, String entityTypeName, List<Classification> newClassifications, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "entityGUID";
        EntityDetail entity = this.getEntityByGUID(userId, entityGUID, "entityGUID", entityTypeName, methodName);
        if (entity != null && newClassifications != null && !newClassifications.isEmpty()) {
            if (entity.getClassifications() == null || entity.getClassifications().isEmpty()) {
                this.updateEntityClassifications(userId, externalSourceGUID, externalSourceName, entityGUID, entity.getClassifications(), newClassifications, methodName);
            } else {
                HashMap<String, Classification> classificationMap = new HashMap<String, Classification>();
                for (Classification classification : entity.getClassifications()) {
                    if (classification == null || classification.getName() == null) continue;
                    classificationMap.put(classification.getName(), classification);
                }
                for (Classification classification : newClassifications) {
                    if (classification == null || classification.getName() == null) continue;
                    classificationMap.put(classification.getName(), classification);
                }
                ArrayList<Classification> fullClassificationList = new ArrayList<Classification>(classificationMap.values());
                this.updateEntityClassifications(userId, externalSourceGUID, externalSourceName, entityGUID, fullClassificationList, newClassifications, methodName);
            }
        }
    }

    private void updateEntityClassifications(String userId, String externalSourceGUID, String externalSourceName, String entityGUID, List<Classification> existingEntityClassifications, List<Classification> classifications, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "updateEntityClassifications";
        try {
            if (existingEntityClassifications == null || existingEntityClassifications.isEmpty()) {
                if (classifications != null && !classifications.isEmpty()) {
                    for (Classification newClassification : classifications) {
                        if (newClassification == null) continue;
                        this.classifyEntity(userId, externalSourceGUID, externalSourceName, entityGUID, null, newClassification.getName(), newClassification.getClassificationOrigin(), newClassification.getClassificationOriginGUID(), newClassification.getProperties(), methodName);
                    }
                }
            } else if (classifications == null || classifications.isEmpty()) {
                for (Classification obsoleteClassification : existingEntityClassifications) {
                    if (obsoleteClassification == null) continue;
                    this.declassifyEntity(userId, externalSourceGUID, externalSourceName, entityGUID, null, obsoleteClassification.getName(), (InstanceAuditHeader)obsoleteClassification, methodName);
                }
            } else {
                HashMap<String, Classification> entityClassificationMap = new HashMap<String, Classification>();
                for (Classification entityClassification : existingEntityClassifications) {
                    if (entityClassification == null || entityClassification.getName() == null) continue;
                    entityClassificationMap.put(entityClassification.getName(), entityClassification);
                }
                for (Classification classification : classifications) {
                    if (classification != null && classification.getName() != null) {
                        Classification matchingEntityClassification = (Classification)entityClassificationMap.get(classification.getName());
                        if (matchingEntityClassification == null) {
                            this.classifyEntity(userId, externalSourceGUID, externalSourceName, entityGUID, null, classification.getName(), classification.getClassificationOrigin(), classification.getClassificationOriginGUID(), classification.getProperties(), methodName);
                        } else {
                            if (classification.getProperties() == null) {
                                if (matchingEntityClassification.getProperties() != null) {
                                    this.reclassifyEntity(userId, externalSourceGUID, externalSourceName, entityGUID, null, classification.getName(), (InstanceAuditHeader)matchingEntityClassification, null, methodName);
                                }
                            } else if (!classification.getProperties().equals((Object)matchingEntityClassification.getProperties())) {
                                this.reclassifyEntity(userId, externalSourceGUID, externalSourceName, entityGUID, null, classification.getName(), (InstanceAuditHeader)matchingEntityClassification, classification.getProperties(), methodName);
                            }
                            entityClassificationMap.remove(classification.getName());
                        }
                    }
                    for (String entityClassificationName : entityClassificationMap.keySet()) {
                        if (entityClassificationName == null || classification == null) continue;
                        this.declassifyEntity(userId, externalSourceGUID, externalSourceName, entityGUID, null, classification.getName(), (InstanceAuditHeader)entityClassificationMap.get(entityClassificationName), methodName);
                    }
                }
            }
        }
        catch (Exception error) {
            this.errorHandler.handleRepositoryError(error, methodName, "updateEntityClassifications");
        }
    }

    private Classification getClassificationForEntity(String userId, String entityGUID, String classificationName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String entityGUIDParameterName = "entityGUID";
        EntityDetail entity = this.getEntityByGUID(userId, entityGUID, "entityGUID", null, methodName);
        if (entity != null && classificationName != null && entity.getClassifications() != null) {
            for (Classification classification : entity.getClassifications()) {
                if (classification == null || !classificationName.equals(classification.getName())) continue;
                return classification;
            }
        }
        return null;
    }

    public EntityDetail updateEntity(String userId, String externalSourceGUID, String externalSourceName, String entityGUID, String entityTypeGUID, String entityTypeName, InstanceProperties properties, List<Classification> classifications, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        EntityDetail entity = this.updateEntityProperties(userId, externalSourceGUID, externalSourceName, entityGUID, entityTypeGUID, entityTypeName, properties, methodName);
        this.updateEntityClassifications(userId, externalSourceGUID, externalSourceName, entity.getGUID(), entity.getClassifications(), classifications, methodName);
        return entity;
    }

    public void updateEntityProperties(String userId, String externalSourceGUID, String externalSourceName, InstanceHeader entityHeader, String entityTypeGUID, String entityTypeName, InstanceProperties properties, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "updateEntityProperties";
        try {
            this.errorHandler.validateProvenance(userId, (InstanceAuditHeader)entityHeader, entityHeader.getGUID(), externalSourceGUID, externalSourceName, methodName);
            EntityDetail newEntity = this.metadataCollection.updateEntityProperties(userId, entityHeader.getGUID(), properties);
            if (newEntity == null) {
                this.errorHandler.handleNoEntity(entityTypeGUID, entityTypeName, properties, methodName);
            }
        }
        catch (UserNotAuthorizedException error) {
            throw error;
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Exception error) {
            this.errorHandler.handleRepositoryError(error, methodName, "updateEntityProperties");
        }
    }

    public void updateEntityStatus(String userId, String externalSourceGUID, String externalSourceName, String entityGUID, String entityTypeGUID, String entityTypeName, InstanceStatus instanceStatus, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "entityGUID";
        String localMethodName = "updateEntityStatus";
        EntityDetail entity = this.getEntityByGUID(userId, entityGUID, "entityGUID", entityTypeName, methodName);
        try {
            this.errorHandler.validateProvenance(userId, (InstanceAuditHeader)entity, entityGUID, externalSourceGUID, externalSourceName, methodName);
            EntityDetail newEntity = this.metadataCollection.updateEntityStatus(userId, entityGUID, instanceStatus);
            if (newEntity == null) {
                this.errorHandler.handleNoEntity(entityTypeGUID, entityTypeName, null, methodName);
            }
        }
        catch (UserNotAuthorizedException error) {
            throw error;
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Exception error) {
            this.errorHandler.handleRepositoryError(error, methodName, "updateEntityStatus");
        }
    }

    public EntityDetail classifyEntity(String userId, String externalSourceGUID, String externalSourceName, String entityGUID, String classificationTypeGUID, String classificationTypeName, ClassificationOrigin classificationOrigin, String classificationOriginGUID, InstanceProperties properties, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "classifyEntity";
        try {
            EntityDetail newEntity = this.metadataCollection.classifyEntity(userId, entityGUID, classificationTypeName, externalSourceGUID, externalSourceName, classificationOrigin, classificationOriginGUID, properties);
            if (newEntity != null) {
                return newEntity;
            }
            this.errorHandler.handleNoEntityForClassification(entityGUID, classificationTypeGUID, classificationTypeName, properties, methodName);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Exception error) {
            this.errorHandler.handleRepositoryError(error, methodName, "classifyEntity");
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void reclassifyEntity(String userId, String externalSourceGUID, String externalSourceName, String entityGUID, String classificationTypeGUID, String classificationTypeName, InstanceAuditHeader existingClassificationHeader, InstanceProperties newProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "reclassifyEntity";
        InstanceAuditHeader auditHeader = existingClassificationHeader;
        if (auditHeader == null) {
            auditHeader = this.getClassificationForEntity(userId, entityGUID, classificationTypeName, methodName);
        }
        if (auditHeader != null) {
            try {
                this.errorHandler.validateProvenance(userId, existingClassificationHeader, entityGUID, externalSourceGUID, externalSourceName, methodName);
                EntityDetail newEntity = this.metadataCollection.updateEntityClassification(userId, entityGUID, classificationTypeName, newProperties);
                if (newEntity != null) return;
                this.errorHandler.handleNoEntityForClassification(entityGUID, classificationTypeGUID, classificationTypeName, newProperties, methodName);
                return;
            }
            catch (UserNotAuthorizedException error) {
                throw error;
            }
            catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
                this.errorHandler.handleUnauthorizedUser(userId, methodName);
                return;
            }
            catch (Exception error) {
                this.errorHandler.handleRepositoryError(error, methodName, "reclassifyEntity(" + classificationTypeName + ")");
                return;
            }
        } else {
            this.classifyEntity(userId, externalSourceGUID, externalSourceName, entityGUID, classificationTypeGUID, classificationTypeName, ClassificationOrigin.ASSIGNED, null, newProperties, methodName);
        }
    }

    public void declassifyEntity(String userId, String externalSourceGUID, String externalSourceName, String entityGUID, String classificationTypeGUID, String classificationTypeName, InstanceAuditHeader existingClassificationHeader, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "declassifyEntity";
        InstanceAuditHeader auditHeader = existingClassificationHeader;
        if (auditHeader == null) {
            auditHeader = this.getClassificationForEntity(userId, entityGUID, classificationTypeName, methodName);
        }
        if (auditHeader != null) {
            try {
                this.errorHandler.validateProvenance(userId, auditHeader, entityGUID, externalSourceGUID, externalSourceName, methodName);
                EntityDetail newEntity = this.metadataCollection.declassifyEntity(userId, entityGUID, classificationTypeName);
                if (newEntity == null) {
                    this.errorHandler.handleNoEntityForClassification(entityGUID, classificationTypeGUID, classificationTypeName, null, methodName);
                }
            }
            catch (UserNotAuthorizedException error) {
                throw error;
            }
            catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
                this.errorHandler.handleUnauthorizedUser(userId, methodName);
            }
            catch (Exception error) {
                this.errorHandler.handleRepositoryError(error, methodName, "declassifyEntity");
            }
        }
    }

    public void removeEntity(String userId, String externalSourceGUID, String externalSourceName, String obsoleteEntityGUID, String obsoleteEntityGUIDParameterName, String entityTypeGUID, String entityTypeName, String validatingPropertyName, String validatingProperty, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "removeEntity";
        try {
            EntityDetail obsoleteEntity = this.getEntityByGUID(userId, obsoleteEntityGUID, obsoleteEntityGUIDParameterName, entityTypeName, methodName);
            if (obsoleteEntity != null) {
                this.errorHandler.validateProvenance(userId, (InstanceAuditHeader)obsoleteEntity, obsoleteEntityGUID, externalSourceGUID, externalSourceName, methodName);
                this.errorHandler.validateProperties(obsoleteEntityGUID, validatingPropertyName, validatingProperty, obsoleteEntity.getProperties(), methodName);
                this.isolateAndRemoveEntity(userId, externalSourceGUID, externalSourceName, obsoleteEntityGUID, entityTypeGUID, entityTypeName, methodName);
            }
        }
        catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException error) {
            throw error;
        }
        catch (Exception error) {
            this.errorHandler.handleRepositoryError(error, methodName, "removeEntity");
        }
    }

    public void removeEntityOnLastUse(String userId, String externalSourceGUID, String externalSourceName, String obsoleteEntityGUID, String guidParameterName, String entityTypeGUID, String entityTypeName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "removeEntityOnLastUse";
        try {
            List relationships = this.metadataCollection.getRelationshipsForEntity(userId, obsoleteEntityGUID, null, 0, null, null, null, null, 5);
            if (relationships == null || relationships.isEmpty()) {
                this.isolateAndRemoveEntity(userId, externalSourceGUID, externalSourceName, obsoleteEntityGUID, entityTypeGUID, entityTypeName, methodName);
            }
        }
        catch (EntityNotKnownException error) {
            this.errorHandler.handleUnknownEntity(error, obsoleteEntityGUID, entityTypeName, methodName, guidParameterName);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Exception error) {
            this.errorHandler.handleRepositoryError(error, methodName, "removeEntityOnLastUse");
        }
    }

    private void isolateAndRemoveEntity(String userId, String externalSourceGUID, String externalSourceName, String obsoleteEntityGUID, String entityTypeGUID, String entityTypeName, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "isolateAndRemoveEntity";
        this.removeAllRelationshipsOfType(userId, externalSourceGUID, externalSourceName, obsoleteEntityGUID, entityTypeName, null, null, methodName);
        try {
            this.metadataCollection.deleteEntity(userId, entityTypeGUID, entityTypeName, obsoleteEntityGUID);
        }
        catch (FunctionNotSupportedException error) {
            this.purgeEntity(userId, obsoleteEntityGUID, entityTypeGUID, entityTypeName, methodName);
        }
        catch (Exception error) {
            this.errorHandler.handleRepositoryError(error, methodName, "isolateAndRemoveEntity");
        }
    }

    public void purgeEntity(String userId, String obsoleteEntityGUID, String entityTypeGUID, String entityTypeName, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "purgeEntity";
        try {
            this.metadataCollection.purgeEntity(userId, entityTypeGUID, entityTypeName, obsoleteEntityGUID);
            this.auditLog.logMessage(methodName, RepositoryHandlerAuditCode.ENTITY_PURGED.getMessageDefinition(obsoleteEntityGUID, entityTypeName, entityTypeGUID, methodName, this.metadataCollection.getMetadataCollectionId(userId)));
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Exception error) {
            this.errorHandler.handleRepositoryError(error, methodName, "purgeEntity");
        }
    }

    public void restoreEntity(String userId, String externalSourceGUID, String externalSourceName, String deletedEntityGUID, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "restoreEntity";
        try {
            EntityDetail entity = this.metadataCollection.restoreEntity(userId, deletedEntityGUID);
            if (entity != null) {
                this.errorHandler.validateProvenance(userId, (InstanceAuditHeader)entity, deletedEntityGUID, externalSourceGUID, externalSourceName, methodName);
            }
        }
        catch (UserNotAuthorizedException error) {
            throw error;
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Exception error) {
            this.errorHandler.handleRepositoryError(error, methodName, "restoreEntity");
        }
    }

    public List<EntityDetail> getEntitiesForType(String userId, String entityTypeGUID, String entityTypeName, int startingFrom, int pageSize, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "getEntitiesForType";
        try {
            List results = this.metadataCollection.findEntitiesByProperty(userId, entityTypeGUID, null, null, startingFrom, null, null, null, null, null, pageSize);
            if (results == null) {
                return null;
            }
            if (results.isEmpty()) {
                return null;
            }
            for (EntityDetail entity : results) {
                if (entity == null) continue;
                this.errorHandler.validateInstanceType((InstanceHeader)entity, entityTypeName, methodName, "getEntitiesForType");
            }
            return results;
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Exception error) {
            this.errorHandler.handleRepositoryError(error, methodName, "getEntitiesForType");
        }
        return null;
    }

    public List<EntityDetail> getEntitiesForRelationshipType(String userId, String startingEntityGUID, String startingEntityTypeName, String relationshipTypeGUID, String relationshipTypeName, int startingFrom, int pageSize, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        return this.getEntitiesForRelationshipType(userId, startingEntityGUID, startingEntityTypeName, relationshipTypeGUID, relationshipTypeName, null, startingFrom, pageSize, methodName);
    }

    public List<EntityDetail> getEntitiesForRelationshipType(String userId, String startingEntityGUID, String startingEntityTypeName, String relationshipTypeGUID, String relationshipTypeName, String sequencingPropertyName, int startingFrom, int pageSize, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "getEntitiesForRelationshipType";
        ArrayList<EntityDetail> results = new ArrayList<EntityDetail>();
        SequencingOrder sequencingOrder = null;
        if (sequencingPropertyName != null) {
            sequencingOrder = SequencingOrder.PROPERTY_ASCENDING;
        }
        try {
            List relationships = this.metadataCollection.getRelationshipsForEntity(userId, startingEntityGUID, relationshipTypeGUID, startingFrom, null, null, sequencingPropertyName, sequencingOrder, pageSize);
            if (relationships != null) {
                for (Relationship relationship : relationships) {
                    EntityProxy requiredEnd = this.getOtherEnd(startingEntityGUID, startingEntityTypeName, relationship, methodName);
                    results.add(this.getEntityForRelationship(userId, requiredEnd, methodName));
                }
            } else if (log.isDebugEnabled()) {
                log.debug("No relationships of type " + relationshipTypeName + " found for " + startingEntityTypeName + " entity " + startingEntityGUID);
            }
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Exception error) {
            this.errorHandler.handleRepositoryError(error, methodName, "getEntitiesForRelationshipType");
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    public List<EntityDetail> getEntitiesForClassificationType(String userId, String entityEntityTypeGUID, String classificationName, int startingFrom, int pageSize, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "getEntitiesForClassificationType";
        try {
            List entitiesByClassification = this.metadataCollection.findEntitiesByClassification(userId, entityEntityTypeGUID, classificationName, null, MatchCriteria.ALL, startingFrom, null, null, null, SequencingOrder.ANY, pageSize);
            if (entitiesByClassification != null) {
                return entitiesByClassification;
            }
            log.debug("No entities of type {} with classification {}.", (Object)entityEntityTypeGUID, (Object)classificationName);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Exception error) {
            this.errorHandler.handleRepositoryError(error, methodName, "getEntitiesForClassificationType");
        }
        return new ArrayList<EntityDetail>();
    }

    public List<EntityDetail> getEntitiesForRelationshipEnd(String userId, String anchorEntityGUID, String anchorEntityTypeName, boolean anchorAtEnd1, String relationshipTypeGUID, String relationshipTypeName, int startingFrom, int pageSize, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "getEntitiesForRelationshipEnd";
        ArrayList<EntityDetail> results = new ArrayList<EntityDetail>();
        try {
            List relationships = this.metadataCollection.getRelationshipsForEntity(userId, anchorEntityGUID, relationshipTypeGUID, startingFrom, null, null, null, null, pageSize);
            if (relationships != null) {
                for (Relationship relationship : relationships) {
                    EntityProxy anchorEndProxy = relationship.getEntityOneProxy();
                    EntityProxy requiredEndProxy = relationship.getEntityTwoProxy();
                    if (!anchorAtEnd1) {
                        anchorEndProxy = relationship.getEntityTwoProxy();
                        requiredEndProxy = relationship.getEntityOneProxy();
                    }
                    if (!anchorEntityGUID.equals(anchorEndProxy.getGUID())) continue;
                    results.add(this.metadataCollection.getEntityDetail(userId, requiredEndProxy.getGUID()));
                }
            } else if (log.isDebugEnabled()) {
                log.debug("No relationships of type " + relationshipTypeName + " found for " + anchorEntityTypeName + " entity " + anchorEntityGUID);
            }
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Exception error) {
            this.errorHandler.handleRepositoryError(error, methodName, "getEntitiesForRelationshipEnd");
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    public EntityDetail getAttachedEntityFromUser(String userId, String startingEntityGUID, String startingEntityTypeName, String relationshipTypeGUID, String relationshipTypeName, String attachedEntityTypeGUID, String attachedEntityTypeName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "getAttachedEntityFromUser";
        RepositoryRelatedEntitiesIterator iterator = new RepositoryRelatedEntitiesIterator(this, userId, startingEntityGUID, startingEntityTypeName, relationshipTypeGUID, relationshipTypeName, null, 0, this.maxPageSize, methodName);
        while (iterator.moreToReceive()) {
            EntityDetail entity = iterator.getNext();
            if (entity == null || !userId.equals(entity.getCreatedBy()) && !userId.equals(entity.getUpdatedBy()) && (entity.getMaintainedBy() == null || !entity.getMaintainedBy().contains(userId))) continue;
            this.errorHandler.validateInstanceType((InstanceHeader)entity, attachedEntityTypeName, methodName, "getAttachedEntityFromUser");
            return entity;
        }
        return null;
    }

    public List<EntityDetail> getAttachedEntitiesFromUser(String userId, String startingEntityGUID, String startingEntityTypeName, String relationshipTypeGUID, String relationshipTypeName, String attachedEntityTypeGUID, String attachedEntityTypeName, String sequencingPropertyName, int startingFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "getAttachedEntitiesFromUser";
        ArrayList<EntityDetail> results = new ArrayList<EntityDetail>();
        RepositoryRelatedEntitiesIterator iterator = new RepositoryRelatedEntitiesIterator(this, userId, startingEntityGUID, startingEntityTypeName, relationshipTypeGUID, relationshipTypeName, sequencingPropertyName, startingFrom, pageSize, methodName);
        while (iterator.moreToReceive() && (pageSize == 0 || results.size() < pageSize)) {
            EntityDetail entity = iterator.getNext();
            if (entity == null || !userId.equals(entity.getCreatedBy()) && !userId.equals(entity.getUpdatedBy()) && (entity.getMaintainedBy() == null || !entity.getMaintainedBy().contains(userId))) continue;
            this.errorHandler.validateInstanceType((InstanceHeader)entity, attachedEntityTypeName, methodName, "getAttachedEntitiesFromUser");
            results.add(entity);
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    public List<EntityProxy> getRelatedEntityProxies(String userId, String startingEntityGUID, String startingEntityTypeName, String relationshipTypeGUID, String relationshipTypeName, int startingFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List<Relationship> relationships = this.getRelationshipsByType(userId, startingEntityGUID, startingEntityTypeName, relationshipTypeGUID, relationshipTypeName, startingFrom, pageSize, methodName);
        if (relationships != null) {
            ArrayList<EntityProxy> entityProxies = new ArrayList<EntityProxy>();
            for (Relationship relationship : relationships) {
                EntityProxy relatedEntityProxy;
                if (relationship == null || (relatedEntityProxy = this.getOtherEnd(startingEntityGUID, startingEntityTypeName, relationship, methodName)) == null) continue;
                entityProxies.add(relatedEntityProxy);
            }
            if (entityProxies.isEmpty()) {
                return null;
            }
            return entityProxies;
        }
        return null;
    }

    public EntityProxy getOtherEnd(String startingEntityGUID, Relationship relationship) {
        if (relationship != null) {
            EntityProxy entityProxy = relationship.getEntityOneProxy();
            if (entityProxy != null && startingEntityGUID.equals(entityProxy.getGUID())) {
                entityProxy = relationship.getEntityTwoProxy();
            }
            return entityProxy;
        }
        return null;
    }

    public EntityProxy getOtherEnd(String startingEntityGUID, String startingEntityTypeName, Relationship relationship, String methodName) throws InvalidParameterException {
        String localMethodName = "getOtherEnd";
        if (relationship != null) {
            EntityProxy requiredEnd = relationship.getEntityOneProxy();
            EntityProxy startingEnd = relationship.getEntityTwoProxy();
            if (startingEntityGUID.equals(requiredEnd.getGUID())) {
                requiredEnd = relationship.getEntityTwoProxy();
                startingEnd = relationship.getEntityOneProxy();
            }
            this.errorHandler.validateInstanceType((InstanceHeader)startingEnd, startingEntityTypeName, methodName, "getOtherEnd");
            return requiredEnd;
        }
        return null;
    }

    private EntityDetail getEntityForRelationship(String userId, EntityProxy requiredEnd, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "getEntityForRelationship";
        try {
            return this.metadataCollection.getEntityDetail(userId, requiredEnd.getGUID());
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Exception error) {
            this.errorHandler.handleRepositoryError(error, methodName, "getEntityForRelationship");
        }
        return null;
    }

    public EntityDetail getEntityForRelationshipType(String userId, String startingEntityGUID, String startingEntityTypeName, String relationshipTypeGUID, String relationshipTypeName, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "getEntityForRelationshipType";
        try {
            List relationships = this.metadataCollection.getRelationshipsForEntity(userId, startingEntityGUID, relationshipTypeGUID, 0, null, null, null, null, 100);
            if (relationships != null) {
                if (relationships.size() == 1) {
                    Relationship relationship = (Relationship)relationships.get(0);
                    EntityProxy requiredEnd = relationship.getEntityOneProxy();
                    EntityProxy startingEnd = relationship.getEntityTwoProxy();
                    if (startingEntityGUID.equals(requiredEnd.getGUID())) {
                        requiredEnd = relationship.getEntityTwoProxy();
                        startingEnd = relationship.getEntityOneProxy();
                    }
                    this.errorHandler.validateInstanceType((InstanceHeader)startingEnd, startingEntityTypeName, methodName, "getEntityForRelationshipType");
                    return this.getEntityForRelationship(userId, requiredEnd, methodName);
                }
                if (relationships.size() > 1) {
                    this.errorHandler.handleAmbiguousRelationships(startingEntityGUID, startingEntityTypeName, relationshipTypeName, relationships, methodName);
                }
            }
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Exception error) {
            this.errorHandler.handleRepositoryError(error, methodName, "getEntityForRelationshipType");
        }
        return null;
    }

    public EntityDetail getEntityByGUID(String userId, String guid, String guidParameterName, String entityTypeName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "getEntityByGUID";
        try {
            EntityDetail entity = this.metadataCollection.getEntityDetail(userId, guid);
            this.errorHandler.validateInstanceType((InstanceHeader)entity, entityTypeName, methodName, "getEntityByGUID");
            return entity;
        }
        catch (EntityNotKnownException error) {
            this.errorHandler.handleUnknownEntity(error, guid, entityTypeName, methodName, guidParameterName);
        }
        catch (EntityProxyOnlyException error) {
            this.errorHandler.handleEntityProxy(error, guid, entityTypeName, methodName, guidParameterName);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Exception error) {
            this.errorHandler.handleRepositoryError(error, methodName, "getEntityByGUID");
        }
        return null;
    }

    public boolean isEntityATypeOf(String userId, String guid, String guidParameterName, String entityTypeName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "isEntityATypeOf";
        try {
            EntityDetail entity = this.metadataCollection.getEntityDetail(userId, guid);
            return this.errorHandler.isInstanceATypeOf((InstanceHeader)entity, entityTypeName, methodName);
        }
        catch (EntityNotKnownException error) {
            this.errorHandler.handleUnknownEntity(error, guid, entityTypeName, methodName, guidParameterName);
        }
        catch (EntityProxyOnlyException error) {
            this.errorHandler.handleEntityProxy(error, guid, entityTypeName, methodName, guidParameterName);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Exception error) {
            this.errorHandler.handleRepositoryError(error, methodName, "isEntityATypeOf");
        }
        return false;
    }

    public List<EntityDetail> getEntityByName(String userId, InstanceProperties nameProperties, String entityTypeGUID, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "getEntityByName";
        try {
            return this.metadataCollection.findEntitiesByProperty(userId, entityTypeGUID, nameProperties, MatchCriteria.ANY, 0, null, null, null, null, null, 2);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Exception error) {
            this.errorHandler.handleRepositoryError(error, methodName, "getEntityByName");
        }
        return null;
    }

    public List<EntityDetail> getEntitiesByName(String userId, InstanceProperties nameProperties, String entityTypeGUID, String sequencingPropertyName, int startingFrom, int pageSize, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "getEntitiesByName";
        SequencingOrder sequencingOrder = SequencingOrder.GUID;
        if (sequencingPropertyName != null) {
            sequencingOrder = SequencingOrder.PROPERTY_ASCENDING;
        }
        try {
            return this.metadataCollection.findEntitiesByProperty(userId, entityTypeGUID, nameProperties, MatchCriteria.ANY, startingFrom, null, null, null, sequencingPropertyName, sequencingOrder, pageSize);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Exception error) {
            this.errorHandler.handleRepositoryError(error, methodName, "getEntitiesByName");
        }
        return null;
    }

    public List<EntityDetail> getEntitiesByAllProperties(String userId, InstanceProperties properties, String entityTypeGUID, String sequencingPropertyName, int startingFrom, int pageSize, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "getEntitiesByAllProperties";
        SequencingOrder sequencingOrder = SequencingOrder.GUID;
        if (sequencingPropertyName != null) {
            sequencingOrder = SequencingOrder.PROPERTY_ASCENDING;
        }
        try {
            return this.metadataCollection.findEntitiesByProperty(userId, entityTypeGUID, properties, MatchCriteria.ALL, startingFrom, null, null, null, sequencingPropertyName, sequencingOrder, pageSize);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Exception error) {
            this.errorHandler.handleRepositoryError(error, methodName, "getEntitiesByAllProperties");
        }
        return null;
    }

    public List<EntityDetail> getEntitiesWithoutPropertyValues(String userId, InstanceProperties properties, String entityTypeGUID, String sequencingPropertyName, int startingFrom, int pageSize, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "getEntitiesWithoutPropertyValues";
        SequencingOrder sequencingOrder = SequencingOrder.GUID;
        if (sequencingPropertyName != null) {
            sequencingOrder = SequencingOrder.PROPERTY_ASCENDING;
        }
        try {
            return this.metadataCollection.findEntitiesByProperty(userId, entityTypeGUID, properties, MatchCriteria.NONE, startingFrom, null, null, null, sequencingPropertyName, sequencingOrder, pageSize);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Exception error) {
            this.errorHandler.handleRepositoryError(error, methodName, "getEntitiesWithoutPropertyValues");
        }
        return null;
    }

    public List<EntityDetail> getEntitiesByValue(String userId, String propertyValue, String entityTypeGUID, String sequencingPropertyName, int startingFrom, int pageSize, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "getEntitiesByValue";
        SequencingOrder sequencingOrder = SequencingOrder.GUID;
        if (sequencingPropertyName != null) {
            sequencingOrder = SequencingOrder.PROPERTY_ASCENDING;
        }
        try {
            return this.metadataCollection.findEntitiesByPropertyValue(userId, entityTypeGUID, propertyValue, startingFrom, null, null, null, sequencingPropertyName, sequencingOrder, pageSize);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Exception error) {
            this.errorHandler.handleRepositoryError(error, methodName, "getEntitiesByValue");
        }
        return null;
    }

    public List<EntityDetail> getEntitiesByPropertyValue(String userId, String entityTypeGUID, String searchCriteria, int startingFrom, int pageSize, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "getEntitiesByPropertyValue";
        try {
            return this.metadataCollection.findEntitiesByPropertyValue(userId, entityTypeGUID, searchCriteria, startingFrom, null, null, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Exception error) {
            this.errorHandler.handleRepositoryError(error, methodName, "getEntitiesByPropertyValue");
        }
        return null;
    }

    public EntityDetail getUniqueEntityByName(String userId, String nameValue, String nameParameterName, InstanceProperties nameProperties, String entityTypeGUID, String entityTypeName, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "getUniqueEntityByName";
        try {
            List returnedEntities = this.metadataCollection.findEntitiesByProperty(userId, entityTypeGUID, nameProperties, MatchCriteria.ANY, 0, null, null, null, null, null, 2);
            if (returnedEntities == null || returnedEntities.isEmpty()) {
                return null;
            }
            if (returnedEntities.size() == 1) {
                return (EntityDetail)returnedEntities.get(0);
            }
            this.errorHandler.handleAmbiguousEntityName(nameValue, nameParameterName, entityTypeName, returnedEntities, methodName);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Exception error) {
            this.errorHandler.handleRepositoryError(error, methodName, "getUniqueEntityByName");
        }
        return null;
    }

    public List<EntityDetail> getEntitiesByType(String userId, String entityTypeGUID, int startingFrom, int pageSize, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        return this.getEntitiesByType(userId, entityTypeGUID, startingFrom, pageSize, null, null, null, methodName);
    }

    public List<EntityDetail> getEntitiesByType(String userId, String entityTypeGUID, int startingFrom, int pageSize, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "getEntitiesByType";
        try {
            return this.metadataCollection.findEntitiesByProperty(userId, entityTypeGUID, null, null, startingFrom, null, null, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Exception error) {
            this.errorHandler.handleRepositoryError(error, methodName, "getEntitiesByType");
        }
        return null;
    }

    public List<EntityDetail> findEntities(String userId, String entityTypeGUID, List<String> entitySubtypeGUIDs, SearchProperties searchProperties, List<InstanceStatus> limitResultsByStatus, SearchClassifications searchClassifications, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int startingFrom, int pageSize, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "findEntities";
        try {
            return this.metadataCollection.findEntities(userId, entityTypeGUID, entitySubtypeGUIDs, searchProperties, startingFrom, limitResultsByStatus, searchClassifications, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Exception error) {
            this.errorHandler.handleRepositoryError(error, methodName, "findEntities");
        }
        return null;
    }

    public List<Relationship> findRelationships(String userId, String relationshipTypeGUID, List<String> relationshipSubtypeGUIDs, SearchProperties searchProperties, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int startingFrom, int pageSize, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "findRelationships";
        try {
            return this.metadataCollection.findRelationships(userId, relationshipTypeGUID, relationshipSubtypeGUIDs, searchProperties, startingFrom, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Exception error) {
            this.errorHandler.handleRepositoryError(error, methodName, "findRelationships");
        }
        return null;
    }

    public List<Relationship> getRelationshipsByType(String userId, String startingEntityGUID, String startingEntityTypeName, String relationshipTypeGUID, String relationshipTypeName, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        return this.getRelationshipsByType(userId, startingEntityGUID, startingEntityTypeName, relationshipTypeGUID, relationshipTypeName, 0, this.maxPageSize, methodName);
    }

    public Relationship getRelationshipByGUID(String userId, String relationshipGUID, String relationshipParameterName, String relationshipTypeName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "getRelationshipByGUID";
        try {
            return this.metadataCollection.getRelationship(userId, relationshipGUID);
        }
        catch (RelationshipNotKnownException error) {
            this.errorHandler.handleUnknownRelationship(error, relationshipGUID, relationshipTypeName, methodName, relationshipParameterName);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Exception error) {
            this.errorHandler.handleRepositoryError(error, methodName, "getRelationshipByGUID");
        }
        return null;
    }

    public List<Relationship> getRelationshipsByType(String userId, String startingEntityGUID, String startingEntityTypeName, String relationshipTypeGUID, String relationshipTypeName, int startingFrom, int pageSize, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "getRelationshipsByType";
        try {
            List relationships = this.metadataCollection.getRelationshipsForEntity(userId, startingEntityGUID, relationshipTypeGUID, startingFrom, null, null, null, SequencingOrder.GUID, pageSize);
            if (relationships == null || relationships.isEmpty()) {
                if (log.isDebugEnabled()) {
                    log.debug("No relationships of type " + relationshipTypeGUID + " found for entity " + startingEntityGUID);
                }
                return null;
            }
            ArrayList<Relationship> results = new ArrayList<Relationship>();
            for (Relationship relationship : relationships) {
                if (relationship == null) continue;
                this.errorHandler.validateInstanceType((InstanceHeader)relationship, relationshipTypeName, methodName, "getRelationshipsByType");
                this.getOtherEnd(startingEntityGUID, startingEntityTypeName, relationship, methodName);
                results.add(relationship);
            }
            if (results.isEmpty()) {
                return null;
            }
            return results;
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Exception error) {
            this.errorHandler.handleRepositoryError(error, methodName, "getRelationshipsByType");
        }
        return null;
    }

    public List<Relationship> getRelationshipsByType(String userId, String startingEntityGUID, String relationshipTypeGUID, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int startingFrom, int pageSize, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "getRelationshipsByType";
        try {
            List relationships = this.metadataCollection.getRelationshipsForEntity(userId, startingEntityGUID, relationshipTypeGUID, startingFrom, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
            if (relationships == null || relationships.isEmpty()) {
                if (log.isDebugEnabled()) {
                    log.debug("No relationships of type " + relationshipTypeGUID + " found for entity " + startingEntityGUID);
                }
                return null;
            }
            ArrayList<Relationship> results = new ArrayList<Relationship>();
            for (Relationship relationship : relationships) {
                if (relationship == null) continue;
                this.errorHandler.validateInstanceType((InstanceHeader)relationship, relationshipTypeGUID, methodName, "getRelationshipsByType");
                this.getOtherEnd(startingEntityGUID, relationship);
                results.add(relationship);
            }
            if (results.isEmpty()) {
                return null;
            }
            return results;
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Exception error) {
            this.errorHandler.handleRepositoryError(error, methodName, "getRelationshipsByType");
        }
        return null;
    }

    public List<Relationship> getRequiredRelationshipsByType(String userId, String anchorEntityGUID, String anchorEntityTypeName, String relationshipTypeGUID, String relationshipTypeName, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        return this.getRequiredRelationshipsByType(userId, anchorEntityGUID, anchorEntityTypeName, relationshipTypeGUID, relationshipTypeName, 0, null, null, null, SequencingOrder.GUID, 100, methodName);
    }

    public List<Relationship> getRequiredRelationshipsByType(String userId, String anchorEntityGUID, String anchorEntityTypeName, String relationshipTypeGUID, String relationshipTypeName, int startingFrom, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "getRequiredRelationshipsByType";
        try {
            List relationships = this.metadataCollection.getRelationshipsForEntity(userId, anchorEntityGUID, relationshipTypeGUID, startingFrom, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
            if (relationships.isEmpty()) {
                return null;
            }
            return relationships;
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Exception error) {
            this.errorHandler.handleRepositoryError(error, methodName, "getRequiredRelationshipsByType");
        }
        return null;
    }

    public int countAttachedRelationshipsByType(String userId, String startingEntityGUID, String startingEntityTypeName, String relationshipTypeGUID, String relationshipTypeName, String methodName) throws PropertyServerException, UserNotAuthorizedException {
        List<Relationship> relationships = this.getRelationshipsByType(userId, startingEntityGUID, startingEntityTypeName, relationshipTypeGUID, relationshipTypeName, methodName);
        int count = 0;
        if (relationships != null) {
            for (Relationship relationship : relationships) {
                if (relationship == null) continue;
                ++count;
            }
        }
        return count;
    }

    public List<Relationship> getRelationshipsBetweenEntities(String userId, String entity1GUID, String entity1TypeName, String entity2GUID, String relationshipTypeGUID, String relationshipTypeName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List<Relationship> entity1Relationships = this.getRelationshipsByType(userId, entity1GUID, entity1TypeName, relationshipTypeGUID, relationshipTypeName, methodName);
        if (entity1Relationships != null) {
            ArrayList<Relationship> results = new ArrayList<Relationship>();
            for (Relationship relationship : entity1Relationships) {
                EntityProxy entity2Proxy;
                if (relationship == null || (entity2Proxy = this.getOtherEnd(entity1GUID, entity1TypeName, relationship, methodName)) == null || !entity2GUID.equals(entity2Proxy.getGUID())) continue;
                results.add(relationship);
            }
            if (!results.isEmpty()) {
                return results;
            }
        }
        return null;
    }

    public Relationship getRelationshipBetweenEntities(String userId, String entity1GUID, String entity1TypeName, String entity2GUID, String relationshipTypeGUID, String relationshipTypeName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List<Relationship> entity1Relationships = this.getRelationshipsBetweenEntities(userId, entity1GUID, entity1TypeName, entity2GUID, relationshipTypeGUID, relationshipTypeName, methodName);
        if (entity1Relationships != null) {
            for (Relationship relationship : entity1Relationships) {
                if (relationship == null) continue;
                return relationship;
            }
        }
        return null;
    }

    public List<Relationship> getPagedRelationshipsByType(String userId, String startingEntityGUID, String startingEntityTypeName, String relationshipTypeGUID, String relationshipTypeName, int startingFrom, int maximumResults, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "getPagedRelationshipsByType";
        try {
            List relationships = this.metadataCollection.getRelationshipsForEntity(userId, startingEntityGUID, relationshipTypeGUID, startingFrom, null, null, null, SequencingOrder.GUID, maximumResults);
            if (relationships == null || relationships.isEmpty()) {
                return null;
            }
            return relationships;
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Exception error) {
            this.errorHandler.handleRepositoryError(error, methodName, "getPagedRelationshipsByType");
        }
        return null;
    }

    public Relationship getUniqueParentRelationshipByType(String userId, String startingEntityGUID, String startingEntityTypeName, String relationshipTypeGUID, String relationshipTypeName, boolean parentAtEnd1, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "getUniqueParentRelationshipByType";
        try {
            List<Relationship> relationships = this.getRelationshipsByType(userId, startingEntityGUID, startingEntityTypeName, relationshipTypeGUID, relationshipTypeName, methodName);
            if (relationships != null) {
                if (log.isDebugEnabled()) {
                    log.debug("getUniqueParentRelationshipByType relationships");
                    for (Relationship relationship : relationships) {
                        log.debug("relationship.getGUID()=" + relationship.getGUID() + "relationship.end1 guid=" + relationship.getEntityOneProxy().getGUID() + relationship.getEntityOneProxy().getUniqueProperties().getInstanceProperties().get("qualifiedName") + "relationship.end2 guid " + relationship.getEntityTwoProxy().getGUID() + relationship.getEntityTwoProxy().getUniqueProperties().getInstanceProperties().get("qualifiedName"));
                    }
                }
                RepositoryRelationshipsIterator iterator = new RepositoryRelationshipsIterator(this, userId, startingEntityGUID, startingEntityTypeName, relationshipTypeGUID, relationshipTypeName, 0, this.maxPageSize, methodName);
                while (iterator.moreToReceive()) {
                    EntityProxy parentEntity;
                    Relationship relationship;
                    relationship = iterator.getNext();
                    if (relationship == null) continue;
                    if (log.isDebugEnabled()) {
                        log.debug("getUniqueParentRelationshipByType while (iterator.moreToReceive()");
                        log.debug("relationship.getGUID()=" + relationship.getGUID() + ", relationship.end1 guid=" + relationship.getEntityOneProxy().getGUID() + ",qualified name=" + relationship.getEntityOneProxy().getUniqueProperties().getInstanceProperties().get("qualifiedName") + "relationship.end2 guid " + relationship.getEntityTwoProxy().getGUID() + ",qualified name=" + relationship.getEntityTwoProxy().getUniqueProperties().getInstanceProperties().get("qualifiedName"));
                    }
                    if ((parentEntity = parentAtEnd1 ? relationship.getEntityOneProxy() : relationship.getEntityTwoProxy()) == null || startingEntityGUID.equals(parentEntity.getGUID())) continue;
                    if (log.isDebugEnabled()) {
                        log.debug("getUniqueParentRelationshipByType : returning relationship.getGUID()=" + relationship.getGUID() + "relationship.end1 guid=" + relationship.getEntityOneProxy().getGUID() + relationship.getEntityOneProxy().getUniqueProperties().getInstanceProperties().get("qualifiedName") + "relationship.end2 guid " + relationship.getEntityTwoProxy().getGUID() + relationship.getEntityTwoProxy().getUniqueProperties().getInstanceProperties().get("qualifiedName"));
                    }
                    return relationship;
                }
            }
        }
        catch (PropertyServerException | UserNotAuthorizedException error) {
            throw error;
        }
        catch (Exception error) {
            this.errorHandler.handleRepositoryError(error, methodName, "getUniqueParentRelationshipByType");
        }
        return null;
    }

    public Relationship getUniqueRelationshipByType(String userId, String startingEntityGUID, String startingEntityTypeName, String relationshipTypeGUID, String relationshipTypeName, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "getUniqueRelationshipByType";
        try {
            List<Relationship> relationships = this.getRelationshipsByType(userId, startingEntityGUID, startingEntityTypeName, relationshipTypeGUID, relationshipTypeName, methodName);
            if (relationships != null) {
                if (relationships.size() == 1) {
                    return relationships.get(0);
                }
                if (relationships.size() > 1) {
                    this.errorHandler.handleAmbiguousRelationships(startingEntityGUID, startingEntityTypeName, relationshipTypeName, relationships, methodName);
                }
            }
        }
        catch (PropertyServerException | UserNotAuthorizedException error) {
            throw error;
        }
        catch (Exception error) {
            this.errorHandler.handleRepositoryError(error, methodName, "getUniqueRelationshipByType");
        }
        return null;
    }

    public Relationship getUniqueRelationshipByType(String userId, String startingEntityGUID, String startingEntityTypeName, boolean startAtEnd1, String relationshipTypeGUID, String relationshipTypeName, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "getUniqueRelationshipByType";
        try {
            List<Relationship> relationships = this.getRelationshipsByType(userId, startingEntityGUID, startingEntityTypeName, relationshipTypeGUID, relationshipTypeName, methodName);
            if (relationships != null) {
                Relationship result = null;
                for (Relationship relationship : relationships) {
                    EntityProxy proxy;
                    if (relationship == null || (proxy = startAtEnd1 ? relationship.getEntityOneProxy() : relationship.getEntityTwoProxy()) == null || !startingEntityGUID.equals(proxy.getGUID())) continue;
                    if (result == null) {
                        result = relationship;
                        continue;
                    }
                    this.errorHandler.handleAmbiguousRelationships(startingEntityGUID, startingEntityTypeName, relationshipTypeName, relationships, methodName);
                }
                return result;
            }
        }
        catch (PropertyServerException | UserNotAuthorizedException error) {
            throw error;
        }
        catch (Exception error) {
            this.errorHandler.handleRepositoryError(error, methodName, "getUniqueRelationshipByType");
        }
        return null;
    }

    public Relationship createRelationship(String userId, String relationshipTypeGUID, String externalSourceGUID, String externalSourceName, String end1GUID, String end2GUID, InstanceProperties relationshipProperties, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "createRelationship";
        try {
            if (externalSourceGUID == null) {
                return this.metadataCollection.addRelationship(userId, relationshipTypeGUID, relationshipProperties, end1GUID, end2GUID, InstanceStatus.ACTIVE);
            }
            return this.metadataCollection.addExternalRelationship(userId, relationshipTypeGUID, externalSourceGUID, externalSourceName, relationshipProperties, end1GUID, end2GUID, InstanceStatus.ACTIVE);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Exception error) {
            this.errorHandler.handleRepositoryError(error, methodName, "createRelationship");
        }
        return null;
    }

    public void ensureRelationship(String userId, String end1TypeName, String externalSourceGUID, String externalSourceName, String end1GUID, String end2GUID, String relationshipTypeGUID, String relationshipTypeName, InstanceProperties relationshipProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        Relationship relationship = this.getRelationshipBetweenEntities(userId, end1GUID, end1TypeName, end2GUID, relationshipTypeGUID, relationshipTypeName, methodName);
        if (relationship == null) {
            this.createRelationship(userId, relationshipTypeGUID, externalSourceGUID, externalSourceName, end1GUID, end2GUID, relationshipProperties, methodName);
        } else {
            this.errorHandler.validateProvenance(userId, (InstanceAuditHeader)relationship, relationship.getGUID(), externalSourceGUID, externalSourceName, methodName);
            if (relationshipProperties != null || relationship.getProperties() != null) {
                this.updateRelationshipProperties(userId, externalSourceGUID, externalSourceName, relationship, relationshipProperties, methodName);
            }
        }
    }

    public void createExternalRelationship(String userId, String relationshipTypeGUID, String externalSourceGUID, String externalSourceName, String end1GUID, String end2GUID, InstanceProperties relationshipProperties, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        this.createRelationship(userId, relationshipTypeGUID, externalSourceGUID, externalSourceName, end1GUID, end2GUID, relationshipProperties, methodName);
    }

    public void removeRelationship(String userId, String externalSourceGUID, String externalSourceName, String relationshipTypeName, String relationshipGUID, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "removeRelationship";
        try {
            Relationship relationship = this.metadataCollection.getRelationship(userId, relationshipGUID);
            if (relationship != null) {
                this.errorHandler.validateInstanceType((InstanceHeader)relationship, relationshipTypeName, methodName, "removeRelationship");
                this.removeRelationship(userId, externalSourceGUID, externalSourceName, relationship, methodName);
            }
        }
        catch (PropertyServerException | UserNotAuthorizedException error) {
            throw error;
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Exception error) {
            this.errorHandler.handleRepositoryError(error, methodName, "removeRelationship");
        }
    }

    public void removeRelationship(String userId, String externalSourceGUID, String externalSourceName, Relationship relationship, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "removeRelationship";
        try {
            this.errorHandler.validateProvenance(userId, (InstanceAuditHeader)relationship, relationship.getGUID(), externalSourceGUID, externalSourceName, methodName);
            this.metadataCollection.deleteRelationship(userId, relationship.getType().getTypeDefGUID(), relationship.getType().getTypeDefName(), relationship.getGUID());
        }
        catch (UserNotAuthorizedException error) {
            throw error;
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (RelationshipNotKnownException error) {
        }
        catch (FunctionNotSupportedException error) {
            this.purgeRelationship(userId, relationship.getType().getTypeDefGUID(), relationship.getType().getTypeDefName(), relationship.getGUID(), methodName);
        }
        catch (Exception error) {
            this.errorHandler.handleRepositoryError(error, methodName, "removeRelationship");
        }
    }

    public void purgeRelationship(String userId, String relationshipTypeGUID, String relationshipTypeName, String relationshipGUID, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "purgeRelationship";
        try {
            this.metadataCollection.purgeRelationship(userId, relationshipTypeGUID, relationshipTypeName, relationshipGUID);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Exception error) {
            this.errorHandler.handleRepositoryError(error, methodName, "purgeRelationship");
        }
    }

    public void restoreRelationship(String userId, String externalSourceGUID, String externalSourceName, String deletedRelationshipGUID, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "restoreRelationship";
        try {
            Relationship relationship = this.metadataCollection.restoreRelationship(userId, deletedRelationshipGUID);
            if (relationship != null) {
                this.errorHandler.validateProvenance(userId, (InstanceAuditHeader)relationship, deletedRelationshipGUID, externalSourceGUID, externalSourceName, methodName);
            }
        }
        catch (UserNotAuthorizedException error) {
            throw error;
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Exception error) {
            this.errorHandler.handleRepositoryError(error, methodName, "restoreRelationship");
        }
    }

    public void removeAllRelationshipsOfType(String userId, String externalSourceGUID, String externalSourceName, String startingEntityGUID, String startingEntityTypeName, String relationshipTypeGUID, String relationshipTypeName, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        RepositoryRelationshipsIterator iterator = new RepositoryRelationshipsIterator(this, userId, startingEntityGUID, startingEntityTypeName, relationshipTypeGUID, relationshipTypeName, 0, this.maxPageSize, methodName);
        while (iterator.moreToReceive()) {
            Relationship relationship = iterator.getNext();
            if (relationship == null) continue;
            this.removeRelationship(userId, externalSourceGUID, externalSourceName, relationship, methodName);
        }
    }

    public void removeRelationshipBetweenEntities(String userId, String externalSourceGUID, String externalSourceName, String relationshipTypeGUID, String relationshipTypeName, String entity1GUID, String entity1TypeName, String entity2GUID, String methodName) throws UserNotAuthorizedException, PropertyServerException, InvalidParameterException {
        Relationship relationship = this.getRelationshipBetweenEntities(userId, entity1GUID, entity1TypeName, entity2GUID, relationshipTypeGUID, relationshipTypeName, methodName);
        if (relationship != null) {
            this.removeRelationship(userId, externalSourceGUID, externalSourceName, relationship, methodName);
        }
    }

    public void updateRelationshipProperties(String userId, String externalSourceGUID, String externalSourceName, Relationship relationship, InstanceProperties relationshipProperties, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "updateRelationshipProperties";
        if (relationship == null || relationship.getProperties() == null && relationshipProperties == null || relationshipProperties != null && relationshipProperties.equals((Object)relationship.getProperties())) {
            return;
        }
        try {
            this.errorHandler.validateProvenance(userId, (InstanceAuditHeader)relationship, relationship.getGUID(), externalSourceGUID, externalSourceName, methodName);
            this.metadataCollection.updateRelationshipProperties(userId, relationship.getGUID(), relationshipProperties);
        }
        catch (UserNotAuthorizedException error) {
            throw error;
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Exception error) {
            this.errorHandler.handleRepositoryError(error, methodName, "updateRelationshipProperties");
        }
    }

    public void updateRelationshipProperties(String userId, String externalSourceGUID, String externalSourceName, String relationshipGUID, InstanceProperties relationshipProperties, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "updateRelationshipProperties";
        try {
            Relationship relationship = this.metadataCollection.getRelationship(userId, relationshipGUID);
            if (relationship != null) {
                this.updateRelationshipProperties(userId, externalSourceGUID, externalSourceName, relationship, relationshipProperties, methodName);
            }
        }
        catch (PropertyServerException | UserNotAuthorizedException error) {
            throw error;
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Exception error) {
            this.errorHandler.handleRepositoryError(error, methodName, "updateRelationshipProperties");
        }
    }

    public void updateRelationshipStatus(String userId, String externalSourceGUID, String externalSourceName, String relationshipGUID, String relationshipParameterName, String relationshipTypeName, InstanceStatus instanceStatus, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "updateRelationshipStatus";
        try {
            Relationship relationship = this.getRelationshipByGUID(userId, relationshipGUID, relationshipParameterName, relationshipParameterName, methodName);
            this.errorHandler.validateProvenance(userId, (InstanceAuditHeader)relationship, relationshipGUID, externalSourceGUID, externalSourceName, methodName);
            this.metadataCollection.updateRelationshipStatus(userId, relationshipGUID, instanceStatus);
        }
        catch (PropertyServerException | UserNotAuthorizedException error) {
            throw error;
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Exception error) {
            this.errorHandler.handleRepositoryError(error, methodName, "updateRelationshipStatus");
        }
    }

    public void updateUniqueRelationshipByType(String userId, String externalSourceGUID, String externalSourceName, String end1GUID, String end1TypeName, String end2GUID, String end2TypeName, String relationshipTypeGUID, String relationshipTypeName, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        Relationship existingRelationshipForEntity1 = this.getUniqueRelationshipByType(userId, end1GUID, end1TypeName, relationshipTypeGUID, relationshipTypeName, methodName);
        existingRelationshipForEntity1 = this.removeIncompatibleRelationship(userId, externalSourceGUID, externalSourceName, existingRelationshipForEntity1, end1GUID, end2GUID, methodName);
        Relationship existingRelationshipForEntity2 = this.getUniqueRelationshipByType(userId, end2GUID, end2TypeName, relationshipTypeGUID, relationshipTypeName, methodName);
        existingRelationshipForEntity2 = this.removeIncompatibleRelationship(userId, externalSourceGUID, externalSourceName, existingRelationshipForEntity2, end1GUID, end2GUID, methodName);
        if (existingRelationshipForEntity1 == null && existingRelationshipForEntity2 == null) {
            this.createRelationship(userId, relationshipTypeGUID, externalSourceGUID, externalSourceName, end1GUID, end2GUID, null, methodName);
        }
    }

    public void removeUniqueRelationshipByType(String userId, String externalSourceGUID, String externalSourceName, String entityGUID, String entityTypeName, String relationshipTypeGUID, String relationshipTypeName, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        Relationship obsoleteRelationship = this.getUniqueRelationshipByType(userId, entityGUID, entityTypeName, relationshipTypeGUID, relationshipTypeName, methodName);
        if (obsoleteRelationship != null) {
            this.removeRelationship(userId, externalSourceGUID, externalSourceName, obsoleteRelationship, methodName);
        }
    }

    private Relationship removeIncompatibleRelationship(String userId, String externalSourceGUID, String externalSourceName, Relationship relationship, String end1GUID, String end2GUID, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        if (relationship == null) {
            return null;
        }
        EntityProxy end1Proxy = relationship.getEntityOneProxy();
        EntityProxy end2Proxy = relationship.getEntityTwoProxy();
        if (end1GUID.equals(end1Proxy.getGUID()) && end2GUID.equals(end2Proxy.getGUID())) {
            return relationship;
        }
        this.removeRelationship(userId, externalSourceGUID, externalSourceName, relationship, methodName);
        return null;
    }

    public InstanceGraph getEntityNeighborhood(String userId, String entityGUID, List<String> entityTypeGUIDs, List<String> relationshipTypeGUIDs, List<InstanceStatus> limitResultsByStatus, List<String> limitResultsByClassification, Date asOfTime, int level, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "getEntityNeighborhood";
        try {
            return this.metadataCollection.getEntityNeighborhood(userId, entityGUID, entityTypeGUIDs, relationshipTypeGUIDs, limitResultsByStatus, limitResultsByClassification, asOfTime, level);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Exception error) {
            this.errorHandler.handleRepositoryError(error, methodName, "getEntityNeighborhood");
        }
        return null;
    }

    public OMRSMetadataCollection getMetadataCollection() {
        return this.metadataCollection;
    }
}

