/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.repositoryhandler;

import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryIteratorForEntities;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryRelatedEntitiesIterator
extends RepositoryIteratorForEntities {
    private String startingEntityGUID;
    private String startingEntityTypeName;
    private String relationshipTypeGUID;
    private String relationshipTypeName;
    private int selectionEnd = 0;
    private static final Logger log = LoggerFactory.getLogger(RepositoryRelatedEntitiesIterator.class);

    public RepositoryRelatedEntitiesIterator(RepositoryHandler repositoryHandler, String userId, String startingEntityGUID, String startingEntityTypeName, String relationshipTypeGUID, String relationshipTypeName, String sequencingPropertyName, int startingFrom, int pageSize, String methodName) {
        super(repositoryHandler, userId, null, null, sequencingPropertyName, startingFrom, pageSize, methodName);
        this.startingEntityGUID = startingEntityGUID;
        this.startingEntityTypeName = startingEntityTypeName;
        this.relationshipTypeGUID = relationshipTypeGUID;
        this.relationshipTypeName = relationshipTypeName;
    }

    public RepositoryRelatedEntitiesIterator(RepositoryHandler repositoryHandler, String userId, String startingEntityGUID, String startingEntityTypeName, String relationshipTypeGUID, String relationshipTypeName, String sequencingPropertyName, int startingFrom, int pageSize, int selectionEnd, String methodName) {
        this(repositoryHandler, userId, startingEntityGUID, startingEntityTypeName, relationshipTypeGUID, relationshipTypeName, sequencingPropertyName, startingFrom, pageSize, methodName);
        if (log.isDebugEnabled()) {
            log.debug("RepositoryRelatedEntitiesIterator :startingFrom=" + startingFrom + ",startingEntityGUID=" + startingEntityGUID);
        }
        this.selectionEnd = selectionEnd;
    }

    @Override
    public boolean moreToReceive() throws UserNotAuthorizedException, PropertyServerException {
        if (this.entitiesCache == null || this.entitiesCache.isEmpty()) {
            if (this.selectionEnd == 0) {
                this.entitiesCache = this.repositoryHandler.getEntitiesForRelationshipType(this.userId, this.startingEntityGUID, this.startingEntityTypeName, this.relationshipTypeGUID, this.relationshipTypeName, this.startingFrom, this.pageSize, this.methodName);
            } else {
                boolean anchorAtEnd1 = false;
                anchorAtEnd1 = this.selectionEnd == 2;
                this.entitiesCache = this.repositoryHandler.getEntitiesForRelationshipEnd(this.userId, this.startingEntityGUID, this.startingEntityTypeName, anchorAtEnd1, this.relationshipTypeGUID, this.relationshipTypeName, this.startingFrom, this.pageSize, this.methodName);
            }
            if (this.entitiesCache != null) {
                if (log.isDebugEnabled()) {
                    log.debug("RepositoryRelatedEntitiesIterator : moreToReceive() entitiesCache not null");
                    for (EntityDetail entityDetail : this.entitiesCache) {
                        String displayName = "";
                        String qualifiedName = "";
                        if (entityDetail.getProperties() != null && entityDetail.getProperties().getInstanceProperties() != null) {
                            if (entityDetail.getProperties().getInstanceProperties().get("displayName") != null) {
                                displayName = ((InstancePropertyValue)entityDetail.getProperties().getInstanceProperties().get("displayName")).toString();
                            }
                            if (entityDetail.getProperties().getInstanceProperties().get("qualifiedName") != null) {
                                qualifiedName = ((InstancePropertyValue)entityDetail.getProperties().getInstanceProperties().get("qualifiedName")).toString();
                            }
                        }
                        log.debug("Cached entity " + entityDetail.getGUID() + ",displayName=" + displayName + ",qualifiedName=" + qualifiedName);
                    }
                }
                this.startingFrom += this.entitiesCache.size();
                if (log.isDebugEnabled()) {
                    log.debug("StartingFrom=" + this.startingFrom);
                }
            }
        }
        return this.entitiesCache != null;
    }
}

