/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.repositoryhandler;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandlerAuditCode;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandlerErrorCode;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceAuditHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.ClassificationErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;

public class RepositoryErrorHandler {
    private String serviceName;
    private String serverName;
    private OMRSRepositoryHelper repositoryHelper;
    private AuditLog auditLog = null;

    public RepositoryErrorHandler(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        this.repositoryHelper = repositoryHelper;
        this.serviceName = serviceName;
        this.serverName = serverName;
    }

    public RepositoryErrorHandler(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName, AuditLog auditLog) {
        this.repositoryHelper = repositoryHelper;
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.auditLog = auditLog;
    }

    public void validateRepositoryConnector(OMRSRepositoryConnector repositoryConnector, String methodName) throws PropertyServerException {
        if (repositoryConnector == null) {
            throw new PropertyServerException(RepositoryHandlerErrorCode.OMRS_NOT_INITIALIZED.getMessageDefinition(methodName), this.getClass().getName(), methodName);
        }
        if (!repositoryConnector.isActive()) {
            throw new PropertyServerException(RepositoryHandlerErrorCode.OMRS_NOT_AVAILABLE.getMessageDefinition(methodName), this.getClass().getName(), methodName);
        }
        try {
            repositoryConnector.getMetadataCollection();
        }
        catch (Exception error) {
            throw new PropertyServerException(RepositoryHandlerErrorCode.NO_METADATA_COLLECTION.getMessageDefinition(methodName), this.getClass().getName(), methodName);
        }
    }

    void validateProperties(String instanceGUID, String validatingPropertyName, String validatingProperty, InstanceProperties retrievedProperties, String methodName) throws InvalidParameterException {
        if (validatingPropertyName != null && validatingProperty != null && retrievedProperties != null) {
            Map instancePropertyValueMap = retrievedProperties.getInstanceProperties();
            InstancePropertyValue retrievedPropertyValue = (InstancePropertyValue)instancePropertyValueMap.get(validatingPropertyName);
            if (retrievedPropertyValue == null) {
                throw new InvalidParameterException(RepositoryHandlerErrorCode.UNRECOGNIZED_PROPERTY.getMessageDefinition(validatingPropertyName, validatingProperty, methodName, instanceGUID), this.getClass().getName(), methodName, validatingPropertyName);
            }
            if (!validatingProperty.equals(retrievedPropertyValue.valueAsString())) {
                throw new InvalidParameterException(RepositoryHandlerErrorCode.INVALID_PROPERTY_VALUE.getMessageDefinition(validatingPropertyName, validatingProperty, methodName, retrievedPropertyValue.valueAsString(), instanceGUID), this.getClass().getName(), methodName, validatingPropertyName);
            }
        }
    }

    boolean validateStatus(String statusPropertyName, int statusThreshold, InstanceProperties properties, String methodName) {
        if (statusPropertyName != null) {
            int status = this.repositoryHelper.getIntProperty(this.serviceName, statusPropertyName, properties, methodName);
            return status >= statusThreshold;
        }
        return true;
    }

    boolean validateIsLatestUpdate(InstanceAuditHeader originalElement, InstanceAuditHeader newElement) {
        Date originalUpdateTime = originalElement.getUpdateTime();
        Date newUpdateTime = newElement.getUpdateTime();
        if (originalUpdateTime == null) {
            originalUpdateTime = originalElement.getCreateTime();
        }
        if (newUpdateTime == null) {
            newUpdateTime = newElement.getCreateTime();
        }
        return originalUpdateTime.before(newUpdateTime);
    }

    Classification isClassifiedAs(EntityDetail entity, String classificationName, String methodName) {
        try {
            return this.repositoryHelper.getClassificationFromEntity(this.serviceName, (EntitySummary)entity, classificationName, methodName);
        }
        catch (ClassificationErrorException classificationErrorException) {
            return null;
        }
    }

    void validateProvenance(String userId, InstanceAuditHeader instanceHeader, String uniqueIdentifier, String externalSourceGUID, String externalSourceName, String methodName) throws UserNotAuthorizedException {
        if (instanceHeader == null) {
            return;
        }
        if (instanceHeader.getInstanceProvenanceType() == null || instanceHeader.getInstanceProvenanceType() == InstanceProvenanceType.LOCAL_COHORT) {
            return;
        }
        InstanceProvenanceType instanceProvenanceType = InstanceProvenanceType.LOCAL_COHORT;
        if (instanceHeader.getInstanceProvenanceType() != null) {
            instanceProvenanceType = instanceHeader.getInstanceProvenanceType();
        }
        if (externalSourceGUID != null) {
            if (!externalSourceGUID.equals(instanceHeader.getMetadataCollectionId())) {
                throw new UserNotAuthorizedException(RepositoryHandlerErrorCode.WRONG_EXTERNAL_SOURCE.getMessageDefinition(methodName, externalSourceGUID, externalSourceName, instanceHeader.getType().getTypeDefCategory().getName(), uniqueIdentifier, instanceProvenanceType.getName(), instanceHeader.getMetadataCollectionId(), instanceHeader.getMetadataCollectionName()), this.getClass().getName(), methodName, userId);
            }
        } else {
            throw new UserNotAuthorizedException(RepositoryHandlerErrorCode.LOCAL_CANNOT_CHANGE_EXTERNAL.getMessageDefinition(methodName, instanceHeader.getType().getTypeDefCategory().getName(), uniqueIdentifier, instanceProvenanceType.getName(), instanceHeader.getMetadataCollectionId(), instanceHeader.getMetadataCollectionName(), userId), this.getClass().getName(), methodName, userId);
        }
    }

    public void validateInstanceType(InstanceHeader instanceHeader, String expectedTypeName, String methodName, String localMethodName) throws InvalidParameterException {
        InstanceType type;
        if (!(instanceHeader == null && expectedTypeName == null || (type = instanceHeader.getType()) == null || this.repositoryHelper.isTypeOf(methodName, type.getTypeDefName(), expectedTypeName))) {
            this.handleWrongTypeForGUIDException(instanceHeader.getGUID(), methodName, type.getTypeDefName(), expectedTypeName, localMethodName);
        }
    }

    public void validateTypeIdentifiers(String typeDefGUID, String guidParameterName, String typeDefName, String nameParameterName, String methodName, String localMethodName) throws PropertyServerException {
        if (typeDefGUID != null && typeDefName != null) {
            try {
                this.repositoryHelper.getTypeDef(localMethodName, guidParameterName, nameParameterName, typeDefGUID, typeDefName, methodName);
            }
            catch (TypeErrorException error) {
                throw new PropertyServerException((OCFCheckedExceptionBase)error);
            }
        }
    }

    boolean isInstanceATypeOf(InstanceHeader instanceHeader, String typeName, String methodName) {
        InstanceType type;
        if (instanceHeader != null && (type = instanceHeader.getType()) != null) {
            return this.repositoryHelper.isTypeOf(methodName, type.getTypeDefName(), typeName);
        }
        return false;
    }

    public void logNullInstance(String expectedTypeName, String methodName) {
        if (this.auditLog != null) {
            this.auditLog.logMessage(methodName, RepositoryHandlerAuditCode.NULL_INSTANCE.getMessageDefinition(expectedTypeName, methodName, this.serviceName));
        }
    }

    public void logBadEntity(String expectedTypeName, EntityDetail entity, String methodName) {
        if (entity == null) {
            this.logNullInstance(expectedTypeName, methodName);
        } else if (this.auditLog != null) {
            this.auditLog.logMessage(methodName, RepositoryHandlerAuditCode.BAD_ENTITY.getMessageDefinition(expectedTypeName, methodName, this.serviceName, entity.toString()), entity.toString());
        }
    }

    public void handleBadEntityProxy(Relationship relationship, int end, EntityProxy entityProxy, String methodName) {
        if (this.auditLog != null) {
            String entityProxyString = "<null>";
            if (entityProxy != null) {
                entityProxyString = entityProxy.toString();
            }
            this.auditLog.logMessage(methodName, RepositoryHandlerAuditCode.BAD_ENTITY_PROXY.getMessageDefinition(relationship.getGUID(), methodName, this.serviceName, Integer.toString(end), entityProxyString));
        }
    }

    public void logBadRelationship(String expectedTypeName, Relationship relationship, String methodName) {
        if (relationship == null) {
            this.logNullInstance(expectedTypeName, methodName);
        } else if (this.auditLog != null) {
            this.auditLog.logMessage(methodName, RepositoryHandlerAuditCode.BAD_RELATIONSHIP.getMessageDefinition(expectedTypeName, methodName, this.serviceName, relationship.toString()), relationship.toString());
        }
    }

    void handleWrongTypeForGUIDException(String guid, String methodName, String actualType, String expectedType, String localMethodName) throws InvalidParameterException {
        String defaultGUIDParameterName = "guid";
        throw new InvalidParameterException(RepositoryHandlerErrorCode.INSTANCE_WRONG_TYPE_FOR_GUID.getMessageDefinition(localMethodName, guid, actualType, expectedType, methodName), this.getClass().getName(), methodName, "guid");
    }

    public void handleDuplicateCreateRequest(String typeName, String qualifiedName, String existingEntityGUID, String methodName) throws InvalidParameterException {
        String parameterName = "qualifiedName";
        throw new InvalidParameterException(RepositoryHandlerErrorCode.DUPLICATE_CREATE_REQUEST.getMessageDefinition(typeName, "qualifiedName", qualifiedName, existingEntityGUID), this.getClass().getName(), methodName, "qualifiedName");
    }

    public void handleUnauthorizedUser(String userId, String methodName) throws UserNotAuthorizedException {
        throw new UserNotAuthorizedException(RepositoryHandlerErrorCode.USER_NOT_AUTHORIZED.getMessageDefinition(userId, methodName, this.serviceName, this.serverName), this.getClass().getName(), methodName, userId);
    }

    public void handleUnsupportedProperty(Exception error, String methodName, String propertyName) throws InvalidParameterException {
        throw new InvalidParameterException(RepositoryHandlerErrorCode.INVALID_PROPERTY.getMessageDefinition(propertyName, methodName, this.serviceName, this.serverName, error.getMessage()), this.getClass().getName(), methodName, (Throwable)error, propertyName);
    }

    public void handleUnsupportedParameter(String methodName, String parameterName, String parameterValue) throws InvalidParameterException {
        throw new InvalidParameterException(RepositoryHandlerErrorCode.INVALID_PARAMETER.getMessageDefinition(parameterName, methodName, this.serviceName, this.serverName, parameterValue), this.getClass().getName(), methodName, parameterName);
    }

    public void handleUnsupportedType(Exception error, String methodName, String typeName) throws InvalidParameterException {
        throw new InvalidParameterException(RepositoryHandlerErrorCode.INVALID_TYPE.getMessageDefinition(typeName, methodName, this.serviceName, this.serverName, error.getMessage()), this.getClass().getName(), methodName, (Throwable)error, typeName);
    }

    public void handleUnsupportedAnchorsType(Exception error, String methodName, String typeName) throws PropertyServerException {
        if (this.auditLog == null) {
            throw new PropertyServerException(RepositoryHandlerErrorCode.UNABLE_TO_SET_ANCHORS.getMessageDefinition(this.serviceName, typeName, methodName, error.getClass().getName(), error.getMessage()), error.getClass().getName(), methodName, (Throwable)error);
        }
        this.auditLog.logException(methodName, RepositoryHandlerAuditCode.UNABLE_TO_SET_ANCHORS.getMessageDefinition(this.serviceName, typeName, methodName, error.getClass().getName(), error.getMessage()), (Throwable)error);
    }

    public void handleRepositoryError(Exception error, String methodName) throws PropertyServerException {
        String localMethodName = "handleRepositoryError";
        this.handleRepositoryError(error, methodName, "handleRepositoryError");
    }

    public void handleRepositoryError(Exception error, String methodName, String localMethodName) throws PropertyServerException {
        if (this.auditLog != null) {
            this.auditLog.logException(methodName, RepositoryHandlerAuditCode.PROPERTY_SERVER_ERROR.getMessageDefinition(error.getMessage(), methodName, this.serviceName, this.serverName, error.getClass().getName(), localMethodName), (Throwable)error);
        }
        throw new PropertyServerException(RepositoryHandlerErrorCode.PROPERTY_SERVER_ERROR.getMessageDefinition(error.getMessage(), methodName, this.serviceName, this.serverName, error.getClass().getName(), localMethodName), this.getClass().getName(), methodName);
    }

    public void handleUnknownEntity(Exception error, String entityGUID, String entityTypeName, String methodName, String guidParameterName) throws InvalidParameterException {
        if (error != null) {
            throw new InvalidParameterException(RepositoryHandlerErrorCode.UNKNOWN_ENTITY.getMessageDefinition(entityTypeName, entityGUID, methodName, this.serviceName, this.serverName, error.getMessage()), this.getClass().getName(), methodName, (Throwable)error, guidParameterName);
        }
        throw new InvalidParameterException(RepositoryHandlerErrorCode.UNKNOWN_ENTITY.getMessageDefinition(entityTypeName, entityGUID, methodName, this.serviceName, this.serverName, null), this.getClass().getName(), methodName, guidParameterName);
    }

    public void handleNotEffectiveElement(String elementGUID, String elementTypeName, InstanceProperties properties, String methodName, String guidParameterName, Date effectiveDate) throws InvalidParameterException {
        String fromTime = "<null>";
        String toTime = "<null>";
        String requestedEffectiveTime = "<any time>";
        if (properties != null) {
            if (properties.getEffectiveFromTime() != null) {
                fromTime = properties.getEffectiveFromTime().toString();
            }
            if (properties.getEffectiveToTime() != null) {
                toTime = properties.getEffectiveToTime().toString();
            }
        }
        if (effectiveDate != null) {
            requestedEffectiveTime = effectiveDate.toString();
        }
        throw new InvalidParameterException(RepositoryHandlerErrorCode.NOT_EFFECTIVE_ELEMENT.getMessageDefinition(elementTypeName, elementGUID, methodName, this.serviceName, this.serverName, fromTime, toTime, requestedEffectiveTime), this.getClass().getName(), methodName, guidParameterName);
    }

    public void handleUnknownRelationship(Exception error, String relationshipGUID, String relationshipTypeName, String methodName, String guidParameterName) throws InvalidParameterException {
        String typeName = "<Unknown>";
        if (relationshipTypeName != null) {
            typeName = relationshipTypeName;
        }
        throw new InvalidParameterException(RepositoryHandlerErrorCode.UNKNOWN_RELATIONSHIP.getMessageDefinition(typeName, relationshipGUID, methodName, this.serviceName, this.serverName, error.getMessage()), this.getClass().getName(), methodName, (Throwable)error, guidParameterName);
    }

    public void handleEntityProxy(Exception error, String entityGUID, String entityTypeName, String methodName, String guidParameterName) throws InvalidParameterException {
        throw new InvalidParameterException(RepositoryHandlerErrorCode.PROXY_ENTITY_FOUND.getMessageDefinition(entityTypeName, entityGUID, this.serverName, error.getMessage()), this.getClass().getName(), methodName, (Throwable)error, guidParameterName);
    }

    public void handleAmbiguousRelationships(String entityGUID, String entityTypeName, String relationshipTypeName, List<Relationship> returnedRelationships, String methodName) throws PropertyServerException {
        ArrayList<String> relationshipGUIDs = new ArrayList<String>();
        if (returnedRelationships != null) {
            for (Relationship relationship : returnedRelationships) {
                if (relationship == null) continue;
                relationshipGUIDs.add(relationship.getGUID());
            }
        }
        throw new PropertyServerException(RepositoryHandlerErrorCode.MULTIPLE_RELATIONSHIPS_FOUND.getMessageDefinition(relationshipTypeName, entityTypeName, entityGUID, ((Object)relationshipGUIDs).toString(), methodName, this.serverName), this.getClass().getName(), methodName);
    }

    public void handleAmbiguousEntityName(String name, String nameParameterName, String entityTypeName, List<EntityDetail> returnedEntities, String methodName) throws PropertyServerException {
        ArrayList<String> entityGUIDs = new ArrayList<String>();
        if (returnedEntities != null) {
            for (EntityDetail entity : returnedEntities) {
                if (entity == null) continue;
                entityGUIDs.add(entity.getGUID());
            }
        }
        throw new PropertyServerException(RepositoryHandlerErrorCode.MULTIPLE_ENTITIES_FOUND.getMessageDefinition(entityTypeName, name, ((Object)entityGUIDs).toString(), methodName, nameParameterName, this.serverName), this.getClass().getName(), methodName);
    }

    public void handleAmbiguousName(String name, String nameParameterName, String entityTypeName, List<String> returnedEntityGUIDs, String methodName) throws PropertyServerException {
        throw new PropertyServerException(RepositoryHandlerErrorCode.MULTIPLE_ENTITIES_FOUND.getMessageDefinition(entityTypeName, name, returnedEntityGUIDs.toString(), methodName, nameParameterName, this.serverName), this.getClass().getName(), methodName);
    }

    public void handleNoRelationship(String entityGUID, String entityTypeName, String relationshipTypeName, String methodName) throws PropertyServerException {
        throw new PropertyServerException(RepositoryHandlerErrorCode.NO_RELATIONSHIPS_FOUND.getMessageDefinition(relationshipTypeName, entityTypeName, entityGUID, methodName, this.serverName), this.getClass().getName(), methodName);
    }

    public void handleNoEntity(String entityTypeGUID, String entityTypeName, InstanceProperties properties, String methodName) throws PropertyServerException {
        String propertiesString = "<null>";
        if (properties != null) {
            propertiesString = properties.toString();
        }
        throw new PropertyServerException(RepositoryHandlerErrorCode.NULL_ENTITY_RETURNED.getMessageDefinition(methodName, this.serverName, entityTypeName, entityTypeGUID, propertiesString), this.getClass().getName(), methodName);
    }

    public void handleNoEntityForClassification(String entityGUID, String classificationTypeGUID, String classificationTypeName, InstanceProperties properties, String methodName) throws PropertyServerException {
        String propertiesString = "<null>";
        if (properties != null) {
            propertiesString = properties.toString();
        }
        throw new PropertyServerException(RepositoryHandlerErrorCode.NULL_ENTITY_RETURNED_FOR_CLASSIFICATION.getMessageDefinition(methodName, this.serverName, entityGUID, classificationTypeName, classificationTypeGUID, propertiesString), this.getClass().getName(), methodName);
    }
}

