/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.repositoryhandler;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryIteratorForEntities;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchClassifications;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchProperties;

public class RepositoryFindEntitiesIterator
extends RepositoryIteratorForEntities {
    private List<String> entitySubtypeGUIDs;
    private SearchProperties searchProperties;
    private List<InstanceStatus> limitResultsByStatus;
    private SearchClassifications searchClassifications;
    private Date asOfTime;
    private String sequencingProperty;
    private SequencingOrder sequencingOrder;

    public RepositoryFindEntitiesIterator(RepositoryHandler repositoryHandler, InvalidParameterHandler invalidParameterHandler, String userId, String entityTypeGUID, List<String> entitySubtypeGUIDs, SearchProperties searchProperties, List<InstanceStatus> limitResultsByStatus, SearchClassifications searchClassifications, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, boolean forLineage, boolean forDuplicateProcessing, int startingFrom, int requesterPageSize, Date effectiveTime, String methodName) throws InvalidParameterException {
        super(repositoryHandler, invalidParameterHandler, userId, entityTypeGUID, null, sequencingProperty, forLineage, forDuplicateProcessing, startingFrom, requesterPageSize, effectiveTime, methodName);
        this.entitySubtypeGUIDs = entitySubtypeGUIDs;
        this.searchProperties = searchProperties;
        this.limitResultsByStatus = limitResultsByStatus;
        this.searchClassifications = searchClassifications;
        this.asOfTime = asOfTime;
        this.sequencingProperty = sequencingProperty;
        this.sequencingOrder = sequencingOrder;
    }

    @Override
    public boolean moreToReceive() throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (this.entitiesCache == null || this.entitiesCache.isEmpty()) {
            this.entitiesCache = new ArrayList();
            while (this.entitiesCache != null && this.entitiesCache.isEmpty()) {
                this.entitiesCache = this.repositoryHandler.findEntities(this.userId, this.entityTypeGUID, this.entitySubtypeGUIDs, this.searchProperties, this.limitResultsByStatus, this.searchClassifications, this.asOfTime, this.sequencingProperty, this.sequencingOrder, this.forLineage, this.forDuplicateProcessing, this.startingFrom, this.pageSize, this.effectiveTime, this.methodName);
                this.startingFrom += this.pageSize;
            }
        }
        return this.entitiesCache != null;
    }
}

