/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.repositoryhandler;

import java.util.ArrayList;
import java.util.Date;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryIteratorForEntities;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryRelatedEntitiesIterator
extends RepositoryIteratorForEntities {
    private String startingEntityGUID;
    private String startingEntityTypeName;
    private String relationshipTypeGUID;
    private String relationshipTypeName;
    private int selectionEnd = 0;
    private static final Logger log = LoggerFactory.getLogger(RepositoryRelatedEntitiesIterator.class);

    public RepositoryRelatedEntitiesIterator(RepositoryHandler repositoryHandler, String userId, String startingEntityGUID, String startingEntityTypeName, String relationshipTypeGUID, String relationshipTypeName, String sequencingPropertyName, boolean forLineage, boolean forDuplicateProcessing, int startingFrom, int pageSize, Date effectiveTime, String methodName) {
        super(repositoryHandler, userId, null, null, sequencingPropertyName, forLineage, forDuplicateProcessing, startingFrom, pageSize, effectiveTime, methodName);
        this.startingEntityGUID = startingEntityGUID;
        this.startingEntityTypeName = startingEntityTypeName;
        this.relationshipTypeGUID = relationshipTypeGUID;
        this.relationshipTypeName = relationshipTypeName;
        if (log.isDebugEnabled()) {
            log.debug("RepositoryRelatedEntitiesIterator: startingFrom=" + startingFrom + ", startingEntityGUID=" + startingEntityGUID);
        }
    }

    public RepositoryRelatedEntitiesIterator(RepositoryHandler repositoryHandler, String userId, String startingEntityGUID, String startingEntityTypeName, String relationshipTypeGUID, String relationshipTypeName, String sequencingPropertyName, boolean forLineage, boolean forDuplicateProcessing, int startingFrom, int pageSize, int selectionEnd, Date effectiveTime, String methodName) {
        this(repositoryHandler, userId, startingEntityGUID, startingEntityTypeName, relationshipTypeGUID, relationshipTypeName, sequencingPropertyName, forLineage, forDuplicateProcessing, startingFrom, pageSize, effectiveTime, methodName);
        this.selectionEnd = selectionEnd;
    }

    @Override
    public boolean moreToReceive() throws UserNotAuthorizedException, PropertyServerException {
        if (this.entitiesCache == null || this.entitiesCache.isEmpty()) {
            this.entitiesCache = new ArrayList();
            while (this.entitiesCache != null && this.entitiesCache.isEmpty()) {
                if (this.selectionEnd == 0) {
                    this.entitiesCache = this.repositoryHandler.getEntitiesForRelationshipType(this.userId, this.startingEntityGUID, this.startingEntityTypeName, this.relationshipTypeGUID, this.relationshipTypeName, null, this.forLineage, this.forDuplicateProcessing, this.startingFrom, this.pageSize, this.effectiveTime, this.methodName);
                } else {
                    boolean startAtEnd1 = false;
                    if (this.selectionEnd == 2) {
                        startAtEnd1 = true;
                    }
                    this.entitiesCache = this.repositoryHandler.getEntitiesForRelationshipEnd(this.userId, this.startingEntityGUID, this.startingEntityTypeName, startAtEnd1, this.relationshipTypeGUID, this.relationshipTypeName, this.forLineage, this.forDuplicateProcessing, this.startingFrom, this.pageSize, this.effectiveTime, this.methodName);
                }
                if (this.entitiesCache != null && log.isDebugEnabled()) {
                    log.debug("RepositoryRelatedEntitiesIterator : moreToReceive() entitiesCache not null");
                    for (EntityDetail entity : this.entitiesCache) {
                        String displayName = "";
                        String qualifiedName = "";
                        if (entity.getProperties() != null && entity.getProperties().getInstanceProperties() != null) {
                            if (entity.getProperties().getInstanceProperties().get("displayName") != null) {
                                displayName = ((InstancePropertyValue)entity.getProperties().getInstanceProperties().get("displayName")).toString();
                            } else if (entity.getProperties().getInstanceProperties().get("name") != null) {
                                displayName = ((InstancePropertyValue)entity.getProperties().getInstanceProperties().get("name")).toString();
                            }
                            if (entity.getProperties().getInstanceProperties().get("qualifiedName") != null) {
                                qualifiedName = ((InstancePropertyValue)entity.getProperties().getInstanceProperties().get("qualifiedName")).toString();
                            }
                        }
                        log.debug("Cached entity " + entity.getGUID() + ",displayName=" + displayName + ",qualifiedName=" + qualifiedName);
                    }
                }
                this.startingFrom += this.pageSize;
                if (!log.isDebugEnabled()) continue;
                log.debug("StartingFrom=" + this.startingFrom);
            }
        }
        return this.entitiesCache != null;
    }
}

