/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.repositoryhandler;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;

public abstract class RepositoryIteratorForEntities {
    protected RepositoryHandler repositoryHandler;
    protected String userId;
    protected String entityTypeGUID;
    protected String entityTypeName;
    protected int startingFrom;
    protected int pageSize;
    protected String methodName;
    protected String sequencingPropertyName;
    protected boolean forLineage;
    protected boolean forDuplicateProcessing;
    protected Date effectiveTime;
    protected List<EntityDetail> entitiesCache = null;

    public RepositoryIteratorForEntities(RepositoryHandler repositoryHandler, String userId, String entityTypeGUID, String entityTypeName, String sequencingPropertyName, boolean forLineage, boolean forDuplicateProcessing, int startingFrom, int pageSize, Date effectiveTime, String methodName) {
        this.repositoryHandler = repositoryHandler;
        this.userId = userId;
        this.entityTypeGUID = entityTypeGUID;
        this.entityTypeName = entityTypeName;
        this.sequencingPropertyName = sequencingPropertyName;
        this.startingFrom = startingFrom;
        this.pageSize = pageSize;
        this.forLineage = forLineage;
        this.forDuplicateProcessing = forDuplicateProcessing;
        this.effectiveTime = effectiveTime;
        this.methodName = methodName;
    }

    public abstract boolean moreToReceive() throws UserNotAuthorizedException, PropertyServerException;

    public EntityDetail getNext() throws UserNotAuthorizedException, PropertyServerException {
        if (this.moreToReceive()) {
            return this.entitiesCache.remove(0);
        }
        return null;
    }
}

