/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.repositoryhandler;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryIterator;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchProperties;

public class RepositoryFindRelationshipsIterator
extends RepositoryIterator {
    private String relationshipTypeGUID;
    private List<Relationship> relationshipsCache = null;
    private List<String> relationshipSubtypeGUIDs;
    private SearchProperties searchProperties;
    private List<InstanceStatus> limitResultsByStatus;
    private Date asOfTime;
    private String sequencingProperty;
    private SequencingOrder sequencingOrder;

    public RepositoryFindRelationshipsIterator(RepositoryHandler repositoryHandler, InvalidParameterHandler invalidParameterHandler, String userId, String relationshipTypeGUID, List<String> relationshipSubtypeGUIDs, SearchProperties searchProperties, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int startingFrom, int pageSize, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException {
        super(repositoryHandler, invalidParameterHandler, userId, startingFrom, pageSize, forDuplicateProcessing, effectiveTime, methodName);
        this.relationshipTypeGUID = relationshipTypeGUID;
        this.relationshipSubtypeGUIDs = relationshipSubtypeGUIDs;
        this.searchProperties = searchProperties;
        this.limitResultsByStatus = limitResultsByStatus;
        this.asOfTime = asOfTime;
        this.sequencingProperty = sequencingProperty;
        this.sequencingOrder = sequencingOrder;
    }

    public boolean moreToReceive() throws UserNotAuthorizedException, PropertyServerException {
        if (this.relationshipsCache == null || this.relationshipsCache.isEmpty()) {
            this.relationshipsCache = new ArrayList<Relationship>();
            while (this.relationshipsCache != null && this.relationshipsCache.isEmpty()) {
                this.relationshipsCache = this.repositoryHandler.findRelationships(this.userId, this.relationshipTypeGUID, this.relationshipSubtypeGUIDs, this.searchProperties, this.limitResultsByStatus, this.asOfTime, this.sequencingProperty, this.sequencingOrder, this.forDuplicateProcessing, this.startingFrom, this.pageSize, this.effectiveTime, this.methodName);
                this.startingFrom += this.pageSize;
            }
        }
        return this.relationshipsCache != null;
    }

    public Relationship getNext() throws UserNotAuthorizedException, PropertyServerException {
        if (this.moreToReceive()) {
            return this.relationshipsCache.remove(0);
        }
        return null;
    }
}

