/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.repositoryhandler;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryIterator;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryRelationshipsIterator
extends RepositoryIterator {
    private static final Logger log = LoggerFactory.getLogger(RepositoryRelationshipsIterator.class);
    private String startingEntityGUID;
    private String startingEntityTypeName;
    private String relationshipTypeGUID;
    private String relationshipTypeName;
    private List<Relationship> relationshipsCache = null;

    public RepositoryRelationshipsIterator(RepositoryHandler repositoryHandler, InvalidParameterHandler invalidParameterHandler, String userId, String startingEntityGUID, String startingEntityTypeName, String relationshipTypeGUID, String relationshipTypeName, boolean forDuplicateProcessing, int startingFrom, int pageSize, Date effectiveTime, String methodName) throws InvalidParameterException {
        super(repositoryHandler, invalidParameterHandler, userId, startingFrom, pageSize, forDuplicateProcessing, effectiveTime, methodName);
        this.startingEntityGUID = startingEntityGUID;
        this.startingEntityTypeName = startingEntityTypeName;
        this.relationshipTypeGUID = relationshipTypeGUID;
        this.relationshipTypeName = relationshipTypeName;
        if (log.isDebugEnabled()) {
            log.debug("RepositoryRelationshipsIterator constructor startingEntityGUID=" + this.startingEntityGUID);
        }
    }

    public boolean moreToReceive() throws UserNotAuthorizedException, PropertyServerException {
        if (this.relationshipsCache == null || this.relationshipsCache.isEmpty()) {
            this.relationshipsCache = new ArrayList<Relationship>();
            while (this.relationshipsCache != null && this.relationshipsCache.isEmpty()) {
                this.relationshipsCache = this.repositoryHandler.getRelationshipsByType(this.userId, this.startingEntityGUID, this.startingEntityTypeName, this.relationshipTypeGUID, this.relationshipTypeName, this.forDuplicateProcessing, this.startingFrom, this.pageSize, this.effectiveTime, this.methodName);
                this.startingFrom += this.pageSize;
            }
            if (this.relationshipsCache != null && log.isDebugEnabled()) {
                log.debug("relationshipsCache");
                for (Relationship relationship : this.relationshipsCache) {
                    log.debug("relationship guid" + relationship.getGUID() + " end1 " + relationship.getEntityOneProxy().getGUID() + " end2 " + relationship.getEntityTwoProxy().getGUID());
                }
            }
        }
        return this.relationshipsCache != null;
    }

    public Relationship getNext() throws UserNotAuthorizedException, PropertyServerException {
        if (this.moreToReceive()) {
            return this.relationshipsCache.remove(0);
        }
        return null;
    }
}

