/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.repositoryhandler;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.DuplicateEntityIterator;
import org.odpi.openmetadata.commonservices.repositoryhandler.RelationshipAccumulator;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryErrorHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandlerAuditCode;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandlerErrorCode;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryRelationshipsIterator;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ClassificationOrigin;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceAuditHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceGraph;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchClassifications;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.ClassificationErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityProxyOnlyException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotKnownException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryHandler {
    private static final String consolidatedDuplicateLinkName = "ConsolidatedDuplicateLink";
    private static final String peerDuplicateLink = "PeerDuplicateLink";
    private final InvalidParameterHandler invalidParameterHandler;
    private final RepositoryErrorHandler errorHandler;
    private final OMRSRepositoryHelper repositoryHelper;
    private final OMRSMetadataCollection metadataCollection;
    private final int maxPageSize;
    private final AuditLog auditLog;
    private static final Logger log = LoggerFactory.getLogger(RepositoryHandler.class);

    public RepositoryHandler(AuditLog auditLog, OMRSRepositoryHelper repositoryHelper, RepositoryErrorHandler errorHandler, OMRSMetadataCollection metadataCollection, int maxPageSize) {
        this.auditLog = auditLog;
        this.repositoryHelper = repositoryHelper;
        this.errorHandler = errorHandler;
        this.metadataCollection = metadataCollection;
        this.maxPageSize = maxPageSize;
        this.invalidParameterHandler = new InvalidParameterHandler();
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
    }

    boolean isCorrectEffectiveTime(InstanceProperties properties, Date effectiveTime) {
        if (effectiveTime == null) {
            return true;
        }
        if (properties == null) {
            return true;
        }
        if (properties.getEffectiveFromTime() != null && effectiveTime.before(properties.getEffectiveFromTime())) {
            return false;
        }
        return properties.getEffectiveToTime() == null || !effectiveTime.after(properties.getEffectiveToTime());
    }

    public EntityDetail validateEntityGUID(String userId, String guid, String guidParameterName, String entityTypeName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "validateEntityGUID";
        try {
            EntityDetail entity = this.metadataCollection.getEntityDetail(userId, guid);
            if (entity != null) {
                this.errorHandler.validateInstanceType((InstanceHeader)entity, entityTypeName, methodName, "validateEntityGUID");
            }
            return entity;
        }
        catch (EntityNotKnownException error) {
            this.errorHandler.handleUnknownEntity((Exception)((Object)error), guid, entityTypeName, methodName, guidParameterName);
        }
        catch (EntityProxyOnlyException error) {
            this.errorHandler.handleEntityProxy((Exception)((Object)error), guid, entityTypeName, methodName, guidParameterName);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Exception error) {
            this.errorHandler.handleRepositoryError(error, methodName, "validateEntityGUID");
        }
        return null;
    }

    public EntityDetail validateRetrievedEntity(String userId, EntityDetail entity, String entityTypeName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (entity == null) {
            log.debug("no supplied entity");
            return null;
        }
        DuplicateEntityIterator duplicateEntityIterator = new DuplicateEntityIterator(this, this.errorHandler, this.invalidParameterHandler, userId, entity, entityTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        EntityDetail resultingEntity = duplicateEntityIterator.getNextPeer();
        if (resultingEntity != null && duplicateEntityIterator.morePeersToReceive()) {
            log.debug("Deduping");
            resultingEntity = new EntityDetail(resultingEntity);
            HashMap<String, Classification> classificationMap = new HashMap<String, Classification>();
            if (entity.getClassifications() != null) {
                for (Classification classification : entity.getClassifications()) {
                    if (classification == null) continue;
                    classificationMap.put(classification.getName(), classification);
                }
            }
            while (duplicateEntityIterator.morePeersToReceive()) {
                EntityDetail peerEntity = duplicateEntityIterator.getNextPeer();
                if (peerEntity != null) {
                    resultingEntity = this.getLatest(resultingEntity, peerEntity);
                    if (peerEntity.getClassifications() != null) {
                        for (Classification peerClassification : peerEntity.getClassifications()) {
                            if (peerClassification == null) continue;
                            Classification existingClassification = (Classification)classificationMap.get(peerClassification.getName());
                            if (existingClassification == null) {
                                classificationMap.put(peerClassification.getName(), peerClassification);
                                continue;
                            }
                            if (!this.errorHandler.validateIsLatestUpdate((InstanceAuditHeader)existingClassification, (InstanceAuditHeader)peerClassification)) continue;
                            classificationMap.put(peerClassification.getName(), peerClassification);
                        }
                    }
                }
                resultingEntity.setClassifications(new ArrayList(classificationMap.values()));
            }
        }
        if (log.isDebugEnabled()) {
            if (resultingEntity == null) {
                log.debug("no resulting entity");
            } else {
                log.debug("Resulting entity: " + resultingEntity.getGUID());
            }
        }
        return resultingEntity;
    }

    private EntityDetail getLatest(EntityDetail currentEntity, EntityDetail newEntity) {
        Date newLastUpdate;
        Date currentLastUpdate = currentEntity.getUpdateTime();
        if (currentLastUpdate == null) {
            currentLastUpdate = currentEntity.getCreateTime();
        }
        if ((newLastUpdate = newEntity.getUpdateTime()) == null) {
            newLastUpdate = newEntity.getCreateTime();
        }
        if (currentLastUpdate.equals(newLastUpdate)) {
            if (currentEntity.getGUID().compareTo(newEntity.getGUID()) >= 0) {
                return currentEntity;
            }
            return newEntity;
        }
        if (currentLastUpdate.before(newLastUpdate)) {
            return new EntityDetail(newEntity);
        }
        return currentEntity;
    }

    private List<EntityDetail> validateEntities(String userId, List<EntityDetail> retrievedEntities, String expectedEntityTypeName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        HashSet<String> acceptedGUIDs = new HashSet<String>();
        if (retrievedEntities != null) {
            ArrayList<EntityDetail> results = new ArrayList<EntityDetail>();
            for (EntityDetail entity : retrievedEntities) {
                if (entity == null) continue;
                EntityDetail validatedEntity = this.validateRetrievedEntity(userId, entity, expectedEntityTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
                if (validatedEntity != null) {
                    if (!acceptedGUIDs.contains(validatedEntity.getGUID())) {
                        acceptedGUIDs.add(validatedEntity.getGUID());
                        results.add(validatedEntity);
                        continue;
                    }
                    log.debug("Skipping entity since already retrieved - because using consolidated entities");
                    continue;
                }
                log.debug("Skipping entity since unavailable for some reason");
            }
            if (log.isDebugEnabled()) {
                log.debug(results.size() + " entities returned");
            }
            return results;
        }
        if (log.isDebugEnabled()) {
            log.debug("No entities returned");
        }
        return null;
    }

    public EntityDetail isEntityKnown(String userId, String guid, String guidParameterName, String entityTypeName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "isEntityKnown";
        try {
            return this.getEntityByGUID(userId, guid, guidParameterName, entityTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        catch (InvalidParameterException error) {
            return null;
        }
        catch (PropertyServerException | UserNotAuthorizedException error) {
            throw error;
        }
        catch (Exception error) {
            this.errorHandler.handleRepositoryError(error, methodName, "isEntityKnown");
            return null;
        }
    }

    public String createEntity(String userId, String entityTypeGUID, String entityTypeName, String externalSourceGUID, String externalSourceName, InstanceProperties properties, InstanceStatus instanceStatus, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        return this.createEntity(userId, entityTypeGUID, entityTypeName, externalSourceGUID, externalSourceName, properties, null, instanceStatus, methodName);
    }

    public String createEntity(String userId, String entityTypeGUID, String entityTypeName, String externalSourceGUID, String externalSourceName, InstanceProperties properties, List<Classification> initialClassifications, InstanceStatus instanceStatus, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "createEntity";
        String typeGUIDParameterName = "entityTypeGUID";
        String typeNameParameterName = "entityTypeName";
        this.errorHandler.validateTypeIdentifiers(entityTypeGUID, "entityTypeGUID", entityTypeName, "entityTypeName", methodName, "createEntity");
        try {
            EntityDetail newEntity = externalSourceGUID == null ? this.metadataCollection.addEntity(userId, entityTypeGUID, properties, initialClassifications, instanceStatus) : this.metadataCollection.addExternalEntity(userId, entityTypeGUID, externalSourceGUID, externalSourceName, properties, initialClassifications, instanceStatus);
            if (newEntity != null) {
                return newEntity.getGUID();
            }
            this.errorHandler.handleNoEntity(entityTypeGUID, entityTypeName, properties, methodName);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Exception error) {
            this.errorHandler.handleRepositoryError(error, methodName, "createEntity");
        }
        return null;
    }

    public EntityDetail updateEntityProperties(String userId, String externalSourceGUID, String externalSourceName, String entityGUID, String entityGUIDParameterName, String entityTypeGUID, String entityTypeName, InstanceProperties updateProperties, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        EntityDetail originalEntity = this.getEntityByGUID(userId, entityGUID, entityGUIDParameterName, entityTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        return this.updateEntityProperties(userId, externalSourceGUID, externalSourceName, originalEntity.getGUID(), originalEntity, entityTypeGUID, entityTypeName, updateProperties, methodName);
    }

    public EntityDetail updateEntityProperties(String userId, String externalSourceGUID, String externalSourceName, String entityGUID, EntityDetail originalEntity, String entityTypeGUID, String entityTypeName, InstanceProperties newProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "updateEntityProperties";
        String guidParameterName = "guid";
        String typeGUIDParameterName = "entityTypeGUID";
        String typeNameParameterName = "entityTypeName";
        this.errorHandler.validateTypeIdentifiers(entityTypeGUID, "entityTypeGUID", entityTypeName, "entityTypeName", methodName, "updateEntityProperties");
        if (originalEntity != null) {
            this.errorHandler.validateProvenance(userId, (InstanceAuditHeader)originalEntity, originalEntity.getGUID(), externalSourceGUID, externalSourceName, methodName);
            if (newProperties == null && originalEntity.getProperties() == null) {
                return originalEntity;
            }
            if (newProperties != null && newProperties.equals((Object)originalEntity.getProperties())) {
                return originalEntity;
            }
            try {
                EntityDetail newEntity = this.metadataCollection.updateEntityProperties(userId, entityGUID, newProperties);
                if (newEntity == null) {
                    this.errorHandler.handleNoEntity(entityTypeGUID, entityTypeName, newProperties, methodName);
                }
                return newEntity;
            }
            catch (EntityNotKnownException error) {
                this.errorHandler.handleUnknownEntity((Exception)((Object)error), entityGUID, entityTypeName, methodName, "guid");
            }
            catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
                this.errorHandler.handleUnauthorizedUser(userId, methodName);
            }
            catch (Exception error) {
                this.errorHandler.handleRepositoryError(error, methodName, "updateEntityProperties");
            }
        }
        return null;
    }

    private String getClassificationTypeGUID(Classification classification) {
        InstanceType type = classification.getType();
        if (type != null) {
            return type.getTypeDefGUID();
        }
        return null;
    }

    private void updateEntityClassifications(String userId, String externalSourceGUID, String externalSourceName, String entityGUID, String entityGUIDParameterName, String entityTypeName, List<Classification> existingEntityClassifications, List<Classification> classifications, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "updateEntityClassifications";
        try {
            if (existingEntityClassifications == null || existingEntityClassifications.isEmpty()) {
                if (classifications != null && !classifications.isEmpty()) {
                    for (Classification newClassification : classifications) {
                        if (newClassification == null) continue;
                        this.classifyEntity(userId, externalSourceGUID, externalSourceName, entityGUID, null, entityGUIDParameterName, entityTypeName, this.getClassificationTypeGUID(newClassification), newClassification.getName(), newClassification.getClassificationOrigin(), newClassification.getClassificationOriginGUID(), newClassification.getProperties(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
                    }
                }
            } else if (classifications == null || classifications.isEmpty()) {
                for (Classification obsoleteClassification : existingEntityClassifications) {
                    if (obsoleteClassification == null) continue;
                    this.declassifyEntity(userId, externalSourceGUID, externalSourceName, entityGUID, null, entityGUIDParameterName, entityTypeName, this.getClassificationTypeGUID(obsoleteClassification), obsoleteClassification.getName(), (InstanceAuditHeader)obsoleteClassification, forLineage, forDuplicateProcessing, effectiveTime, methodName);
                }
            } else {
                HashMap<String, Classification> entityClassificationMap = new HashMap<String, Classification>();
                for (Classification entityClassification : existingEntityClassifications) {
                    if (entityClassification == null || entityClassification.getName() == null) continue;
                    entityClassificationMap.put(entityClassification.getName(), entityClassification);
                }
                for (Classification classification : classifications) {
                    if (classification != null && classification.getName() != null) {
                        Classification matchingEntityClassification = (Classification)entityClassificationMap.get(classification.getName());
                        if (matchingEntityClassification == null) {
                            this.classifyEntity(userId, externalSourceGUID, externalSourceName, entityGUID, null, entityGUIDParameterName, entityTypeName, this.getClassificationTypeGUID(classification), classification.getName(), classification.getClassificationOrigin(), classification.getClassificationOriginGUID(), classification.getProperties(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
                        } else {
                            if (classification.getProperties() == null) {
                                if (matchingEntityClassification.getProperties() != null) {
                                    this.reclassifyEntity(userId, externalSourceGUID, externalSourceName, entityGUID, entityGUIDParameterName, entityTypeName, this.getClassificationTypeGUID(classification), classification.getName(), (InstanceAuditHeader)matchingEntityClassification, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
                                }
                            } else if (!classification.getProperties().equals((Object)matchingEntityClassification.getProperties())) {
                                this.reclassifyEntity(userId, externalSourceGUID, externalSourceName, entityGUID, entityGUIDParameterName, entityTypeName, this.getClassificationTypeGUID(classification), classification.getName(), (InstanceAuditHeader)matchingEntityClassification, classification.getProperties(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
                            }
                            entityClassificationMap.remove(classification.getName());
                        }
                    }
                    for (String entityClassificationName : entityClassificationMap.keySet()) {
                        if (entityClassificationName == null || classification == null) continue;
                        this.declassifyEntity(userId, externalSourceGUID, externalSourceName, entityGUID, null, entityGUIDParameterName, entityTypeName, this.getClassificationTypeGUID(classification), classification.getName(), (InstanceAuditHeader)entityClassificationMap.get(entityClassificationName), forLineage, forDuplicateProcessing, effectiveTime, methodName);
                    }
                }
            }
        }
        catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException error) {
            throw error;
        }
        catch (Exception error) {
            this.errorHandler.handleRepositoryError(error, methodName, "updateEntityClassifications");
        }
    }

    private Classification getClassificationForEntity(String userId, String entityGUID, String entityGUIDParameterName, String entityTypeName, String classificationName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        EntityDetail entity = this.getEntityByGUID(userId, entityGUID, entityGUIDParameterName, entityTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (entity != null && classificationName != null && entity.getClassifications() != null) {
            for (Classification classification : entity.getClassifications()) {
                if (classification == null || !classificationName.equals(classification.getName())) continue;
                return classification;
            }
        }
        return null;
    }

    public EntityDetail updateEntity(String userId, String externalSourceGUID, String externalSourceName, String entityGUID, String entityTypeGUID, String entityTypeName, InstanceProperties properties, List<Classification> classifications, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String entityGUIDParameterName = "entityGUID";
        return this.updateEntity(userId, externalSourceGUID, externalSourceName, entityGUID, "entityGUID", entityTypeGUID, entityTypeName, properties, classifications, false, false, new Date(), methodName);
    }

    public EntityDetail updateEntity(String userId, String externalSourceGUID, String externalSourceName, String entityGUID, String entityGUIDParameterName, String entityTypeGUID, String entityTypeName, InstanceProperties properties, List<Classification> classifications, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        EntityDetail entity = this.updateEntityProperties(userId, externalSourceGUID, externalSourceName, entityGUID, entityGUIDParameterName, entityTypeGUID, entityTypeName, properties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.updateEntityClassifications(userId, externalSourceGUID, externalSourceName, entity.getGUID(), entityGUIDParameterName, entityTypeName, entity.getClassifications(), classifications, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        return entity;
    }

    public void updateEntityProperties(String userId, String externalSourceGUID, String externalSourceName, InstanceHeader entityHeader, String entityTypeGUID, String entityTypeName, InstanceProperties properties, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "updateEntityProperties";
        String typeGUIDParameterName = "entityTypeGUID";
        String typeNameParameterName = "entityTypeName";
        this.errorHandler.validateTypeIdentifiers(entityTypeGUID, "entityTypeGUID", entityTypeName, "entityTypeName", methodName, "updateEntityProperties");
        try {
            this.errorHandler.validateProvenance(userId, (InstanceAuditHeader)entityHeader, entityHeader.getGUID(), externalSourceGUID, externalSourceName, methodName);
            EntityDetail newEntity = this.metadataCollection.updateEntityProperties(userId, entityHeader.getGUID(), properties);
            if (newEntity == null) {
                this.errorHandler.handleNoEntity(entityTypeGUID, entityTypeName, properties, methodName);
            }
        }
        catch (UserNotAuthorizedException error) {
            throw error;
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Exception error) {
            this.errorHandler.handleRepositoryError(error, methodName, "updateEntityProperties");
        }
    }

    public void updateEntityStatus(String userId, String externalSourceGUID, String externalSourceName, String entityGUID, EntityDetail entity, String entityTypeGUID, String entityTypeName, InstanceStatus instanceStatus, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "entityGUID";
        String localMethodName = "updateEntityStatus";
        String typeGUIDParameterName = "entityTypeGUID";
        String typeNameParameterName = "entityTypeName";
        this.errorHandler.validateTypeIdentifiers(entityTypeGUID, "entityTypeGUID", entityTypeName, "entityTypeName", methodName, "updateEntityStatus");
        EntityDetail retrievedEntity = entity;
        if (retrievedEntity == null) {
            retrievedEntity = this.getEntityByGUID(userId, entityGUID, "entityGUID", entityTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        try {
            this.errorHandler.validateProvenance(userId, (InstanceAuditHeader)retrievedEntity, retrievedEntity.getGUID(), externalSourceGUID, externalSourceName, methodName);
            EntityDetail newEntity = this.metadataCollection.updateEntityStatus(userId, entityGUID, instanceStatus);
            if (newEntity == null) {
                this.errorHandler.handleNoEntity(entityTypeGUID, entityTypeName, null, methodName);
            }
        }
        catch (UserNotAuthorizedException error) {
            throw error;
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Exception error) {
            this.errorHandler.handleRepositoryError(error, methodName, "updateEntityStatus");
        }
    }

    public EntityDetail classifyEntity(String userId, String externalSourceGUID, String externalSourceName, String entityGUID, EntityDetail entityDetail, String entityGUIDParameterName, String entityTypeName, String classificationTypeGUID, String classificationTypeName, ClassificationOrigin classificationOrigin, String classificationOriginGUID, InstanceProperties properties, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "classifyEntity";
        String typeGUIDParameterName = "classificationTypeGUID";
        String typeNameParameterName = "classificationTypeName";
        this.errorHandler.validateTypeIdentifiers(classificationTypeGUID, "classificationTypeGUID", classificationTypeName, "classificationTypeName", methodName, "classifyEntity");
        try {
            EntityProxy entityProxy;
            Classification newClassification;
            if (entityDetail == null) {
                entityDetail = this.getEntityByGUID(userId, entityGUID, entityGUIDParameterName, entityTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
            if ((newClassification = this.metadataCollection.classifyEntity(userId, entityProxy = this.repositoryHelper.getNewEntityProxy(userId, entityDetail), classificationTypeName, externalSourceGUID, externalSourceName, classificationOrigin, classificationOriginGUID, properties)) != null) {
                List<Classification> classifications = entityDetail.getClassifications() == null ? new ArrayList() : entityDetail.getClassifications();
                classifications.add(newClassification);
                entityDetail.setClassifications(classifications);
                return entityDetail;
            }
            this.errorHandler.handleNoEntityForClassification(entityGUID, classificationTypeGUID, classificationTypeName, properties, methodName);
        }
        catch (PropertyServerException | UserNotAuthorizedException error) {
            throw error;
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (ClassificationErrorException error) {
            try {
                entityDetail = this.getEntityByGUID(userId, entityGUID, entityGUIDParameterName, entityTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
                if (entityDetail.getClassifications() != null) {
                    for (Classification classification : entityDetail.getClassifications()) {
                        if (!classificationTypeName.equals(classification.getName())) continue;
                        if (classification.getProperties() == null ? properties == null : classification.getProperties().equals((Object)properties)) {
                            return entityDetail;
                        }
                        this.errorHandler.handleRepositoryError((Exception)((Object)error), methodName, "classifyEntity");
                    }
                    this.errorHandler.handleRepositoryError((Exception)((Object)error), methodName, "classifyEntity");
                }
                this.errorHandler.handleRepositoryError((Exception)((Object)error), methodName, "classifyEntity");
            }
            catch (Exception nestedError) {
                this.errorHandler.handleRepositoryError((Exception)((Object)error), methodName, "classifyEntity");
            }
        }
        catch (Exception error) {
            this.errorHandler.handleRepositoryError(error, methodName, "classifyEntity");
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void reclassifyEntity(String userId, String externalSourceGUID, String externalSourceName, String entityGUID, String entityGUIDParameterName, String entityTypeName, String classificationTypeGUID, String classificationTypeName, InstanceAuditHeader existingClassificationHeader, InstanceProperties newProperties, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "reclassifyEntity";
        String typeGUIDParameterName = "classificationTypeGUID";
        String typeNameParameterName = "classificationTypeName";
        this.errorHandler.validateTypeIdentifiers(classificationTypeGUID, "classificationTypeGUID", classificationTypeName, "classificationTypeName", methodName, "reclassifyEntity");
        InstanceAuditHeader auditHeader = existingClassificationHeader;
        if (auditHeader == null) {
            auditHeader = this.getClassificationForEntity(userId, entityGUID, entityGUIDParameterName, entityTypeName, classificationTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        if (auditHeader != null) {
            try {
                this.errorHandler.validateProvenance(userId, existingClassificationHeader, entityGUID, externalSourceGUID, externalSourceName, methodName);
                EntityDetail entityDetail = this.getEntityByGUID(userId, entityGUID, entityGUIDParameterName, entityTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
                EntityProxy entityProxy = this.repositoryHelper.getNewEntityProxy(userId, entityDetail);
                Classification newClassification = this.metadataCollection.updateEntityClassification(userId, entityProxy, classificationTypeName, newProperties);
                if (newClassification != null) return;
                this.errorHandler.handleNoEntityForClassification(entityGUID, classificationTypeGUID, classificationTypeName, newProperties, methodName);
                return;
            }
            catch (PropertyServerException | UserNotAuthorizedException error) {
                throw error;
            }
            catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
                this.errorHandler.handleUnauthorizedUser(userId, methodName);
                return;
            }
            catch (Exception error) {
                this.errorHandler.handleRepositoryError(error, methodName, "reclassifyEntity(" + classificationTypeName + ")");
                return;
            }
        } else {
            this.classifyEntity(userId, externalSourceGUID, externalSourceName, entityGUID, null, entityGUIDParameterName, entityTypeName, classificationTypeGUID, classificationTypeName, ClassificationOrigin.ASSIGNED, null, newProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
    }

    public void declassifyEntity(String userId, String externalSourceGUID, String externalSourceName, String entityGUID, EntityDetail entity, String entityGUIDParameterName, String entityTypeName, String classificationTypeGUID, String classificationTypeName, InstanceAuditHeader existingClassificationHeader, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "declassifyEntity";
        String typeGUIDParameterName = "classificationTypeGUID";
        String typeNameParameterName = "classificationTypeName";
        this.errorHandler.validateTypeIdentifiers(classificationTypeGUID, "classificationTypeGUID", classificationTypeName, "classificationTypeName", methodName, "declassifyEntity");
        InstanceAuditHeader auditHeader = existingClassificationHeader;
        if (auditHeader == null) {
            auditHeader = this.getClassificationForEntity(userId, entityGUID, entityGUIDParameterName, entityTypeName, classificationTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        if (auditHeader != null) {
            try {
                EntityProxy entityProxy;
                Classification removedClassification;
                this.errorHandler.validateProvenance(userId, auditHeader, entityGUID, externalSourceGUID, externalSourceName, methodName);
                EntityDetail entityDetail = entity;
                if (entityDetail == null) {
                    entityDetail = this.getEntityByGUID(userId, entityGUID, entityGUIDParameterName, entityTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
                }
                if ((removedClassification = this.metadataCollection.declassifyEntity(userId, entityProxy = this.repositoryHelper.getNewEntityProxy(userId, entityDetail), classificationTypeName)) == null) {
                    this.errorHandler.handleNoEntityForClassification(entityGUID, classificationTypeGUID, classificationTypeName, null, methodName);
                }
            }
            catch (UserNotAuthorizedException error) {
                throw error;
            }
            catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
                this.errorHandler.handleUnauthorizedUser(userId, methodName);
            }
            catch (Exception error) {
                this.errorHandler.handleRepositoryError(error, methodName, "declassifyEntity");
            }
        }
    }

    public void removeEntity(String userId, String externalSourceGUID, String externalSourceName, String obsoleteEntityGUID, String obsoleteEntityGUIDParameterName, String entityTypeGUID, String entityTypeName, String validatingPropertyName, String validatingProperty, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.removeEntity(userId, externalSourceGUID, externalSourceName, obsoleteEntityGUID, obsoleteEntityGUIDParameterName, entityTypeGUID, entityTypeName, validatingPropertyName, validatingProperty, false, false, new Date(), methodName);
    }

    public void removeEntity(String userId, String externalSourceGUID, String externalSourceName, String obsoleteEntityGUID, String obsoleteEntityGUIDParameterName, String entityTypeGUID, String entityTypeName, String validatingPropertyName, String validatingProperty, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "removeEntity";
        String typeGUIDParameterName = "entityTypeGUID";
        String typeNameParameterName = "entityTypeName";
        this.errorHandler.validateTypeIdentifiers(entityTypeGUID, "entityTypeGUID", entityTypeName, "entityTypeName", methodName, "removeEntity");
        try {
            EntityDetail obsoleteEntity = this.getEntityByGUID(userId, obsoleteEntityGUID, obsoleteEntityGUIDParameterName, entityTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            if (obsoleteEntity != null) {
                this.errorHandler.validateProvenance(userId, (InstanceAuditHeader)obsoleteEntity, obsoleteEntity.getGUID(), externalSourceGUID, externalSourceName, methodName);
                this.errorHandler.validateProperties(obsoleteEntity.getGUID(), validatingPropertyName, validatingProperty, obsoleteEntity.getProperties(), methodName);
                this.isolateAndRemoveEntity(userId, externalSourceGUID, externalSourceName, obsoleteEntity.getGUID(), entityTypeGUID, entityTypeName, forLineage, forDuplicateProcessing, methodName);
            }
        }
        catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException error) {
            throw error;
        }
        catch (Exception error) {
            this.errorHandler.handleRepositoryError(error, methodName, "removeEntity");
        }
    }

    public void removeEntityOnLastUse(String userId, String externalSourceGUID, String externalSourceName, String obsoleteEntityGUID, String guidParameterName, String entityTypeGUID, String entityTypeName, boolean forLineage, boolean forDuplicateProcessing, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "removeEntityOnLastUse";
        String typeGUIDParameterName = "entityTypeGUID";
        String typeNameParameterName = "entityTypeName";
        this.errorHandler.validateTypeIdentifiers(entityTypeGUID, "entityTypeGUID", entityTypeName, "entityTypeName", methodName, "removeEntityOnLastUse");
        try {
            List relationships = this.metadataCollection.getRelationshipsForEntity(userId, obsoleteEntityGUID, null, 0, null, null, null, null, 5);
            if (relationships == null || relationships.isEmpty()) {
                this.isolateAndRemoveEntity(userId, externalSourceGUID, externalSourceName, obsoleteEntityGUID, entityTypeGUID, entityTypeName, forLineage, forDuplicateProcessing, methodName);
            }
        }
        catch (EntityNotKnownException error) {
            this.errorHandler.handleUnknownEntity((Exception)((Object)error), obsoleteEntityGUID, entityTypeName, methodName, guidParameterName);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Exception error) {
            this.errorHandler.handleRepositoryError(error, methodName, "removeEntityOnLastUse");
        }
    }

    private void isolateAndRemoveEntity(String userId, String externalSourceGUID, String externalSourceName, String obsoleteEntityGUID, String entityTypeGUID, String entityTypeName, boolean forLineage, boolean forDuplicateProcessing, String methodName) throws UserNotAuthorizedException, PropertyServerException, InvalidParameterException {
        String localMethodName = "isolateAndRemoveEntity";
        String typeGUIDParameterName = "entityTypeGUID";
        String typeNameParameterName = "entityTypeName";
        this.errorHandler.validateTypeIdentifiers(entityTypeGUID, "entityTypeGUID", entityTypeName, "entityTypeName", methodName, "isolateAndRemoveEntity");
        this.removeAllRelationshipsOfType(userId, externalSourceGUID, externalSourceName, obsoleteEntityGUID, entityTypeName, null, null, forLineage, forDuplicateProcessing, null, methodName);
        try {
            this.metadataCollection.deleteEntity(userId, entityTypeGUID, entityTypeName, obsoleteEntityGUID);
        }
        catch (FunctionNotSupportedException error) {
            this.purgeEntity(userId, obsoleteEntityGUID, entityTypeGUID, entityTypeName, methodName);
        }
        catch (Exception error) {
            this.errorHandler.handleRepositoryError(error, methodName, "isolateAndRemoveEntity");
        }
    }

    public void purgeEntity(String userId, String obsoleteEntityGUID, String entityTypeGUID, String entityTypeName, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "purgeEntity";
        String typeGUIDParameterName = "entityTypeGUID";
        String typeNameParameterName = "entityTypeName";
        this.errorHandler.validateTypeIdentifiers(entityTypeGUID, "entityTypeGUID", entityTypeName, "entityTypeName", methodName, "purgeEntity");
        try {
            this.metadataCollection.purgeEntity(userId, entityTypeGUID, entityTypeName, obsoleteEntityGUID);
            this.auditLog.logMessage(methodName, RepositoryHandlerAuditCode.ENTITY_PURGED.getMessageDefinition(obsoleteEntityGUID, entityTypeName, entityTypeGUID, methodName, this.metadataCollection.getMetadataCollectionId(userId)));
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Exception error) {
            this.errorHandler.handleRepositoryError(error, methodName, "purgeEntity");
        }
    }

    public void restoreEntity(String userId, String externalSourceGUID, String externalSourceName, String deletedEntityGUID, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "restoreEntity";
        try {
            EntityDetail entity = this.metadataCollection.restoreEntity(userId, deletedEntityGUID);
            if (entity != null) {
                this.errorHandler.validateProvenance(userId, (InstanceAuditHeader)entity, deletedEntityGUID, externalSourceGUID, externalSourceName, methodName);
            }
        }
        catch (UserNotAuthorizedException error) {
            throw error;
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Exception error) {
            this.errorHandler.handleRepositoryError(error, methodName, "restoreEntity");
        }
    }

    public List<EntityDetail> getEntitiesForType(String userId, String entityTypeGUID, String entityTypeName, boolean forLineage, boolean forDuplicateProcessing, int startingFrom, int pageSize, Date effectiveTime, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "getEntitiesForType";
        String typeGUIDParameterName = "entityTypeGUID";
        String typeNameParameterName = "entityTypeName";
        this.errorHandler.validateTypeIdentifiers(entityTypeGUID, "entityTypeGUID", entityTypeName, "entityTypeName", methodName, "getEntitiesForType");
        try {
            List retrievedEntities = this.metadataCollection.findEntitiesByProperty(userId, entityTypeGUID, null, null, startingFrom, null, null, null, null, null, pageSize);
            if (retrievedEntities != null) {
                return this.validateEntities(userId, retrievedEntities, entityTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
            if (log.isDebugEnabled()) {
                log.debug("No entities of type {}", (Object)entityTypeGUID);
            }
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Exception error) {
            this.errorHandler.handleRepositoryError(error, methodName, "getEntitiesForType");
        }
        return null;
    }

    public EntityDetail getEntityForRelationshipType(String userId, String startingEntityGUID, String startingEntityTypeName, String relationshipTypeGUID, String relationshipTypeName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String startingEntityGUIDParameterName = "startingEntityGUID";
        Date effectiveTime = new Date();
        EntityDetail startingEntity = this.getEntityByGUID(userId, startingEntityGUID, "startingEntityGUID", startingEntityTypeName, false, false, effectiveTime, methodName);
        return this.getEntityForRelationshipType(userId, startingEntity, startingEntityTypeName, relationshipTypeGUID, relationshipTypeName, null, 0, null, 0, false, false, effectiveTime, methodName);
    }

    public EntityDetail getEntityForRelationshipType(String userId, EntityDetail startingEntity, String startingEntityTypeName, String relationshipTypeGUID, String relationshipTypeName, String statusPropertyName, int statusThreshold, String returningEntityTypeName, int attachmentEntityEnd, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "getEntityForRelationshipType";
        String typeGUIDParameterName = "relationshipTypeGUID";
        String typeNameParameterName = "relationshipTypeName";
        this.errorHandler.validateTypeIdentifiers(relationshipTypeGUID, "relationshipTypeGUID", relationshipTypeName, "relationshipTypeName", methodName, "getEntityForRelationshipType");
        List<Relationship> filteredRelationships = this.getRelationshipsByType(userId, startingEntity, startingEntityTypeName, relationshipTypeGUID, relationshipTypeName, attachmentEntityEnd, forLineage, forDuplicateProcessing, null, 0, 0, effectiveTime, methodName);
        Relationship resultingRelationship = null;
        if (filteredRelationships != null && filteredRelationships.size() == 1) {
            resultingRelationship = filteredRelationships.get(0);
            if (!this.errorHandler.validateStatus(statusPropertyName, statusThreshold, resultingRelationship.getProperties(), methodName)) {
                resultingRelationship = null;
            }
        } else if (filteredRelationships != null && filteredRelationships.size() > 1) {
            this.errorHandler.handleAmbiguousRelationships(startingEntity.getGUID(), startingEntityTypeName, relationshipTypeName, filteredRelationships, methodName);
        }
        if (resultingRelationship != null) {
            EntityProxy requiredEnd = resultingRelationship.getEntityOneProxy();
            EntityProxy startingEnd = resultingRelationship.getEntityTwoProxy();
            if (startingEntity.getGUID().equals(requiredEnd.getGUID())) {
                requiredEnd = resultingRelationship.getEntityTwoProxy();
                startingEnd = resultingRelationship.getEntityOneProxy();
            }
            this.errorHandler.validateInstanceType((InstanceHeader)startingEnd, startingEntityTypeName, methodName, "getEntityForRelationshipType");
            this.errorHandler.validateInstanceType((InstanceHeader)requiredEnd, returningEntityTypeName, methodName, "getEntityForRelationshipType");
            String guidParameterName = "requiredEnd.getGUID";
            return this.getEntityByGUID(userId, requiredEnd.getGUID(), "requiredEnd.getGUID", returningEntityTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        return null;
    }

    @Deprecated
    public List<EntityDetail> getEntitiesForRelationshipType(String userId, String startingEntityGUID, String startingEntityTypeName, String relationshipTypeGUID, String relationshipTypeName, int startingFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getEntitiesForRelationshipType(userId, startingEntityGUID, startingEntityTypeName, relationshipTypeGUID, relationshipTypeName, null, 0, false, false, startingFrom, pageSize, new Date(), methodName);
    }

    public List<EntityDetail> getEntitiesForRelationshipType(String userId, String startingEntityGUID, String startingEntityTypeName, String relationshipTypeGUID, String relationshipTypeName, String sequencingPropertyName, int attachmentEntityEnd, boolean forLineage, boolean forDuplicateProcessing, int startingFrom, int pageSize, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "getEntitiesForRelationshipType";
        String typeGUIDParameterName = "relationshipTypeGUID";
        String typeNameParameterName = "relationshipTypeName";
        this.errorHandler.validateTypeIdentifiers(relationshipTypeGUID, "relationshipTypeGUID", relationshipTypeName, "relationshipTypeName", methodName, "getEntitiesForRelationshipType");
        String guidParameterName = "startingEntityGUID";
        EntityDetail startingEntity = this.getEntityByGUID(userId, startingEntityGUID, "startingEntityGUID", startingEntityTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (startingEntity != null) {
            List<Relationship> relationships = this.getRelationshipsByType(userId, startingEntity, startingEntityTypeName, relationshipTypeGUID, relationshipTypeName, attachmentEntityEnd, forLineage, forDuplicateProcessing, sequencingPropertyName, startingFrom, pageSize, effectiveTime, methodName);
            if (relationships != null) {
                ArrayList<EntityDetail> results = new ArrayList<EntityDetail>();
                for (Relationship relationship : relationships) {
                    EntityProxy requiredEnd;
                    EntityDetail entity;
                    if (relationship == null || (entity = this.getEntityByGUID(userId, (requiredEnd = this.getOtherEnd(startingEntityGUID, startingEntityTypeName, relationship, attachmentEntityEnd, methodName)).getGUID(), "startingEntityGUID", requiredEnd.getType().getTypeDefName(), forLineage, forDuplicateProcessing, effectiveTime, methodName)) == null) continue;
                    results.add(entity);
                }
                return this.validateEntities(userId, results, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
            if (log.isDebugEnabled()) {
                log.debug("No relationships of type " + relationshipTypeName + " found for " + startingEntityTypeName + " entity " + startingEntityGUID);
            }
        }
        return null;
    }

    private List<Relationship> filterRelationshipsByEntityEnd(List<Relationship> receivedRelationships, EntityDetail retrievingEntity, int attachmentEntityEnd, boolean forDuplicateProcessing) {
        ArrayList<Relationship> filteredRelationships;
        List<Relationship> notDeDupRelationships;
        if (receivedRelationships == null) {
            log.debug("No relationships retrieved for entity " + retrievingEntity.getGUID());
            return null;
        }
        if (forDuplicateProcessing) {
            notDeDupRelationships = receivedRelationships;
        } else {
            notDeDupRelationships = new ArrayList<Relationship>();
            for (Relationship receivedRelationship : receivedRelationships) {
                if (receivedRelationship == null || peerDuplicateLink.equals(receivedRelationship.getType().getTypeDefName()) || consolidatedDuplicateLinkName.equals(receivedRelationship.getType().getTypeDefName())) continue;
                notDeDupRelationships.add(receivedRelationship);
            }
        }
        if (attachmentEntityEnd == 1) {
            filteredRelationships = new ArrayList<Relationship>();
            for (Relationship retrievedRelationship : notDeDupRelationships) {
                if (retrievedRelationship == null || !retrievingEntity.getGUID().equals(retrievedRelationship.getEntityTwoProxy().getGUID())) continue;
                filteredRelationships.add(retrievedRelationship);
            }
            log.debug(filteredRelationships.size() + " relationships returned after filtering for attachmentEntityEnd=1 and entity " + retrievingEntity.getGUID());
            return filteredRelationships;
        }
        if (attachmentEntityEnd == 2) {
            filteredRelationships = new ArrayList();
            for (Relationship retrievedRelationship : notDeDupRelationships) {
                if (retrievedRelationship == null || !retrievingEntity.getGUID().equals(retrievedRelationship.getEntityOneProxy().getGUID())) continue;
                filteredRelationships.add(retrievedRelationship);
            }
            log.debug(filteredRelationships.size() + " relationships returned after filtering for attachmentEntityEnd=2 and entity " + retrievingEntity.getGUID());
            return filteredRelationships;
        }
        log.debug(notDeDupRelationships.size() + " relationships returned after filtering for attachmentEntityEnd=0 and entity " + retrievingEntity.getGUID());
        return notDeDupRelationships;
    }

    public List<EntityDetail> getEntitiesForClassificationType(String userId, String entityTypeGUID, String classificationName, boolean forLineage, boolean forDuplicateProcessing, int startingFrom, int pageSize, Date effectiveTime, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "getEntitiesForClassificationType";
        try {
            List retrievedEntities = this.metadataCollection.findEntitiesByClassification(userId, entityTypeGUID, classificationName, null, null, startingFrom, null, null, null, SequencingOrder.ANY, pageSize);
            if (retrievedEntities != null) {
                return this.validateEntities(userId, retrievedEntities, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
            if (log.isDebugEnabled()) {
                log.debug("No entities of type {} with classification {}.", (Object)entityTypeGUID, (Object)classificationName);
            }
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Exception error) {
            this.errorHandler.handleRepositoryError(error, methodName, "getEntitiesForClassificationType");
        }
        return null;
    }

    public List<EntityDetail> getEntitiesForRelationshipEnd(String userId, String startEntityGUID, String startEntityTypeName, boolean startAtEnd1, String relationshipTypeGUID, String relationshipTypeName, int startingFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (startAtEnd1) {
            return this.getEntitiesForRelationshipType(userId, startEntityGUID, startEntityTypeName, relationshipTypeGUID, relationshipTypeName, null, 2, false, false, startingFrom, pageSize, new Date(), methodName);
        }
        return this.getEntitiesForRelationshipType(userId, startEntityGUID, startEntityTypeName, relationshipTypeGUID, relationshipTypeName, null, 1, false, false, startingFrom, pageSize, new Date(), methodName);
    }

    public EntityProxy getOtherEnd(String startingEntityGUID, Relationship relationship) {
        if (relationship != null) {
            EntityProxy entityProxy = relationship.getEntityOneProxy();
            if (entityProxy != null && startingEntityGUID.equals(entityProxy.getGUID())) {
                entityProxy = relationship.getEntityTwoProxy();
            }
            return entityProxy;
        }
        return null;
    }

    public EntityProxy getOtherEnd(String startingEntityGUID, String startingEntityTypeName, Relationship relationship, int attachmentEntityEnd, String methodName) throws InvalidParameterException {
        String localMethodName = "getOtherEnd";
        if (relationship != null) {
            if (attachmentEntityEnd == 1) {
                this.errorHandler.validateInstanceType((InstanceHeader)relationship.getEntityTwoProxy(), startingEntityTypeName, methodName, "getOtherEnd");
                return relationship.getEntityOneProxy();
            }
            if (attachmentEntityEnd == 2) {
                this.errorHandler.validateInstanceType((InstanceHeader)relationship.getEntityOneProxy(), startingEntityTypeName, methodName, "getOtherEnd");
                return relationship.getEntityTwoProxy();
            }
            EntityProxy requiredEnd = relationship.getEntityOneProxy();
            EntityProxy startingEnd = relationship.getEntityTwoProxy();
            if (startingEntityGUID.equals(requiredEnd.getGUID())) {
                requiredEnd = relationship.getEntityTwoProxy();
                startingEnd = relationship.getEntityOneProxy();
            }
            this.errorHandler.validateInstanceType((InstanceHeader)startingEnd, startingEntityTypeName, methodName, "getOtherEnd");
            return requiredEnd;
        }
        return null;
    }

    public EntityDetail getEntityByGUID(String userId, String guid, String guidParameterName, String entityTypeName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "getEntityByGUID";
        EntityDetail entity = this.validateEntityGUID(userId, guid, guidParameterName, entityTypeName, methodName);
        if (entity != null) {
            log.debug("retrievedEntity=" + entity.getGUID());
        } else {
            log.debug("No retrievedEntity");
        }
        EntityDetail verifiedEntity = this.validateRetrievedEntity(userId, entity, entityTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (verifiedEntity != null) {
            log.debug("verifiedEntity=" + verifiedEntity.getGUID());
            return verifiedEntity;
        }
        if (entity != null) {
            log.debug("No verifiedEntity");
            ArrayList<String> classificationNames = new ArrayList<String>();
            if (entity.getClassifications() != null) {
                for (Classification classification : entity.getClassifications()) {
                    if (classification == null) continue;
                    classificationNames.add(classification.getName());
                }
            }
            Object effectiveFromString = "<null>";
            Object effectiveToString = "<null>";
            Object effectiveTimeString = "<null>";
            if (effectiveTime != null) {
                effectiveTimeString = effectiveTime + " (" + effectiveTime.getTime() + ")";
            }
            if (entity.getProperties() != null) {
                if (entity.getProperties().getEffectiveFromTime() != null) {
                    effectiveFromString = entity.getProperties().getEffectiveFromTime().toString() + " (" + entity.getProperties().getEffectiveFromTime().getTime() + ")";
                }
                if (entity.getProperties().getEffectiveToTime() != null) {
                    effectiveToString = entity.getProperties().getEffectiveToTime().toString() + " (" + entity.getProperties().getEffectiveToTime().getTime() + ")";
                }
            }
            InvalidParameterException error = new InvalidParameterException(RepositoryHandlerErrorCode.UNAVAILABLE_ENTITY.getMessageDefinition(new String[]{entityTypeName, guid, "getEntityByGUID", methodName, userId, effectiveTimeString, effectiveFromString, effectiveToString, ((Object)classificationNames).toString(), Boolean.toString(forLineage), Boolean.toString(forDuplicateProcessing)}), this.getClass().getName(), methodName, guidParameterName);
            this.auditLog.logException("getEntityByGUID", RepositoryHandlerAuditCode.UNAVAILABLE_ENTITY.getMessageDefinition(new String[]{entityTypeName, guid, "getEntityByGUID", methodName, userId, effectiveTimeString, effectiveFromString, effectiveToString, ((Object)classificationNames).toString(), Boolean.toString(forLineage), Boolean.toString(forDuplicateProcessing)}), (Throwable)error);
            throw error;
        }
        throw new PropertyServerException(RepositoryHandlerErrorCode.NULL_ENTITY_RETURNED.getMessageDefinition(entityTypeName, guid, "getEntityByGUID", methodName, userId), this.getClass().getName(), methodName);
    }

    public boolean isEntityATypeOf(String userId, String guid, String guidParameterName, String entityTypeName, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "isEntityATypeOf";
        try {
            EntityDetail entity = this.metadataCollection.getEntityDetail(userId, guid);
            if (entity == null || !this.isCorrectEffectiveTime(entity.getProperties(), effectiveTime)) {
                this.errorHandler.handleUnknownEntity(null, guid, entityTypeName, methodName, guidParameterName);
            }
            return this.errorHandler.isInstanceATypeOf((InstanceHeader)entity, entityTypeName, methodName);
        }
        catch (EntityNotKnownException error) {
            this.errorHandler.handleUnknownEntity((Exception)((Object)error), guid, entityTypeName, methodName, guidParameterName);
        }
        catch (EntityProxyOnlyException error) {
            this.errorHandler.handleEntityProxy((Exception)((Object)error), guid, entityTypeName, methodName, guidParameterName);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Exception error) {
            this.errorHandler.handleRepositoryError(error, methodName, "isEntityATypeOf");
        }
        return false;
    }

    public List<EntityDetail> getEntitiesByName(String userId, InstanceProperties nameProperties, String entityTypeGUID, String sequencingPropertyName, boolean forLineage, boolean forDuplicateProcessing, int startingFrom, int pageSize, Date effectiveTime, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "getEntitiesByName";
        SequencingOrder sequencingOrder = SequencingOrder.GUID;
        if (sequencingPropertyName != null) {
            sequencingOrder = SequencingOrder.PROPERTY_ASCENDING;
        }
        try {
            List retrievedEntities = this.metadataCollection.findEntitiesByProperty(userId, entityTypeGUID, nameProperties, MatchCriteria.ANY, startingFrom, null, null, null, sequencingPropertyName, sequencingOrder, pageSize);
            return this.validateEntities(userId, retrievedEntities, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Exception error) {
            this.errorHandler.handleRepositoryError(error, methodName, "getEntitiesByName");
        }
        return null;
    }

    public List<EntityDetail> getEntitiesByAllProperties(String userId, InstanceProperties properties, String entityTypeGUID, String sequencingPropertyName, boolean forLineage, boolean forDuplicateProcessing, int startingFrom, int pageSize, Date effectiveTime, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "getEntitiesByAllProperties";
        SequencingOrder sequencingOrder = SequencingOrder.GUID;
        if (sequencingPropertyName != null) {
            sequencingOrder = SequencingOrder.PROPERTY_ASCENDING;
        }
        try {
            List retrievedEntities = this.metadataCollection.findEntitiesByProperty(userId, entityTypeGUID, properties, MatchCriteria.ALL, startingFrom, null, null, null, sequencingPropertyName, sequencingOrder, pageSize);
            return this.validateEntities(userId, retrievedEntities, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Exception error) {
            this.errorHandler.handleRepositoryError(error, methodName, "getEntitiesByAllProperties");
        }
        return null;
    }

    public List<EntityDetail> getEntitiesWithoutPropertyValues(String userId, InstanceProperties properties, String entityTypeGUID, String sequencingPropertyName, boolean forLineage, boolean forDuplicateProcessing, int startingFrom, int pageSize, Date effectiveTime, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "getEntitiesWithoutPropertyValues";
        SequencingOrder sequencingOrder = SequencingOrder.GUID;
        if (sequencingPropertyName != null) {
            sequencingOrder = SequencingOrder.PROPERTY_ASCENDING;
        }
        try {
            List retrievedEntities = this.metadataCollection.findEntitiesByProperty(userId, entityTypeGUID, properties, MatchCriteria.NONE, startingFrom, null, null, null, sequencingPropertyName, sequencingOrder, pageSize);
            return this.validateEntities(userId, retrievedEntities, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Exception error) {
            this.errorHandler.handleRepositoryError(error, methodName, "getEntitiesWithoutPropertyValues");
        }
        return null;
    }

    public List<EntityDetail> getEntitiesByValue(String userId, String propertyValue, String entityTypeGUID, String sequencingPropertyName, boolean forLineage, boolean forDuplicateProcessing, int startingFrom, int pageSize, Date effectiveTime, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "getEntitiesByValue";
        SequencingOrder sequencingOrder = SequencingOrder.GUID;
        if (sequencingPropertyName != null) {
            sequencingOrder = SequencingOrder.PROPERTY_ASCENDING;
        }
        try {
            List retrievedEntities = this.metadataCollection.findEntitiesByPropertyValue(userId, entityTypeGUID, propertyValue, startingFrom, null, null, null, sequencingPropertyName, sequencingOrder, pageSize);
            return this.validateEntities(userId, retrievedEntities, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Exception error) {
            this.errorHandler.handleRepositoryError(error, methodName, "getEntitiesByValue");
        }
        return null;
    }

    public List<EntityDetail> getEntitiesByPropertyValue(String userId, String entityTypeGUID, String searchCriteria, boolean forLineage, boolean forDuplicateProcessing, int startingFrom, int pageSize, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, Date effectiveTime, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "getEntitiesByPropertyValue";
        try {
            List retrievedEntities = this.metadataCollection.findEntitiesByPropertyValue(userId, entityTypeGUID, searchCriteria, startingFrom, null, null, asOfTime, sequencingProperty, sequencingOrder, pageSize);
            return this.validateEntities(userId, retrievedEntities, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Exception error) {
            this.errorHandler.handleRepositoryError(error, methodName, "getEntitiesByPropertyValue");
        }
        return null;
    }

    public EntityDetail getUniqueEntityByName(String userId, String nameValue, String nameParameterName, InstanceProperties nameProperties, String entityTypeGUID, String entityTypeName, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        return this.getUniqueEntityByName(userId, nameValue, nameParameterName, nameProperties, entityTypeGUID, entityTypeName, false, false, new Date(), methodName);
    }

    public EntityDetail getUniqueEntityByName(String userId, String nameValue, String nameParameterName, InstanceProperties nameProperties, String entityTypeGUID, String entityTypeName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "getUniqueEntityByName";
        String typeGUIDParameterName = "entityTypeGUID";
        String typeNameParameterName = "entityTypeName";
        this.errorHandler.validateTypeIdentifiers(entityTypeGUID, "entityTypeGUID", entityTypeName, "entityTypeName", methodName, "getUniqueEntityByName");
        try {
            List retrievedEntities = this.metadataCollection.findEntitiesByProperty(userId, entityTypeGUID, nameProperties, MatchCriteria.ANY, 0, null, null, null, null, null, 2);
            List<EntityDetail> effectiveEntities = this.validateEntities(userId, retrievedEntities, entityTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            if (effectiveEntities == null || effectiveEntities.isEmpty()) {
                return null;
            }
            if (effectiveEntities.size() == 1) {
                return effectiveEntities.get(0);
            }
            this.errorHandler.handleAmbiguousEntityName(nameValue, nameParameterName, entityTypeName, effectiveEntities, methodName);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Exception error) {
            this.errorHandler.handleRepositoryError(error, methodName, "getUniqueEntityByName");
        }
        return null;
    }

    public List<EntityDetail> getEntitiesByType(String userId, String entityTypeGUID, int startingFrom, int pageSize, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        return this.getEntitiesByType(userId, entityTypeGUID, false, false, startingFrom, pageSize, null, null, null, new Date(), methodName);
    }

    public List<EntityDetail> getEntitiesByType(String userId, String entityTypeGUID, boolean forLineage, boolean forDuplicateProcessing, int startingFrom, int pageSize, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, Date effectiveTime, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "getEntitiesByType";
        try {
            List retrievedEntities = this.metadataCollection.findEntitiesByProperty(userId, entityTypeGUID, null, null, startingFrom, null, null, asOfTime, sequencingProperty, sequencingOrder, pageSize);
            return this.validateEntities(userId, retrievedEntities, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Exception error) {
            this.errorHandler.handleRepositoryError(error, methodName, "getEntitiesByType");
        }
        return null;
    }

    public List<EntityDetail> findEntities(String userId, String entityTypeGUID, List<String> entitySubtypeGUIDs, SearchProperties searchProperties, List<InstanceStatus> limitResultsByStatus, SearchClassifications searchClassifications, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, boolean forLineage, boolean forDuplicateProcessing, int startingFrom, int pageSize, Date effectiveTime, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "findEntities";
        try {
            List retrievedEntities = this.metadataCollection.findEntities(userId, entityTypeGUID, entitySubtypeGUIDs, searchProperties, startingFrom, limitResultsByStatus, searchClassifications, asOfTime, sequencingProperty, sequencingOrder, pageSize);
            return this.validateEntities(userId, retrievedEntities, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Exception error) {
            this.errorHandler.handleRepositoryError(error, methodName, "findEntities");
        }
        return null;
    }

    public List<Relationship> findRelationships(String userId, String relationshipTypeGUID, List<String> relationshipSubtypeGUIDs, SearchProperties searchProperties, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, boolean forDuplicateProcessing, int startingFrom, int pageSize, Date effectiveTime, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "findRelationships";
        try {
            List relationships = this.metadataCollection.findRelationships(userId, relationshipTypeGUID, relationshipSubtypeGUIDs, searchProperties, startingFrom, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
            if (relationships != null) {
                RelationshipAccumulator accumulator = new RelationshipAccumulator(this.repositoryHelper, this, this.errorHandler, forDuplicateProcessing, effectiveTime, methodName);
                accumulator.addRelationships(relationships);
                return accumulator.getRelationships();
            }
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Exception error) {
            this.errorHandler.handleRepositoryError(error, methodName, "findRelationships");
        }
        return null;
    }

    public Relationship getRelationshipByGUID(String userId, String relationshipGUID, String relationshipParameterName, String relationshipTypeName, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "getRelationshipByGUID";
        try {
            Relationship relationship = this.metadataCollection.getRelationship(userId, relationshipGUID);
            this.errorHandler.validateInstanceType((InstanceHeader)relationship, relationshipTypeName, methodName, "getRelationshipByGUID");
            if (this.isCorrectEffectiveTime(relationship.getProperties(), effectiveTime)) {
                return relationship;
            }
            this.errorHandler.handleNotEffectiveElement(relationshipGUID, relationshipTypeName, relationship.getProperties(), methodName, relationshipParameterName, effectiveTime);
        }
        catch (RelationshipNotKnownException error) {
            this.errorHandler.handleUnknownRelationship((Exception)((Object)error), relationshipGUID, relationshipTypeName, methodName, relationshipParameterName);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Exception error) {
            this.errorHandler.handleRepositoryError(error, methodName, "getRelationshipByGUID");
        }
        return null;
    }

    public List<Relationship> getRelationshipsByType(String userId, String startingEntityGUID, String startingEntityTypeName, String relationshipTypeGUID, String relationshipTypeName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getRelationshipsByType(userId, startingEntityGUID, startingEntityTypeName, relationshipTypeGUID, relationshipTypeName, 0, false, false, 0, this.maxPageSize, new Date(), methodName);
    }

    public List<Relationship> getRelationshipsByType(String userId, String startingEntityGUID, String startingEntityTypeName, String relationshipTypeGUID, String relationshipTypeName, int attachmentEntityEnd, boolean forLineage, boolean forDuplicateProcessing, int startingFrom, int pageSize, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "startingEntityGUID";
        EntityDetail startingEntity = this.getEntityByGUID(userId, startingEntityGUID, "startingEntityGUID", startingEntityTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (startingEntity != null) {
            return this.getRelationshipsByType(userId, startingEntity, startingEntityTypeName, relationshipTypeGUID, relationshipTypeName, attachmentEntityEnd, forLineage, forDuplicateProcessing, null, startingFrom, pageSize, effectiveTime, methodName);
        }
        return null;
    }

    public List<Relationship> getRelationshipsByType(String userId, EntityDetail startingEntity, String startingEntityTypeName, String relationshipTypeGUID, String relationshipTypeName, int attachmentEntityEnd, boolean forLineage, boolean forDuplicateProcessing, String sequencingPropertyName, int startingFrom, int pageSize, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "getRelationshipsByType";
        String typeGUIDParameterName = "relationshipTypeGUID";
        String typeNameParameterName = "relationshipTypeName";
        this.errorHandler.validateTypeIdentifiers(relationshipTypeGUID, "relationshipTypeGUID", relationshipTypeName, "relationshipTypeName", methodName, "getRelationshipsByType");
        this.errorHandler.validateInstanceType((InstanceHeader)startingEntity, startingEntityTypeName, methodName, "getRelationshipsByType");
        SequencingOrder sequencingOrder = SequencingOrder.GUID;
        if (sequencingPropertyName != null) {
            sequencingOrder = SequencingOrder.PROPERTY_ASCENDING;
        }
        if (!forDuplicateProcessing) {
            DuplicateEntityIterator duplicateEntityIterator = new DuplicateEntityIterator(this, this.errorHandler, this.invalidParameterHandler, userId, startingEntity, startingEntityTypeName, forLineage, false, effectiveTime, methodName);
            if (duplicateEntityIterator.morePeersToReceive()) {
                EntityProxy startingProxy = new EntityProxy((EntitySummary)startingEntity);
                startingProxy.setUniqueProperties(this.repositoryHelper.getUniqueProperties(methodName, startingEntity.getType().getTypeDefName(), startingEntity.getProperties()));
                RelationshipAccumulator accumulator = new RelationshipAccumulator(this.repositoryHelper, this, this.errorHandler, false, effectiveTime, methodName);
                do {
                    EntityDetail retrievingEntity = duplicateEntityIterator.getNextPeer();
                    try {
                        List retrievedRelationships = this.metadataCollection.getRelationshipsForEntity(userId, retrievingEntity.getGUID(), relationshipTypeGUID, startingFrom, null, null, sequencingPropertyName, sequencingOrder, pageSize);
                        accumulator.addRelationships(startingProxy, retrievingEntity.getGUID(), this.filterRelationshipsByEntityEnd(retrievedRelationships, retrievingEntity, attachmentEntityEnd, forDuplicateProcessing));
                    }
                    catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
                        this.errorHandler.handleUnauthorizedUser(userId, methodName);
                    }
                    catch (Exception error) {
                        this.errorHandler.handleRepositoryError(error, methodName, "getRelationshipsByType");
                    }
                } while (duplicateEntityIterator.morePeersToReceive());
                return accumulator.getRelationships(startingEntity.getGUID(), attachmentEntityEnd);
            }
        } else {
            try {
                List relationships = this.metadataCollection.getRelationshipsForEntity(userId, startingEntity.getGUID(), relationshipTypeGUID, startingFrom, null, null, sequencingPropertyName, sequencingOrder, pageSize);
                if (relationships == null || relationships.isEmpty()) {
                    if (log.isDebugEnabled()) {
                        log.debug("No relationships of type " + relationshipTypeGUID + " found for entity " + startingEntity.getGUID());
                    }
                    return null;
                }
                for (Relationship relationship : relationships) {
                    if (relationship == null) continue;
                    this.errorHandler.validateInstanceType((InstanceHeader)relationship, relationshipTypeName, methodName, "getRelationshipsByType");
                    this.getOtherEnd(startingEntity.getGUID(), startingEntityTypeName, relationship, attachmentEntityEnd, methodName);
                }
                return this.filterRelationshipsByEntityEnd(relationships, startingEntity, attachmentEntityEnd, forDuplicateProcessing);
            }
            catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
                this.errorHandler.handleUnauthorizedUser(userId, methodName);
            }
            catch (Exception error) {
                this.errorHandler.handleRepositoryError(error, methodName, "getRelationshipsByType");
            }
        }
        return null;
    }

    public int countAttachedRelationshipsByType(String userId, String startingEntityGUID, String startingEntityTypeName, String relationshipTypeGUID, String relationshipTypeName, int attachmentEntityEnd, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        List<Relationship> relationships = this.getRelationshipsByType(userId, startingEntityGUID, startingEntityTypeName, relationshipTypeGUID, relationshipTypeName, attachmentEntityEnd, forLineage, forDuplicateProcessing, 0, 0, effectiveTime, methodName);
        int count = 0;
        if (relationships != null) {
            for (Relationship relationship : relationships) {
                if (relationship == null) continue;
                ++count;
            }
        }
        return count;
    }

    public List<Relationship> getRelationshipsBetweenEntities(String userId, String entity1GUID, String entity1TypeName, String entity2GUID, String relationshipTypeGUID, String relationshipTypeName, int attachmentEntityEnd, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "getRelationshipsBetweenEntities";
        String typeGUIDParameterName = "relationshipTypeGUID";
        String typeNameParameterName = "relationshipTypeName";
        this.errorHandler.validateTypeIdentifiers(relationshipTypeGUID, "relationshipTypeGUID", relationshipTypeName, "relationshipTypeName", methodName, "getRelationshipsBetweenEntities");
        List<Relationship> entity1Relationships = this.getRelationshipsByType(userId, entity1GUID, entity1TypeName, relationshipTypeGUID, relationshipTypeName, attachmentEntityEnd, forLineage, forDuplicateProcessing, 0, 0, effectiveTime, methodName);
        if (entity1Relationships != null) {
            ArrayList<Relationship> results = new ArrayList<Relationship>();
            for (Relationship relationship : entity1Relationships) {
                EntityProxy entity2Proxy;
                if (relationship == null || !this.isCorrectEffectiveTime(relationship.getProperties(), effectiveTime) || (entity2Proxy = this.getOtherEnd(entity1GUID, entity1TypeName, relationship, attachmentEntityEnd, methodName)) == null || !entity2GUID.equals(entity2Proxy.getGUID())) continue;
                results.add(relationship);
            }
            if (!results.isEmpty()) {
                return results;
            }
        }
        return null;
    }

    public List<Relationship> getRelationshipsBetweenEntities(String userId, EntityDetail entity1Entity, String entity1TypeName, String entity2GUID, String relationshipTypeGUID, String relationshipTypeName, int attachmentEntityEnd, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, boolean exactMatchOnEffectivityDates, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List<Relationship> entity1Relationships;
        String localMethodName = "getRelationshipsBetweenEntities";
        String typeGUIDParameterName = "relationshipTypeGUID";
        String typeNameParameterName = "relationshipTypeName";
        this.errorHandler.validateTypeIdentifiers(relationshipTypeGUID, "relationshipTypeGUID", relationshipTypeName, "relationshipTypeName", methodName, "getRelationshipsBetweenEntities");
        long effectiveFromLong = Long.MIN_VALUE;
        long effectiveToLong = Long.MAX_VALUE;
        String effectiveFromString = "<null>";
        String effectiveToString = "<null>";
        if (effectiveFrom != null) {
            effectiveFromLong = effectiveFrom.getTime();
            effectiveFromString = effectiveFrom.toString();
        }
        if (effectiveTo != null) {
            effectiveToLong = effectiveTo.getTime();
            effectiveToString = effectiveTo.toString();
        }
        if ((entity1Relationships = this.getRelationshipsByType(userId, entity1Entity, entity1TypeName, relationshipTypeGUID, relationshipTypeName, attachmentEntityEnd, forLineage, forDuplicateProcessing, null, 0, 0, null, methodName)) != null) {
            ArrayList<Relationship> results = new ArrayList<Relationship>();
            for (Relationship relationship : entity1Relationships) {
                EntityProxy entity2Proxy;
                if (relationship == null || (entity2Proxy = this.getOtherEnd(entity1Entity.getGUID(), entity1TypeName, relationship, attachmentEntityEnd, methodName)) == null || !entity2GUID.equals(entity2Proxy.getGUID())) continue;
                if (relationship.getProperties() == null) {
                    if (!(effectiveFrom != null && effectiveFrom.getTime() != Long.MIN_VALUE || effectiveTo != null && effectiveTo.getTime() != Long.MAX_VALUE)) {
                        log.debug("{} also has maximum effectivity dates", (Object)relationship.getGUID());
                        results.add(relationship);
                        continue;
                    }
                    if (exactMatchOnEffectivityDates) {
                        log.error("{} has broader effectivity dates than requested", (Object)relationship.getGUID());
                        throw new InvalidParameterException(RepositoryHandlerErrorCode.BROADER_EFFECTIVE_RELATIONSHIP.getMessageDefinition(relationshipTypeName, relationship.getGUID(), effectiveFromString, effectiveToString), this.getClass().getName(), methodName, relationshipTypeName);
                    }
                    log.debug("{} has narrower effectivity dates", (Object)relationship.getGUID());
                    results.add(relationship);
                    continue;
                }
                long relationshipEffectiveFromLong = Long.MIN_VALUE;
                long relationshipEffectiveToLong = Long.MAX_VALUE;
                String relationshipEffectiveFromString = "<null>";
                String relationshipEffectiveToString = "<null>";
                if (relationship.getProperties().getEffectiveFromTime() != null) {
                    relationshipEffectiveFromLong = relationship.getProperties().getEffectiveFromTime().getTime();
                    relationshipEffectiveFromString = Long.toString(relationship.getProperties().getEffectiveFromTime().getTime());
                }
                if (relationship.getProperties().getEffectiveFromTime() != null) {
                    relationshipEffectiveToLong = relationship.getProperties().getEffectiveToTime().getTime();
                    relationshipEffectiveToString = Long.toString(relationship.getProperties().getEffectiveToTime().getTime());
                }
                if (relationshipEffectiveFromLong > effectiveToLong || relationshipEffectiveToLong < effectiveFromLong) {
                    log.debug("{} outside of requested effective dates and can be ignored", (Object)relationship.getGUID());
                    continue;
                }
                if (relationshipEffectiveFromLong == effectiveFromLong && relationshipEffectiveToLong == effectiveToLong) {
                    log.debug("{} has matching effective dates and can be returned", (Object)relationship.getGUID());
                    results.add(relationship);
                    continue;
                }
                if (relationshipEffectiveFromLong > effectiveFromLong && relationshipEffectiveToLong < effectiveToLong) {
                    if (exactMatchOnEffectivityDates) {
                        log.error("{} has narrower effectivity dates and exact match required", (Object)relationship.getGUID());
                        throw new InvalidParameterException(RepositoryHandlerErrorCode.NARROWER_EFFECTIVE_RELATIONSHIP.getMessageDefinition(relationshipTypeName, relationship.getGUID(), relationshipEffectiveFromString, relationshipEffectiveToString, effectiveFromString, effectiveToString), this.getClass().getName(), methodName, relationshipTypeName);
                    }
                    log.debug("{} has narrower effectivity dates and so can return", (Object)relationship.getGUID());
                    results.add(relationship);
                    continue;
                }
                log.error("{} has overlapping effectivity dates", (Object)relationship.getGUID());
                throw new InvalidParameterException(RepositoryHandlerErrorCode.OVERLAPPING_EFFECTIVE_RELATIONSHIPS.getMessageDefinition(relationshipTypeName, relationship.getGUID(), relationshipEffectiveFromString, relationshipEffectiveToString, effectiveFromString, effectiveToString), this.getClass().getName(), methodName, relationshipTypeName);
            }
            if (!results.isEmpty()) {
                return results;
            }
        }
        return null;
    }

    @Deprecated
    public Relationship getRelationshipBetweenEntities(String userId, String entity1GUID, String entity1TypeName, String entity2GUID, String relationshipTypeGUID, String relationshipTypeName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getRelationshipBetweenEntities(userId, entity1GUID, entity1TypeName, entity2GUID, relationshipTypeGUID, relationshipTypeName, false, false, new Date(), methodName);
    }

    public Relationship getRelationshipBetweenEntities(String userId, String entity1GUID, String entity1TypeName, String entity2GUID, String relationshipTypeGUID, String relationshipTypeName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "getRelationshipBetweenEntities";
        String typeGUIDParameterName = "relationshipTypeGUID";
        String typeNameParameterName = "relationshipTypeName";
        this.errorHandler.validateTypeIdentifiers(relationshipTypeGUID, "relationshipTypeGUID", relationshipTypeName, "relationshipTypeName", methodName, "getRelationshipBetweenEntities");
        List<Relationship> entity1Relationships = this.getRelationshipsBetweenEntities(userId, entity1GUID, entity1TypeName, entity2GUID, relationshipTypeGUID, relationshipTypeName, 2, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (entity1Relationships != null) {
            for (Relationship relationship : entity1Relationships) {
                if (relationship == null) continue;
                return relationship;
            }
        }
        return null;
    }

    public Relationship getUniqueParentRelationshipByType(String userId, String startingEntityGUID, String startingEntityTypeName, String relationshipTypeGUID, String relationshipTypeName, boolean parentAtEnd1, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "getUniqueParentRelationshipByType";
        String typeGUIDParameterName = "relationshipTypeGUID";
        String typeNameParameterName = "relationshipTypeName";
        this.errorHandler.validateTypeIdentifiers(relationshipTypeGUID, "relationshipTypeGUID", relationshipTypeName, "relationshipTypeName", methodName, "getUniqueParentRelationshipByType");
        try {
            int attachmentEntityEnd = 2;
            if (parentAtEnd1) {
                attachmentEntityEnd = 1;
            }
            RepositoryRelationshipsIterator iterator = new RepositoryRelationshipsIterator(this, this.invalidParameterHandler, userId, startingEntityGUID, startingEntityTypeName, relationshipTypeGUID, relationshipTypeName, attachmentEntityEnd, forLineage, forDuplicateProcessing, 0, this.maxPageSize, effectiveTime, methodName);
            while (iterator.moreToReceive()) {
                EntityProxy parentEntity;
                Relationship relationship = iterator.getNext();
                if (relationship == null) continue;
                if (log.isDebugEnabled()) {
                    log.debug("getUniqueParentRelationshipByType while (iterator.moreToReceive()");
                    log.debug("relationship.getGUID()=" + relationship.getGUID() + ", relationship.end1 guid=" + relationship.getEntityOneProxy().getGUID() + ",qualified name=" + relationship.getEntityOneProxy().getUniqueProperties().getInstanceProperties().get("qualifiedName") + "relationship.end2 guid " + relationship.getEntityTwoProxy().getGUID() + ",qualified name=" + relationship.getEntityTwoProxy().getUniqueProperties().getInstanceProperties().get("qualifiedName"));
                }
                if ((parentEntity = parentAtEnd1 ? relationship.getEntityOneProxy() : relationship.getEntityTwoProxy()) == null || startingEntityGUID.equals(parentEntity.getGUID())) continue;
                if (log.isDebugEnabled()) {
                    log.debug("getUniqueParentRelationshipByType : returning relationship.getGUID()=" + relationship.getGUID() + "relationship.end1 guid=" + relationship.getEntityOneProxy().getGUID() + relationship.getEntityOneProxy().getUniqueProperties().getInstanceProperties().get("qualifiedName") + "relationship.end2 guid " + relationship.getEntityTwoProxy().getGUID() + relationship.getEntityTwoProxy().getUniqueProperties().getInstanceProperties().get("qualifiedName"));
                }
                return relationship;
            }
        }
        catch (PropertyServerException | UserNotAuthorizedException error) {
            throw error;
        }
        catch (Exception error) {
            this.errorHandler.handleRepositoryError(error, methodName, "getUniqueParentRelationshipByType");
        }
        return null;
    }

    @Deprecated
    public Relationship getUniqueRelationshipByType(String userId, String startingEntityGUID, String startingEntityTypeName, String relationshipTypeGUID, String relationshipTypeName, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        return this.getUniqueRelationshipByType(userId, startingEntityGUID, startingEntityTypeName, relationshipTypeGUID, relationshipTypeName, 0, false, false, new Date(), methodName);
    }

    public Relationship getUniqueRelationshipByType(String userId, String startingEntityGUID, String startingEntityTypeName, String relationshipTypeGUID, String relationshipTypeName, int attachmentEntityEnd, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "getUniqueRelationshipByType";
        String typeGUIDParameterName = "relationshipTypeGUID";
        String typeNameParameterName = "relationshipTypeName";
        this.errorHandler.validateTypeIdentifiers(relationshipTypeGUID, "relationshipTypeGUID", relationshipTypeName, "relationshipTypeName", methodName, "getUniqueRelationshipByType");
        try {
            List<Relationship> relationships = this.getRelationshipsByType(userId, startingEntityGUID, startingEntityTypeName, relationshipTypeGUID, relationshipTypeName, attachmentEntityEnd, forLineage, forDuplicateProcessing, 0, 0, effectiveTime, methodName);
            if (relationships != null) {
                if (relationships.size() == 1) {
                    return relationships.get(0);
                }
                if (relationships.size() > 1) {
                    this.errorHandler.handleAmbiguousRelationships(startingEntityGUID, startingEntityTypeName, relationshipTypeName, relationships, methodName);
                }
            }
        }
        catch (PropertyServerException | UserNotAuthorizedException error) {
            throw error;
        }
        catch (Exception error) {
            this.errorHandler.handleRepositoryError(error, methodName, "getUniqueRelationshipByType");
        }
        return null;
    }

    public Relationship getUniqueRelationshipByType(String userId, String startingEntityGUID, String startingEntityTypeName, boolean startAtEnd1, String relationshipTypeGUID, String relationshipTypeName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "getUniqueRelationshipByType";
        try {
            List<Relationship> relationships;
            int attachmentEntityEnd = 1;
            if (startAtEnd1) {
                attachmentEntityEnd = 2;
            }
            if ((relationships = this.getRelationshipsByType(userId, startingEntityGUID, startingEntityTypeName, relationshipTypeGUID, relationshipTypeName, attachmentEntityEnd, forLineage, forDuplicateProcessing, 0, 2, effectiveTime, methodName)) != null && !relationships.isEmpty()) {
                if (relationships.size() == 1) {
                    return relationships.get(0);
                }
                this.errorHandler.handleAmbiguousRelationships(startingEntityGUID, startingEntityTypeName, relationshipTypeName, relationships, methodName);
            }
        }
        catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException error) {
            throw error;
        }
        catch (Exception error) {
            this.errorHandler.handleRepositoryError(error, methodName, "getUniqueRelationshipByType");
        }
        return null;
    }

    public Relationship createRelationship(String userId, String relationshipTypeGUID, String externalSourceGUID, String externalSourceName, String end1GUID, String end2GUID, InstanceProperties relationshipProperties, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "createRelationship";
        try {
            if (externalSourceGUID == null) {
                return this.metadataCollection.addRelationship(userId, relationshipTypeGUID, relationshipProperties, end1GUID, end2GUID, InstanceStatus.ACTIVE);
            }
            return this.metadataCollection.addExternalRelationship(userId, relationshipTypeGUID, externalSourceGUID, externalSourceName, relationshipProperties, end1GUID, end2GUID, InstanceStatus.ACTIVE);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Exception error) {
            this.errorHandler.handleRepositoryError(error, methodName, "createRelationship");
        }
        return null;
    }

    public void ensureRelationship(String userId, String end1TypeName, String externalSourceGUID, String externalSourceName, String end1GUID, String end2GUID, String relationshipTypeGUID, String relationshipTypeName, InstanceProperties relationshipProperties, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "ensureRelationship";
        String typeGUIDParameterName = "relationshipTypeGUID";
        String typeNameParameterName = "relationshipTypeName";
        this.errorHandler.validateTypeIdentifiers(relationshipTypeGUID, "relationshipTypeGUID", relationshipTypeName, "relationshipTypeName", methodName, "ensureRelationship");
        Relationship relationship = this.getRelationshipBetweenEntities(userId, end1GUID, end1TypeName, end2GUID, relationshipTypeGUID, relationshipTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (relationship == null) {
            this.createRelationship(userId, relationshipTypeGUID, externalSourceGUID, externalSourceName, end1GUID, end2GUID, relationshipProperties, methodName);
        } else {
            this.errorHandler.validateProvenance(userId, (InstanceAuditHeader)relationship, relationship.getGUID(), externalSourceGUID, externalSourceName, methodName);
            if (relationshipProperties != null || relationship.getProperties() != null) {
                this.updateRelationshipProperties(userId, externalSourceGUID, externalSourceName, relationship, relationshipProperties, methodName);
            }
        }
    }

    public void createExternalRelationship(String userId, String relationshipTypeGUID, String externalSourceGUID, String externalSourceName, String end1GUID, String end2GUID, InstanceProperties relationshipProperties, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        this.createRelationship(userId, relationshipTypeGUID, externalSourceGUID, externalSourceName, end1GUID, end2GUID, relationshipProperties, methodName);
    }

    public void removeRelationship(String userId, String externalSourceGUID, String externalSourceName, String relationshipTypeName, String relationshipGUID, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "removeRelationship";
        try {
            Relationship relationship = this.metadataCollection.getRelationship(userId, relationshipGUID);
            if (relationship != null) {
                this.errorHandler.validateInstanceType((InstanceHeader)relationship, relationshipTypeName, methodName, "removeRelationship");
                this.removeRelationship(userId, externalSourceGUID, externalSourceName, relationship, methodName);
            }
        }
        catch (PropertyServerException | UserNotAuthorizedException error) {
            throw error;
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Exception error) {
            this.errorHandler.handleRepositoryError(error, methodName, "removeRelationship");
        }
    }

    public void removeRelationship(String userId, String externalSourceGUID, String externalSourceName, Relationship relationship, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "removeRelationship";
        try {
            this.errorHandler.validateProvenance(userId, (InstanceAuditHeader)relationship, relationship.getGUID(), externalSourceGUID, externalSourceName, methodName);
            this.metadataCollection.deleteRelationship(userId, relationship.getType().getTypeDefGUID(), relationship.getType().getTypeDefName(), relationship.getGUID());
        }
        catch (UserNotAuthorizedException error) {
            throw error;
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (RelationshipNotKnownException error) {
        }
        catch (FunctionNotSupportedException error) {
            this.purgeRelationship(userId, relationship.getType().getTypeDefGUID(), relationship.getType().getTypeDefName(), relationship.getGUID(), methodName);
        }
        catch (Exception error) {
            this.errorHandler.handleRepositoryError(error, methodName, "removeRelationship");
        }
    }

    public void purgeRelationship(String userId, String relationshipTypeGUID, String relationshipTypeName, String relationshipGUID, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "purgeRelationship";
        String typeGUIDParameterName = "relationshipTypeGUID";
        String typeNameParameterName = "relationshipTypeName";
        this.errorHandler.validateTypeIdentifiers(relationshipTypeGUID, "relationshipTypeGUID", relationshipTypeName, "relationshipTypeName", methodName, "purgeRelationship");
        try {
            this.metadataCollection.purgeRelationship(userId, relationshipTypeGUID, relationshipTypeName, relationshipGUID);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Exception error) {
            this.errorHandler.handleRepositoryError(error, methodName, "purgeRelationship");
        }
    }

    public void restoreRelationship(String userId, String externalSourceGUID, String externalSourceName, String deletedRelationshipGUID, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "restoreRelationship";
        try {
            Relationship relationship = this.metadataCollection.restoreRelationship(userId, deletedRelationshipGUID);
            if (relationship != null) {
                this.errorHandler.validateProvenance(userId, (InstanceAuditHeader)relationship, deletedRelationshipGUID, externalSourceGUID, externalSourceName, methodName);
            }
        }
        catch (UserNotAuthorizedException error) {
            throw error;
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Exception error) {
            this.errorHandler.handleRepositoryError(error, methodName, "restoreRelationship");
        }
    }

    public void removeAllRelationshipsOfType(String userId, String externalSourceGUID, String externalSourceName, String startingEntityGUID, String startingEntityTypeName, String relationshipTypeGUID, String relationshipTypeName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws UserNotAuthorizedException, PropertyServerException, InvalidParameterException {
        String localMethodName = "removeAllRelationshipsOfType";
        String typeGUIDParameterName = "relationshipTypeGUID";
        String typeNameParameterName = "relationshipTypeName";
        this.errorHandler.validateTypeIdentifiers(relationshipTypeGUID, "relationshipTypeGUID", relationshipTypeName, "relationshipTypeName", methodName, "removeAllRelationshipsOfType");
        RepositoryRelationshipsIterator iterator = new RepositoryRelationshipsIterator(this, this.invalidParameterHandler, userId, startingEntityGUID, startingEntityTypeName, relationshipTypeGUID, relationshipTypeName, 0, forLineage, forDuplicateProcessing, 0, this.maxPageSize, effectiveTime, methodName);
        while (iterator.moreToReceive()) {
            Relationship relationship = iterator.getNext();
            if (relationship == null) continue;
            this.removeRelationship(userId, externalSourceGUID, externalSourceName, relationship, methodName);
        }
    }

    public void removeRelationshipBetweenEntities(String userId, String externalSourceGUID, String externalSourceName, String relationshipTypeGUID, String relationshipTypeName, String entity1GUID, String entity1TypeName, String entity2GUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws UserNotAuthorizedException, PropertyServerException, InvalidParameterException {
        Relationship relationship = this.getRelationshipBetweenEntities(userId, entity1GUID, entity1TypeName, entity2GUID, relationshipTypeGUID, relationshipTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (relationship != null) {
            this.removeRelationship(userId, externalSourceGUID, externalSourceName, relationship, methodName);
        }
    }

    public Relationship updateRelationshipProperties(String userId, String externalSourceGUID, String externalSourceName, Relationship relationship, InstanceProperties relationshipProperties, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "updateRelationshipProperties";
        if (relationship == null || relationship.getProperties() == null && relationshipProperties == null || relationshipProperties != null && relationshipProperties.equals((Object)relationship.getProperties())) {
            return relationship;
        }
        try {
            this.errorHandler.validateProvenance(userId, (InstanceAuditHeader)relationship, relationship.getGUID(), externalSourceGUID, externalSourceName, methodName);
            return this.metadataCollection.updateRelationshipProperties(userId, relationship.getGUID(), relationshipProperties);
        }
        catch (UserNotAuthorizedException error) {
            throw error;
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Exception error) {
            this.errorHandler.handleRepositoryError(error, methodName, "updateRelationshipProperties");
        }
        return null;
    }

    public void updateRelationshipProperties(String userId, String externalSourceGUID, String externalSourceName, String relationshipGUID, InstanceProperties relationshipProperties, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "updateRelationshipProperties";
        try {
            Relationship relationship = this.metadataCollection.getRelationship(userId, relationshipGUID);
            if (relationship != null) {
                this.updateRelationshipProperties(userId, externalSourceGUID, externalSourceName, relationship, relationshipProperties, methodName);
            }
        }
        catch (PropertyServerException | UserNotAuthorizedException error) {
            throw error;
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Exception error) {
            this.errorHandler.handleRepositoryError(error, methodName, "updateRelationshipProperties");
        }
    }

    public void updateRelationshipStatus(String userId, String externalSourceGUID, String externalSourceName, String relationshipGUID, String relationshipParameterName, String relationshipTypeName, InstanceStatus instanceStatus, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "updateRelationshipStatus";
        try {
            Relationship relationship = this.getRelationshipByGUID(userId, relationshipGUID, relationshipParameterName, relationshipParameterName, null, methodName);
            this.errorHandler.validateInstanceType((InstanceHeader)relationship, relationshipTypeName, methodName, "updateRelationshipStatus");
            this.errorHandler.validateProvenance(userId, (InstanceAuditHeader)relationship, relationshipGUID, externalSourceGUID, externalSourceName, methodName);
            this.metadataCollection.updateRelationshipStatus(userId, relationshipGUID, instanceStatus);
        }
        catch (PropertyServerException | UserNotAuthorizedException error) {
            throw error;
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Exception error) {
            this.errorHandler.handleRepositoryError(error, methodName, "updateRelationshipStatus");
        }
    }

    public void updateUniqueRelationshipByType(String userId, String externalSourceGUID, String externalSourceName, String end1GUID, String end1TypeName, String end2GUID, String end2TypeName, String relationshipTypeGUID, String relationshipTypeName, InstanceProperties properties, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "updateUniqueRelationshipByType";
        String typeGUIDParameterName = "relationshipTypeGUID";
        String typeNameParameterName = "relationshipTypeName";
        this.errorHandler.validateTypeIdentifiers(relationshipTypeGUID, "relationshipTypeGUID", relationshipTypeName, "relationshipTypeName", methodName, "updateUniqueRelationshipByType");
        Relationship existingRelationshipForEntity1 = this.getUniqueRelationshipByType(userId, end1GUID, end1TypeName, relationshipTypeGUID, relationshipTypeName, 2, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        existingRelationshipForEntity1 = this.removeIncompatibleRelationship(userId, externalSourceGUID, externalSourceName, existingRelationshipForEntity1, end1GUID, end2GUID, methodName);
        Relationship existingRelationshipForEntity2 = this.getUniqueRelationshipByType(userId, end2GUID, end2TypeName, relationshipTypeGUID, relationshipTypeName, 1, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        existingRelationshipForEntity2 = this.removeIncompatibleRelationship(userId, externalSourceGUID, externalSourceName, existingRelationshipForEntity2, end1GUID, end2GUID, methodName);
        if (existingRelationshipForEntity1 == null && existingRelationshipForEntity2 == null) {
            this.createRelationship(userId, relationshipTypeGUID, externalSourceGUID, externalSourceName, end1GUID, end2GUID, properties, methodName);
        }
    }

    public void removeUniqueRelationshipByType(String userId, String externalSourceGUID, String externalSourceName, String entityGUID, String entityTypeName, String relationshipTypeGUID, String relationshipTypeName, int attachmentEntityEnd, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "removeUniqueRelationshipByType";
        String typeGUIDParameterName = "relationshipTypeGUID";
        String typeNameParameterName = "relationshipTypeName";
        this.errorHandler.validateTypeIdentifiers(relationshipTypeGUID, "relationshipTypeGUID", relationshipTypeName, "relationshipTypeName", methodName, "removeUniqueRelationshipByType");
        Relationship obsoleteRelationship = this.getUniqueRelationshipByType(userId, entityGUID, entityTypeName, relationshipTypeGUID, relationshipTypeName, attachmentEntityEnd, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (obsoleteRelationship != null) {
            this.removeRelationship(userId, externalSourceGUID, externalSourceName, obsoleteRelationship, methodName);
        }
    }

    private Relationship removeIncompatibleRelationship(String userId, String externalSourceGUID, String externalSourceName, Relationship relationship, String end1GUID, String end2GUID, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        if (relationship == null) {
            return null;
        }
        EntityProxy end1Proxy = relationship.getEntityOneProxy();
        EntityProxy end2Proxy = relationship.getEntityTwoProxy();
        if (end1GUID.equals(end1Proxy.getGUID()) && end2GUID.equals(end2Proxy.getGUID())) {
            return relationship;
        }
        this.removeRelationship(userId, externalSourceGUID, externalSourceName, relationship, methodName);
        return null;
    }

    public InstanceGraph getEntityNeighborhood(String userId, String entityGUID, List<String> entityTypeGUIDs, List<String> relationshipTypeGUIDs, List<InstanceStatus> limitResultsByStatus, List<String> limitResultsByClassification, Date asOfTime, int level, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "getEntityNeighborhood";
        try {
            return this.metadataCollection.getEntityNeighborhood(userId, entityGUID, entityTypeGUIDs, relationshipTypeGUIDs, limitResultsByStatus, limitResultsByClassification, asOfTime, level);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        catch (Exception error) {
            this.errorHandler.handleRepositoryError(error, methodName, "getEntityNeighborhood");
        }
        return null;
    }

    public OMRSMetadataCollection getMetadataCollection() {
        return this.metadataCollection;
    }
}

